#include <stdio.h>

#define MAX_SUBTREES 3
#define NSUBSCORES MAX_SUBTREES

struct Node {
	struct Node *next, *father;
	struct ListNode *first_child, *last_child;
	long na, nc, nchr, nm;
	long min, max; /* in sorted list */
	long chromo;
	long depth;
	long shared_length;
	double mean_shared, loc;
};

struct ListNode {
	struct Node *ptr;
	struct ListNode *next, *prev;
};

/* hpm_tree.c */
void allocate_sortlist(void);
void free_sortlist(void);

void init_left_sort(void);
void init_right_sort(void);
void left_update(void);
void right_update(void);
void finalize_sort(void); 

/* pattern.c */
void add_pattern(struct Node *);

/* io.c */
int read_data(FILE *);
void dispose_data(void);
/* void write_pvalues(FILE *); */
void write_power(FILE *);
void write_left_tree(FILE *, struct Node *, long);
void write_right_tree(FILE *, struct Node *, long);
void write_subscores(FILE *, long);
void write_sub_pvalues(FILE *, long);

void debug_dump_chromo(long);

/* score.c */
void calculate_scores(char *, double *);

/* permu.c */
void alloc_permu(void);
void free_permu(void);
void permu_phase1(int, long);
void permu_phase2(long);
double total_p(double);
