#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "common.h"

void error_msg(int, char *);

extern double obs_pval[];

char *mdata, *status, *maxallele, *mutation;

long nchromo, nmarkers, na, nc, nmuta;
long npermu;
long seed;
double obs_score1[MAX_SUBTREES];
double correct_locus, *location, current_location;
long closest_mk, tree_mk;
int muta_info;
char mode;
long fixed_k;

struct Node *root;


int main(int argn, char **argv)
{
	long m;
	FILE *fi;


	if (argn < 2)
	{
		fprintf(stderr, "usage 0: treedt s file\n");
		fprintf(stderr, "usage 1: treedt p file #permutations\n");
		fprintf(stderr, "usage 2: treedt P file #permutations correct_location\n");
		fprintf(stderr, "usage 3: treedt k file #permutations fixed_#subtrees\n");
		fprintf(stderr, "usage 4: treedt K file #permutations correct_location fixed_#subtrees\n");
		exit(-1);
	}

	mode = *argv[1];
	if (argn < 3) error_msg(-1, NULL);
	fi = fopen(argv[2], "r");
	if (fi == NULL) error_msg(-2, argv[2]);

	npermu = 0;
	if (mode == 'p' || mode == 'P' || mode == 'k' || mode == 'K' || mode == 'v')
	{
		/* permutation tests */
		if (mode == 'P' || mode == 'k') argn--;
		if (mode == 'K') argn -= 2;
		if (argn < 4) error_msg(-3, NULL);
		if (argn > 4) error_msg(-4, NULL);
		if (mode == 'P' || mode == 'K')
		{
			correct_locus = atof(argv[4]);
			closest_mk = (long)floor(correct_locus);
		}
		else closest_mk = -1;
		fixed_k = 0;
		if (mode == 'k') fprintf(stderr, "k=%ld\n", fixed_k = atol(argv[4]));
		if (mode == 'K') fprintf(stderr, "k=%ld\n", fixed_k = atol(argv[5]));
		npermu = atol(argv[3]);
		fprintf(stderr, "%ld permutations\n", npermu);
	}
	else if (mode == 's')
	{
		/* raw scores */
		if (argn > 3) error_msg(-4, NULL);
	}
	else if (mode == 't')
	{
		/* tree output */
		if (argn < 4) error_msg(-3, NULL);
		if (argn > 4) error_msg(-4, NULL);
		tree_mk = atol(argv[3]);
	}
	else if (mode == 'd')
	{
	}
	else error_msg(1, argv[1]);


	fprintf(stderr, "Reading data ...\n");
	
	read_data(fi);
	fclose(fi);
	
	fprintf(stderr, "done.\n");
	
	allocate_sortlist();

	if (mode == 'd')
	{
		debug_dump_chromo(atol(argv[3]));
		exit(0);
	}

	if (npermu > 0) alloc_permu();

	seed = 0;

	/* left to right pass */
	init_left_sort();
	fprintf(stderr, "at marker ");
	for (m = 0; m < nmarkers; m++)
	{
		fprintf(stderr, "%ld ", m+1);
		left_update();
		current_location = location[m] + 0.5;
		calculate_scores(status, obs_score1);

		if (npermu > 0)
		{
			permu_phase1(0, m);
			if (mode == 'v') write_sub_pvalues(stdout, m);
		}
		if (mode == 's') write_subscores(stdout, m);
		else if (mode == 't' && m + 1 == tree_mk) write_left_tree(stdout, root, m);
	}
	fprintf(stderr, "done.\n");
	finalize_sort();

	/* right to left pass */
	init_right_sort();
	fprintf(stderr, "at marker ");
	for (m = 0; m < nmarkers; m++)
	{
		fprintf(stderr, "%ld ", nmarkers - m);
		right_update();
		current_location = location[nmarkers - m] - 0.5;
		calculate_scores(status, obs_score1);

		if (npermu > 0)
		{
			permu_phase1(1, nmarkers - m - 1);
			if (mode == 'v') write_sub_pvalues(stdout, nmarkers - m - 1);
		}
		if (mode == 's') write_subscores(stdout, nmarkers - m - 1);
		else if (mode == 't' && nmarkers - m == tree_mk) write_right_tree(stdout, root, nmarkers - m - 1); 
	}
	fprintf(stderr, "done.\n");
	finalize_sort();

	if (npermu > 0)
	{
		if (mode == 'p' || mode == 'P' || mode == 'k' || mode == 'K')
		{
			fprintf(stderr, "Permutation phase 2\n");
			for (m = 0; m < nmarkers + 1; m++) permu_phase2(m);
			fprintf(stderr, "done\n");
			write_power(stdout);
		}
		free_permu();
	}

	free_sortlist();
	dispose_data();
	
	return 0;
}

void error_msg(int e, char *s2)
{
	char *s;
	switch (e)
	{
		case 1: s = "Unsupported mode"; break;
		case -1: s = "USAGE 1: hpm p <datafile> <# permutations>\n"
					 "USAGE 2: hpm t <datafile>"; break;
		case -2: s = "Can't open input file"; break;
		case -3: s = "Too few arguments"; break;
		case -4: s = "Too many arguments"; break;
	}

	fprintf(stderr, "%s", s);
	if (s2) fprintf(stderr, " %s", s2);
	fprintf(stderr, "\n");
	exit(-1);
}
