#!/usr/bin/env python
# -*- coding: utf-8 -*-

import string
from plasTeX.Renderers import Renderer

class Renderer(Renderer):

    indent=0
    
    def default(self, node):
        s=self.indent*" "+'\\'+node.nodeName
        if node.hasAttributes():
            s=s+'{'
            for key, value in node.attributes.items():
                s=s+unicode(key)+'='+unicode(value)+' '
            s=s+"}"
        s=s+"\n"+self.indent*" "+"<\n"
        self.indent=self.indent+1
        us=unicode(s)+unicode(node)
        self.indent=self.indent-1
        us=us+self.indent*" "+">\n"
        return us

    def textDefault(self,node):
        return self.indent*" "+unicode(node)+"\n"

