<!-- received="Mon Jun 22 07:35:59 1998 EET DST" -->
<!-- sent="Mon, 22 Jun 1998 00:27:13 -0400 (EDT)" -->
<!-- name="George" -->
<!-- email="greerga@nidhogg.ham.muohio.edu" -->
<!-- subject="Fix (sort of) for OOM swap deadlock." -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-25,: Fix (sort of) for OOM swap deadlock.</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Fix (sort of) for OOM swap deadlock.</h1>
<b>George</b> (<a href="mailto:greerga@nidhogg.ham.muohio.edu"><i>greerga@nidhogg.ham.muohio.edu</i></a>)<br>
<i>Mon, 22 Jun 1998 00:27:13 -0400 (EDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#490">[ date ]</a><a href="index.html#490">[ thread ]</a><a href="subject.html#490">[ subject ]</a><a href="author.html#490">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0491.html">Myrdraal: "Re: WARNING Re: SYSENTER based syscalls patch, 2.1.105, RFC"</a>
<li> <b>Previous message:</b> <a href="0489.html">Ralf Wierzbicki: "re: Limits in the kernel"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Of course, I have no idea if this has a race since I'm not an experienced<br>
kernel hacker, but "it works for me."<br>
<p>
----<br>
/usr/include/unistd.h:678: virtual memory exhaustedvirtual memory<br>
exhaustedvirtual memory exhausted<br>
<p>
<p>
virtual memory exhausted<br>
virtual memory exhausted<br>
virtual memory exhausted<br>
virtual memory exhausted<br>
virtual memory exhausted<br>
In file included from /usr/include/sys/time.h:6,<br>
----<br>
<p>
diff -upr 2.1.106/linux/mm/vmscan.c linux/mm/vmscan.c<br>
--- 2.1.106/linux/mm/vmscan.c	Mon Jun 22 00:01:49 1998<br>
+++ linux/mm/vmscan.c	Sun Jun 21 23:58:53 1998<br>
@@ -511,6 +511,28 @@ void kswapd_setup(void)<br>
        printk ("Starting kswapd v%.*s\n", i, s);<br>
 }<br>
 <br>
+/* Code borrowed from 'get_swaparea_info' in mm/swapfile.c */<br>
+int out_of_swap(void)<br>
+{<br>
+	struct swap_info_struct *ptr = swap_info;<br>
+	int i, j, usedswap;<br>
+	int bytes_total = 0, bytes_used = 0;<br>
+<br>
+	for (i = 0 ; i &lt; nr_swapfiles ; i++, ptr++) {<br>
+		if ((ptr-&gt;flags &amp; SWP_USED) == 0)<br>
+			continue;<br>
+		for (usedswap = 0, j = 0; j &lt; ptr-&gt;max; ++j)<br>
+			if (ptr-&gt;swap_map[j] != 128 &amp;&amp; ptr-&gt;swap_map[j] != 0)<br>
+				usedswap++;<br>
+		bytes_total += (ptr-&gt;pages &lt;&lt; (PAGE_SHIFT - 10));<br>
+		bytes_used += (usedswap &lt;&lt; (PAGE_SHIFT - 10));<br>
+	}<br>
+#ifdef DEBUG<br>
+	printk("VM: Swap total: %6d Swap used: %6d\n", bytes_total, bytes_used);<br>
+#endif<br>
+	return (bytes_total == bytes_used);<br>
+}<br>
+<br>
 /*<br>
  * The background pageout daemon.<br>
  * Started as a kernel thread from the init process.<br>
@@ -564,6 +586,13 @@ int kswapd(void *unused)<br>
 		 * woken up more often and the rate will be even<br>
 		 * higher).<br>
 		 */<br>
+		if (out_of_swap()) {<br>
+#ifdef DEBUG<br>
+			printk("kswapd: No swap left, not paging.\n");<br>
+#endif<br>
+			continue;<br>
+		}<br>
+<br>
 		tries = pager_daemon.tries_base &gt;&gt; free_memory_available(3);<br>
 	<br>
 		while (tries--) {<br>
<p>
-George<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0491.html">Myrdraal: "Re: WARNING Re: SYSENTER based syscalls patch, 2.1.105, RFC"</a>
<li> <b>Previous message:</b> <a href="0489.html">Ralf Wierzbicki: "re: Limits in the kernel"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
