<!-- received="Tue Jun 23 13:58:56 1998 EET DST" -->
<!-- sent="Tue, 23 Jun 1998 14:51:46 +0400" -->
<!-- name="Savochkin Andrey Vladimirovich" -->
<!-- email="saw@msu.ru" -->
<!-- subject="Re: loop devices under SMP (2.1.106ac4)" -->
<!-- id="" -->
<!-- inreplyto="Pine.HPP.3.96.980622174413.18606A-100000@ixion.honeywell.com" -->
<title>Linux-kernel mailing list archive 1998-25,: Re: loop devices under SMP (2.1.106ac4)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: loop devices under SMP (2.1.106ac4)</h1>
<b>Savochkin Andrey Vladimirovich</b> (<a href="mailto:saw@msu.ru"><i>saw@msu.ru</i></a>)<br>
<i>Tue, 23 Jun 1998 14:51:46 +0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#977">[ date ]</a><a href="index.html#977">[ thread ]</a><a href="subject.html#977">[ subject ]</a><a href="author.html#977">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0978.html">Etienne Lorrain: "Re: uniform input device packets?"</a>
<li> <b>Previous message:</b> <a href="0976.html">Albert D. Cahalan: "Re: keyboard raw mode?"</a>
<li> <b>In reply to:</b> <a href="0842.html">Shawn Leas: "Re: loop devices under SMP (2.1.106ac4)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Mon, Jun 22, 1998 at 05:46:27PM -0500, Shawn Leas wrote:<br>
<i>&gt; On Mon, 22 Jun 1998, Rick Payne wrote:</i><br>
<i>&gt; </i><br>
<i>&gt; &gt; </i><br>
<i>&gt; &gt; There appears to be a deadlock of some kind with loop devices under</i><br>
<i>&gt; &gt; 2.1.106-ac4 and SMP. Executing the following command locks my system dead:</i><br>
<i>&gt; &gt; </i><br>
<i>&gt; &gt; 	mount isoimage.raw -r -t iso9660 -o loop /mnt</i><br>
<i>&gt; &gt; </i><br>
<i>&gt; &gt; Running a non-SMP kernel and the above works a treat. The problem was also</i><br>
<i>&gt; &gt; present in 2.1.106-ac3 and -ac2, but these are the only kernels I've tried</i><br>
<i>&gt; &gt; since getting the SMP box, so it may well have existed in previous kernels.</i><br>
<i>&gt; &gt; </i><br>
<i>&gt; &gt; It looks like something is going awry inside ll_rw_block called from</i><br>
<i>&gt; &gt; loop.c's do_lo_request. A spinlock thing perhaps?</i><br>
<i>&gt; </i><br>
<i>&gt; How many times does this have to be rediscovered?  You are very correct,</i><br>
<i>&gt; and there was supposed to be a fix coming.  This has not materialized.</i><br>
<i>&gt; </i><br>
<i>&gt; And yes, I believe it was a spinlock misuse thing.</i><br>
<i>&gt; </i><br>
<i>&gt; -Shawn</i><br>
<i>&gt; </i><br>
<i>&gt; &gt; I'll continue looking at it, but if this rings any bells for anyone and</i><br>
<i>&gt; &gt; they get there before me, give me a shout.</i><br>
<p>
Hi,<br>
<p>
I've got a simple and stupid patch.<br>
It revives loopback devices but can lead to more serious problems<br>
because of IRQ playing.<br>
You may try it if you're a brave person.<br>
<p>
--- linux.orig/drivers/block/loop.c	Sat May 16 16:16:51 1998<br>
+++ linux/drivers/block/loop.c	Thu Jun 11 16:30:05 1998<br>
@@ -187,11 +187,15 @@<br>
 	struct loop_device *lo;<br>
 	struct buffer_head *bh;<br>
 	struct request *current_request;<br>
+	unsigned long flags;<br>
 <br>
+	save_flags(flags);<br>
 repeat:<br>
 	INIT_REQUEST;<br>
 	current_request=CURRENT;<br>
 	CURRENT=current_request-&gt;next;<br>
+	spin_unlock_irqrestore(&amp;io_request_lock,flags);<br>
+	__sti();<br>
 	if (MINOR(current_request-&gt;rq_dev) &gt;= MAX_LOOP)<br>
 		goto error_out;<br>
 	lo = &amp;loop_dev[MINOR(current_request-&gt;rq_dev)];<br>
@@ -274,11 +278,13 @@<br>
 		offset = 0;<br>
 		block++;<br>
 	}<br>
+	spin_lock_irq(&amp;io_request_lock);<br>
 	current_request-&gt;next=CURRENT;<br>
 	CURRENT=current_request;<br>
 	end_request(1);<br>
 	goto repeat;<br>
 error_out:<br>
+	spin_lock_irq(&amp;io_request_lock);<br>
 	current_request-&gt;next=CURRENT;<br>
 	CURRENT=current_request;<br>
 	end_request(0);<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0978.html">Etienne Lorrain: "Re: uniform input device packets?"</a>
<li> <b>Previous message:</b> <a href="0976.html">Albert D. Cahalan: "Re: keyboard raw mode?"</a>
<li> <b>In reply to:</b> <a href="0842.html">Shawn Leas: "Re: loop devices under SMP (2.1.106ac4)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
