<!-- received="Tue Jun 23 23:37:42 1998 EET DST" -->
<!-- sent="Tue, 23 Jun 1998 20:58:19 +0100" -->
<!-- name="Richard Hirst" -->
<!-- email="richard@sleepie.demon.co.uk" -->
<!-- subject="BUG FIX modules problems" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-25,: BUG FIX modules problems</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>BUG FIX modules problems</h1>
<b>Richard Hirst</b> (<a href="mailto:richard@sleepie.demon.co.uk"><i>richard@sleepie.demon.co.uk</i></a>)<br>
<i>Tue, 23 Jun 1998 20:58:19 +0100</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1051">[ date ]</a><a href="index.html#1051">[ thread ]</a><a href="subject.html#1051">[ subject ]</a><a href="author.html#1051">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1052.html">Raul Miller: "Re: Header files and interfaces"</a>
<li> <b>Previous message:</b> <a href="1050.html">Vojtech Pavlik: "Re: uniform input device packets?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi,<br>
  This patch fixes the problems people have been seeing when trying to<br>
load modules in 2.1.1xx kernels.  The problem is that the MMU ATC entries<br>
don't get flushed on the switch to modprobe.  I don't think this is an<br>
m68k specific problem - there have been similar problems reported on<br>
linux-kernel.  I am not sure this patch is in the best place, but it is<br>
effective.<br>
<p>
Richard.<br>
<p>
<p>
--- linuxvme-2.1.106/kernel/kmod.c-	Tue Jun 23 18:50:09 1998<br>
+++ linuxvme-2.1.106/kernel/kmod.c	Tue Jun 23 19:46:29 1998<br>
@@ -14,8 +14,10 @@<br>
 #include &lt;linux/sched.h&gt;<br>
 #include &lt;linux/types.h&gt;<br>
 #include &lt;linux/unistd.h&gt;<br>
+#include &lt;linux/mm.h&gt;<br>
 #include &lt;asm/smp_lock.h&gt;<br>
 #include &lt;asm/uaccess.h&gt;<br>
+#include &lt;asm/pgtable.h&gt;<br>
 <br>
 /*<br>
 	modprobe_path is set via /proc/sys.<br>
@@ -48,6 +50,16 @@<br>
 {<br>
 	char *argv[] = { modprobe_path, "-s", "-k", (char*)module_name, NULL};<br>
 	int i;<br>
+<br>
+	/*<br>
+	 * The MMU ATC entries need flushing somewhere round here.  This<br>
+	 * thread was created with CLONE_VM, so there was no cause to<br>
+	 * flush it there.  exec_mmap() called as a result of the<br>
+	 * following execve() finds current-&gt;mm-&gt;count=2, so that doesn't<br>
+	 * flush the MMU either.<br>
+	 */<br>
+<br>
+	flush_tlb_mm(current-&gt;mm);<br>
 <br>
 	use_init_file_context();<br>
 <br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1052.html">Raul Miller: "Re: Header files and interfaces"</a>
<li> <b>Previous message:</b> <a href="1050.html">Vojtech Pavlik: "Re: uniform input device packets?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
