<!-- received="Wed Jun 24 12:19:45 1998 EET DST" -->
<!-- sent="Wed, 24 Jun 98 02:10:07 -0700" -->
<!-- name="Mike " -->
<!-- email="ford@omnicron.com" -->
<!-- subject="Re: Error in poll implementation?" -->
<!-- id="" -->
<!-- inreplyto="Error in poll implementation?" -->
<title>Linux-kernel mailing list archive 1998-25,: Re: Error in poll implementation?</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Error in poll implementation?</h1>
<b>Mike </b> (<a href="mailto:ford@omnicron.com"><i>ford@omnicron.com</i></a>)<br>
<i>Wed, 24 Jun 98 02:10:07 -0700</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1142">[ date ]</a><a href="index.html#1142">[ thread ]</a><a href="subject.html#1142">[ subject ]</a><a href="author.html#1142">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1143.html">Richard Gooch: "Re: Thread implementations, poll, etc."</a>
<li> <b>Previous message:</b> <a href="1141.html">Anthony Barbachan: "Re: isapnp and pnpdump seam to dump core on 2.0.34"</a>
<li> <b>In reply to:</b> <a href="0349.html">: ""</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
<i>&gt; I do think there's an error in the implementation of the poll system</i><br>
<i>&gt; call in linux 2.1.106.  In one application I set the fd field to</i><br>
<i>&gt; -1 to ignore that field.  The call returns immediatly and doesn't</i><br>
<i>&gt; ignore the field :-(.</i><br>
<p>
Yup, looks like a bug.  Even SVR4 specifies ignoring negative fds.<br>
Here's a candidate fix, which I have not tested except that it compiles.<br>
This patch is against kernel 2.1.105ac5 (sorry, it's what I had handy).<br>
<p>
					-=] Ford [=-<br>
<p>
"That's high quality Velcro.  Can you	(In Real Life:  Mike Ditto)<br>
get this spot out?  More Tang, Mom."	<a href="mailto:ford@omnicron.com">ford@omnicron.com</a><br>
 -- Jerry Steiner			<a href="http://www.omnicron.com/~ford/ford.html">http://www.omnicron.com/~ford/ford.html</a><br>
<p>
<p>
--- fs/ORIGselect.c	Mon Mar 23 10:13:52 1998<br>
+++ fs/select.c	Wed Jun 24 01:39:24 1998<br>
@@ -300,15 +300,16 @@<br>
 			unsigned int mask;<br>
 			struct file * file;<br>
 <br>
-			mask = POLLNVAL;<br>
+			if (fdpnt-&gt;fd &lt; 0)<br>
+				mask = 0;<br>
 			/* poll_wait increments f_count if needed */<br>
-			file = fcheck(fdpnt-&gt;fd);<br>
-			if (file != NULL) {<br>
+			else if ((file = fcheck(fdpnt-&gt;fd)) != NULL) {<br>
 				mask = DEFAULT_POLLMASK;<br>
 				if (file-&gt;f_op &amp;&amp; file-&gt;f_op-&gt;poll)<br>
 					mask = file-&gt;f_op-&gt;poll(file, wait);<br>
 				mask &amp;= fdpnt-&gt;events | POLLERR | POLLHUP;<br>
-			}<br>
+			} else<br>
+				mask = POLLNVAL;<br>
 			if (mask) {<br>
 				wait = NULL;<br>
 				count++;<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1143.html">Richard Gooch: "Re: Thread implementations, poll, etc."</a>
<li> <b>Previous message:</b> <a href="1141.html">Anthony Barbachan: "Re: isapnp and pnpdump seam to dump core on 2.0.34"</a>
<li> <b>In reply to:</b> <a href="0349.html">: ""</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
