<!-- received="Wed Jun 24 15:08:48 1998 EET DST" -->
<!-- sent="Wed, 24 Jun 1998 12:35:01 +0100 (BST)" -->
<!-- name="Matthew Wilcox" -->
<!-- email="willy@odie.barnet.ac.uk" -->
<!-- subject="fix for loop device" -->
<!-- id="199806241135.MAA11504@odie.barnet.ac.uk" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-25,: fix for loop device</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>fix for loop device</h1>
<b>Matthew Wilcox</b> (<a href="mailto:willy@odie.barnet.ac.uk"><i>willy@odie.barnet.ac.uk</i></a>)<br>
<i>Wed, 24 Jun 1998 12:35:01 +0100 (BST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1161">[ date ]</a><a href="index.html#1161">[ thread ]</a><a href="subject.html#1161">[ subject ]</a><a href="author.html#1161">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1162.html">Marsh Ray: "Re: Y2K"</a>
<li> <b>Previous message:</b> <a href="1160.html">Ernest ter Kuile: "Re: Thread implementations..."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This patch isn't intended to fix the lockups; it fixes the problem with<br>
being able to unmount a device which has an open loop device on it.<br>
<p>
P.S.<br>
I haven't heard anything from linux-kernel for the last day.. should I<br>
be worried?<br>
<p>
Matthew Wilcox<br>
<p>
<p>
diff -ur linux-2.1.105/drivers/block/loop.c linux/drivers/block/loop.c<br>
--- linux-2.1.105/drivers/block/loop.c	Wed Jun 24 10:35:12 1998<br>
+++ linux/drivers/block/loop.c	Wed Jun 24 10:26:21 1998<br>
@@ -166,8 +166,8 @@<br>
 {<br>
 	int	size;<br>
 <br>
-	if (S_ISREG(lo-&gt;lo_inode-&gt;i_mode))<br>
-		size = (lo-&gt;lo_inode-&gt;i_size - lo-&gt;lo_offset) / BLOCK_SIZE;<br>
+	if (S_ISREG(lo-&gt;lo_dentry-&gt;d_inode-&gt;i_mode))<br>
+		size = (lo-&gt;lo_dentry-&gt;d_inode-&gt;i_size - lo-&gt;lo_offset) / BLOCK_SIZE;<br>
 	else {<br>
 		kdev_t lodev = lo-&gt;lo_device;<br>
 		if (blk_size[MAJOR(lodev)])<br>
@@ -195,7 +195,7 @@<br>
 	if (MINOR(current_request-&gt;rq_dev) &gt;= MAX_LOOP)<br>
 		goto error_out;<br>
 	lo = &amp;loop_dev[MINOR(current_request-&gt;rq_dev)];<br>
-	if (!lo-&gt;lo_inode || !lo-&gt;transfer)<br>
+	if (!lo-&gt;lo_dentry || !lo-&gt;transfer)<br>
 		goto error_out;<br>
 <br>
 	blksize = BLOCK_SIZE;<br>
@@ -232,7 +232,7 @@<br>
 	while (len &gt; 0) {<br>
 		real_block = block;<br>
 		if (lo-&gt;lo_flags &amp; LO_FLAGS_DO_BMAP) {<br>
-			real_block = bmap(lo-&gt;lo_inode, block);<br>
+			real_block = bmap(lo-&gt;lo_dentry-&gt;d_inode, block);<br>
 			if (!real_block) {<br>
 				printk("loop: block %d not present\n", block);<br>
 				goto error_out;<br>
@@ -292,15 +292,16 @@<br>
 	int error;<br>
 <br>
 	MOD_INC_USE_COUNT;<br>
+<br>
+	error = -EBUSY;<br>
+	if (lo-&gt;lo_dentry)<br>
+		goto out;<br>
+<br>
 	error = -EBADF;<br>
 	file = fget(arg);<br>
 	if (!file)<br>
 		goto out;<br>
 <br>
-	error = -EBUSY;<br>
-	if (lo-&gt;lo_inode)<br>
-		goto out_putf;<br>
-<br>
 	error = -EINVAL;<br>
 	inode = file-&gt;f_dentry-&gt;d_inode;<br>
 	if (!inode) {<br>
@@ -328,9 +329,8 @@<br>
 		set_device_ro(dev, 0);<br>
 	}<br>
 <br>
-	/* N.B. Should keep the file or dentry ... */<br>
-	inode-&gt;i_count++;<br>
-	lo-&gt;lo_inode = inode;<br>
+	lo-&gt;lo_dentry = file-&gt;f_dentry;<br>
+	lo-&gt;lo_dentry-&gt;d_count++;<br>
 	lo-&gt;transfer = NULL;<br>
 	figure_loop_size(lo);<br>
 <br>
@@ -344,17 +344,17 @@<br>
 <br>
 static int loop_clr_fd(struct loop_device *lo, kdev_t dev)<br>
 {<br>
-	struct inode *inode = lo-&gt;lo_inode;<br>
+	struct dentry *dentry = lo-&gt;lo_dentry;<br>
 <br>
-	if (!inode)<br>
+	if (!dentry)<br>
 		return -ENXIO;<br>
 	if (lo-&gt;lo_refcnt &gt; 1)	/* we needed one fd for the ioctl */<br>
 		return -EBUSY;<br>
 <br>
-	if (S_ISBLK(inode-&gt;i_mode))<br>
-		blkdev_release (inode);<br>
-	lo-&gt;lo_inode = NULL;<br>
-	iput(inode);<br>
+	if (S_ISBLK(dentry-&gt;d_inode-&gt;i_mode))<br>
+		blkdev_release (dentry-&gt;d_inode);<br>
+	lo-&gt;lo_dentry = NULL;<br>
+	dput(dentry);<br>
 	lo-&gt;lo_device = 0;<br>
 	lo-&gt;lo_encrypt_type = 0;<br>
 	lo-&gt;lo_offset = 0;<br>
@@ -372,7 +372,7 @@<br>
 	struct loop_info info;<br>
 	int err;<br>
 <br>
-	if (!lo-&gt;lo_inode)<br>
+	if (!lo-&gt;lo_dentry)<br>
 		return -ENXIO;<br>
 	if (!arg)<br>
 		return -EINVAL;<br>
@@ -432,7 +432,7 @@<br>
 	struct loop_info	info;<br>
 	int err;<br>
 	<br>
-	if (!lo-&gt;lo_inode)<br>
+	if (!lo-&gt;lo_dentry)<br>
 		return -ENXIO;<br>
 	if (!arg)<br>
 		return -EINVAL;<br>
@@ -441,8 +441,8 @@<br>
 		return err;<br>
 	memset(&amp;info, 0, sizeof(info));<br>
 	info.lo_number = lo-&gt;lo_number;<br>
-	info.lo_device = kdev_t_to_nr(lo-&gt;lo_inode-&gt;i_dev);<br>
-	info.lo_inode = lo-&gt;lo_inode-&gt;i_ino;<br>
+	info.lo_device = kdev_t_to_nr(lo-&gt;lo_dentry-&gt;d_inode-&gt;i_dev);<br>
+	info.lo_inode = lo-&gt;lo_dentry-&gt;d_inode-&gt;i_ino;<br>
 	info.lo_rdevice = kdev_t_to_nr(lo-&gt;lo_device);<br>
 	info.lo_offset = lo-&gt;lo_offset;<br>
 	info.lo_flags = lo-&gt;lo_flags;<br>
@@ -483,7 +483,7 @@<br>
 	case LOOP_GET_STATUS:<br>
 		return loop_get_status(lo, (struct loop_info *) arg);<br>
 	case BLKGETSIZE:   /* Return device size */<br>
-		if (!lo-&gt;lo_inode)<br>
+		if (!lo-&gt;lo_dentry)<br>
 			return -ENXIO;<br>
 		if (!arg)<br>
 			return -EINVAL;<br>
diff -ur linux-2.1.105/include/linux/loop.h linux/include/linux/loop.h<br>
--- linux-2.1.105/include/linux/loop.h	Mon Jul  1 17:06:05 1996<br>
+++ linux/include/linux/loop.h	Wed Jun 24 10:07:33 1998<br>
@@ -17,7 +17,7 @@<br>
        <br>
 struct loop_device {<br>
 	int		lo_number;<br>
-	struct inode	*lo_inode;<br>
+	struct dentry	*lo_dentry;<br>
 	int		lo_refcnt;<br>
 	kdev_t		lo_device;<br>
 	int		lo_offset;<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1162.html">Marsh Ray: "Re: Y2K"</a>
<li> <b>Previous message:</b> <a href="1160.html">Ernest ter Kuile: "Re: Thread implementations..."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
