<!-- received="Thu Jun 25 05:47:47 1998 EET DST" -->
<!-- sent="24 Jun 1998 19:40:18 -0700" -->
<!-- name="Ben Gertzfield" -->
<!-- email="che@debian.org" -->
<!-- subject="Re: Sendmail 8.9.0 claims a Linux kernel bug" -->
<!-- id="" -->
<!-- inreplyto="25 Jun 1998 03:26:11 +0200"" -->
<title>Linux-kernel mailing list archive 1998-25,: Re: Sendmail 8.9.0 claims a Linux kernel bug</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Sendmail 8.9.0 claims a Linux kernel bug</h1>
<b>Ben Gertzfield</b> (<a href="mailto:che@debian.org"><i>che@debian.org</i></a>)<br>
<i>24 Jun 1998 19:40:18 -0700</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1286">[ date ]</a><a href="index.html#1286">[ thread ]</a><a href="subject.html#1286">[ subject ]</a><a href="author.html#1286">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1287.html">Alex Buell: "Re: devfs patch v38 available"</a>
<li> <b>Previous message:</b> <a href="1285.html">Richard B. Johnson: "Re: Sendmail 8.9.0 claims a Linux kernel bug"</a>
<li> <b>In reply to:</b> <a href="1281.html">Andi Kleen: "Re: Sendmail 8.9.0 claims a Linux kernel bug"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1557.html">H. Peter Anvin: "Re: Sendmail 8.9.0 claims a Linux kernel bug"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
<i>&gt;&gt;&gt;&gt;&gt; "Andi" == Andi Kleen &lt;<a href="mailto:ak@muc.de">ak@muc.de</a>&gt; writes:</i><br>
<p>
(from the Sendmail KNOWN-BUGS file)<br>
<p>
<i>    &gt;&gt; Apparently, the accept() in sendmail daemon loop can return</i><br>
<i>    &gt;&gt; ETIMEDOUT and cause sendmail to sleep for 5 seconds during</i><br>
<i>    &gt;&gt; which time no new connections will be accepted.  An error is</i><br>
<i>    &gt;&gt; reported to syslog:</i><br>
<i>    &gt;&gt; </i><br>
<i>    &gt;&gt; Jun 9 17:14:12 hostname sendmail[207]: NOQUEUE: SYSERR(root):</i><br>
<i>    &gt;&gt; getrequests: accept: Connection timed out</i><br>
<i>    &gt;&gt; </i><br>
<i>    &gt;&gt; "Connection timed out" is not documented as a valid return from</i><br>
<i>    &gt;&gt; accept(2) and this is believed to be a bug in the Linux kernel.</i><br>
<p>
    Andi&gt; This is no kernel bug, but an intentional change from<br>
    Andi&gt; BSD/Solaris semantics.  Linux accept() returns errors for<br>
    Andi&gt; failed connection attempts unlike BSD which drops them.<br>
<p>
Ah hah!<br>
<p>
    Andi&gt; It is a documentation bug if the manpage does not state<br>
    Andi&gt; that.<br>
<p>
Then let's document it. Who's the current maintainer of the kernel<br>
manpages?<br>
<p>
In any case, here's a preliminary patch to sendmail to fix this<br>
problem for Linux. Is #ifdef __linux__ the right way to check if<br>
we're compiling under Linux?<br>
<p>
Are there any errors we should ignore besides ETIMEDOUT and<br>
EHOSTUNREACH?<br>
<p>
I'm forwarding this to the Sendmail people, as well.<br>
<p>
Ben<br>
<p>
diff -ruN sendmail-8.9.0.orig/src/daemon.c sendmail-8.9.0/src/daemon.c<br>
--- sendmail-8.9.0.orig/src/daemon.c	Tue May 19 16:36:06 1998<br>
+++ sendmail-8.9.0/src/daemon.c	Wed Jun 24 19:35:13 1998<br>
@@ -293,7 +293,12 @@<br>
 			lotherend = socksize;<br>
 			t = accept(DaemonSocket,<br>
 			    (struct sockaddr *)&amp;RealHostAddr, &amp;lotherend);<br>
+#ifdef __linux__<br>
+			if (t &gt;= 0 || (errno != EINTR &amp;&amp; errno != ETIMEDOUT<br>
+				       &amp;&amp; errno != EHOSTUNREACH))<br>
+#else<br>
 			if (t &gt;= 0 || errno != EINTR)<br>
+#endif<br>
 				break;<br>
 		}<br>
 		savederrno = errno;<br>
<p>
<pre>
-- 
Brought to you by the letters A and K and the number 14.
"Everybody wants prosthetic foreheads on their real heads." -- TMBG
Debian GNU/Linux -- where do you want to go tomorrow? <a href="http://www.debian.org/">http://www.debian.org/</a>
I'm on FurryMUCK as Che, and EFNet and YiffNet IRC as Che_Fox.
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1287.html">Alex Buell: "Re: devfs patch v38 available"</a>
<li> <b>Previous message:</b> <a href="1285.html">Richard B. Johnson: "Re: Sendmail 8.9.0 claims a Linux kernel bug"</a>
<li> <b>In reply to:</b> <a href="1281.html">Andi Kleen: "Re: Sendmail 8.9.0 claims a Linux kernel bug"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1557.html">H. Peter Anvin: "Re: Sendmail 8.9.0 claims a Linux kernel bug"</a>
<!-- reply="end" -->
</ul>
</font></body>
