<!-- received="Fri Jun 26 05:10:50 1998 EET DST" -->
<!-- sent="Thu, 25 Jun 1998 18:09:29 -0400 (EDT)" -->
<!-- name="Chris Ricker" -->
<!-- email="kaboom@gatech.edu" -->
<!-- subject="Ksymoops re-written in C, not C++ was Change in kernel "changes" :) , (fwd)" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-25,: Ksymoops re-written in C, not C++ was Change in kernel "changes" :) , (fwd)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Ksymoops re-written in C, not C++ was Change in kernel "changes" :) , (fwd)</h1>
<b>Chris Ricker</b> (<a href="mailto:kaboom@gatech.edu"><i>kaboom@gatech.edu</i></a>)<br>
<i>Thu, 25 Jun 1998 18:09:29 -0400 (EDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1537">[ date ]</a><a href="index.html#1537">[ thread ]</a><a href="subject.html#1537">[ subject ]</a><a href="author.html#1537">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1538.html">Bob Lorenzini: "2.1.107"</a>
<li> <b>Previous message:</b> <a href="1536.html">Trevor Johnson: "Re: Weird spelling fixes in 2.1.107"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
  This message is in MIME format.  The first part should be readable text,<br>
  while the remaining parts are likely unreadable without MIME-aware tools.<br>
  Send mail to <a href="mailto:mime@docserver.cac.washington.edu">mime@docserver.cac.washington.edu</a> for more info.<br>
<p>
--------------167EB0E72781E494446B9B3D<br>
Content-Type: TEXT/PLAIN; CHARSETus-ascii<br>
Content-ID: &lt;<a href="mailto:Pine.GSO.3.96.980625180148.8754C@oobleck.gatech.edu">Pine.GSO.3.96.980625180148.8754C@oobleck.gatech.edu</a>&gt;<br>
<p>
Hello all,<br>
<p>
Jean-Francois Bignolles &lt;<a href="mailto:bignolle@grif.fr">bignolle@grif.fr</a>&gt; asked me to forward this to the<br>
list as he's not a subscriber.  Basically, he's proposing a replacement<br>
scripts/ksymoops written in C instead of C++ to lessen the need to have a<br>
C++ compiler around....  Please direct comments / questions to him, not<br>
me.  Thanks.<br>
<p>
later,<br>
chris<br>
<p>
<pre>
--
Chris Ricker                                            <a href="mailto:kaboom@gatech.edu">kaboom@gatech.edu</a>
<p>
The time you enjoy wasting
is not wasting time.
        -- T.S. Eliot
<p>
---------- Forwarded message ----------
Date: Fri, 12 Jun 1998 13:54:59 +0200
From: Jean-Francois Bignolles &lt;<a href="mailto:bignolle@grif.fr">bignolle@grif.fr</a>&gt;
To: <a href="mailto:kaboom@gatech.edu">kaboom@gatech.edu</a>
Subject: Change in kernel "changes" :)
<p>
Hello,
<p>
I want to submit a change. It is said that
<p>
        Linux C++ Library      2.7.2.8
<p>
is needed to compile Linux kernel. In fact, there is only one file (!)
which is a C++ source: Scripts/ksymoops.cc (~10K). That's why a rewrite
of this file in plain C can remove a dependancy from C++ libs and tools
(and save some dowloads:). So I have rewriten it, and I send i to you.
Please note that I have not tested it (I'm not a kernel hacker)...
<p>
--------------167EB0E72781E494446B9B3D
Content-Type: TEXT/PLAIN; CHARSETiso-8859-1; NAME"ksymoops.c"
Content-Transfer-Encoding: QUOTED-PRINTABLE
Content-ID: &lt;<a href="mailto:Pine.GSO.3.96.980625180148.8754D@oobleck.gatech.edu">Pine.GSO.3.96.980625180148.8754D@oobleck.gatech.edu</a>&gt;
Content-Description: 
<p>
/* ksymoops.c v1.8 -- A simple filter to resolve symbols in Linux Oops-logs
 * Copyright (C) 1995 Greg McGary &lt;<a href="mailto:gkm@magilla.cichlid.com">gkm@magilla.cichlid.com</a>&gt;
 * compile like so: gcc -o ksymoops ksymoops.c
 *
 * Update to binutils 2.8 and handling of header text on oops lines by
 * Keith Owens &lt;<a href="mailto:kaos@ocs.com.au">kaos@ocs.com.au</a>&gt;
 *
 * This is a rewrite of ksymoops.cc v1.7 in plain C -- this removes a
 * dependency from C++ libs/tools (there was only one C++ source in the
 * kernel tree!).  Now room for the namelist is dynamicaly allocated
 * Jean-Franois Bignolles &lt;<a href="mailto:bignolle@grif.fr">bignolle@grif.fr</a>&gt;
 */
<p>
/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This is a simple filter to resolve EIP and call-trace symbols from
 * a Linux kernel "Oops" log.  Supply the symbol-map file name as a
 * command-line argument, and redirect the oops-log into stdin.  Out
 * will come the EIP and call-trace in symbolic form.
 */
<p>
/* BUGS:
 * * Only resolves operands of jump and call instructions.
 */
#include &lt;stdio.h&gt;
#include &lt;string.h&gt;
#include &lt;stdlib.h&gt;
#include &lt;unistd.h&gt;
#include &lt;ctype.h&gt;
<p>
<p>
#define  KSYM_LEN_MAX   129
#define  CODE_SIZE      20
<p>
#define  strnequ( x, y, n)      (strncmp ((x), (y), (n)) == 0)
<p>
char const *program_name;
<p>
/*------------------------------------------------------------------*/
<p>
struct KSym
{
    unsigned long address;
    char *name;
    long offset;
    long extent;
};
typedef struct KSym KSym;
<p>
struct NameList
{
    KSym *ksyms_0;
    int  cardinality;
};
typedef struct NameList NameList;
<p>
<p>
void KSym_set_extent (KSym*, KSym const*);
void KSym_scan (KSym*, FILE*);
void KSym_print (KSym*, FILE*);
<p>
void NameList_ctor (NameList*);
void NameList_init (NameList*, unsigned);
int  NameList_valid (NameList*);
void NameList_scan (NameList*, FILE*);
KSym *NameList_find (NameList*, unsigned long);
void NameList_decode (NameList*, unsigned char*, long);
<p>
/*------------------------------------------------------------------*/
<p>
inline void KSym_set_extent (KSym *ksym, KSym const *next_ksym)
{
    ksym-&gt;extent = next_ksym-&gt;address - ksym-&gt;address;
}
<p>
void KSym_scan (KSym *ksym, FILE *file)
{
    char type;
    char name[KSYM_LEN_MAX + 1];
<p>
    fscanf (file, "%lx %c %s", &amp;(ksym-&gt;address), &amp;type, name);
    ksym-&gt;name = strdup (name);
    ksym-&gt;offset = 0;
}
<p>
void KSym_print (KSym *ksym, FILE *file)
{
    fprintf (file, "%lx &lt;%s", (ksym-&gt;address + ksym-&gt;offset), ksym-&gt;name);
<p>
    if (ksym-&gt;offset &gt; 0)
        fprintf (file, "+%lx/%lx", ksym-&gt;offset, ksym-&gt;extent);
    putc ('&gt;', file);
}
<p>
/*------------------------------------------------------------------*/
<p>
inline void NameList_ctor (NameList *nlist)
{
    nlist-&gt;cardinality = 0;
}
<p>
void NameList_init (NameList *nlist, unsigned ksym_max)
{
    nlist-&gt;ksyms_0 = (KSym*) malloc (ksym_max * sizeof(struct KSym));
<p>
    if (nlist-&gt;ksyms_0 == NULL) {
        perror (program_name);
        exit (EXIT_FAILURE);
    } 
}
<p>
inline int NameList_valid (NameList *nlist)
{
    return (nlist-&gt;cardinality &gt; 0);
}
<p>
KSym *NameList_find (NameList *nlist, unsigned long address)
{
    KSym *start, *end, *mid;
<p>
    if (!NameList_valid (nlist))
        return NULL;
    start = nlist-&gt;ksyms_0;
    end   = start + nlist-&gt;cardinality - 1;
<p>
    if (address &lt; start-&gt;address || address &gt;= end-&gt;address)
        return NULL;
<p>
    while (start &lt;= end) {
        mid = start + ((end - start) / 2);
<p>
        if (mid-&gt;address &lt; address)
            start = mid + 1;
        else if (mid-&gt;address &gt; address)
            end = mid - 1;
        else
            return mid;
    }
    while (mid-&gt;address &gt; address)
        --mid;
    mid-&gt;offset = address - mid-&gt;address;
<p>
    if (mid-&gt;offset &gt; mid-&gt;extent) {
        fputs ("Oops! ", stderr);
        KSym_print (mid, stderr);
        putc ('\n', stderr);
    }
    return mid;
}
<p>
void NameList_decode (NameList *nlist, unsigned char* code, long eip_addr)
{
    /* This is a hack to avoid using gcc.  We create an object file by
       concatenating objfile_head, the twenty bytes of code, and
       objfile_tail.  */
    unsigned char objfile_head[] = {
        0x07, 0x01, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    };
    unsigned char objfile_tail[] = {
        0x00, 0x90, 0x90, 0x90,
        0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00,
        0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x25, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x00, 0x00,
        'g',  'c',  'c',  '2',  '_',  'c',  'o',  'm',  
        'p',  'i',  'l',  'e',  'd',  '.',  '\0', '_',  
        'E',  'I',  'P',  '\0', '\0', '\0', '\0', '\0',
        '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0',
        '\0', '\0', '\0', '\0', '\0', '\0'
    };
    char const *objdump_command = "objdump -d oops_decode.o";
    char const *objfile_name    = objdump_command + 11;
<p>
    FILE *file, *dumppipe;
    KSym *ksym;
    char buf[1024], newbuf[1024];
    char *bp, *bp_0, *bp_1;
    int  lines = 0;
    int  eip_seen = 0;
    long offset, rel_addr;
<p>
<p>
    if ((file = fopen (objfile_name, "w")) == NULL) {
        fprintf (stderr, "%s: can't open `%s'\n", program_name, objfile_name);
        return;
    }
    fwrite (objfile_head, sizeof(objfile_head), 1, file);
    fwrite (code, CODE_SIZE, 1, file);
    fwrite (objfile_tail, sizeof(objfile_tail), 1, file);
    fclose (file);
<p>
    if ((dumppipe = popen (objdump_command, "r")) == NULL) {
        fprintf (stderr, "%s: can't exec `%s'; `Code' section not"
                         " disassembled\n", program_name, objdump_command);
        return;
    }
    while (fgets (buf, sizeof(buf), dumppipe)) {
        if (strlen (buf) &lt; 14)
            continue;
<p>
        if (eip_seen &amp;&amp; buf[4] == ':') {
            /* assume objdump from binutils 2.8..., reformat to old style */
            offset = strtol (buf, 0, 16);
            sprintf (newbuf, "%8lx &lt;_EIP+%lx&gt;: %s", offset, offset, buf + 6);
            strcpy (buf, newbuf);
        }
        if (!strnequ (buf + 9, "&lt;_EIP", 5))
            continue;
        eip_seen = 1;
<p>
        if (strstr (buf, " is out of bounds"))
            break;
        lines++;
        fputs ("Code: ", stdout);
<p>
        if (!NameList_valid (nlist)) {
            fputs (buf, stdout);
            continue;
        }
        offset = strtol (buf, 0, 16);
        bp_0 = strchr (buf, '&gt;');
        bp_0 = bp_0 != NULL?
               bp_0 + 2: strchr (buf, ':');
<p>
        if ((ksym = NameList_find (nlist, eip_addr + offset)) != NULL) {
            KSym_print (ksym, stdout);
            putchar (' ');
        }
        bp_1 = strstr (bp_0, "\t");    /* objdump from binutils 2.8... */
        bp_1 = bp_1 != NULL?
               bp_1 + 1: bp_0;
<p>
        for (bp = bp_1; !isspace (*bp); bp++) ;
        for (; isspace (*bp); bp++) ;
<p>
        if (!isxdigit (*bp))
            fputs (bp_0, stdout);
        else if (*bp_1 == 'j' || strnequ (bp_1, "call", 4)) {
            /* a jump or call insn */
            rel_addr = strtol (bp, 0, 16);
<p>
            if ((ksym = NameList_find (nlist, eip_addr + rel_addr)) != NULL) {
                *bp++ = '\0';
                fputs (bp_0, stdout);
                KSym_print (ksym, stdout);
                putchar ('\n');
            }
            else fputs (bp_0, stdout);
        }
        else fputs (bp_0, stdout);
    }
    if (!lines)
        fprintf (stderr, "%s: `%s' can't disassemble--you must upgrade"
                         " your binutils\n", program_name, objdump_command);
    pclose (dumppipe);
    unlink (objfile_name);
}
<p>
void NameList_scan (NameList *nlist, FILE *file)
{
    KSym *ksyms;
    int  cardinality;
<p>
    for (ksyms = nlist-&gt;ksyms_0, cardinality = 0; !feof (file); ksyms++) {
        KSym_scan (ksyms, file);
<p>
        if (cardinality++ &gt; 0)
            KSym_set_extent (ksyms - 1, ksyms);
    }
    nlist-&gt;cardinality = cardinality - 1;
}
<p>
/*------------------------------------------------------------------*/
<p>
void usage ()
{
    fprintf (stderr, "Usage: %s [System.map] &lt; oops-log\n", program_name);
    exit (EXIT_FAILURE);
}
<p>
int file_line_count (char *file_name)
{
    const char *wc_opt_l = "wc -l ";
    char command [129];
    FILE *wc_pipe;
    int  line_count;
<p>
    strcpy (command, wc_opt_l);
    strcat (command, file_name);
<p>
    if ((wc_pipe = popen (command, "r")) == NULL)
        return -1;
<p>
    fscanf (wc_pipe, " %d", &amp;line_count); 
    pclose (wc_pipe);
    return line_count;
}
<p>
int main (int argc, char *argv[])
{
    FILE *map;
    KSym *ksym;
    int  ksym_max;
    int  c;
    char *p, *cp, *end;
    char *oops_column = NULL;
    char *map_file_name;
    char buffer[1024];
    unsigned char code[CODE_SIZE];
    long eip_addr;
    unsigned long address;
    NameList names;
<p>
    NameList_ctor (&amp;names);
    program_name = (argc--, *argv++);
<p>
    if (argc &gt; 1)
        usage ();
    else if (argc == 1) {
        map_file_name = (argc--, *argv++);
<p>
        if ((ksym_max = file_line_count (map_file_name)) &lt; 0)
            fprintf (stderr, "%s: can't open `%s'\n", program_name,
                             map_file_name);
        else {
            printf ("using `%s' to map addresses to symbols\n",
                     map_file_name);
            map = fopen (map_file_name, "r");
            NameList_init (&amp;names, ksym_max);
            NameList_scan (&amp;names, map);
        }
    } 
    if (!NameList_valid (&amp;names))
        printf ("no symbol map.  I'll only show you disassembled code.\n");
    putchar ('\n');
<p>
    for (;;) {
        if (fgets (buffer, sizeof(buffer), stdin) == NULL)
            break;
<p>
        if (strstr (buffer, "EIP:") &amp;&amp; NameList_valid (&amp;names)) {
            oops_column = strstr (buffer, "EIP:");
<p>
            if (sscanf (oops_column + 13, "[&lt;%lx&gt;]", &amp;eip_addr) != 1) {
                fprintf (stderr, "Cannot read eip address from EIP: line."
                                 "  Is this a valid oops file?\n");
                exit (EXIT_FAILURE);
            }
            printf ("&gt;&gt;EIP: ");
<p>
            if ((ksym = NameList_find (&amp;names, eip_addr)) != NULL) {
                KSym_print (ksym, stdout);
                putchar ('\n');
            }
            else printf ("%lx cannot be resolved\n", eip_addr);
        }
        else if (oops_column &amp;&amp; strstr (oops_column, "[&lt;")
                 &amp;&amp; NameList_valid (&amp;names)) {
            while (strstr (oops_column, "[&lt;")) {
                for (p = oops_column;;) {
                    while (*p &amp;&amp; *p++ != '[')
                        ;
                    if (sscanf (p, "&lt;%lx&gt;]", &amp;address) != 1)
                        break;
                    printf ("Trace: ");
<p>
                    if ((ksym = NameList_find (&amp;names, address)) != NULL)
                        KSym_print (ksym, stdout);
                    else
                        printf ("%lx", address);
                    putchar ('\n');
                }
                if (fgets (buffer, sizeof(buffer), stdin) == NULL)
                    break;
            }
        }
        if (oops_column &amp;&amp; strnequ (oops_column, "Code:", 5)) {
            p = oops_column + 5;
            cp = code;
            end = code + CODE_SIZE;
            memset (code, '\0', sizeof(code));
<p>
            while (*p &amp;&amp; cp &lt; end) {
                while (*p == ' ')
                    ++p;
<p>
                if (sscanf (p, "%x", &amp;c) != 1)
                    break;
                *cp++ = c;
                while (*p &amp;&amp; *p++ != ' ')
                    ;
            }
            NameList_decode (&amp;names, code, eip_addr);
        }
    }
    fflush (stdout);
    exit (EXIT_SUCCESS);
}
<p>
/* end  ksymoops.c */
<p>
--------------167EB0E72781E494446B9B3D--
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1538.html">Bob Lorenzini: "2.1.107"</a>
<li> <b>Previous message:</b> <a href="1536.html">Trevor Johnson: "Re: Weird spelling fixes in 2.1.107"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
