<!-- received="Fri Jun 26 16:15:28 1998 EET DST" -->
<!-- sent="Fri, 26 Jun 1998 11:29:15 +0200 (CEST)" -->
<!-- name="Niels Kristian Bech Jensen" -->
<!-- email="nkbj@image.dk" -->
<!-- subject="Re: Patch to ask if user has egcs/pgcc / add me to credits" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.3.96.980626094445.694A-100000@snoopy.privat.at" -->
<title>Linux-kernel mailing list archive 1998-25,: Re: Patch to ask if user has egcs/pgcc / add me to credits</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Patch to ask if user has egcs/pgcc / add me to credits</h1>
<b>Niels Kristian Bech Jensen</b> (<a href="mailto:nkbj@image.dk"><i>nkbj@image.dk</i></a>)<br>
<i>Fri, 26 Jun 1998 11:29:15 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1670">[ date ]</a><a href="index.html#1670">[ thread ]</a><a href="subject.html#1670">[ subject ]</a><a href="author.html#1670">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1671.html">Marcus Meissner: "[2.1.107] new console handling problems"</a>
<li> <b>Previous message:</b> <a href="1669.html">MOLNAR Ingo: "Re: kswapd's priority"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Fri, 26 Jun 1998, Peter-Paul Witta wrote:<br>
<p>
<i>&gt; On Tue, 23 Jun 1998, Marcelo de Paula Bezerra wrote:</i><br>
<i>&gt; </i><br>
<i>&gt; </i><br>
<i>&gt; why couldn't we simply parse a gcc --version in the toplevel makefile,</i><br>
<i>&gt; and set variables correspondig so that the arch/xxxx/Makefile can</i><br>
<i>&gt; implement proper compiling flags?</i><br>
<i>&gt; </i><br>
<i>&gt; i guess this hasnt been done yet because it's a Bad Idea. could someone</i><br>
<i>&gt; kindly express why?</i><br>
<i>&gt; </i><br>
I've done it for the Intel platform. Try this patch. Feedback is welcome.<br>
<p>
diff -urN linux-2.1.106/Makefile linux/Makefile<br>
--- linux-2.1.106/Makefile	Wed Jun 17 06:57:01 1998<br>
+++ linux/Makefile	Wed Jun 24 09:40:03 1998<br>
@@ -24,7 +24,7 @@<br>
 FINDHPATH	= $(HPATH)/asm $(HPATH)/linux $(HPATH)/scsi $(HPATH)/net<br>
 <br>
 HOSTCC  	=gcc<br>
-HOSTCFLAGS	=-O2 -fomit-frame-pointer<br>
+HOSTCFLAGS	=-Wall -Wstrict-prototypes -O2 -fomit-frame-pointer<br>
 <br>
 CROSS_COMPILE 	=<br>
 <br>
@@ -85,7 +85,7 @@<br>
 # standard CFLAGS<br>
 #<br>
 <br>
-CFLAGS = -Wall -Wstrict-prototypes -O2 -fomit-frame-pointer<br>
+CFLAGS = $(HOSTCFLAGS)<br>
 <br>
 ifdef SMP<br>
 CFLAGS += -D__SMP__<br>
@@ -155,21 +155,10 @@<br>
 <br>
 include arch/$(ARCH)/Makefile<br>
 <br>
-ifdef SMP<br>
-<br>
 .S.s:<br>
 	$(CC) -D__ASSEMBLY__ $(AFLAGS) -traditional -E -o $*.s $&lt;<br>
 .S.o:<br>
 	$(CC) -D__ASSEMBLY__ $(AFLAGS) -traditional -c -o $*.o $&lt;<br>
-<br>
-else<br>
-<br>
-.S.s:<br>
-	$(CC) -D__ASSEMBLY__ -traditional -E -o $*.s $&lt;<br>
-.S.o:<br>
-	$(CC) -D__ASSEMBLY__ -traditional -c -o $*.o $&lt;<br>
-<br>
-endif<br>
 <br>
 Version: dummy<br>
 	@rm -f include/linux/compile.h<br>
diff -urN linux-2.1.106/arch/i386/Makefile linux/arch/i386/Makefile<br>
--- linux-2.1.106/arch/i386/Makefile	Wed Jun 17 06:53:55 1998<br>
+++ linux/arch/i386/Makefile	Wed Jun 24 09:41:06 1998<br>
@@ -13,39 +13,51 @@<br>
 # Copyright (C) 1994 by Linus Torvalds<br>
 #<br>
 <br>
-AS86    =$(CROSS_COMPILE)as86 -0 -a<br>
-AS386   =$(CROSS_COMPILE)as86 -3<br>
-LD86    =$(CROSS_COMPILE)ld86 -0<br>
-<br>
 LD=$(CROSS_COMPILE)ld -m elf_i386<br>
 CPP=$(CC) -E<br>
 OBJCOPY=$(CROSS_COMPILE)objcopy -O binary -R .note -R .comment -S<br>
 LDFLAGS=-e stext<br>
 LINKFLAGS =-T $(TOPDIR)/arch/i386/vmlinux.lds $(LDFLAGS)<br>
 <br>
-CFLAGS_PIPE := -pipe<br>
+OLD_GCC := $(shell if $(CC) -v 2&gt;&amp;1 | grep 'version 2.7' &gt; /dev/null; then echo y; else echo n; fi)<br>
+<br>
 CFLAGS_NSR  := -fno-strength-reduce<br>
-CFLAGS := $(CFLAGS) $(CFLAGS_PIPE) $(CFLAGS_NSR)<br>
+CFLAGS_ALIGN := -malign-loops=2 -malign-jumps=2 -malign-functions=2<br>
 <br>
 ifdef CONFIG_M386<br>
-CFLAGS := $(CFLAGS) -m386 -DCPU=386<br>
+ifeq ($(OLD_GCC),y)<br>
+CFLAGS_PROC := $(CFLAGS_NSR) -m386 -DCPU=386<br>
+else<br>
+CFLAGS_PROC := -march=i386 -DCPU=386<br>
+endif<br>
 endif<br>
 <br>
 ifdef CONFIG_M486<br>
-CFLAGS := $(CFLAGS) -m486 -DCPU=486<br>
+ifeq ($(OLD_GCC),y)<br>
+CFLAGS_PROC := $(CFLAGS_NSR) -m486 -DCPU=486<br>
+else<br>
+CFLAGS_PROC := -march=i486 -DCPU=486<br>
+endif<br>
 endif<br>
 <br>
 ifdef CONFIG_M586<br>
-CFLAGS := $(CFLAGS) -m486 -malign-loops=2 -malign-jumps=2 -malign-functions=2 -DCPU=586<br>
+ifeq ($(OLD_GCC),y)<br>
+CFLAGS_PROC := $(CFLAGS_NSR) -m486 $(CFLAGS_ALIGN) -DCPU=586<br>
+else<br>
+CFLAGS_PROC := -march=pentium -DCPU=586<br>
+endif<br>
 endif<br>
 <br>
 ifdef CONFIG_M686<br>
-CFLAGS := $(CFLAGS) -m486 -malign-loops=2 -malign-jumps=2 -malign-functions=2 -DCPU=686<br>
+ifeq ($(OLD_GCC),y)<br>
+CFLAGS_PROC := $(CFLAGS_NSR) -m486 $(CFLAGS_ALIGN) -DCPU=686<br>
+else<br>
+CFLAGS_PROC := -march=pentiumpro -DCPU=686<br>
 endif<br>
-<br>
-ifdef SMP<br>
-CFLAGS := $(CFLAGS) -D__SMP__<br>
 endif<br>
+<br>
+CFLAGS_PIPE := -pipe<br>
+CFLAGS := $(CFLAGS) $(CFLAGS_PIPE) $(CFLAGS_PROC)<br>
 <br>
 HEAD := arch/i386/kernel/head.o arch/i386/kernel/init_task.o<br>
 <br>
diff -urN linux-2.1.106/arch/i386/boot/Makefile linux/arch/i386/boot/Makefile<br>
--- linux-2.1.106/arch/i386/boot/Makefile	Thu Apr 24 04:01:14 1997<br>
+++ linux/arch/i386/boot/Makefile	Wed Jun 24 09:40:03 1998<br>
@@ -8,9 +8,8 @@<br>
 # Copyright (C) 1994 by Linus Torvalds<br>
 #<br>
 <br>
-ifdef SMP<br>
-HOSTCFLAGS := $(HOSTCFLAGS) -D__SMP__<br>
-endif<br>
+AS86	=$(CROSS_COMPILE)as86 -0 -a<br>
+LD86	=$(CROSS_COMPILE)ld86 -0<br>
 <br>
 BOOT_INCL =	$(TOPDIR)/include/linux/config.h \<br>
 		$(TOPDIR)/include/linux/autoconf.h \<br>
diff -urN linux-2.1.106/arch/i386/boot/compressed/Makefile linux/arch/i386/boot/compressed/Makefile<br>
--- linux-2.1.106/arch/i386/boot/compressed/Makefile	Mon Dec 22 02:27:17 1997<br>
+++ linux/arch/i386/boot/compressed/Makefile	Wed Jun 24 09:40:03 1998<br>
@@ -22,10 +22,6 @@<br>
 ZLINKFLAGS = -Ttext $(ZIMAGE_OFFSET) $(ZLDFLAGS)<br>
 BZLINKFLAGS = -Ttext $(BZIMAGE_OFFSET) $(ZLDFLAGS)<br>
 <br>
-ifdef SMP<br>
-CFLAGS := $(CFLAGS) -D__SMP__<br>
-endif<br>
-<br>
 all: vmlinux<br>
 <br>
 vmlinux: piggy.o $(OBJECTS)<br>
@@ -34,18 +30,8 @@<br>
 bvmlinux: piggy.o $(OBJECTS)<br>
 	$(LD) $(BZLINKFLAGS) -o bvmlinux $(OBJECTS) piggy.o<br>
 <br>
-ifdef SMP<br>
-<br>
 head.o: head.S $(TOPDIR)/include/linux/tasks.h<br>
-	$(CC) -D__SMP__ -traditional -c head.S<br>
-<br>
-else<br>
-<br>
-head.o: head.S $(TOPDIR)/include/linux/tasks.h<br>
-	$(CC) -traditional -c head.S<br>
-<br>
-endif<br>
-<br>
+	$(CC) $(AFLAGS) -traditional -c head.S<br>
 <br>
 piggy.o:	$(SYSTEM)<br>
 	tmppiggy=_tmp_$$$$piggy; \<br>
diff -urN linux-2.1.106/arch/i386/kernel/Makefile linux/arch/i386/kernel/Makefile<br>
--- linux-2.1.106/arch/i386/kernel/Makefile	Wed Jun 17 06:52:11 1998<br>
+++ linux/arch/i386/kernel/Makefile	Wed Jun 24 09:40:03 1998<br>
@@ -7,13 +7,8 @@<br>
 #<br>
 # Note 2! The CFLAGS definitions are now in the main makefile...<br>
 <br>
-ifdef SMP<br>
 .S.o:<br>
 	$(CC) -D__ASSEMBLY__ $(AFLAGS) -traditional -c $&lt; -o $*.o<br>
-else<br>
-.S.o:<br>
-	$(CC) -D__ASSEMBLY__ -traditional -c $&lt; -o $*.o<br>
-endif<br>
 <br>
 all: kernel.o head.o init_task.o<br>
 <br>
@@ -39,19 +34,11 @@<br>
   endif<br>
 endif<br>
 <br>
-<br>
 ifdef SMP<br>
-<br>
 O_OBJS += io_apic.o smp.o trampoline.o<br>
+endif<br>
 <br>
 head.o: head.S $(TOPDIR)/include/linux/tasks.h<br>
-	$(CC) -D__ASSEMBLY__ -D__SMP__ -traditional -c $*.S -o $*.o<br>
-<br>
-else<br>
-<br>
-head.o: head.S $(TOPDIR)/include/linux/tasks.h<br>
-	$(CC) -D__ASSEMBLY__ -traditional -c $*.S -o $*.o<br>
-<br>
-endif<br>
+	$(CC) -D__ASSEMBLY__ $(AFLAGS) -traditional -c $*.S -o $*.o<br>
 <br>
 include $(TOPDIR)/Rules.make<br>
diff -urN linux-2.1.106/arch/i386/lib/Makefile linux/arch/i386/lib/Makefile<br>
--- linux-2.1.106/arch/i386/lib/Makefile	Sat Jan 10 23:51:20 1998<br>
+++ linux/arch/i386/lib/Makefile	Wed Jun 24 09:40:03 1998<br>
@@ -2,13 +2,8 @@<br>
 # Makefile for i386-specific library files..<br>
 #<br>
 <br>
-ifdef SMP<br>
 .S.o:<br>
 	$(CC) -D__ASSEMBLY__ $(AFLAGS) -traditional -c $&lt; -o $*.o<br>
-else<br>
-.S.o:<br>
-	$(CC) -D__ASSEMBLY__ -traditional -c $&lt; -o $*.o<br>
-endif<br>
 <br>
 L_TARGET = lib.a<br>
 L_OBJS  = checksum.o semaphore.o locks.o delay.o usercopy.o getuser.o putuser.o<br>
diff -urN linux-2.1.106/arch/sparc/kernel/Makefile linux/arch/sparc/kernel/Makefile<br>
--- linux-2.1.106/arch/sparc/kernel/Makefile	Wed Jun 17 06:51:33 1998<br>
+++ linux/arch/sparc/kernel/Makefile	Wed Jun 24 09:40:03 1998<br>
@@ -7,24 +7,12 @@<br>
 #<br>
 # Note 2! The CFLAGS definitions are now in the main makefile...<br>
 <br>
-ifdef SMP<br>
-<br>
 .S.s:<br>
 	$(CPP) -D__ASSEMBLY__ $(AFLAGS) -ansi $&lt; -o $*.s<br>
 <br>
 .S.o:<br>
 	$(CC) -D__ASSEMBLY__ $(AFLAGS) -ansi -c $&lt; -o $*.o<br>
 <br>
-else<br>
-<br>
-.S.s:<br>
-	$(CPP) -D__ASSEMBLY__ -ansi $&lt; -o $*.s<br>
-<br>
-.S.o:<br>
-	$(CC) -D__ASSEMBLY__ -ansi -c $&lt; -o $*.o<br>
-<br>
-endif<br>
-<br>
 all: kernel.o head.o init_task.o<br>
 <br>
 O_TARGET := kernel.o<br>
@@ -46,17 +34,8 @@<br>
 O_OBJS += auxio.o<br>
 endif<br>
 <br>
-ifdef SMP<br>
-<br>
 head.o: head.S<br>
 	$(CC) -D__ASSEMBLY__ $(AFLAGS) -ansi -c $*.S -o $*.o<br>
-<br>
-else<br>
-<br>
-head.o: head.S<br>
-	$(CC) -D__ASSEMBLY__ -ansi -c $*.S -o $*.o<br>
-<br>
-endif<br>
 <br>
 check_asm: dummy<br>
 	@echo "/* Automatically generated. Do not edit. */" &gt; asm_offsets.h<br>
diff -urN linux-2.1.106/arch/sparc/lib/Makefile linux/arch/sparc/lib/Makefile<br>
--- linux-2.1.106/arch/sparc/lib/Makefile	Wed Jun 17 06:51:34 1998<br>
+++ linux/arch/sparc/lib/Makefile	Wed Jun 24 09:40:03 1998<br>
@@ -45,8 +45,6 @@<br>
 memset.o: memset.S<br>
 	$(CC) -D__ASSEMBLY__ -ansi -c -o memset.o memset.S<br>
 <br>
-ifdef SMP<br>
-<br>
 locks.o: locks.S<br>
 	$(CC) -D__ASSEMBLY__ $(AFLAGS) -ansi -c -o locks.o locks.S<br>
 <br>
@@ -56,20 +54,9 @@<br>
 bitops.o: bitops.S<br>
 	$(CC) -D__ASSEMBLY__ $(AFLAGS) -ansi -c -o bitops.o bitops.S<br>
 <br>
+ifdef SMP<br>
 irqlock.o: irqlock.S<br>
 	$(CC) -D__ASSEMBLY__ $(AFLAGS) -ansi -c -o irqlock.o irqlock.S<br>
-<br>
-else<br>
-<br>
-locks.o: locks.S<br>
-	$(CC) -D__ASSEMBLY__ -ansi -c -o locks.o locks.S<br>
-<br>
-atomic.o: atomic.S<br>
-	$(CC) -D__ASSEMBLY__ -ansi -c -o atomic.o atomic.S<br>
-<br>
-bitops.o: bitops.S<br>
-	$(CC) -D__ASSEMBLY__ -ansi -c -o bitops.o bitops.S<br>
-<br>
 endif<br>
 <br>
 strlen.o: strlen.S<br>
diff -urN linux-2.1.106/arch/sparc/mm/Makefile linux/arch/sparc/mm/Makefile<br>
--- linux-2.1.106/arch/sparc/mm/Makefile	Wed Jun 17 06:51:34 1998<br>
+++ linux/arch/sparc/mm/Makefile	Wed Jun 24 09:40:03 1998<br>
@@ -22,8 +22,6 @@<br>
 <br>
 include $(TOPDIR)/Rules.make<br>
 <br>
-ifdef SMP<br>
-<br>
 hypersparc.o: hypersparc.S<br>
 	$(CC) -D__ASSEMBLY__ $(AFLAGS) -ansi -c -o hypersparc.o hypersparc.S<br>
 <br>
@@ -35,19 +33,3 @@<br>
 <br>
 tsunami.o: tsunami.S<br>
 	$(CC) -D__ASSEMBLY__ $(AFLAGS) -ansi -c -o tsunami.o tsunami.S<br>
-<br>
-else<br>
-<br>
-hypersparc.o: hypersparc.S<br>
-	$(CC) -D__ASSEMBLY__ -ansi -c -o hypersparc.o hypersparc.S<br>
-<br>
-turbosparc.o: turbosparc.S<br>
-	$(CC) -D__ASSEMBLY__ -ansi -c -o turbosparc.o turbosparc.S<br>
-<br>
-viking.o: viking.S<br>
-	$(CC) -D__ASSEMBLY__ -ansi -c -o viking.o viking.S<br>
-<br>
-tsunami.o: tsunami.S<br>
-	$(CC) -D__ASSEMBLY__ -ansi -c -o tsunami.o tsunami.S<br>
-<br>
-endif<br>
diff -urN linux-2.1.106/arch/sparc64/kernel/Makefile linux/arch/sparc64/kernel/Makefile<br>
--- linux-2.1.106/arch/sparc64/kernel/Makefile	Wed Jun 17 06:51:37 1998<br>
+++ linux/arch/sparc64/kernel/Makefile	Wed Jun 24 09:40:03 1998<br>
@@ -7,23 +7,11 @@<br>
 #<br>
 # Note 2! The CFLAGS definitions are now in the main makefile...<br>
 <br>
-ifdef SMP<br>
-<br>
 .S.s:<br>
 	$(CPP) -D__ASSEMBLY__ $(AFLAGS) -ansi $&lt; -o $*.s<br>
 <br>
 .S.o:<br>
 	$(CC) -D__ASSEMBLY__ $(AFLAGS) -ansi -c $&lt; -o $*.o<br>
-<br>
-else<br>
-<br>
-.S.s:<br>
-	$(CPP) -D__ASSEMBLY__ -ansi $&lt; -o $*.s<br>
-<br>
-.S.o:<br>
-	$(CC) -D__ASSEMBLY__ -ansi -c $&lt; -o $*.o<br>
-<br>
-endif<br>
 <br>
 all: kernel.o head.o init_task.o<br>
 <br>
diff -urN linux-2.1.106/arch/sparc64/mm/Makefile linux/arch/sparc64/mm/Makefile<br>
--- linux-2.1.106/arch/sparc64/mm/Makefile	Thu Jul 31 22:09:17 1997<br>
+++ linux/arch/sparc64/mm/Makefile	Wed Jun 24 09:40:03 1998<br>
@@ -7,23 +7,11 @@<br>
 #<br>
 # Note 2! The CFLAGS definition is now in the main makefile...<br>
 <br>
-ifdef SMP<br>
-<br>
 .S.s:<br>
 	$(CPP) -D__ASSEMBLY__ $(AFLAGS) -ansi $&lt; -o $*.s<br>
 <br>
 .S.o:<br>
 	$(CC) -D__ASSEMBLY__ $(AFLAGS) -ansi -c $&lt; -o $*.o<br>
-<br>
-else<br>
-<br>
-.S.s:<br>
-	$(CPP) -D__ASSEMBLY__ -ansi $&lt; -o $*.s<br>
-<br>
-.S.o:<br>
-	$(CC) -D__ASSEMBLY__ -ansi -c $&lt; -o $*.o<br>
-<br>
-endif<br>
 <br>
 O_TARGET := mm.o<br>
 O_OBJS   := ultra.o fault.o init.o generic.o asyncd.o extable.o modutil.o<br>
diff -urN linux-2.1.106/drivers/char/Makefile linux/drivers/char/Makefile<br>
--- linux-2.1.106/drivers/char/Makefile	Wed Jun 17 06:55:59 1998<br>
+++ linux/drivers/char/Makefile	Wed Jun 24 09:40:04 1998<br>
@@ -456,7 +456,7 @@<br>
 fastdep:<br>
 <br>
 conmakehash: conmakehash.c<br>
-	$(HOSTCC) -o conmakehash conmakehash.c<br>
+	$(HOSTCC) $(HOSTCFLAGS) -o conmakehash conmakehash.c<br>
 <br>
 consolemap_deftbl.c: $(FONTMAPFILE) conmakehash<br>
 	./conmakehash $(FONTMAPFILE) &gt; consolemap_deftbl.c<br>
diff -urN linux-2.1.106/drivers/char/conmakehash.c linux/drivers/char/conmakehash.c<br>
--- linux-2.1.106/drivers/char/conmakehash.c	Wed Jun 17 06:45:06 1998<br>
+++ linux/drivers/char/conmakehash.c	Wed Jun 24 09:40:04 1998<br>
@@ -52,7 +52,6 @@<br>
 void addpair(int fp, int un)<br>
 {<br>
   int i;<br>
-  unicode hu;<br>
 <br>
   if ( un &lt;= 0xfffe )<br>
     {<br>
diff -urN linux-2.1.106/drivers/char/hfmodem/Makefile linux/drivers/char/hfmodem/Makefile<br>
--- linux-2.1.106/drivers/char/hfmodem/Makefile	Tue Aug  5 18:48:55 1997<br>
+++ linux/drivers/char/hfmodem/Makefile	Wed Jun 24 09:40:04 1998<br>
@@ -25,7 +25,7 @@<br>
 .PHONY:		all<br>
 <br>
 gentbl:		gentbl.c<br>
-		$(HOSTCC) -Wall $&lt; -o $@ -lm<br>
+		$(HOSTCC) $(HOSTCFLAGS) $&lt; -o $@ -lm<br>
 <br>
 TBLHDR		:= tables.h<br>
 <br>
diff -urN linux-2.1.106/drivers/net/hamradio/soundmodem/Makefile linux/drivers/net/hamradio/soundmodem/Makefile<br>
--- linux-2.1.106/drivers/net/hamradio/soundmodem/Makefile	Thu Sep  4 22:25:28 1997<br>
+++ linux/drivers/net/hamradio/soundmodem/Makefile	Wed Jun 24 09:40:04 1998<br>
@@ -46,7 +46,7 @@<br>
 .PHONY:		all<br>
 <br>
 gentbl:		gentbl.c<br>
-		$(HOSTCC) -Wall $&lt; -o $@ -lm<br>
+		$(HOSTCC) $(HOSTCFLAGS) $&lt; -o $@ -lm<br>
 <br>
 TBLHDR		:= sm_tbl_afsk1200.h sm_tbl_afsk2400_8.h <br>
 TBLHDR		+= sm_tbl_afsk2666.h sm_tbl_psk4800.h<br>
diff -urN linux-2.1.106/drivers/net/hamradio/soundmodem/gentbl.c linux/drivers/net/hamradio/soundmodem/gentbl.c<br>
--- linux-2.1.106/drivers/net/hamradio/soundmodem/gentbl.c	Wed Jun 17 06:49:51 1998<br>
+++ linux/drivers/net/hamradio/soundmodem/gentbl.c	Wed Jun 24 09:40:04 1998<br>
@@ -438,7 +438,7 @@<br>
 {<br>
         int i, j, k, l;<br>
 	float s;<br>
-	float c[40];<br>
+	float c[44];<br>
 	float min, max;<br>
 <br>
 	fprintf(f, "\n/*\n * hapn4800 specific tables\n */\n\n");<br>
diff -urN linux-2.1.106/drivers/sound/Makefile linux/drivers/sound/Makefile<br>
--- linux-2.1.106/drivers/sound/Makefile	Wed Jun 17 06:57:10 1998<br>
+++ linux/drivers/sound/Makefile	Wed Jun 24 09:40:04 1998<br>
@@ -185,10 +185,10 @@<br>
 # First make the utilities.<br>
 <br>
 bin2hex: bin2hex.c<br>
-	$(HOSTCC) -o bin2hex bin2hex.c<br>
+	$(HOSTCC) $(HOSTCFLAGS) -o bin2hex bin2hex.c<br>
 <br>
 hex2hex: hex2hex.c<br>
-	$(HOSTCC) -o hex2hex hex2hex.c<br>
+	$(HOSTCC) $(HOSTCFLAGS) -o hex2hex hex2hex.c<br>
 <br>
 <br>
 <br>
diff -urN linux-2.1.106/scripts/Makefile linux/scripts/Makefile<br>
--- linux-2.1.106/scripts/Makefile	Mon Jan  5 10:41:01 1998<br>
+++ linux/scripts/Makefile	Wed Jun 24 09:40:04 1998<br>
@@ -1,4 +1,3 @@<br>
-HOSTCFLAGS:=$(HOSTCFLAGS) -g -Wall<br>
 HEADER=header.tk<br>
 TAIL=tail.tk<br>
 <br>
diff -urN linux-2.1.106/scripts/lxdialog/Makefile linux/scripts/lxdialog/Makefile<br>
--- linux-2.1.106/scripts/lxdialog/Makefile	Sat Apr 20 10:18:14 1996<br>
+++ linux/scripts/lxdialog/Makefile	Wed Jun 24 09:40:04 1998<br>
@@ -1,8 +1,7 @@<br>
-CC = gcc<br>
-CPP = gcc -E<br>
-OPTIM = -O2 -Wall -fomit-frame-pointer<br>
+CC = $(HOSTCC)<br>
+CPP = $(HOSTCC) -E<br>
 <br>
-CFLAGS = $(OPTIM) -DLOCALE <br>
+CFLAGS = $(HOSTCFLAGS) -DLOCALE <br>
 LDFLAGS = -s -L .<br>
 LDLIBS = -lncurses<br>
 <br>
<p>
<pre>
--
Med venlig hilsen / Best regards
                                                          <a href="mailto:nkbj@image.dk">nkbj@image.dk</a>
Niels Kristian Bech Jensen                   <a href="http://www.image.dk/~nkbj/">http://www.image.dk/~nkbj/</a>
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1671.html">Marcus Meissner: "[2.1.107] new console handling problems"</a>
<li> <b>Previous message:</b> <a href="1669.html">MOLNAR Ingo: "Re: kswapd's priority"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
