<!-- received="Sat Jun 27 07:51:14 1998 EET DST" -->
<!-- sent="Fri, 26 Jun 1998 18:16:59 -0700 (PDT)" -->
<!-- name="Linus Torvalds" -->
<!-- email="torvalds@transmeta.com" -->
<!-- subject="Re: Thread implementations..." -->
<!-- id="" -->
<!-- inreplyto="Pine.GSO.3.96.980626201051.6245I-100000@csb" -->
<title>Linux-kernel mailing list archive 1998-25,: Re: Thread implementations...</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Thread implementations...</h1>
<b>Linus Torvalds</b> (<a href="mailto:torvalds@transmeta.com"><i>torvalds@transmeta.com</i></a>)<br>
<i>Fri, 26 Jun 1998 18:16:59 -0700 (PDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1843">[ date ]</a><a href="index.html#1843">[ thread ]</a><a href="subject.html#1843">[ subject ]</a><a href="author.html#1843">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1844.html">david parsons: "Re: (reiserfs) Re: LVM / Filesystems / High availability"</a>
<li> <b>Previous message:</b> <a href="1842.html">Alex Buell: "Re: egcs-1.0.3a weirdness with lynx-2.8 on v2.1.107"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1874.html">Andi Kleen: "Re: Thread implementations..."</a>
<li> <b>Reply:</b> <a href="1874.html">Andi Kleen: "Re: Thread implementations..."</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Fri, 26 Jun 1998, Adam D. Bradley wrote:<br>
<i>&gt; </i><br>
<i>&gt; I think the send() idea Alan and Linus tossed around is the cleanest</i><br>
<i>&gt; way to go, in combination with:</i><br>
<i>&gt; 	setsockopt(fd, SOL_SOCKET, SO_CONSTIPATED)</i><br>
<i>&gt; ;-)</i><br>
<p>
I'd like to still get David's feedback on this (and I definitely would<br>
prefer a different name for the socket option ;), but I really think it's<br>
the right way to go. <br>
<p>
I just made a pre-2.1.108 and put it on ftp.kernel.org - it fixes a<br>
problem where my sendfile() forgot to get the kernel lock (blush), so it<br>
randomly didn't work correctly on SMP. <br>
<p>
I've also done some more testing of sendfile(), and the nice thing is that<br>
when I compared doing a file copy with sendfile compared to a plain "cp",<br>
the sendfile implementation was about twice as fast (at least my version<br>
of "cp" will just do read+write pairs over and over again). When I copied<br>
a 38MB file the "cp" took 1:58 seconds while sendfile took 1:08 seconds<br>
according to "time" (I have 512MB of RAM, so this was all cached,<br>
obviously).. <br>
<p>
I haven't done any network tests, because I don't think I'd be able to see<br>
any difference, and it does need the "SO_CONSTIPATED" thing and a way to<br>
push the end of data for best performance.<br>
<p>
Some final words on sendfile():<br>
<p>
 - it does report errors correctly. That doesn't mean that you necessarily<br>
   can know _which_ fd produced the error, that you have to find out on<br>
   your own. A file real access can generally result in EIO and EACCES<br>
   (the latter with NFS and other "protection-at-read-time" non-UNIX<br>
   filesystems), while the output write() can result in a number of errors<br>
   as the output fd can be any kind of socket/tty/file. Depending on the<br>
   mode of the output file, the output errors can include EINTR, EAGAIN<br>
   etc, and you can mix sendfile() with select() on the output socket, for<br>
   example.<br>
<p>
 - you can give it a length of MAX_ULONG, and it will write as much as it<br>
   can. This is entirely consistent with the notion that it is equivalent<br>
   with write(out, tmpbuf, read(in, tmpbuf, size)) where "tmpbuf" is<br>
   essentially infinite - the read() will read al of the file and return<br>
   the file length in the process. Thus you don't even need to know the<br>
   size of the file beforehand.<br>
<p>
   The file copy test was essentially done with a single<br>
<p>
	error = sendfile(out, in, ~0);<br>
<p>
   and I'm appending my current test-program.<br>
<p>
This is going to be in 2.2, btw. The changes are so small and so obviously<br>
have to work that it would be ridiculous not to have this - the only<br>
question is whether I'll try to make it a "copyfd()" system call instead,<br>
falling back on read+write when I can't use the page cache directly. I<br>
suspect I won't. <br>
<p>
			Linus<br>
<p>
-----<br>
/*<br>
 * Very stupid example of using the sendfile()<br>
 * system call.<br>
 */<br>
<p>
#include &lt;stdio.h&gt;<br>
#include &lt;sys/types.h&gt;<br>
#include &lt;unistd.h&gt;<br>
#include &lt;errno.h&gt;<br>
#include &lt;sys/fcntl.h&gt;<br>
<p>
ssize_t sendfile(int out, int in, size_t size)<br>
{<br>
	ssize_t retval;<br>
<p>
	asm volatile(<br>
		"pushl %%ebx\n\t"<br>
		"movl %%esi,%%ebx\n\t"<br>
		"int $0x80\n\t"<br>
		"popl %%ebx"<br>
		:"=a" (retval)<br>
		:"0" (187),<br>
		 "S" (out),	/* pseudo-ebx */<br>
		 "c" (in),<br>
		 "d" (size));<br>
	if ((unsigned long) retval &gt; (unsigned long)-1000) {<br>
		errno = -retval;<br>
		retval = -1;<br>
	}<br>
	return retval;<br>
}<br>
<p>
int main(int argc, char **argv)<br>
{<br>
	int in, out, error;<br>
<p>
	in = open(argv[1], O_RDONLY);<br>
	if (in &lt; 0) {<br>
		perror("open input");<br>
		exit(1);<br>
	}<br>
	out = open(argv[2], O_WRONLY | O_CREAT, 0666);<br>
	if (out &lt; 0) {<br>
		perror("open output");<br>
		exit(1);<br>
	}<br>
	error = sendfile(out, in, ~0);<br>
	printf("sendfile returned %d\n", error);<br>
	if (error &lt; 0) {<br>
		perror("sendfile");<br>
	}<br>
	return 0;<br>
}<br>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1844.html">david parsons: "Re: (reiserfs) Re: LVM / Filesystems / High availability"</a>
<li> <b>Previous message:</b> <a href="1842.html">Alex Buell: "Re: egcs-1.0.3a weirdness with lynx-2.8 on v2.1.107"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1874.html">Andi Kleen: "Re: Thread implementations..."</a>
<li> <b>Reply:</b> <a href="1874.html">Andi Kleen: "Re: Thread implementations..."</a>
<!-- reply="end" -->
</ul>
</font></body>
