<!-- received="Sun May 30 01:37:55 1999 EET DST" -->
<!-- sent="Fri, 28 May 1999 05:55:07 +0100 (BST)" -->
<!-- name="Stephen C. Tweedie" -->
<!-- email="sct@redhat.com" -->
<!-- subject="Re: [PATCH] 2.2.9: block_read bug" -->
<!-- id="" -->
<!-- inreplyto="13811608@toto.iv" -->
<title>Linux-kernel mailing list archive 1999-22,: Re: [PATCH] 2.2.9: block_read bug</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: [PATCH] 2.2.9: block_read bug</h1>
<b>Stephen C. Tweedie</b> (<a href="mailto:sct@redhat.com"><i>sct@redhat.com</i></a>)<br>
<i>Fri, 28 May 1999 05:55:07 +0100 (BST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#15">[ date ]</a><a href="index.html#15">[ thread ]</a><a href="subject.html#15">[ subject ]</a><a href="author.html#15">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0016.html">James Willard: "Re: How to pass network card options.."</a>
<li> <b>Previous message:</b> <a href="0014.html">David S. Miller: "Re: pre-2.3.4.."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi,<br>
<p>
Linus, this patch looks as if it fixes a rather nasty<br>
readahead/end-of-device bug lurking in the block read code.<br>
<p>
On Mon, 24 May 1999 18:54:12 +0100 (GMT), Tim Waugh<br>
&lt;<a href="mailto:tim@cyberelk.demon.co.uk">tim@cyberelk.demon.co.uk</a>&gt; said:<br>
<p>
<i>&gt; There is a problem with block_read.  While running badblocks on a</i><br>
<i>&gt; particular partition on a particular machine, I've seen control fall out</i><br>
<i>&gt; of the inner loop here with bhe equal to bhb, but with left still</i><br>
<i>&gt; 1024.</i><br>
<p>
That's perfectly OK.  bhe==bhb just means that we have processed the<br>
entire readahead buffer already.  That buffer is a fixed length, so if<br>
we request more data than will fit into it, we will still have non-zero<br>
IO left at this point.<br>
<p>
The problem only occurs if we go back round the loop with blocks==0.  In<br>
that case, we'll not submit any new IO requests but will treat the<br>
readahead list as if it were full, not empty.  Things go horribly wrong<br>
at this point.<br>
<p>
As far as I can tell, this can only occur if we truncated the requested<br>
blocks count due to encountering the end of the device, but it does look<br>
like a problem.  <br>
<p>
<i>&gt; The code is a little hard to follow.  Here is a patch that prevents the</i><br>
<i>&gt; bug from causing the otherwise inevitable oopses.  Does someone who knows</i><br>
<i>&gt; that code a little better than me want to take a closer look and see why</i><br>
<i>&gt; this is happening in the first place?</i><br>
<p>
Your patch looks perfectly good.  We only get into difficulty if several<br>
conditions are all met:<br>
<p>
* last is non-zero: there is still space in the user buffer<br>
* blocks is zero (we hit end-of-device)<br>
* the readahead buffer has been emptied in this pass<br>
<p>
In this case, we know for sure that there is nothing useful left to be<br>
done: !blocks indicates no more IO left to submit, and (bhe == bhb)<br>
indicates no more readahead buffer left to process.  If the patch you<br>
suggest not only looks correct but also actually fixes the problem, then<br>
I think we have a winner.<br>
<p>
--Stephen<br>
<p>
----------------------------------------------------------------<br>
--- block_dev.c.orig	Mon May 24 18:41:04 1999<br>
+++ block_dev.c	Mon May 24 18:41:07 1999<br>
@@ -273,6 +273,8 @@<br>
 			if (++bhe == &amp;buflist[NBUF])<br>
 				bhe = buflist;<br>
 		} while (left &gt; 0 &amp;&amp; bhe != bhb &amp;&amp; (!*bhe || !buffer_locked(*bhe)));<br>
+		if (bhe == bhb &amp;&amp; !blocks)<br>
+			break;<br>
 	} while (left &gt; 0);<br>
 <br>
 /* Release the read-ahead blocks */<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0016.html">James Willard: "Re: How to pass network card options.."</a>
<li> <b>Previous message:</b> <a href="0014.html">David S. Miller: "Re: pre-2.3.4.."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
