<!-- received="Sun May 30 09:58:29 1999 EET DST" -->
<!-- sent="Fri, 28 May 1999 21:53:03 +0100 (GMT)" -->
<!-- name="Tim Waugh" -->
<!-- email="tim@cyberelk.demon.co.uk" -->
<!-- subject="Re: [PATCH] optimised memmove() for alpha" -->
<!-- id="" -->
<!-- inreplyto="19990527000349.A18186@kotol.kotelna.sk" -->
<title>Linux-kernel mailing list archive 1999-22,: Re: [PATCH] optimised memmove() for alpha</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: [PATCH] optimised memmove() for alpha</h1>
<b>Tim Waugh</b> (<a href="mailto:tim@cyberelk.demon.co.uk"><i>tim@cyberelk.demon.co.uk</i></a>)<br>
<i>Fri, 28 May 1999 21:53:03 +0100 (GMT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#73">[ date ]</a><a href="index.html#73">[ thread ]</a><a href="subject.html#73">[ subject ]</a><a href="author.html#73">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0074.html">Andrew R. Baker: "Re: Help with oops"</a>
<li> <b>Previous message:</b> <a href="0072.html">Stephen C. Tweedie: "Re: Q: PAGE_CACHE_SIZE?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Here is an untested fix to the memmove patch.<br>
<p>
I think the code looks quite ugly with tests everywhere to see which<br>
direction we are going in.  Perhaps it would be better to split out<br>
separate functions for that, and have memcpy just use the 'up' versions.<br>
<p>
Tim.<br>
*/<br>
<p>
--- memcpy.c.orig	Fri May 28 21:47:22 1999<br>
+++ memcpy.c	Fri May 28 21:49:17 1999<br>
@@ -106,11 +106,13 @@<br>
 	n -= 8;<br>
 	while (n &gt;= 0) {<br>
 		unsigned long tmp;<br>
+		if (dir &lt;= 0) s -= 8;<br>
 		__asm__("ldq %0,%1":"=r" (tmp):"m" (*(unsigned long *) s));<br>
 		n -= 8;<br>
-		(dir &gt; 0) ? (s += 8) : (s -= 8);<br>
+		if (dir &gt; 0) s += 8;<br>
+		else d -= 8;<br>
 		*(unsigned long *) d = tmp;<br>
-		(dir &gt; 0) ? (d += 8) : (d -= 8);<br>
+		if (dir &gt; 0) d += 8;<br>
 	}<br>
 	n += 8;<br>
 	DO_REST_ALIGNED(d,s,n);<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0074.html">Andrew R. Baker: "Re: Help with oops"</a>
<li> <b>Previous message:</b> <a href="0072.html">Stephen C. Tweedie: "Re: Q: PAGE_CACHE_SIZE?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
