<!-- received="Mon May 31 00:07:38 1999 EET DST" -->
<!-- sent="29 May 1999 12:22:00 -0500" -->
<!-- name="Eric W. Biederman" -->
<!-- email="ebiederm+eric@ccr.net" -->
<!-- subject="Re: [RFC][PATCH] rename() on braindead filesystems" -->
<!-- id="" -->
<!-- inreplyto="Wed, 26 May 1999 00:42:48 -0400 (EDT)"" -->
<title>Linux-kernel mailing list archive 1999-22,: Re: [RFC][PATCH] rename() on braindead filesystems</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: [RFC][PATCH] rename() on braindead filesystems</h1>
<b>Eric W. Biederman</b> (<a href="mailto:ebiederm%22eric@ccr.net"><i>ebiederm+eric@ccr.net</i></a>)<br>
<i>29 May 1999 12:22:00 -0500</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#169">[ date ]</a><a href="index.html#169">[ thread ]</a><a href="subject.html#169">[ subject ]</a><a href="author.html#169">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0170.html">Giuliano Pochini: "Re: Allocation of too much memory hangs system, kernel 2.2.*"</a>
<li> <b>Previous message:</b> <a href="0168.html">Alistair Riddell: "Re: How to pass network card options.."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
For handling case changes how about something like this:<br>
<p>
Where the idea is for renames:<br>
a) Always change the case of the name in the dcache, (if the bytes don't match)<br>
   It doesn't hurt as it hashes the same, and compares the same,<br>
   and could be anything anyway, d_lookup is what sets it.<br>
b) Explicitly allow the case where old_dentry-&gt;d_inode == new_dentry-&gt;d_inode<br>
   and the case has changed. (Either by calling inode-&gt;i_op-&gt;rename,<br>
   or a new function inode-&gt;i_op-&gt;case_change..)<br>
c) In the filesystems affected handle the case where new_dentry == old_dentry.<br>
<p>
The code below mostly implements this but it doesn't handle storage allocation<br>
properly.<br>
<p>
Eric<br>
<p>
<p>
--- namei.c.good	Sat May 29 11:08:15 1999<br>
+++ namei.c	Sat May 29 11:42:08 1999<br>
@@ -1240,9 +1240,6 @@<br>
 	int error;<br>
 	int need_rehash = 0;<br>
 <br>
-	if (old_dentry-&gt;d_inode == new_dentry-&gt;d_inode)<br>
-		return 0;<br>
-<br>
 	error = may_delete(old_dir, old_dentry, 1);<br>
 	if (error)<br>
 		return error;<br>
@@ -1297,9 +1294,6 @@<br>
 {<br>
 	int error;<br>
 <br>
-	if (old_dentry-&gt;d_inode == new_dentry-&gt;d_inode)<br>
-		return 0;<br>
-<br>
 	error = may_delete(old_dir, old_dentry, 0);<br>
 	if (error)<br>
 		return error;<br>
@@ -1330,8 +1324,19 @@<br>
 }<br>
 <br>
 int vfs_rename(struct inode *old_dir, struct dentry *old_dentry,<br>
-	       struct inode *new_dir, struct dentry *new_dentry)<br>
+	       struct inode *new_dir, struct dentry *new_dentry,<br>
+	       char *newname)<br>
 {<br>
+	int byte_change = 0;<br>
+	if (strcmp(new_dentry-&gt;d_name, newname) != 0) {<br>
+		byte_change = 1;<br>
+		strcpy(new_dentry-&gt;d_name, newname);<br>
+	}<br>
+	if ((old_dentry-&gt;d_inode == new_dentry-&gt;d_inode) <br>
+		&amp;&amp; (!byte_change || (new_dentry != old_dentry))) {<br>
+		return 0;<br>
+	}<br>
+<br>
 	if (S_ISDIR(old_dentry-&gt;d_inode-&gt;i_mode))<br>
 		return vfs_rename_dir(old_dir,old_dentry,new_dir,new_dentry);<br>
 	else<br>
@@ -1373,7 +1378,7 @@<br>
 	error = -ENOENT;<br>
 	if (check_parent(old_dir, old_dentry) &amp;&amp; check_parent(new_dir, new_dentry))<br>
 		error = vfs_rename(old_dir-&gt;d_inode, old_dentry,<br>
-				   new_dir-&gt;d_inode, new_dentry);<br>
+				   new_dir-&gt;d_inode, new_dentry, newname);<br>
 <br>
 	double_unlock(new_dir, old_dir);<br>
 	dput(new_dentry);<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0170.html">Giuliano Pochini: "Re: Allocation of too much memory hangs system, kernel 2.2.*"</a>
<li> <b>Previous message:</b> <a href="0168.html">Alistair Riddell: "Re: How to pass network card options.."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
