<!-- received="Mon May 31 04:59:24 1999 EET DST" -->
<!-- sent="Sun, 30 May 1999 12:41:41 -0300 (EST)" -->
<!-- name="Augusto Cesar" -->
<!-- email="bishop@sekure.org" -->
<!-- subject="Re: [PATCH]: alternative security - special gids" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.4.10.9905281808140.1040-100000@localhost" -->
<title>Linux-kernel mailing list archive 1999-22,: Re: [PATCH]: alternative security - special gids</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: [PATCH]: alternative security - special gids</h1>
<b>Augusto Cesar</b> (<a href="mailto:bishop@sekure.org"><i>bishop@sekure.org</i></a>)<br>
<i>Sun, 30 May 1999 12:41:41 -0300 (EST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#214">[ date ]</a><a href="index.html#214">[ thread ]</a><a href="subject.html#214">[ subject ]</a><a href="author.html#214">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0215.html">Siddharth Srivastava: "Re: Lauching a userland program inside the kernel"</a>
<li> <b>Previous message:</b> <a href="0213.html">Horst von Brand: "Re: [PATCH] Improving send_sigio() scalability"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Fri, 28 May 1999, Augusto Cesar wrote:<br>
<p>
Im sorry, pine have some problems with the permissions of attached patch.<br>
Im sending as plaintext.<br>
<p>
<p>
------------------<br>
<p>
diff -urN v2.2.9/include/linux/sysctl.h linux/include/linux/sysctl.h<br>
--- v2.2.9/include/linux/sysctl.h       Sat Apr 24 16:47:47 1999<br>
+++ linux/include/linux/sysctl.h        Fri May 28 18:03:46 1999<br>
@@ -223,7 +223,9 @@<br>
        NET_IPV4_ICMP_PARAMPROB_RATE=62,<br>
        NET_IPV4_ICMP_ECHOREPLY_RATE=63,<br>
        NET_IPV4_ICMP_IGNORE_BOGUS_ERROR_RESPONSES=64,<br>
-       NET_IPV4_IGMP_MAX_MEMBERSHIPS=65<br>
+       NET_IPV4_IGMP_MAX_MEMBERSHIPS=65,<br>
+       NET_IPV4_SOCKET_PORT_GID=66,<br>
+       NET_IPV4_SOCKET_RAW_GID=67,<br>
 };<br>
   <br>
 enum {<br>
diff -urN v2.2.9/net/ipv4/af_inet.c linux/net/ipv4/af_inet.c<br>
--- v2.2.9/net/ipv4/af_inet.c   Thu Apr 22 23:45:19 1999<br>
+++ linux/net/ipv4/af_inet.c    Fri May 28 18:28:51 1999<br>
@@ -54,6 +54,7 @@<br>
  *                                     Some other random speedups.<br>
  *             Cyrus Durgin    :       Cleaned up file for kmod hacks.<br>
  *             Andi Kleen      :       Fix inet_stream_connect TCP race.<br>
+ *             Augusto Cesar   :       Added special gids support.<br>
  *<br>
  *             This program is free software; you can redistribute it<br>
and/or<br>
  *             modify it under the terms of the GNU General Public<br>
License<br>
@@ -120,6 +121,10 @@<br>
<p>
 struct linux_mib net_statistics;<br>
<p>
+/* default control parameters for special gids */<br>
+int sysctl_socket_port_gid = 16;<br>
+int sysctl_socket_raw_gid = 17; <br>
+<br>
 extern int raw_get_info(char *, char **, off_t, int, int);<br>
 extern int snmp_get_info(char *, char **, off_t, int, int);<br>
 extern int netstat_get_info(char *, char **, off_t, int, int);<br>
@@ -330,6 +335,7 @@<br>
        /* Compatibility */<br>
        if (sock-&gt;type == SOCK_PACKET) {<br>
                static int warned; <br>
+               <br>
                if (net_families[PF_PACKET]==NULL)<br>
                {<br>
 #if defined(CONFIG_KMOD) &amp;&amp; defined(CONFIG_PACKET_MODULE)<br>
@@ -375,7 +381,8 @@<br>
                break;<br>
        case SOCK_RAW:<br>
                if (!capable(CAP_NET_RAW))<br>
-                       goto free_and_badperm;<br>
+                       if (current-&gt;egid != sysctl_socket_raw_gid)<br>
+                               goto free_and_badperm;<br>
                if (!protocol)<br>
                        goto free_and_noproto;<br>
                prot = &amp;raw_prot;<br>
@@ -543,7 +550,8 @@<br>
        if (snum == 0)<br>
                snum = sk-&gt;prot-&gt;good_socknum();<br>
        if (snum &lt; PROT_SOCK &amp;&amp; !capable(CAP_NET_BIND_SERVICE))<br>
-               return(-EACCES);<br>
+               if (current-&gt;egid != sysctl_socket_port_gid)<br>
+                       return(-EACCES);<br>
        <br>
        /* Make sure we are allowed to bind here. */<br>
        if(sk-&gt;prot-&gt;verify_bind(sk, snum))<br>
diff -urN v2.2.9/net/ipv4/sysctl_net_ipv4.c<br>
linux/net/ipv4/sysctl_net_ipv4.c<br>
--- v2.2.9/net/ipv4/sysctl_net_ipv4.c   Mon Jan  4 21:31:35 1999<br>
+++ linux/net/ipv4/sysctl_net_ipv4.c    Fri May 28 18:03:22 1999<br>
@@ -28,6 +28,10 @@<br>
 static int boolean_max = 1;<br>
 #endif<br>
 <br>
+/* From af_inet.c */<br>
+extern int sysctl_socket_port_gid;<br>
+extern int sysctl_socket_raw_gid; <br>
+<br>
 /* From icmp.c */<br>
 extern int sysctl_icmp_echo_ignore_all;<br>
 extern int sysctl_icmp_echo_ignore_broadcasts;<br>
@@ -95,6 +99,12 @@<br>
 <br>
 <br>
 ctl_table ipv4_table[] = {<br>
+        {NET_IPV4_SOCKET_PORT_GID, "socket_port_gid",<br>
+         &amp;sysctl_socket_port_gid, sizeof(int), 0644, NULL,<br>
+         &amp;proc_dointvec},<br>
+        {NET_IPV4_SOCKET_RAW_GID, "socket_raw_gid",<br>
+         &amp;sysctl_socket_raw_gid, sizeof(int), 0644, NULL,<br>
+         &amp;proc_dointvec},<br>
         {NET_IPV4_TCP_TIMESTAMPS, "tcp_timestamps",<br>
          &amp;sysctl_tcp_timestamps, sizeof(int), 0644, NULL,<br>
          &amp;proc_dointvec},<br>
<p>
--------------------<br>
<p>
<p>
<pre>
--
Augusto Cesar
Sekure SDI
<a href="http://www.sekure.org">http://www.sekure.org</a>
<p>
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0215.html">Siddharth Srivastava: "Re: Lauching a userland program inside the kernel"</a>
<li> <b>Previous message:</b> <a href="0213.html">Horst von Brand: "Re: [PATCH] Improving send_sigio() scalability"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
