<!-- received="Mon May 31 06:45:36 1999 EET DST" -->
<!-- sent="Sun, 30 May 1999 07:50:57 -0400 (EDT)" -->
<!-- name="Jeff Garzik" -->
<!-- email="jgarzik@pobox.com" -->
<!-- subject="[2.3.4.pre2] alpha compile fixes" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-22,: [2.3.4.pre2] alpha compile fixes</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[2.3.4.pre2] alpha compile fixes</h1>
<b>Jeff Garzik</b> (<a href="mailto:jgarzik@pobox.com"><i>jgarzik@pobox.com</i></a>)<br>
<i>Sun, 30 May 1999 07:50:57 -0400 (EDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#241">[ date ]</a><a href="index.html#241">[ thread ]</a><a href="subject.html#241">[ subject ]</a><a href="author.html#241">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0242.html">Matthew Kirkwood: "Re: Allocation of too much memory hangs system, kernel 2.2.*"</a>
<li> <b>Previous message:</b> <a href="0240.html">Matthew Wilcox: "Re: Minor bug in lib/string.c"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This patch fixes Alpha compile problems on 2.3.4.pre2.  They seem to be<br>
working on my UP Alpha, but I do get two kmem_grow warnings on bootup.<br>
Maybe kmem_grow warning is not Alpha-specific, though.<br>
<p>
	Jeff<br>
<p>
<p>
Patch changelog:<br>
<p>
	include/asm-alpha/softirq.h: New macros local_bh_{dis,en}able,<br>
	copied from include/asm-i386/softirq.h<br>
<p>
	include/asm-alpha/spinlock.h: New macros {spin,read,write}_{un}lock_bh,<br>
	copied from include/asm-i386/spinlock.h<br>
<p>
	include/linux/interrupt.h: Needs ptrace.h for struct pt_regs.<br>
<p>
Kernel bootup messages:<br>
...<br>
ncr53c810-0-&lt;3,*&gt;: FAST-10 SCSI 10.0 MB/s (100 ns, offset 8)<br>
SCSI device sda: hdwr sector= 512 bytes. Sectors= 2069860 [1010 MB] [1.0 GB]<br>
ncr53c810-0-&lt;6,*&gt;: FAST-10 SCSI 10.0 MB/s (100 ns, offset 8)<br>
SCSI device sdb: hdwr sector= 512 bytes. Sectors= 4124736 [2014 MB] [2.0 GB]<br>
kmem_grow: Called nonatomically from int - size-256<br>
eth0: DE434/5 at 0x8800 (PCI bus 0, device 11), h/w address 00:00:f8:21:6a:09,<br>
kmem_grow: Called nonatomically from int - size-16384<br>
      and requires IRQ15 (provided by PCI BIOS).<br>
de4x5.c:V0.544 1999/5/8 <a href="mailto:davies@maniac.ultranet.com">davies@maniac.ultranet.com</a><br>
Partition check:<br>
 sda: sda1 sda2 sda3 sda4 sda5<br>
 sdb: sdb1 sdb3<br>
...<br>
<p>
<p>
diff -u -r -N linux.pre2/include/asm-alpha/softirq.h linux/include/asm-alpha/softirq.h<br>
--- linux.pre2/include/asm-alpha/softirq.h	Sun Dec 27 18:20:32 1998<br>
+++ linux/include/asm-alpha/softirq.h	Sun May 30 06:53:29 1999<br>
@@ -2,12 +2,16 @@<br>
 #define _ALPHA_SOFTIRQ_H<br>
 <br>
 #include &lt;linux/stddef.h&gt;<br>
+#include &lt;linux/interrupt.h&gt;<br>
+#include &lt;linux/smp.h&gt;<br>
 #include &lt;asm/atomic.h&gt;<br>
 #include &lt;asm/hardirq.h&gt;<br>
 <br>
 extern unsigned int local_bh_count[NR_CPUS];<br>
 <br>
 #define get_active_bhs()	(bh_mask &amp; bh_active)<br>
+#define local_bh_disable()      (local_bh_count[smp_processor_id()]++)<br>
+#define local_bh_enable()       (local_bh_count[smp_processor_id()]--)<br>
 <br>
 static inline void clear_active_bhs(unsigned long x)<br>
 {<br>
diff -u -r -N linux.pre2/include/asm-alpha/spinlock.h linux/include/asm-alpha/spinlock.h<br>
--- linux.pre2/include/asm-alpha/spinlock.h	Sun Jan 10 12:59:59 1999<br>
+++ linux/include/asm-alpha/spinlock.h	Sun May 30 06:53:25 1999<br>
@@ -2,6 +2,15 @@<br>
 #define _ALPHA_SPINLOCK_H<br>
 <br>
 #include &lt;asm/system.h&gt;<br>
+#include &lt;asm/softirq.h&gt;<br>
+<br>
+#define spin_lock_bh(lock)                      do { local_bh_disable(); spin_lock(lock); } while (0)<br>
+#define read_lock_bh(lock)                      do { local_bh_disable(); read_lock(lock); } while (0)<br>
+#define write_lock_bh(lock)                     do { local_bh_disable(); write_lock(lock); } while (0)<br>
+#define spin_unlock_bh(lock)                    do { spin_unlock(lock); local_bh_enable();        } while (0)<br>
+#define read_unlock_bh(lock)                    do { read_unlock(lock); local_bh_enable();        } while (0)<br>
+#define write_unlock_bh(lock)                   do { write_unlock(lock); local_bh_enable();        } while (0)<br>
+<br>
 <br>
 #ifndef __SMP__<br>
 <br>
diff -u -r -N linux.pre2/include/linux/interrupt.h linux/include/linux/interrupt.h<br>
--- linux.pre2/include/linux/interrupt.h	Sun May 16 16:18:21 1999<br>
+++ linux/include/linux/interrupt.h	Sun May 30 06:53:29 1999<br>
@@ -3,6 +3,7 @@<br>
 #define _LINUX_INTERRUPT_H<br>
 <br>
 #include &lt;linux/kernel.h&gt;<br>
+#include &lt;linux/ptrace.h&gt;<br>
 #include &lt;asm/bitops.h&gt;<br>
 #include &lt;asm/atomic.h&gt;<br>
 <br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0242.html">Matthew Kirkwood: "Re: Allocation of too much memory hangs system, kernel 2.2.*"</a>
<li> <b>Previous message:</b> <a href="0240.html">Matthew Wilcox: "Re: Minor bug in lib/string.c"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
