<!-- received="Mon May 31 08:19:00 1999 EET DST" -->
<!-- sent="30 May 1999 12:28:34 -0500" -->
<!-- name="Eric W. Biederman" -->
<!-- email="ebiederm+eric@ccr.net" -->
<!-- subject="[RFC] [PATCH] vm_store" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-22,: [RFC] [PATCH] vm_store</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[RFC] [PATCH] vm_store</h1>
<b>Eric W. Biederman</b> (<a href="mailto:ebiederm%22eric@ccr.net"><i>ebiederm+eric@ccr.net</i></a>)<br>
<i>30 May 1999 12:28:34 -0500</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#282">[ date ]</a><a href="index.html#282">[ thread ]</a><a href="subject.html#282">[ subject ]</a><a href="author.html#282">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0283.html">Vagn Scott: "Re: large directory handling speed"</a>
<li> <b>Previous message:</b> <a href="0281.html">Ralf Baechle: "Re: Linux is a MicroKernal? [was Re: is Linux obsolete?]"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This patch creates the the abstraction of a vm_store, allowing the<br>
page cache to be seperated from the vfs layer.<br>
<p>
It also seperates out what is the page cache, from filemap.c<br>
into mm/vm_store.c<br>
<p>
The only vm_store operation implemented in this patch<br>
is clear_page.  Allowing delete_from_swap_cache to stop being a<br>
special case.<br>
<p>
<p>
Note: This is on top of some other patches, to see my whole series<br>
see:<br>
<a href="http://www.ccr.net/ebiederm/files/patches9.tar.gz">http://www.ccr.net/ebiederm/files/patches9.tar.gz</a><br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/arch/m68k/atari/stram.c linux-2.3.3.eb6/arch/m68k/atari/stram.c<br>
--- linux-2.3.3.eb5/arch/m68k/atari/stram.c	Tue Feb  9 22:52:51 1999<br>
+++ linux-2.3.3.eb6/arch/m68k/atari/stram.c	Sat May 22 18:19:39 1999<br>
@@ -944,7 +944,7 @@<br>
 				/* Now get rid of the extra reference to<br>
 				   the temporary page we've been using. */<br>
 				if (PageSwapCache(page_map))<br>
-					delete_from_swap_cache(page_map);<br>
+						remove_store_page(page_map);<br>
 				__free_page(page_map);<br>
 	#ifdef DO_PROC<br>
 				stat_swap_force++;<br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/fs/dcache.c linux-2.3.3.eb6/fs/dcache.c<br>
--- linux-2.3.3.eb5/fs/dcache.c	Sun May 16 21:53:57 1999<br>
+++ linux-2.3.3.eb6/fs/dcache.c	Sat May 22 18:19:39 1999<br>
@@ -236,7 +236,7 @@<br>
 		 * (We skip inodes that aren't immediately available.)<br>
 		 */<br>
 		if (inode) {<br>
-			value = inode-&gt;i_nrpages;	<br>
+			value = inode-&gt;vm_store-&gt;st_nrpages;	<br>
 			if (value &gt;= max_value)<br>
 				continue;<br>
 			if (inode-&gt;i_state || inode-&gt;i_count &gt; 1)<br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/fs/exec.c linux-2.3.3.eb6/fs/exec.c<br>
--- linux-2.3.3.eb5/fs/exec.c	Sat May 22 17:16:53 1999<br>
+++ linux-2.3.3.eb6/fs/exec.c	Sat May 22 18:19:39 1999<br>
@@ -316,6 +316,7 @@<br>
 		mpnt-&gt;vm_ops = NULL;<br>
 		mpnt-&gt;vm_index = 0;<br>
 		mpnt-&gt;vm_file = NULL;<br>
+		mpnt-&gt;vm_store = NULL;<br>
 		mpnt-&gt;vm_pte = 0;<br>
 		insert_vm_struct(current-&gt;mm, mpnt);<br>
 		current-&gt;mm-&gt;total_vm = (mpnt-&gt;vm_end - mpnt-&gt;vm_start) &gt;&gt; PAGE_SHIFT;<br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/fs/inode.c linux-2.3.3.eb6/fs/inode.c<br>
--- linux-2.3.3.eb5/fs/inode.c	Sat May 22 16:10:11 1999<br>
+++ linux-2.3.3.eb6/fs/inode.c	Sat May 22 18:19:39 1999<br>
@@ -231,14 +231,12 @@<br>
  */<br>
 void clear_inode(struct inode *inode)<br>
 {<br>
-	if (inode-&gt;i_nrpages)<br>
-		truncate_inode_pages(inode, 0);<br>
 	wait_on_inode(inode);<br>
 	if (IS_QUOTAINIT(inode))<br>
 		DQUOT_DROP(inode);<br>
 	if (inode-&gt;i_sb &amp;&amp; inode-&gt;i_sb-&gt;s_op &amp;&amp; inode-&gt;i_sb-&gt;s_op-&gt;clear_inode)<br>
 		inode-&gt;i_sb-&gt;s_op-&gt;clear_inode(inode);<br>
-<br>
+	zap_inode_pages(inode);<br>
 	inode-&gt;i_state = 0;<br>
 }<br>
 <br>
@@ -549,6 +547,8 @@<br>
 		inode = list_entry(tmp, struct inode, i_list);<br>
 add_new_inode:<br>
 		list_add(&amp;inode-&gt;i_list, &amp;inode_in_use);<br>
+		inode-&gt;vm_store-&gt;st_id = 0;<br>
+		inode-&gt;vm_store-&gt;generic_stp = &amp;inode;<br>
 		inode-&gt;i_sb = NULL;<br>
 		inode-&gt;i_dev = 0;<br>
 		inode-&gt;i_ino = ++last_ino;<br>
@@ -589,6 +589,8 @@<br>
 add_new_inode:<br>
 		list_add(&amp;inode-&gt;i_list, &amp;inode_in_use);<br>
 		list_add(&amp;inode-&gt;i_hash, head);<br>
+		inode-&gt;vm_store-&gt;st_id = 0;<br>
+		inode-&gt;vm_store-&gt;generic_stp = &amp;inode;<br>
 		inode-&gt;i_sb = sb;<br>
 		inode-&gt;i_dev = sb-&gt;s_dev;<br>
 		inode-&gt;i_ino = ino;<br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/fs/locks.c linux-2.3.3.eb6/fs/locks.c<br>
--- linux-2.3.3.eb5/fs/locks.c	Sat May 22 16:09:58 1999<br>
+++ linux-2.3.3.eb6/fs/locks.c	Sat May 22 18:19:39 1999<br>
@@ -403,8 +403,8 @@<br>
 	 */<br>
 	if (IS_MANDLOCK(inode) &amp;&amp;<br>
 	    (inode-&gt;i_mode &amp; (S_ISGID | S_IXGRP)) == S_ISGID &amp;&amp;<br>
-	    inode-&gt;i_mmap) {<br>
-		struct vm_area_struct *vma = inode-&gt;i_mmap;<br>
+	    inode-&gt;vm_store-&gt;st_mmap) {<br>
+		struct vm_area_struct *vma = inode-&gt;vm_store-&gt;st_mmap;<br>
 		error = -EAGAIN;<br>
 		do {<br>
 			if (vma-&gt;vm_flags &amp; VM_MAYSHARE)<br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/include/linux/fs.h linux-2.3.3.eb6/include/linux/fs.h<br>
--- linux-2.3.3.eb5/include/linux/fs.h	Sat May 22 17:16:36 1999<br>
+++ linux-2.3.3.eb6/include/linux/fs.h	Sat May 22 18:19:40 1999<br>
@@ -18,6 +18,7 @@<br>
 #include &lt;linux/list.h&gt;<br>
 #include &lt;linux/dcache.h&gt;<br>
 #include &lt;linux/stat.h&gt;<br>
+#include &lt;linux/vm_store.h&gt;<br>
 <br>
 #include &lt;asm/atomic.h&gt;<br>
 #include &lt;asm/bitops.h&gt;<br>
@@ -356,17 +357,15 @@<br>
 	unsigned long		i_blksize;<br>
 	unsigned long		i_blocks;<br>
 	unsigned long		i_version;<br>
-	unsigned long		i_nrpages;<br>
 	struct semaphore	i_sem;<br>
 	struct semaphore	i_atomic_write;<br>
 	struct inode_operations	*i_op;<br>
 	struct super_block	*i_sb;<br>
 	wait_queue_head_t	i_wait;<br>
 	struct file_lock	*i_flock;<br>
-	struct vm_area_struct	*i_mmap;<br>
-	struct page		*i_pages;<br>
 	struct dquot		*i_dquot[MAXQUOTAS];<br>
 <br>
+ 	struct vm_store		vm_store[1];<br>
 	unsigned long		i_state;<br>
 <br>
 	unsigned int		i_flags;<br>
@@ -788,7 +787,6 @@<br>
 <br>
 extern int check_disk_change(kdev_t dev);<br>
 extern int invalidate_inodes(struct super_block * sb);<br>
-extern void invalidate_inode_pages(struct inode *);<br>
 extern void invalidate_buffers(kdev_t dev);<br>
 extern int floppy_is_wp(int minor);<br>
 extern void sync_inodes(kdev_t dev);<br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/include/linux/mm.h linux-2.3.3.eb6/include/linux/mm.h<br>
--- linux-2.3.3.eb5/include/linux/mm.h	Sat May 22 17:16:53 1999<br>
+++ linux-2.3.3.eb6/include/linux/mm.h	Sat May 22 18:19:40 1999<br>
@@ -16,6 +16,8 @@<br>
 #include &lt;asm/page.h&gt;<br>
 #include &lt;asm/atomic.h&gt;<br>
 <br>
+struct vm_store;<br>
+<br>
 /*<br>
  * Linux kernel virtual memory manager primitives.<br>
  * The idea being to have a "virtual" mm in the same way<br>
@@ -60,6 +62,7 @@<br>
 	 * except the value is potentially too large for the old vm_offset field.<br>
 	 */<br>
 	struct file * vm_file;<br>
+	struct vm_store *vm_store;<br>
 	unsigned long vm_pte;			/* shared mem */<br>
 };<br>
 <br>
@@ -85,6 +88,10 @@<br>
 #define VM_LOCKED	0x2000<br>
 #define VM_IO           0x4000  /* Memory mapped I/O or similar */<br>
 <br>
+#define VM_SPARSE_MERGE	0x8000 /* Sparce VMA's with non continous<br>
+				* indecies may be merged <br>
+				*/<br>
+<br>
 #define VM_STACK_FLAGS	0x0177<br>
 <br>
 /*<br>
@@ -126,7 +133,7 @@<br>
 	/* these must be first (free area handling) */<br>
 	struct page *next;<br>
 	struct page *prev;<br>
-	struct inode *inode;<br>
+	struct vm_store *store;<br>
 	unsigned long key;<br>
 	struct page *next_hash;<br>
 	atomic_t count;<br>
@@ -325,10 +332,12 @@<br>
 extern int do_munmap(unsigned long, size_t);<br>
 <br>
 /* filemap.c */<br>
-extern void remove_inode_page(struct page *);<br>
 extern unsigned long page_unuse(struct page *);<br>
 extern int shrink_mmap(int, int);<br>
 extern void truncate_inode_pages(struct inode *, loff_t);<br>
+extern void invalidate_inode_pages(struct inode *);<br>
+extern void zap_inode_pages(struct inode *);<br>
+extern void update_vm_cache(struct inode *, loff_t, const char *, int);<br>
 extern unsigned long get_cached_page(struct inode *, unsigned long, int);<br>
 extern void put_cached_page(unsigned long);<br>
 <br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/include/linux/pagemap.h linux-2.3.3.eb6/include/linux/pagemap.h<br>
--- linux-2.3.3.eb5/include/linux/pagemap.h	Sat May 22 17:16:36 1999<br>
+++ linux-2.3.3.eb6/include/linux/pagemap.h	Sat May 22 18:19:40 1999<br>
@@ -11,6 +11,7 @@<br>
 <br>
 #include &lt;linux/mm.h&gt;<br>
 #include &lt;linux/fs.h&gt;<br>
+#include &lt;linux/vm_store.h&gt;<br>
 <br>
 static inline unsigned long page_address(struct page * page)<br>
 {<br>
@@ -50,23 +51,23 @@<br>
 /*<br>
  * We use a power-of-two hash table to avoid a modulus,<br>
  * and get a reasonable hash by knowing roughly how the<br>
- * inode pointer and offsets are distributed (ie, we<br>
+ * store pointer and offsets are distributed (ie, we<br>
  * roughly know which bits are "significant")<br>
  */<br>
-static inline unsigned long _page_hashfn(struct inode * inode, unsigned long key)<br>
+static inline unsigned long _page_hashfn(struct vm_store * store, unsigned long key)<br>
 {<br>
-#define i (((unsigned long) inode)/(sizeof(struct inode) &amp; ~ (sizeof(struct inode) - 1)))<br>
+#define i (((unsigned long) store)/(sizeof(struct inode) &amp; ~ (sizeof(struct inode) - 1)))<br>
 #define o (key)<br>
-#define s(x) ((x)+((x)&gt;&gt;PAGE_HASH_BITS))<br>
+#define s(x) ((x)+((x)&gt;&gt;PAGE_HASH_BITS)+((x)&gt;&gt;(PAGE_HASH_BITS*2)))<br>
 	return s(i+o) &amp; (PAGE_HASH_SIZE-1);<br>
 #undef i<br>
 #undef o<br>
 #undef s<br>
 }<br>
 <br>
-#define page_hash(inode,key) (page_hash_table+_page_hashfn(inode,key))<br>
+#define page_hash(store,key) (page_hash_table+_page_hashfn(store,key))<br>
 <br>
-static inline struct page * __find_page(struct inode * inode, unsigned long key, struct page *page)<br>
+static inline struct page * __find_page(struct vm_store * store, unsigned long key, struct page *page)<br>
 {<br>
 	goto inside;<br>
 	for (;;) {<br>
@@ -74,7 +75,7 @@<br>
 inside:<br>
 		if (!page)<br>
 			goto not_found;<br>
-		if (page-&gt;inode != inode)<br>
+		if (page-&gt;store != store)<br>
 			continue;<br>
 		if (page-&gt;key == key)<br>
 			break;<br>
@@ -85,9 +86,9 @@<br>
 not_found:<br>
 	return page;<br>
 }<br>
-static inline struct page *find_page(struct inode * inode, unsigned long key)<br>
+static inline struct page *find_page(struct vm_store * store, unsigned long key)<br>
 {<br>
-	return __find_page(inode, key, *page_hash(inode, key));<br>
+	return __find_page(store, key, *page_hash(store, key));<br>
 }<br>
 <br>
 static inline void remove_page_from_hash_queue(struct page * page)<br>
@@ -110,19 +111,19 @@<br>
 	page-&gt;pprev_hash = p;<br>
 }<br>
 <br>
-static inline void add_page_to_hash_queue(struct page * page, struct inode * inode, unsigned long key)<br>
+static inline void add_page_to_hash_queue(struct page * page, struct vm_store * store, unsigned long key)<br>
 {<br>
-	__add_page_to_hash_queue(page, page_hash(inode,key));<br>
+	__add_page_to_hash_queue(page, page_hash(store,key));<br>
 }<br>
 <br>
-static inline void remove_page_from_inode_queue(struct page * page)<br>
+static inline void remove_page_from_store_queue(struct page * page)<br>
 {<br>
-	struct inode * inode = page-&gt;inode;<br>
+	struct vm_store * store = page-&gt;store;<br>
 <br>
-	page-&gt;inode = NULL;<br>
-	inode-&gt;i_nrpages--;<br>
-	if (inode-&gt;i_pages == page)<br>
-		inode-&gt;i_pages = page-&gt;next;<br>
+	page-&gt;store = NULL;<br>
+	store-&gt;st_nrpages--;<br>
+	if (store-&gt;st_pages == page)<br>
+		store-&gt;st_pages = page-&gt;next;<br>
 	if (page-&gt;next)<br>
 		page-&gt;next-&gt;prev = page-&gt;prev;<br>
 	if (page-&gt;prev)<br>
@@ -131,12 +132,12 @@<br>
 	page-&gt;prev = NULL;<br>
 }<br>
 <br>
-static inline void add_page_to_inode_queue(struct inode * inode, struct page * page)<br>
+static inline void add_page_to_store_queue(struct vm_store * store, struct page * page)<br>
 {<br>
-	struct page **p = &amp;inode-&gt;i_pages;<br>
+	struct page **p = &amp;store-&gt;st_pages;<br>
 <br>
-	inode-&gt;i_nrpages++;<br>
-	page-&gt;inode = inode;<br>
+	store-&gt;st_nrpages++;<br>
+	page-&gt;store = store;<br>
 	page-&gt;prev = NULL;<br>
 	if ((page-&gt;next = *p) != NULL)<br>
 		page-&gt;next-&gt;prev = page;<br>
@@ -150,6 +151,8 @@<br>
 		__wait_on_page(page);<br>
 }<br>
 <br>
-extern void update_vm_cache(struct inode *, loff_t, const char *, int);<br>
+extern void add_to_page_cache(struct page *page,<br>
+	struct vm_store *store, unsigned long key,<br>
+	struct page **hash);<br>
 <br>
 #endif<br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/include/linux/swap.h linux-2.3.3.eb6/include/linux/swap.h<br>
--- linux-2.3.3.eb5/include/linux/swap.h	Sat May 22 17:16:36 1999<br>
+++ linux-2.3.3.eb6/include/linux/swap.h	Sat May 22 18:19:40 1999<br>
@@ -66,7 +66,7 @@<br>
 extern int nr_swap_pages;<br>
 extern int nr_free_pages;<br>
 extern atomic_t nr_async_pages;<br>
-extern struct inode swapper_inode;<br>
+extern struct vm_store swapper_store;<br>
 extern unsigned long page_cache_size;<br>
 extern int buffermem;<br>
 <br>
@@ -107,7 +107,6 @@<br>
 /*<br>
  * Make these inline later once they are working properly.<br>
  */<br>
-extern void delete_from_swap_cache(struct page *page);<br>
 extern void free_page_and_swap_cache(unsigned long addr);<br>
 <br>
 /* linux/mm/swapfile.c */<br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/include/linux/vm_store.h linux-2.3.3.eb6/include/linux/vm_store.h<br>
--- linux-2.3.3.eb5/include/linux/vm_store.h	Wed Dec 31 18:00:00 1969<br>
+++ linux-2.3.3.eb6/include/linux/vm_store.h	Sat May 22 18:19:40 1999<br>
@@ -0,0 +1,52 @@<br>
+#ifndef _LINUX_VM_STORE_H<br>
+#define _LINUX_VM_STORE_H<br>
+#ifdef __KERNEL__<br>
+/*<br>
+ * This structure replaces the use of an inode in the page cache.<br>
+ * struct vm_store is much lighter than an inode, and several of them<br>
+ * can be allocated per inode, to hold large files if necessary.<br>
+ *<br>
+ * Also this should make it much easier to handle reverse page mapping,<br>
+ * and shared memory.<br>
+ *<br>
+ * Note:<br>
+ *  This structure should be an even 32 bytes on 32 bit machines, and<br>
+ *  an even 64 bytes on 64 bit machines.<br>
+ */<br>
+struct vm_store {<br>
+	struct vm_area_struct *st_mmap;<br>
+	struct page *st_pages;<br>
+	unsigned long st_nrpages;<br>
+	struct vm_store_operations *st_ops;<br>
+<br>
+	struct vm_store *st_next;<br>
+	struct vm_store *st_prev;<br>
+	long st_id;  /* user defined */<br>
+	void *generic_stp;<br>
+};<br>
+<br>
+struct vm_store_operations {<br>
+	int (*write_page) (struct vm_store *, struct page *, unsigned long key, void **p);<br>
+	void (*clear_page) (struct vm_store *, struct page *, unsigned long key, void **p);<br>
+};<br>
+<br>
+static inline struct vm_store * find_store(struct vm_store * first, unsigned long id)<br>
+{<br>
+	struct vm_store *store;<br>
+	for(store = first; store != 0; store = store-&gt;st_next) {<br>
+		if (store-&gt;st_id == id) <br>
+			break;<br>
+	}<br>
+	return store;<br>
+}<br>
+extern struct page *get_store_page(struct vm_store *store,<br>
+	unsigned long index, unsigned long *page_cache_ptr);<br>
+extern void invalidate_store_pages(struct vm_store *store);<br>
+extern void zap_store_pages(struct vm_store * store, unsigned long low, unsigned long high);<br>
+extern void remove_store_page(struct page *page);<br>
+extern int shrink_mmap(int priority, int gfp_mask);<br>
+extern void update_vm_store_cache(struct vm_store *store,<br>
+	unsigned long index, unsigned long offset, const char * buf, int count);<br>
+<br>
+#endif /* KERNEL */<br>
+#endif /* _LINUX_VM_STORE_H */<br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/ipc/shm.c linux-2.3.3.eb6/ipc/shm.c<br>
--- linux-2.3.3.eb5/ipc/shm.c	Sat May 22 17:20:31 1999<br>
+++ linux-2.3.3.eb6/ipc/shm.c	Sat May 22 18:19:40 1999<br>
@@ -513,6 +513,7 @@<br>
<i> 			 | VM_MAYREAD | VM_MAYEXEC | VM_READ | VM_EXEC</i><br>
<i> 			 | ((shmflg &amp; SHM_RDONLY) ? 0 : VM_MAYWRITE | VM_WRITE);</i><br>
 	shmd-&gt;vm_file = NULL;<br>
+	shmd-&gt;vm_store = NULL;<br>
 	shmd-&gt;vm_index = 0;<br>
 	shmd-&gt;vm_ops = &amp;shm_vm_ops;<br>
 <br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/mm/Makefile linux-2.3.3.eb6/mm/Makefile<br>
--- linux-2.3.3.eb5/mm/Makefile	Sat May 22 17:09:32 1999<br>
+++ linux-2.3.3.eb6/mm/Makefile	Sat May 22 18:19:40 1999<br>
@@ -10,7 +10,8 @@<br>
 O_TARGET := mm.o<br>
 O_OBJS	 := memory.o mmap.o filemap.o mprotect.o mlock.o mremap.o \<br>
 	    vmalloc.o slab.o \<br>
-	    swap.o vmscan.o page_io.o page_alloc.o swap_state.o swapfile.o<br>
+	    swap.o vmscan.o page_io.o page_alloc.o swap_state.o swapfile.o \<br>
+	    vm_store.o<br>
 <br>
 OX_OBJS := swap_syms.o<br>
 <br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/mm/filemap.c linux-2.3.3.eb6/mm/filemap.c<br>
--- linux-2.3.3.eb5/mm/filemap.c	Sat May 22 17:27:18 1999<br>
+++ linux-2.3.3.eb6/mm/filemap.c	Sat May 22 18:21:10 1999<br>
@@ -53,7 +53,6 @@<br>
 static inline void <br>
 make_pio_request(struct file *, unsigned long, unsigned long);<br>
 <br>
-<br>
 /*<br>
  * Invalidate the pages of an inode, removing all pages that aren't<br>
  * locked down (those are sure to be up-to-date anyway, so we shouldn't<br>
@@ -61,25 +60,7 @@<br>
  */<br>
 void invalidate_inode_pages(struct inode * inode)<br>
 {<br>
-	struct page ** p;<br>
-	struct page * page;<br>
-<br>
-	p = &amp;inode-&gt;i_pages;<br>
-	while ((page = *p) != NULL) {<br>
-		if (PageLocked(page)) {<br>
-			p = &amp;page-&gt;next;<br>
-			continue;<br>
-		}<br>
-		inode-&gt;i_nrpages--;<br>
-		if ((*p = page-&gt;next) != NULL)<br>
-			(*p)-&gt;prev = page-&gt;prev;<br>
-		page-&gt;next = NULL;<br>
-		page-&gt;prev = NULL;<br>
-		remove_page_from_hash_queue(page);<br>
-		page-&gt;inode = NULL;<br>
-		page_cache_release(page);<br>
-		continue;<br>
-	}<br>
+ 	invalidate_store_pages(inode-&gt;vm_store);<br>
 }<br>
 <br>
 /*<br>
@@ -88,7 +69,6 @@<br>
  */<br>
 void truncate_inode_pages(struct inode * inode, loff_t start)<br>
 {<br>
-	struct page ** p;<br>
 	struct page * page;<br>
 	unsigned long last_keep, partial_keep;<br>
 	unsigned long keep_bytes;<br>
@@ -100,30 +80,11 @@<br>
 	partial_keep = start &gt;&gt; PAGE_CACHE_SHIFT;<br>
 	last_keep = partial_keep + (keep_bytes?1:0);<br>
 <br>
-repeat:<br>
-	p = &amp;inode-&gt;i_pages;<br>
-	while ((page = *p) != NULL) {<br>
-		unsigned long index = page-&gt;key;<br>
-<br>
-		/* page wholly truncated - free it */<br>
-		if (index &gt;= last_keep) {<br>
-			if (PageLocked(page)) {<br>
-				wait_on_page(page);<br>
-				goto repeat;<br>
-			}<br>
-			inode-&gt;i_nrpages--;<br>
-			if ((*p = page-&gt;next) != NULL)<br>
-				(*p)-&gt;prev = page-&gt;prev;<br>
-			page-&gt;next = NULL;<br>
-			page-&gt;prev = NULL;<br>
-			remove_page_from_hash_queue(page);<br>
-			page-&gt;inode = NULL;<br>
-			page_cache_release(page);<br>
-			continue;<br>
-		}<br>
-		p = &amp;page-&gt;next;<br>
+	zap_store_pages(inode-&gt;vm_store, last_keep, -1);<br>
+	if (keep_bytes) {<br>
 		/* partial truncate, clear end of page */<br>
-		if (index == partial_keep) {<br>
+		page = find_page(inode-&gt;vm_store, partial_keep);<br>
+		if (page) {<br>
 			unsigned long address = page_address(page);<br>
 			memset((void *) (keep_bytes + address), 0, PAGE_CACHE_SIZE - keep_bytes);<br>
 			flush_page_to_ram(address);<br>
@@ -131,93 +92,14 @@<br>
 	}<br>
 }<br>
 <br>
-/*<br>
- * Remove a page from the page cache and free it.<br>
- */<br>
-void remove_inode_page(struct page *page)<br>
+/* Remove all store pages */<br>
+void zap_inode_pages(struct inode *inode)<br>
 {<br>
-	remove_page_from_hash_queue(page);<br>
-	remove_page_from_inode_queue(page);<br>
-	page_cache_release(page);<br>
-}<br>
-<br>
-int shrink_mmap(int priority, int gfp_mask)<br>
-{<br>
-	static unsigned long clock = 0;<br>
-	unsigned long limit = num_physpages;<br>
-	struct page * page;<br>
-	int count;<br>
-<br>
-	count = limit &gt;&gt; priority;<br>
-<br>
-	page = mem_map + clock;<br>
-	do {<br>
-		int referenced;<br>
-<br>
-		/* This works even in the presence of PageSkip because<br>
-		 * the first two entries at the beginning of a hole will<br>
-		 * be marked, not just the first.<br>
-		 */<br>
-		page++;<br>
-		clock++;<br>
-		if (clock &gt;= max_mapnr) {<br>
-			clock = 0;<br>
-			page = mem_map;<br>
-		}<br>
-		if (PageSkip(page)) {<br>
-			/* next_hash is overloaded for PageSkip */<br>
-			page = page-&gt;next_hash;<br>
-			clock = page - mem_map;<br>
-		}<br>
-		<br>
-		referenced = test_and_clear_bit(PG_referenced, &amp;page-&gt;flags);<br>
-<br>
-		if (PageLocked(page))<br>
-			continue;<br>
-<br>
-		if ((gfp_mask &amp; __GFP_DMA) &amp;&amp; !PageDMA(page))<br>
-			continue;<br>
-<br>
-		/* We can't free pages unless there's just one user */<br>
-		if (atomic_read(&amp;page-&gt;count) != 1)<br>
-			continue;<br>
-<br>
-		count--;<br>
-<br>
-		/*<br>
-		 * Is it a page swap page? If so, we want to<br>
-		 * drop it if it is no longer used, even if it<br>
-		 * were to be marked referenced..<br>
-		 */<br>
-		if (PageSwapCache(page)) {<br>
-			if (referenced &amp;&amp; swap_count(page-&gt;key) != 1)<br>
-				continue;<br>
-			delete_from_swap_cache(page);<br>
-			return 1;<br>
-		}	<br>
-<br>
-		if (referenced)<br>
-			continue;<br>
-<br>
-		/* Is it a buffer page? */<br>
-		if (PageBuffer(page)) {<br>
-			if (buffer_under_min())<br>
-				continue;<br>
-			if (!try_to_free_buffers(page))<br>
-				continue;<br>
-			return 1;<br>
-		}<br>
-<br>
-		/* is it a page-cache page? */<br>
-		if (page-&gt;inode) {<br>
-			if (pgcache_under_min())<br>
-				continue;<br>
-			remove_inode_page(page);<br>
-			return 1;<br>
-		}<br>
-<br>
-	} while (count &gt; 0);<br>
-	return 0;<br>
+	struct vm_store *store, *next;<br>
+	for(store = inode-&gt;vm_store; store != NULL; store = next) {<br>
+		next = store-&gt;st_next;<br>
+		zap_store_pages(store, 0, -1);<br>
+	}<br>
 }<br>
 <br>
 /*<br>
@@ -226,42 +108,21 @@<br>
  */<br>
 void update_vm_cache(struct inode * inode, loff_t pos, const char * buf, int count)<br>
 {<br>
-	unsigned long offset, len, index;<br>
+	unsigned long offset, index;<br>
 <br>
 	if (pos &gt; PAGE_MAX_FILE_OFFSET) {<br>
 		return;<br>
 	}<br>
 	offset = (pos &amp; ~PAGE_CACHE_MASK);<br>
 	index = pos &gt;&gt; PAGE_CACHE_SHIFT;<br>
-	len = PAGE_CACHE_SIZE - offset;<br>
-	do {<br>
-		struct page * page;<br>
+	update_vm_store_cache(inode-&gt;vm_store, index, offset, buf, count);<br>
+}<br>
 <br>
-		if (len &gt; count)<br>
-			len = count;<br>
-		page = find_page(inode, index);<br>
-		if (page) {<br>
-			wait_on_page(page);<br>
-			memcpy((void *) (offset + page_address(page)), buf, len);<br>
-			page_cache_release(page);<br>
-		}<br>
-		count -= len;<br>
-		buf += len;<br>
-		len = PAGE_CACHE_SIZE;<br>
-		offset = 0;<br>
-		index++<br>
-	} while (count);<br>
-}<br>
-<br>
-static inline void add_to_page_cache(struct page * page,<br>
-	struct inode * inode, unsigned long key,<br>
-	struct page **hash)<br>
-{<br>
-	atomic_inc(&amp;page-&gt;count);<br>
-	page-&gt;flags = (page-&gt;flags &amp; ~((1 &lt;&lt; PG_uptodate) | (1 &lt;&lt; PG_error))) | (1 &lt;&lt; PG_referenced);<br>
-	page-&gt;key = key;<br>
-	add_page_to_inode_queue(inode, page);<br>
-	__add_page_to_hash_queue(page, hash);<br>
+struct page *get_inode_page(<br>
+	struct inode *inode, loff_t page, unsigned long *page_cache_ptr)<br>
+{<br>
+	unsigned long index = page &gt;&gt; PAGE_CACHE_SHIFT;<br>
+	return get_store_page(inode-&gt;vm_store, index, page_cache_ptr);<br>
 }<br>
 <br>
 /*<br>
@@ -273,57 +134,26 @@<br>
 				unsigned long index, unsigned long page_cache)<br>
 {<br>
 	struct inode *inode = file-&gt;f_dentry-&gt;d_inode;<br>
+	struct vm_store *store = inode-&gt;vm_store;<br>
 	struct page * page;<br>
-	struct page ** hash;<br>
 <br>
-	switch (page_cache) {<br>
-	case 0:<br>
-		page_cache = page_cache_alloc();<br>
-		if (!page_cache)<br>
-			break;<br>
-	default:<br>
-		if ((((loff_t)index) &lt;&lt; PAGE_CACHE_SHIFT) &gt; inode-&gt;i_size)<br>
-			break;<br>
-		hash = page_hash(inode, index);<br>
-		page = __find_page(inode, index, *hash);<br>
-		if (!page) {<br>
+	/* FIXME loff_t used in a loop . . . */<br>
+	page = NULL;<br>
+	if ((((loff_t) index) &lt;&lt; PAGE_CACHE_SHIFT) &lt; inode-&gt;i_size) {<br>
+		page = get_store_page(store, index, &amp;page_cache);<br>
+	}<br>
+	if (page) {<br>
+		if (!PageUptodate(page) &amp;&amp; !PageLocked(page)) {<br>
 			/*<br>
-			 * Ok, add the new page to the hash-queues...<br>
+			 * Ok, read the new page...<br>
 			 */<br>
-			page = page_cache_entry(page_cache);<br>
-			add_to_page_cache(page, inode, index, hash);<br>
 			inode-&gt;i_op-&gt;readpage(file, page);<br>
-			page_cache = 0;<br>
 		}<br>
 		page_cache_release(page);<br>
 	}<br>
 	return page_cache;<br>
 }<br>
 <br>
-/* <br>
- * Wait for IO to complete on a locked page.<br>
- *<br>
- * This must be called with the caller "holding" the page,<br>
- * ie with increased "page-&gt;count" so that the page won't<br>
- * go away during the wait..<br>
- */<br>
-void __wait_on_page(struct page *page)<br>
-{<br>
-	struct task_struct *tsk = current;<br>
-	DECLARE_WAITQUEUE(wait, tsk);<br>
-<br>
-	add_wait_queue(&amp;page-&gt;wait, &amp;wait);<br>
-repeat:<br>
-	tsk-&gt;state = TASK_UNINTERRUPTIBLE;<br>
-	run_task_queue(&amp;tq_disk);<br>
-	if (PageLocked(page)) {<br>
-		schedule();<br>
-		goto repeat;<br>
-	}<br>
-	tsk-&gt;state = TASK_RUNNING;<br>
-	remove_wait_queue(&amp;page-&gt;wait, &amp;wait);<br>
-}<br>
-<br>
 #if 0<br>
 #define PROFILE_READAHEAD<br>
 #define DEBUG_READAHEAD<br>
@@ -478,7 +308,7 @@<br>
  * page only.<br>
  */<br>
 	if (PageLocked(page)) {<br>
-		if (!filp-&gt;f_ralen || ppos &gt;= raend || ppos + filp-&gt;f_ralen &lt; raend) {<br>
+		if (!filp-&gt;f_ralen || index &gt;= raend || index + filp-&gt;f_ralen &lt; raend) {<br>
 			raend = index;<br>
 			if (((loff_t)raend &lt;&lt; PAGE_CACHE_SHIFT) &lt; inode-&gt;i_size)<br>
 				max_ahead = filp-&gt;f_ramax;<br>
@@ -590,8 +420,7 @@<br>
 {<br>
 	struct dentry *dentry = filp-&gt;f_dentry;<br>
 	struct inode *inode = dentry-&gt;d_inode;<br>
-	unsinged long page_cache, index;<br>
-	size_t pos, pgpos, page_cache;<br>
+	unsigned long page_cache, index;<br>
 	int reada_ok;<br>
 	int max_readahead = get_max_readahead(inode);<br>
 	loff_t pos;<br>
@@ -644,7 +473,7 @@<br>
 	}<br>
 <br>
 	for (;;) {<br>
-		struct page *page, **hash;<br>
+		struct page *page;<br>
 <br>
 		if (pos &gt;= inode-&gt;i_size)<br>
 			break;<br>
@@ -657,9 +486,12 @@<br>
 		/*<br>
 		 * Try to find the data in the page cache..<br>
 		 */<br>
-		hash = page_hash(inode, index);<br>
-		page = __find_page(inode, index, *hash);<br>
-		if (!page)<br>
+		page = get_inode_page(inode, pos, &amp;page_cache);<br>
+		if (!page) {<br>
+			desc-&gt;error = -ENOMEM;<br>
+			break;<br>
+		}<br>
+		if (!PageUptodate(page) &amp;&amp; !PageLocked(page))<br>
 			goto no_cached_page;<br>
 <br>
 found_page:<br>
@@ -710,29 +542,6 @@<br>
 <br>
 no_cached_page:<br>
 		/*<br>
-		 * Ok, it wasn't cached, so we need to create a new<br>
-		 * page..<br>
-		 */<br>
-		if (!page_cache) {<br>
-			page_cache = page_cache_alloc();<br>
-			/*<br>
-			 * That could have slept, so go around to the<br>
-			 * very beginning..<br>
-			 */<br>
-			if (page_cache)<br>
-				continue;<br>
-			desc-&gt;error = -ENOMEM;<br>
-			break;<br>
-		}<br>
-<br>
-		/*<br>
-		 * Ok, add the new page to the hash-queues...<br>
-		 */<br>
-		page = page_cache_entry(page_cache);<br>
-		page_cache = 0;<br>
-		add_to_page_cache(page, inode, index, hash);<br>
-<br>
-		/*<br>
 		 * Error handling is tricky. If we get a read error,<br>
 		 * the cached page stays in the cache (but uptodate=0),<br>
 		 * and the next process that accesses it will try to<br>
@@ -957,7 +766,7 @@<br>
 	struct dentry * dentry = file-&gt;f_dentry;<br>
 	struct inode * inode = dentry-&gt;d_inode;<br>
 	unsigned long index, reada, i;<br>
-	struct page * page, **hash;<br>
+	struct page * page;<br>
 	unsigned long old_page, new_page;<br>
 	<br>
 <br>
@@ -967,12 +776,14 @@<br>
 		((((loff_t)index) &lt;&lt; PAGE_SHIFT) &gt;= inode-&gt;i_size))<br>
 		goto no_page;<br>
 <br>
-	hash = page_hash(inode, (index &gt;&gt; (PAGE_CACHE_SHIFT - PAGE_SHIFT)));<br>
 	/*<br>
 	 * Do we have something in the page cache already?<br>
 	 */<br>
-	page = __find_page(inode, (index &gt;&gt; (PAGE_CACHE_SHIFT - PAGE_SHIFT)), *hash);<br>
+	page = get_store_page(inode-&gt;vm_store, <br>
+		index &gt;&gt; (PAGE_CACHE_SHIFT - PAGE_SHIFT), &amp;new_page);<br>
 	if (!page)<br>
+		goto failure;<br>
+	if (!PageLocked(page) &amp;&amp; !PageUptodate(page))<br>
 		goto no_cached_page;<br>
 <br>
 found_page:<br>
@@ -1029,28 +840,15 @@<br>
 	for (i = 1 &lt;&lt; page_cluster; i &gt; 0; --i, reada++)<br>
 		new_page = try_to_read_ahead(file, reada, new_page);<br>
 <br>
-	if (!new_page)<br>
-		new_page = page_cache_alloc();<br>
-	if (!new_page)<br>
-		goto no_page;<br>
-<br>
-	/*<br>
-	 * During getting the above page we might have slept,<br>
-	 * so we need to re-check the situation with the page<br>
-	 * cache.. The page we just got may be useful if we<br>
-	 * can't share, so don't get rid of it here.<br>
-	 */<br>
-	page = __find_page(inode, (index &gt;&gt; (PAGE_CACHE_SHIFT - PAGE_SHIFT)), *hash);<br>
-	if (page)<br>
+	/* While reading ahead we might have slept */<br>
+	if (PageLocked(page) || PageUptodate(page))<br>
 		goto found_page;<br>
 <br>
-	/*<br>
-	 * Now, create a new page-cache page from the page we got<br>
-	 */<br>
-	page = page_cache_entry(new_page);<br>
-	new_page = 0;<br>
-	add_to_page_cache(page, inode, (index &gt;&gt; (PAGE_CACHE_SHIFT - PAGE_SHIFT)), hash);<br>
-<br>
+	/* Note: If we are past the end of the file<br>
+	 * this routine is expected to clear the page and set<br>
+	 * PG_uptotdate.  This handles the cases of private anonymous<br>
+	 * pages, past then end of the file.<br>
+  	 */<br>
 	if (inode-&gt;i_op-&gt;readpage(file, page) != 0)<br>
 		goto failure;<br>
 <br>
@@ -1081,7 +879,8 @@<br>
 	 * mm layer so, possibly freeing the page cache page first.<br>
 	 */<br>
 failure:<br>
-	page_cache_release(page);<br>
+	if (page)<br>
+		page_cache_release(page);<br>
 	if (new_page)<br>
 		page_cache_free(new_page);<br>
 no_page:<br>
@@ -1343,6 +1142,7 @@<br>
 	struct vm_operations_struct * ops;<br>
 	struct inode *inode = file-&gt;f_dentry-&gt;d_inode;<br>
 	unsigned long index;<br>
+	struct vm_store *store;<br>
 <br>
 	if ((offset &gt; PAGE_MAX_FILE_OFFSET) ||<br>
 		((offset + (vma-&gt;vm_end - vma-&gt;vm_start)) &gt; PAGE_MAX_FILE_OFFSET)) {<br>
@@ -1366,7 +1166,9 @@<br>
 		return -EACCES;<br>
 	if (!inode-&gt;i_op || !inode-&gt;i_op-&gt;readpage)<br>
 		return -ENOEXEC;<br>
+	store = inode-&gt;vm_store;<br>
 	UPDATE_ATIME(inode);<br>
+	vma-&gt;vm_store = store;<br>
 	vma-&gt;vm_index = index;<br>
 	vma-&gt;vm_ops = ops;<br>
 	return 0;<br>
@@ -1480,7 +1282,7 @@<br>
 	struct inode	*inode = dentry-&gt;d_inode; <br>
 	loff_t pos = *ppos;<br>
 	loff_t limit = current-&gt;rlim[RLIMIT_FSIZE].rlim_cur;<br>
-	struct page	*page, **hash;<br>
+	struct page	*page;<br>
 	unsigned long	page_cache = 0;<br>
 	unsigned long	written;<br>
 	long		status, sync;<br>
@@ -1525,30 +1327,20 @@<br>
 	}<br>
 <br>
 	while (count) {<br>
-		unsigned long bytes, index, offset;<br>
+		unsigned long bytes, offset;<br>
 		/*<br>
 		 * Try to find the page in the cache. If it isn't there,<br>
 		 * allocate a free page.<br>
 		 */<br>
 		offset = (pos &amp; ~PAGE_CACHE_MASK);<br>
-		index = pos &gt;&gt; PAGE_CACHE_SHIFT;<br>
 		bytes = PAGE_CACHE_SIZE - offset;<br>
 		if (bytes &gt; count)<br>
 			bytes = count;<br>
 <br>
-		hash = page_hash(inode, index);<br>
-		page = __find_page(inode, index, *hash);<br>
+		page = get_inode_page(inode, pos, &amp;page_cache);<br>
 		if (!page) {<br>
-			if (!page_cache) {<br>
-				page_cache = page_cache_alloc();<br>
-				if (page_cache)<br>
-					continue;<br>
-				status = -ENOMEM;<br>
-				break;<br>
-			}<br>
-			page = page_cache_entry(page_cache);<br>
-			add_to_page_cache(page, inode, index, hash);<br>
-			page_cache = 0;<br>
+			status = -ENOMEM;<br>
+			break;<br>
 		}<br>
 <br>
 		/* Get exclusive IO access to the page.. */<br>
@@ -1603,33 +1395,29 @@<br>
 				int new)<br>
 {<br>
 	struct page * page;<br>
-	struct page ** hash;<br>
 	unsigned long page_cache = 0;<br>
 	unsigned long index;<br>
+	unsigned long new_page = 0;<br>
 <br>
 	index = offset &gt;&gt; PAGE_CACHE_SHIFT;<br>
 <br>
-	hash = page_hash(inode, index);<br>
-	page = __find_page(inode, index, *hash);<br>
-	if (!page) {<br>
-		if (!new)<br>
-			goto out;<br>
-		page_cache = page_cache_alloc();<br>
-		if (!page_cache)<br>
-			goto out;<br>
-		clear_page(page_cache);<br>
-		page = page_cache_entry(page_cache);<br>
-		add_to_page_cache(page, inode, index, hash);<br>
-	}<br>
-	if (atomic_read(&amp;page-&gt;count) != 2)<br>
-		printk(KERN_ERR "get_cached_page: page count=%d\n",<br>
-			atomic_read(&amp;page-&gt;count));<br>
-	if (test_bit(PG_locked, &amp;page-&gt;flags))<br>
-		printk(KERN_ERR "get_cached_page: page already locked!\n");<br>
-	set_bit(PG_locked, &amp;page-&gt;flags);<br>
-	page_cache = page_address(page);<br>
-<br>
-out:<br>
+	if (new) {<br>
+		page = get_store_page(inode-&gt;vm_store, index, &amp;new_page);<br>
+	} else {<br>
+		page = find_page(inode-&gt;vm_store, index);<br>
+	}<br>
+	if (page) {<br>
+		if (atomic_read(&amp;page-&gt;count) != 2)<br>
+			printk(KERN_ERR "get_cached_page: page count=%d\n",<br>
+				atomic_read(&amp;page-&gt;count));<br>
+		if (test_bit(PG_locked, &amp;page-&gt;flags))<br>
+			printk(KERN_ERR "get_cached_page: page already locked!\n");<br>
+		set_bit(PG_locked, &amp;page-&gt;flags);<br>
+		page_cache = page_address(page);<br>
+	}<br>
+	if (new_page) {<br>
+		free_page(new_page);<br>
+	}<br>
 	return page_cache;<br>
 }<br>
 <br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/mm/memory.c linux-2.3.3.eb6/mm/memory.c<br>
--- linux-2.3.3.eb5/mm/memory.c	Sat May 22 17:16:55 1999<br>
+++ linux-2.3.3.eb6/mm/memory.c	Sat May 22 18:19:40 1999<br>
@@ -649,7 +649,7 @@<br>
 			break;<br>
 		if (swap_count(page_map-&gt;key) != 1)<br>
 			break;<br>
-		delete_from_swap_cache(page_map);<br>
+		remove_store_page(page_map);<br>
 		/* FallThrough */<br>
 	case 1:<br>
 		/* We can release the kernel lock now.. */<br>
@@ -740,13 +740,13 @@<br>
 	struct vm_area_struct * mpnt;<br>
 <br>
 	truncate_inode_pages(inode, offset);<br>
-	if ((!inode-&gt;i_mmap) || (offset &gt; PAGE_MAX_FILE_OFFSET)) {<br>
+	if ((!inode-&gt;vm_store-&gt;st_mmap) || (offset &gt; PAGE_MAX_FILE_OFFSET)) {<br>
 		return;<br>
 	}<br>
 	index = offset &gt;&gt; PAGE_CACHE_SHIFT;<br>
 	partial = offset &amp; PAGE_CACHE_MASK;<br>
 	trunk_index = index + (partial)? 1 : 0;<br>
-	mpnt = inode-&gt;i_mmap;<br>
+	mpnt = inode-&gt;vm_store-&gt;st_mmap;<br>
 	do {<br>
 		struct mm_struct *mm = mpnt-&gt;vm_mm;<br>
 		unsigned long start = mpnt-&gt;vm_start;<br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/mm/mmap.c linux-2.3.3.eb6/mm/mmap.c<br>
--- linux-2.3.3.eb5/mm/mmap.c	Sat May 22 17:16:56 1999<br>
+++ linux-2.3.3.eb6/mm/mmap.c	Sat May 22 18:19:40 1999<br>
@@ -74,10 +74,13 @@<br>
 static inline void remove_shared_vm_struct(struct vm_area_struct *vma)<br>
 {<br>
 	struct file * file = vma-&gt;vm_file;<br>
+	struct vm_store *store = vma-&gt;vm_store;<br>
 <br>
 	if (file) {<br>
 		if (vma-&gt;vm_flags &amp; VM_DENYWRITE)<br>
 			file-&gt;f_dentry-&gt;d_inode-&gt;i_writecount++;<br>
+	}<br>
+	if (store) {<br>
 		if(vma-&gt;vm_next_share)<br>
 			vma-&gt;vm_next_share-&gt;vm_pprev_share = vma-&gt;vm_pprev_share;<br>
 		*vma-&gt;vm_pprev_share = vma-&gt;vm_next_share;<br>
@@ -280,6 +283,7 @@<br>
 	vma-&gt;vm_ops = NULL;<br>
 	vma-&gt;vm_index = 0;<br>
 	vma-&gt;vm_file = NULL;<br>
+	vma-&gt;vm_store = NULL;<br>
 	vma-&gt;vm_pte = 0;<br>
 <br>
 	/* Clear old maps */<br>
@@ -530,6 +534,7 @@<br>
 		mpnt-&gt;vm_ops = area-&gt;vm_ops;<br>
 		mpnt-&gt;vm_index = area-&gt;vm_index + ((end - area-&gt;vm_start) &gt;&gt; PAGE_SHIFT);<br>
 		mpnt-&gt;vm_file = area-&gt;vm_file;<br>
+		mpnt-&gt;vm_store = area-&gt;vm_store;<br>
 		mpnt-&gt;vm_pte = area-&gt;vm_pte;<br>
 		if (mpnt-&gt;vm_file)<br>
 			mpnt-&gt;vm_file-&gt;f_count++;<br>
@@ -755,6 +760,7 @@<br>
 {<br>
 	struct vm_area_struct **pprev;<br>
 	struct file * file;<br>
+	struct vm_store *store;<br>
 <br>
 	if (!mm-&gt;mmap_avl) {<br>
 		pprev = &amp;mm-&gt;mmap;<br>
@@ -779,12 +785,14 @@<br>
 		struct inode * inode = file-&gt;f_dentry-&gt;d_inode;<br>
 		if (vmp-&gt;vm_flags &amp; VM_DENYWRITE)<br>
 			inode-&gt;i_writecount--;<br>
-      <br>
-		/* insert vmp into inode's share list */<br>
-		if((vmp-&gt;vm_next_share = inode-&gt;i_mmap) != NULL)<br>
-			inode-&gt;i_mmap-&gt;vm_pprev_share = &amp;vmp-&gt;vm_next_share;<br>
-		inode-&gt;i_mmap = vmp;<br>
-		vmp-&gt;vm_pprev_share = &amp;inode-&gt;i_mmap;<br>
+	}<br>
+	store = vmp-&gt;vm_store;<br>
+	if (store) {<br>
+      		/* insert vmp into store's share list */<br>
+		if((vmp-&gt;vm_next_share = store-&gt;st_mmap) != NULL)<br>
+			store-&gt;st_mmap-&gt;vm_pprev_share = &amp;vmp-&gt;vm_next_share;<br>
+		store-&gt;st_mmap = vmp;<br>
+		vmp-&gt;vm_pprev_share = &amp;store-&gt;st_mmap;<br>
 	}<br>
 }<br>
 <br>
@@ -818,7 +826,8 @@<br>
 		next = mpnt-&gt;vm_next;<br>
 <br>
 		/* To share, we must have the same file, operations.. */<br>
-		if ((mpnt-&gt;vm_file != prev-&gt;vm_file)||<br>
+		if ((mpnt-&gt;vm_file != prev-&gt;vm_file)	||<br>
+		    (mpnt-&gt;vm_store != prev-&gt;vm_store)	||<br>
 		    (mpnt-&gt;vm_pte != prev-&gt;vm_pte)	||<br>
 		    (mpnt-&gt;vm_ops != prev-&gt;vm_ops)	||<br>
 		    (mpnt-&gt;vm_flags != prev-&gt;vm_flags)	||<br>
@@ -829,6 +838,7 @@<br>
 		 * If we have a file or it's a shared memory area<br>
 		 * the offsets must be contiguous..<br>
 		 */<br>
+		/*  use VM_SPARCE_MERGE here? */<br>
 		if ((mpnt-&gt;vm_file != NULL) || (mpnt-&gt;vm_flags &amp; VM_SHM)) {<br>
 			unsigned long off = prev-&gt;vm_index + <br>
 				((prev-&gt;vm_end - prev-&gt;vm_start) &gt;&gt; PAGE_SHIFT);<br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/mm/page_alloc.c linux-2.3.3.eb6/mm/page_alloc.c<br>
--- linux-2.3.3.eb5/mm/page_alloc.c	Sat May 22 16:10:03 1999<br>
+++ linux-2.3.3.eb6/mm/page_alloc.c	Sat May 22 18:19:40 1999<br>
@@ -425,7 +425,7 @@<br>
 	 * down the swap cache and give exclusive access to the page to<br>
 	 * this process.<br>
 	 */<br>
-	delete_from_swap_cache(page_map);<br>
+	remove_store_page(page_map);<br>
 	set_pte(page_table, pte_mkwrite(pte_mkdirty(mk_pte(page, vma-&gt;vm_page_prot))));<br>
   	return;<br>
 }<br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/mm/page_io.c linux-2.3.3.eb6/mm/page_io.c<br>
--- linux-2.3.3.eb5/mm/page_io.c	Sat May 22 17:16:37 1999<br>
+++ linux-2.3.3.eb6/mm/page_io.c	Sat May 22 18:19:40 1999<br>
@@ -237,7 +237,7 @@<br>
 {<br>
 	struct page *page = mem_map + MAP_NR(buf);<br>
 <br>
-	if (page-&gt;inode &amp;&amp; page-&gt;inode != &amp;swapper_inode)<br>
+	if (page-&gt;store &amp;&amp; page-&gt;store != &amp;swapper_store)<br>
 		panic ("Tried to swap a non-swapper page");<br>
 <br>
 	/*<br>
@@ -274,16 +274,16 @@<br>
 		printk ("VM: read_swap_page: page already in swap cache!\n");<br>
 		return;<br>
 	}<br>
-	if (page-&gt;inode) {<br>
+	if (page-&gt;store) {<br>
 		printk ("VM: read_swap_page: page already in page cache!\n");<br>
 		return;<br>
 	}<br>
-	page-&gt;inode = &amp;swapper_inode;<br>
+	page-&gt;store = &amp;swapper_store;<br>
 	page-&gt;key = entry;<br>
 	atomic_inc(&amp;page-&gt;count);	/* Protect from shrink_mmap() */<br>
 	rw_swap_page(rw, entry, buffer, 1);<br>
 	atomic_dec(&amp;page-&gt;count);<br>
-	page-&gt;inode = 0;<br>
+	page-&gt;store = 0;<br>
 	clear_bit(PG_swap_cache, &amp;page-&gt;flags);<br>
 }<br>
 <br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/mm/swap_state.c linux-2.3.3.eb6/mm/swap_state.c<br>
--- linux-2.3.3.eb5/mm/swap_state.c	Sat May 22 17:16:37 1999<br>
+++ linux-2.3.3.eb6/mm/swap_state.c	Sat May 22 18:19:40 1999<br>
@@ -13,9 +13,16 @@<br>
 #include &lt;linux/swapctl.h&gt;<br>
 #include &lt;linux/init.h&gt;<br>
 #include &lt;linux/pagemap.h&gt;<br>
+#include &lt;linux/vm_store.h&gt;<br>
 <br>
 #include &lt;asm/pgtable.h&gt;<br>
 <br>
+static void clear_swap_page(struct vm_store *, struct page *, unsigned long, void **);<br>
+struct vm_store_operations swap_operations = {<br>
+	NULL,<br>
+	clear_swap_page<br>
+};<br>
+		<br>
 /* <br>
  * Keep a reserved false inode which we will use to mark pages in the<br>
  * page cache are acting as swap cache instead of file cache. <br>
@@ -25,7 +32,11 @@<br>
  * ensure that any mistaken dereferences of this structure cause a<br>
  * kernel oops.<br>
  */<br>
-struct inode swapper_inode;<br>
+struct vm_store swapper_store =<br>
+{<br>
+	NULL, NULL, 0, &amp;swap_operations,<br>
+	NULL, NULL, 0, NULL<br>
+};<br>
 <br>
 #ifdef SWAP_CACHE_INFO<br>
 unsigned long swap_cache_add_total = 0;<br>
@@ -57,16 +68,12 @@<br>
 		       page-&gt;key, page_address(page));<br>
 		return 0;<br>
 	}<br>
-	if (page-&gt;inode) {<br>
+	if (page-&gt;store) {<br>
 		printk(KERN_ERR "swap_cache: replacing page-cached entry "<br>
 		       "on page %08lx\n", page_address(page));<br>
 		return 0;<br>
 	}<br>
-	atomic_inc(&amp;page-&gt;count);<br>
-	page-&gt;inode = &amp;swapper_inode;<br>
-	page-&gt;key = entry;<br>
-	add_page_to_hash_queue(page, &amp;swapper_inode, entry);<br>
-	add_page_to_inode_queue(&amp;swapper_inode, page);<br>
+	add_to_page_cache(page, &amp;swapper_store, entry, page_hash(&amp;swapper_store, entry));<br>
 	return 1;<br>
 }<br>
 <br>
@@ -176,45 +183,14 @@<br>
 	goto out;<br>
 }<br>
 <br>
-static inline void remove_from_swap_cache(struct page *page)<br>
-{<br>
-	if (!page-&gt;inode) {<br>
-		printk ("VM: Removing swap cache page with zero inode hash "<br>
-			"on page %08lx\n", page_address(page));<br>
-		return;<br>
-	}<br>
-	if (page-&gt;inode != &amp;swapper_inode) {<br>
-		printk ("VM: Removing swap cache page with wrong inode hash "<br>
-			"on page %08lx\n", page_address(page));<br>
-	}<br>
-<br>
-#ifdef DEBUG_SWAP<br>
-	printk("DebugVM: remove_from_swap_cache(%08lx count %d)\n",<br>
-	       page_address(page), atomic_read(&amp;page-&gt;count));<br>
-#endif<br>
-	PageClearSwapCache (page);<br>
-	remove_inode_page(page);<br>
-}<br>
-<br>
-<br>
-/*<br>
- * This must be called only on pages that have<br>
- * been verified to be in the swap cache.<br>
- */<br>
-void delete_from_swap_cache(struct page *page)<br>
+static void clear_swap_page(<br>
+	struct vm_store *store, struct page *page, unsigned long entry, void **generic_stpp)<br>
 {<br>
-	long entry = page-&gt;key;<br>
-<br>
 #ifdef SWAP_CACHE_INFO<br>
 	swap_cache_del_total++;<br>
 #endif<br>
-#ifdef DEBUG_SWAP<br>
-	printk("DebugVM: delete_from_swap_cache(%08lx count %d, "<br>
-	       "entry %08lx)\n",<br>
-	       page_address(page), atomic_read(&amp;page-&gt;count), entry);<br>
-#endif<br>
-	remove_from_swap_cache (page);<br>
-	swap_free (entry);<br>
+	PageClearSwapCache(page);<br>
+	swap_free(entry);<br>
 }<br>
 <br>
 /* <br>
@@ -230,7 +206,7 @@<br>
 	 * If we are the only user, then free up the swap cache. <br>
 	 */<br>
 	if (PageSwapCache(page) &amp;&amp; !is_page_shared(page)) {<br>
-		delete_from_swap_cache(page);<br>
+		remove_store_page(page);<br>
 	}<br>
 	<br>
 	__free_page(page);<br>
@@ -251,10 +227,10 @@<br>
 	swap_cache_find_total++;<br>
 #endif<br>
 	while (1) {<br>
-		found = find_page(&amp;swapper_inode, entry);<br>
+		found = find_page(&amp;swapper_store, entry);<br>
 		if (!found)<br>
 			return 0;<br>
-		if (found-&gt;inode != &amp;swapper_inode || !PageSwapCache(found))<br>
+		if (found-&gt;store != &amp;swapper_store || !PageSwapCache(found))<br>
 			goto out_bad;<br>
 		if (!PageLocked(found)) {<br>
 #ifdef SWAP_CACHE_INFO<br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/mm/swap_syms.c linux-2.3.3.eb6/mm/swap_syms.c<br>
--- linux-2.3.3.eb5/mm/swap_syms.c	Sat May 22 17:09:32 1999<br>
+++ linux-2.3.3.eb6/mm/swap_syms.c	Sat May 22 18:19:40 1999<br>
@@ -13,4 +13,4 @@<br>
 EXPORT_SYMBOL(si_swapinfo);<br>
 EXPORT_SYMBOL(register_swap_unuse_function);<br>
 EXPORT_SYMBOL(unregister_swap_unuse_function);<br>
-EXPORT_SYMBOL(swapper_inode);<br>
+EXPORT_SYMBOL(swapper_store);<br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/mm/swapfile.c linux-2.3.3.eb6/mm/swapfile.c<br>
--- linux-2.3.3.eb5/mm/swapfile.c	Sat May 22 17:09:32 1999<br>
+++ linux-2.3.3.eb6/mm/swapfile.c	Sat May 22 18:19:40 1999<br>
@@ -447,7 +447,7 @@<br>
 		/* Now get rid of the extra reference to the temporary<br>
                    page we've been using. */<br>
 		if (PageSwapCache(page_map))<br>
-			delete_from_swap_cache(page_map);<br>
+			remove_store_page(page_map);<br>
 		__free_page(page_map);<br>
 		/*<br>
 		 * Check for and clear any overflowed swap map counts.<br>
diff -uNrX /home/eric/projects/linux/linux-ignore-files linux-2.3.3.eb5/mm/vm_store.c linux-2.3.3.eb6/mm/vm_store.c<br>
--- linux-2.3.3.eb5/mm/vm_store.c	Wed Dec 31 18:00:00 1969<br>
+++ linux-2.3.3.eb6/mm/vm_store.c	Sat May 22 18:19:40 1999<br>
@@ -0,0 +1,254 @@<br>
+#include &lt;linux/vm_store.h&gt;<br>
+#include &lt;linux/pagemap.h&gt;<br>
+#include &lt;linux/mm.h&gt;<br>
+#include &lt;linux/fs.h&gt;<br>
+#include &lt;linux/malloc.h&gt;<br>
+#include &lt;linux/swap.h&gt;<br>
+#include &lt;linux/swapctl.h&gt;<br>
+<br>
+#include &lt;asm/pgtable.h&gt;<br>
+<br>
+/* add a page to the page cache on a specific vm_store */<br>
+void add_to_page_cache(struct page * page,<br>
+	struct vm_store * store, unsigned long key,<br>
+	struct page **hash)<br>
+{<br>
+	atomic_inc(&amp;page-&gt;count);<br>
+	page-&gt;flags = (page-&gt;flags &amp; ~((1 &lt;&lt; PG_uptodate) | (1 &lt;&lt; PG_error))) | (1 &lt;&lt; PG_referenced);<br>
+	page-&gt;key = key;<br>
+	add_page_to_store_queue(store, page);<br>
+	__add_page_to_hash_queue(page, hash);<br>
+}<br>
+<br>
+/*<br>
+ * Get a store page allocating a new one if necessary.<br>
+ * "page_cache" is a potentially free page that we could use for the<br>
+ * cache (if it is 0 we can try to create one)<br>
+ * If we can't find or allocate the page we return NULL;<br>
+ */<br>
+<br>
+struct page *get_store_page(struct vm_store *store,<br>
+	unsigned long index, unsigned long *page_cache_ptr)<br>
+{<br>
+	struct page * page;<br>
+	struct page ** hash;<br>
+	unsigned long page_cache;<br>
+<br>
+	page = 0;<br>
+	page_cache = *page_cache_ptr;<br>
+	<br>
+	hash = page_hash(store, index);<br>
+	page = __find_page(store, index, *hash);<br>
+<br>
+	if (!page &amp;&amp; !page_cache) {<br>
+		page_cache = page_cache_alloc();<br>
+	}<br>
+	if (!page &amp;&amp; page_cache) {<br>
+		page = __find_page(store, index, *hash);<br>
+		if (!page) {<br>
+			/*<br>
+			 * Ok, add the new page to the hash-queues...<br>
+			 */<br>
+			page = mem_map + MAP_NR(page_cache);<br>
+			add_to_page_cache(page, store, index, hash);<br>
+			page_cache = 0;<br>
+		} <br>
+	}<br>
+	*page_cache_ptr = page_cache;<br>
+	return page;<br>
+}<br>
+<br>
+/*<br>
+ * Remove a page from the page cache and free it.<br>
+ */<br>
+void remove_store_page(struct page *page)<br>
+{<br>
+	struct vm_store *store = page-&gt;store;<br>
+	if (store &amp;&amp; store-&gt;st_ops &amp;&amp; store-&gt;st_ops-&gt;clear_page) {<br>
+		(store-&gt;st_ops-&gt;clear_page)(store, page, page-&gt;key, &amp;page-&gt;generic_pp);<br>
+	}<br>
+	remove_page_from_hash_queue(page);<br>
+	remove_page_from_store_queue(page);<br>
+	page_cache_release(page);<br>
+}<br>
+<br>
+/*<br>
+ * Invalidate the pages of a store, removing all pages that aren't<br>
+ * locked down (those are sure to be up-to-date anyway, so we shouldn't<br>
+ * invalidate them).<br>
+ */<br>
+void invalidate_store_pages(struct vm_store * store)<br>
+{<br>
+	struct page ** p;<br>
+	struct page * page;<br>
+<br>
+	p = &amp;store-&gt;st_pages;<br>
+	while ((page = *p) != NULL) {<br>
+		if (PageLocked(page)) {<br>
+			p = &amp;page-&gt;next;<br>
+			continue;<br>
+		}<br>
+		remove_store_page(page);<br>
+		continue;<br>
+	}<br>
+}<br>
+<br>
+/*<br>
+ * Truncate the page cache at a set offset, removing the pages<br>
+ * that are beyond that offset (and zeroing out partial pages).<br>
+ */<br>
+void zap_store_pages(struct vm_store * store, unsigned long low, unsigned long high)<br>
+{<br>
+	struct page ** p;<br>
+	struct page * page;<br>
+<br>
+repeat:<br>
+	p = &amp;store-&gt;st_pages;<br>
+	while ((page = *p) != NULL) {<br>
+		unsigned long index = page-&gt;key;<br>
+<br>
+		/* page zapped - free it */<br>
+		if ((index &gt;= low) &amp;&amp; (index &lt;= high)){<br>
+			if (PageLocked(page)) {<br>
+				wait_on_page(page);<br>
+				goto repeat;<br>
+			}<br>
+			remove_store_page(page);<br>
+			continue;<br>
+		}<br>
+		p = &amp;page-&gt;next;<br>
+	}<br>
+}<br>
+<br>
+<br>
+/*<br>
+ * Update a page cache copy, when we're doing a "write()" system call<br>
+ * See also "update_vm_cache()".<br>
+ */<br>
+<br>
+void update_vm_store_cache(struct vm_store *store,<br>
+	unsigned long index, unsigned long offset, const char * buf, int count)<br>
+{<br>
+	unsigned long len;<br>
+<br>
+	len = PAGE_CACHE_SIZE - offset;<br>
+	do {<br>
+		struct page * page;<br>
+<br>
+		if (len &gt; count)<br>
+			len = count;<br>
+		page = find_page(store, index);<br>
+		if (page) {<br>
+			wait_on_page(page);<br>
+			memcpy((void *) (offset + page_address(page)), buf, len);<br>
+			page_cache_release(page);<br>
+		}<br>
+		count -= len;<br>
+		buf += len;<br>
+		len = PAGE_CACHE_SIZE;<br>
+		offset = 0;<br>
+		index++;<br>
+	} while (count);<br>
+}<br>
+<br>
+<br>
+/* <br>
+ * Wait for IO to complete on a locked page.<br>
+ *<br>
+ * This must be called with the caller "holding" the page,<br>
+ * ie with increased "page-&gt;count" so that the page won't<br>
+ * go away during the wait..<br>
+ */<br>
+void __wait_on_page(struct page *page)<br>
+{<br>
+	struct task_struct *tsk = current;<br>
+	DECLARE_WAITQUEUE(wait, tsk);<br>
+<br>
+	add_wait_queue(&amp;page-&gt;wait, &amp;wait);<br>
+repeat:<br>
+	tsk-&gt;state = TASK_UNINTERRUPTIBLE;<br>
+	run_task_queue(&amp;tq_disk);<br>
+	if (PageLocked(page)) {<br>
+		schedule();<br>
+		goto repeat;<br>
+	}<br>
+	tsk-&gt;state = TASK_RUNNING;<br>
+	remove_wait_queue(&amp;page-&gt;wait, &amp;wait);<br>
+}<br>
+<br>
+int shrink_mmap(int priority, int gfp_mask)<br>
+{<br>
+	static unsigned long clock = 0;<br>
+	unsigned long limit = num_physpages;<br>
+	struct page * page;<br>
+	int count;<br>
+<br>
+	count = limit &gt;&gt; priority;<br>
+<br>
+	page = mem_map + clock;<br>
+	do {<br>
+		int referenced;<br>
+<br>
+		/* This works even in the presence of PageSkip because<br>
+		 * the first two entries at the beginning of a hole will<br>
+		 * be marked, not just the first.<br>
+		 */<br>
+		page++;<br>
+		clock++;<br>
+		if (clock &gt;= max_mapnr) {<br>
+			clock = 0;<br>
+			page = mem_map;<br>
+		}<br>
+		if (PageSkip(page)) {<br>
+			/* next_hash is overloaded for PageSkip */<br>
+			page = page-&gt;next_hash;<br>
+			clock = page - mem_map;<br>
+		}<br>
+		<br>
+		referenced = test_and_clear_bit(PG_referenced, &amp;page-&gt;flags);<br>
+<br>
+		if (PageLocked(page))<br>
+			continue;<br>
+<br>
+		if ((gfp_mask &amp; __GFP_DMA) &amp;&amp; !PageDMA(page))<br>
+			continue;<br>
+<br>
+		/* We can't free pages unless there's just one user */<br>
+		if (atomic_read(&amp;page-&gt;count) != 1)<br>
+			continue;<br>
+<br>
+		count--;<br>
+<br>
+		/*<br>
+		 * Is it a page swap page? If so, we want to<br>
+		 * drop it if it is no longer used, even if it<br>
+		 * were to be marked referenced..<br>
+		 */<br>
+		if (referenced &amp;&amp; PageSwapCache(page) &amp;&amp; <br>
+			(swap_count(page-&gt;key) == 1)) {<br>
+			referenced = 0;<br>
+<br>
+		}<br>
+		if (referenced)<br>
+			continue;<br>
+<br>
+		/* Is it a buffer page? */<br>
+		if (PageBuffer(page)) {<br>
+			if (buffer_under_min())<br>
+				continue;<br>
+			if (!try_to_free_buffers(page))<br>
+				continue;<br>
+			return 1;<br>
+		}<br>
+<br>
+		/* is it a page-cache page? */<br>
+		if (page-&gt;store) {<br>
+			if (!PageSwapCache(page) &amp;&amp; pgcache_under_min())<br>
+				continue;<br>
+			remove_store_page(page);<br>
+			return 1;<br>
+		}<br>
+<br>
+	} while (count &gt; 0);<br>
+	return 0;<br>
+}<br>
<p>
<p>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0283.html">Vagn Scott: "Re: large directory handling speed"</a>
<li> <b>Previous message:</b> <a href="0281.html">Ralf Baechle: "Re: Linux is a MicroKernal? [was Re: is Linux obsolete?]"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
