<!-- received="Mon May 31 15:38:19 1999 EET DST" -->
<!-- sent="Mon, 31 May 1999 00:36:46 -0700" -->
<!-- name="Clemens Huebner" -->
<!-- email="clemens.huebner@att.net" -->
<!-- subject="IPC msgctl MSG_STAT broken, fix proposal attached" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-22,: IPC msgctl MSG_STAT broken, fix proposal attached</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>IPC msgctl MSG_STAT broken, fix proposal attached</h1>
<b>Clemens Huebner</b> (<a href="mailto:clemens.huebner@att.net"><i>clemens.huebner@att.net</i></a>)<br>
<i>Mon, 31 May 1999 00:36:46 -0700</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#373">[ date ]</a><a href="index.html#373">[ thread ]</a><a href="subject.html#373">[ subject ]</a><a href="author.html#373">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0374.html">Albert D. Cahalan: "Re: Migrating to larger numbers"</a>
<li> <b>Previous message:</b> <a href="0372.html">Larry McVoy: "Re: Annoying GPL issues"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi,<br>
<p>
i just joined the list, so i don't know whether someone else already<br>
fixed this:<br>
<p>
The message queue changes in 2.3.3 breaks the MSG_STAT function of the<br>
msgctl ipc<br>
userland function (segmentation fault due to buffer flow).<br>
<p>
There are two possibilities to fix this:<br>
1) change all userland programs to use the new msqid_ds structure. That<br>
would be a major<br>
   hassle and have no real advantages<br>
2) change the kernel to put out the structure with the old offsets.<br>
Since the changed<br>
   fields are not copied out anyways, there is no drawback (except for<br>
increasing<br>
   kernel source sice.<br>
<p>
<p>
Clemens<br>
<p>
Here's the patch:<br>
diff -ur linux/include/linux/msg.h linux.new/include/linux/msg.h<br>
--- linux/include/linux/msg.h   Sat May 15 16:34:43 1999<br>
+++ linux.new/include/linux/msg.h       Sat May 29 21:03:42 1999<br>
@@ -27,6 +27,25 @@<br>
        __kernel_ipc_pid_t msg_lspid;   /* pid of last msgsnd */<br>
        __kernel_ipc_pid_t msg_lrpid;   /* last receive pid */<br>
 };<br>
+/* to keep compatibility with ipc msgctl syscall, keep old msqid_ds<br>
+   struct */<br>
+struct msqid_u_ds<br>
+{<br>
+  struct ipc_perm msg_perm;<br>
+  struct msg *__msg_first;<br>
+  struct msg *__msg_last;<br>
+  __kernel_time_t msg_stime;<br>
+  __kernel_time_t msg_rtime;<br>
+  __kernel_time_t msg_ctime;<br>
+  void *__wwait;       /* not transmitted to userland */<br>
+  void *__rwait;       /* not transmitted to userland */<br>
+  unsigned short int msg_cbytes;<br>
+  unsigned short int msg_qnum;<br>
+  unsigned short int msg_qbytes;<br>
+  __kernel_ipc_pid_t msg_lspid;<br>
+  __kernel_ipc_pid_t msg_lrpid;<br>
+};<br>
+<br>
<p>
 /* message buffer for msgsnd and msgrcv calls */<br>
 struct msgbuf {<br>
@@ -73,7 +92,7 @@<br>
 asmlinkage int sys_msgsnd (int msqid, struct msgbuf *msgp, size_t<br>
msgsz, int ms<br>
gflg);<br>
 asmlinkage int sys_msgrcv (int msqid, struct msgbuf *msgp, size_t<br>
msgsz, long m<br>
sgtyp,<br>
                       int msgflg);<br>
-asmlinkage int sys_msgctl (int msqid, int cmd, struct msqid_ds *buf);<br>
+asmlinkage int sys_msgctl (int msqid, int cmd, struct msqid_u_ds *buf);<br>
<p>
 #endif /* __KERNEL__ */<br>
<p>
diff -ur linux/ipc/msg.c linux.new/ipc/msg.c<br>
--- linux/ipc/msg.c     Sat May 29 16:50:49 1999<br>
+++ linux.new/ipc/msg.c Sat May 29 19:41:39 1999<br>
@@ -352,11 +352,11 @@<br>
        kfree(msq);<br>
 }<br>
<p>
-asmlinkage int sys_msgctl (int msqid, int cmd, struct msqid_ds *buf)<br>
+asmlinkage int sys_msgctl (int msqid, int cmd, struct msqid_u_ds *buf)<br>
 {<br>
        int id, err = -EINVAL;<br>
        struct msqid_ds *msq;<br>
-       struct msqid_ds tbuf;<br>
+       struct msqid_u_ds tbuf;<br>
        struct ipc_perm *ipcp;<br>
<p>
        printk("msgctl: %d %d %p\n",msqid,cmd,buf);<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0374.html">Albert D. Cahalan: "Re: Migrating to larger numbers"</a>
<li> <b>Previous message:</b> <a href="0372.html">Larry McVoy: "Re: Annoying GPL issues"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
