<!-- received="Tue Jun  1 00:30:26 1999 EET DST" -->
<!-- sent="Mon, 31 May 1999 15:29:31 -0400 (EDT)" -->
<!-- name="Benjamin C.R. LaHaise" -->
<!-- email="blah@kvack.org" -->
<!-- subject="Re: TTY_FLIPBUF_SIZE too low causing dataloss on too fast serial lines?" -->
<!-- id="" -->
<!-- inreplyto="199905282132.RAA17731@dcl.MIT.EDU" -->
<title>Linux-kernel mailing list archive 1999-22,: Re: TTY_FLIPBUF_SIZE too low causing dataloss on too fast serial lines?</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: TTY_FLIPBUF_SIZE too low causing dataloss on too fast serial lines?</h1>
<b>Benjamin C.R. LaHaise</b> (<a href="mailto:blah@kvack.org"><i>blah@kvack.org</i></a>)<br>
<i>Mon, 31 May 1999 15:29:31 -0400 (EDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#463">[ date ]</a><a href="index.html#463">[ thread ]</a><a href="subject.html#463">[ subject ]</a><a href="author.html#463">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0464.html">Marcelo Tosatti: "Re: Everyone's a captain on a calm sea..."</a>
<li> <b>Previous message:</b> <a href="0462.html">Ian Eure: "Re: New S3 videocard"</a>
<li> <b>In reply to:</b> <a href="0086.html">Theodore Y. Ts'o: "Re: TTY_FLIPBUF_SIZE too low causing dataloss on too fast serial lines?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0748.html">Pavel Machek: "Re: TTY_FLIPBUF_SIZE too low causing dataloss on too fast serial lines?"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Fri, 28 May 1999, Theodore Y. Ts'o wrote:<br>
<p>
<i>&gt;    Date: Thu, 27 May 1999 00:15:03 +0200</i><br>
<i>&gt;    From: Pavel Machek &lt;<a href="mailto:pavel@bug.ucw.cz">pavel@bug.ucw.cz</a>&gt;</i><br>
...<br>
<p>
<i>&gt;    Is there some easy way for me to make it work 'just now'? Like calling</i><br>
<i>&gt;    tty_flip_buffer_push from some kind of bh or increasing hz to 1000 or</i><br>
<i>&gt;    ...? </i><br>
<i>&gt; </i><br>
<i>&gt; Well, you could set tty-&gt;low_latency and then call</i><br>
<i>&gt; tty_flip_buffer_push(), which will force it out to the line discpline</i><br>
<i>&gt; right away.  Increasaing HZ to 1000 is also a possibility.</i><br>
<p>
UGH!  Please don't kludge around the broken bottom half handling in 2.2. <br>
I've offered the patch below, and received a couple of good comments.  2.2<br>
as-is will not run a bottom half if it was marked while bottom halves were<br>
being run (this affects the serial driver when using ppp (SERIAL_BH -&gt;<br>
NET_BH), and any other driver that uses IMMED_BH to defer things) which is<br>
pretty broken if you ask me. If the following patch isn't the right way to<br>
do things (the original patch would run bhs indefinately, wheas this<br>
version will run each bh at most once -- would it be preferred to just use<br>
a counter for the maximum number of times to loop or just to revert things<br>
back to the state they were in 2.0?), please make suggestions.<br>
<p>
		-ben<br>
<p>
<p>
--- kernel/softirq.c.orig	Sun Mar 21 10:22:00 1999<br>
+++ kernel/softirq.c	Thu May  6 21:30:47 1999<br>
@@ -26,45 +26,50 @@<br>
 void (*bh_base[32])(void);<br>
 <br>
 /*<br>
- * This needs to make sure that only one bottom half handler<br>
- * is ever active at a time. We do this without locking by<br>
- * doing an atomic increment on the intr_count, and checking<br>
- * (nonatomically) against 1. Only if it's 1 do we schedule<br>
- * the bottom half.<br>
- *<br>
- * Note that the non-atomicity of the test (as opposed to the<br>
- * actual update) means that the test may fail, and _nobody_<br>
- * runs the handlers if there is a race that makes multiple<br>
- * CPU's get here at the same time. That's ok, we'll run them<br>
- * next time around.<br>
+ * Repeatedly run over the bottom halves until there are no more, but only run<br>
+ * each bottom half at most once.  If we don't loop, if one bottom half triggers<br>
+ * another, it might get delayed a long time.  If we loop indefinately, then the<br>
+ * system will lock completely under a heavy irq load. -bcrl<br>
  */<br>
-static inline void run_bottom_halves(void)<br>
-{<br>
-	unsigned long active;<br>
-	void (**bh)(void);<br>
-<br>
-	active = get_active_bhs();<br>
-	clear_active_bhs(active);<br>
-	bh = bh_base;<br>
-	do {<br>
-		if (active &amp; 1)<br>
-			(*bh)();<br>
-		bh++;<br>
-		active &gt;&gt;= 1;<br>
-	} while (active);<br>
-}<br>
-<br>
 asmlinkage void do_bottom_half(void)<br>
 {<br>
 	int cpu = smp_processor_id();<br>
+	unsigned long left = ~0UL;<br>
+	unsigned long active;<br>
+	void (**bh)(void);<br>
 <br>
+again:<br>
 	if (softirq_trylock(cpu)) {<br>
 		if (hardirq_trylock(cpu)) {<br>
 			__sti();<br>
-			run_bottom_halves();<br>
+<br>
+			while ((active = left &amp; get_active_bhs())) {<br>
+				left &amp;= ~active;<br>
+				clear_active_bhs(active);<br>
+				bh = bh_base;<br>
+				do {<br>
+					if (active &amp; 1)<br>
+						(*bh)();<br>
+					bh++;<br>
+						active &gt;&gt;= 1;<br>
+				} while (active);<br>
+			}<br>
+<br>
 			__cli();<br>
 			hardirq_endlock(cpu);<br>
+			softirq_endlock(cpu);<br>
+<br>
+			/*<br>
+			 * Avoid the race by checking if any bottom halves<br>
+			 * are active after releasing all locks.  This is a<br>
+			 * rare race, but should inexpensive to check.  -bcrl<br>
+			 */<br>
+			rmb();<br>
+			if (get_active_bhs() &amp; left)<br>
+				goto again;<br>
+			return;<br>
 		}<br>
 		softirq_endlock(cpu);<br>
 	}<br>
 }<br>
+<br>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0464.html">Marcelo Tosatti: "Re: Everyone's a captain on a calm sea..."</a>
<li> <b>Previous message:</b> <a href="0462.html">Ian Eure: "Re: New S3 videocard"</a>
<li> <b>In reply to:</b> <a href="0086.html">Theodore Y. Ts'o: "Re: TTY_FLIPBUF_SIZE too low causing dataloss on too fast serial lines?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0748.html">Pavel Machek: "Re: TTY_FLIPBUF_SIZE too low causing dataloss on too fast serial lines?"</a>
<!-- reply="end" -->
</ul>
</font></body>
