<!-- received="Tue Jun  1 02:47:07 1999 EET DST" -->
<!-- sent="Mon, 31 May 1999 15:20:41 -0600" -->
<!-- name="Jeff Merkey" -->
<!-- email="jmerkey@timpanogas.com" -->
<!-- subject="Fw: Availability Dates for FENRIS (NetWare) File System for Linux Open Sources (non-HTML version)" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-22,: Fw: Availability Dates for FENRIS (NetWare) File System for Linux Open Sources (non-HTML version)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Fw: Availability Dates for FENRIS (NetWare) File System for Linux Open Sources (non-HTML version)</h1>
<b>Jeff Merkey</b> (<a href="mailto:jmerkey@timpanogas.com"><i>jmerkey@timpanogas.com</i></a>)<br>
<i>Mon, 31 May 1999 15:20:41 -0600</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#486">[ date ]</a><a href="index.html#486">[ thread ]</a><a href="subject.html#486">[ subject ]</a><a href="author.html#486">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0487.html">Bryn Paul Arnold Jones: "Re: 2nd cpu"</a>
<li> <b>Previous message:</b> <a href="0485.html">Andi Kleen: "Re: Migrating to larger numbers"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
<p>
------=_NextPart_000_0047_01BEAB79.25032C30<br>
Content-Type: text/plain;<br>
	charset="iso-8859-1"<br>
Content-Transfer-Encoding: 7bit<br>
<p>
<p>
Some folks requested a "non- Microsoft LookOut Version".  Here you go.<br>
<p>
Jeff<br>
<p>
<p>
----- Original Message -----<br>
From: Jeff Merkey<br>
To: <a href="mailto:linux-kernel@vger.rutgers.edu">linux-kernel@vger.rutgers.edu</a><br>
Sent: Monday, May 31, 1999 11:14 AM<br>
Subject: Availability Dates for FENRIS (NetWare) File System for Linux Open<br>
Sources<br>
<p>
<p>
<p>
Linux Community,<br>
<p>
We had planned on June 1, 1999 as for release of the tar containing the<br>
source code for FENRIS on our website, however, we had forgotten that Moday<br>
May 31, 1999 is a US holiday (Memorial Day).  As such, FENRIS will be<br>
available the following day in the evening.<br>
<p>
We apologize for the inconveniance.  The FENRIS For Linux tar containing the<br>
source code for version 1.4 of NWFS for Linux will be available June 3, 1999<br>
in the morning for download from www.timpanogas.com.  We will make one final<br>
code review pass for bugs and completeness on June 2, 1999, then the code<br>
will be available from our website either the evening of June 2, 1999 or the<br>
following morning (depending on where on planet earth you are when we<br>
publish it to our site).  We also are putting in a fix for Document<br>
Solutions in Alabama that allows Linux to mount NetWare volumes &gt; 560 GB in<br>
size, we are finalizing these changes.<br>
<p>
The license statement for this open source is in an attached source file for<br>
everyone's review.  Anyone wanting to make changes or comments to the<br>
license needs to get this info to us NLT June 2, 1999 before we publish the<br>
code.  Also, anyone who feels they contributed that may left out should let<br>
us know so we can get your names into the first release as contributors.<br>
<p>
We will also be posting a subsequent release of the Open Source 1.5 in two<br>
weeks, and two weeks thereafter we will post 1.6 (around July 1, 1999).<br>
Releases will then follow as required for bug fixes and enhancements.  It is<br>
anticipated at some point, we will release quarterly to all.  The two<br>
interim releases for June are to integrate bug fixes and to put some final<br>
touches on 4 and 8 way volume mirroring, and write hotfixing.<br>
<p>
The nwfs-utils tar containing the open source code utilities to fsck,<br>
create, and maintain NetWare volume and partitions will be available later<br>
in the week, and will also be part of the nwfs quarterly releases.<br>
<p>
<p>
Very Truly Yours,<br>
<p>
Jeff Merkey<br>
CEO, TRG<br>
<p>
------=_NextPart_000_0047_01BEAB79.25032C30<br>
Content-Type: application/octet-stream;<br>
	name="NWFILE.C"<br>
Content-Transfer-Encoding: quoted-printable<br>
Content-Disposition: attachment;<br>
	filename="NWFILE.C"<br>
<p>
<p>
/************************************************************************=<br>
***<br>
*<br>
*   Copyright (c) 1998, 1999 Timpanogas Research Group, Inc.<br>
*   895 West Center Street<br>
*   Orem, Utah  84057<br>
*   <a href="mailto:jmerkey@timpanogas.com">jmerkey@timpanogas.com</a><br>
*<br>
*   This program is free software; you can redistribute it and/or modify =<br>
it<br>
*   under the terms of the GNU General Public License as published by =<br>
the<br>
*   Free Software Foundation, version 2, or any later version.<br>
*<br>
*   This program is distributed in the hope that it will be useful, but<br>
*   WITHOUT ANY WARRANTY; without even the implied warranty of<br>
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU<br>
*   General Public License for more details.<br>
*<br>
*   You should have received a copy of the GNU General Public License =<br>
along<br>
*   with this program; if not, write to the Free Software Foundation, =<br>
Inc.,<br>
*   675 Mass Ave, Cambridge, MA 02139, USA.<br>
*<br>
*   You are free to modify and re-distribute this program in accordance<br>
*   with the terms specified in the GNU Public License.  The copyright<br>
*   contained in this code is required to be present in any derivative<br>
*   works and you are required to provide the source code for this<br>
*   program as part of any commercial or non-commercial distribution.<br>
*   You are required to respect the rights of the Copyright holders<br>
*   named within this code.<br>
*<br>
*   <a href="mailto:jmerkey@timpanogas.com">jmerkey@timpanogas.com</a> and TRG, Inc. are the official maintainers of<br>
*   this code.  You are encouraged to report any bugs, problems, fixes,<br>
*   suggestions, and comments about this software to =<br>
<a href="mailto:jmerkey@timpanogas.com">jmerkey@timpanogas.com</a><br>
*   or <a href="mailto:linux-kernel@vger.rutgers.edu">linux-kernel@vger.rutgers.edu</a>.  New releases, patches, bug fixes, =<br>
and<br>
*   technical documentation can be found at www.timpanogas.com.  TRG =<br>
will<br>
*   periodically post new releases of this software to =<br>
www.timpanogas.com<br>
*   that contain bug fixes and enhanced capabilities.<br>
*<br>
*   Original Authorship      :  v1.4<br>
*      source code written by Jeff V. Merkey, TRG, Inc.    11/1/98 to =<br>
6/1/99<br>
*<br>
*   Original Contributors    :  v1.4<br>
*      engineer  consulting  Jeff V. Merkey, TRG, Inc.     11/1/98 to =<br>
6/1/99<br>
*      technical consulting  Darren Major, TRG, Inc.       11/1/98 to =<br>
6/1/99<br>
*      technical consulting  Drew Spencer, Caldera Systems 11/1/98 to =<br>
6/1/99<br>
*      technical consulting  Steve Spicer, Document Solutions 4/15/99 =<br>
6/1/99<br>
*         (testing for very large NetWare volumes &gt; 560 GB)<br>
*<br>
*************************************************************************=<br>
***<br>
*<br>
*<br>
*   AUTHOR   :  Jeff V. Merkey (<a href="mailto:jmerkey@timpanogas.com">jmerkey@timpanogas.com</a>)<br>
*   FILE     :  NWFILE.C<br>
*   DESCRIP  :  FENRIS NetWare File Management<br>
*   DATE     :  December 14, 1998<br>
*<br>
*<br>
*************************************************************************=<br>
**/<br>
<p>
#include "version.h"<br>
#include "globals.h"<br>
#include "stdio.h"<br>
#include "stdlib.h"<br>
#include "string.h"<br>
#include "nwfs.h"<br>
#include "nwstruct.h"<br>
#include "nwdir.h"<br>
#include "hash.h"<br>
#include "externs.h"<br>
<p>
<p>
#include &lt;linux/module.h&gt;<br>
#include &lt;asm/system.h&gt;<br>
#include &lt;asm/segment.h&gt;<br>
#include &lt;linux/sched.h&gt;<br>
#include &lt;linux/kernel.h&gt;<br>
#include &lt;linux/mm.h&gt;<br>
#include &lt;linux/string.h&gt;<br>
#include &lt;linux/stat.h&gt;<br>
#include &lt;linux/errno.h&gt;<br>
#include &lt;linux/locks.h&gt;<br>
#include &lt;linux/fcntl.h&gt;<br>
#include &lt;linux/malloc.h&gt;<br>
#include &lt;linux/version.h&gt;<br>
#include &lt;linux/module.h&gt;<br>
#include &lt;linux/modversions.h&gt;<br>
<p>
<p>
<p>
ULONG NWReadFile(VOLUME *volume, DOS *dos, ULONG offset, BYTE *buf, long =<br>
count)<br>
{<br>
    register long cluster, index;<br>
    register ULONG bytesRead =3D 0, bytesLeft =3D 0;<br>
    register ULONG StartIndex, StartOffset;<br>
    register FAT_ENTRY *FAT;<br>
    register ULONG voffset, vsize, vindex, cbytes;<br>
<p>
    // adjust size and range check for EOF<br>
<p>
    if ((offset + count) &gt; dos-&gt;FileSize)<br>
       count =3D dos-&gt;FileSize - offset;<br>
<p>
    if (count &lt;=3D 0)<br>
       return 0;<br>
<p>
    // if a subdirectory then return 0<br>
    if (dos-&gt;Flags &amp; SUBDIRECTORY_FILE)<br>
       return 0;<br>
<p>
    bytesLeft =3D count;<br>
    StartIndex =3D offset / volume-&gt;ClusterSize;<br>
    StartOffset =3D offset % volume-&gt;ClusterSize;<br>
<p>
    // we always start with an index of zero<br>
    index =3D 0;<br>
    cluster =3D dos-&gt;FirstBlock;<br>
    vindex =3D StartIndex;<br>
<p>
    if ((bytesLeft &gt; 0) &amp;&amp; (cluster &lt; 0))<br>
    {<br>
       // check for EOF<br>
       if (cluster =3D=3D (ULONG) -1)<br>
       {<br>
	  // filesize may exceed allocation, which means the rest of<br>
	  // the file is sparse.  fill zeros into the requested<br>
	  // size.  bytesLeft will have been set by count, which is<br>
	  // range checked to the actual length of the file.<br>
<p>
	  if (bytesLeft &gt; 0)<br>
	  {<br>
	     NWFSSetUserSpace(buf, 0, bytesLeft);<br>
	     bytesRead +=3D bytesLeft;<br>
	  }<br>
	  return bytesRead;<br>
       }<br>
<p>
       // index should be null here<br>
       if (StartIndex)<br>
       {<br>
	  // filesize may exceed allocation, which means the rest of<br>
	  // the file is sparse.  fill zeros into the requested<br>
	  // size.<br>
<p>
	  if (bytesLeft &gt; 0)<br>
	  {<br>
	     NWFSSetUserSpace(buf, 0, bytesLeft);<br>
	     bytesRead +=3D bytesLeft;<br>
	  }<br>
	  return bytesRead;<br>
       }<br>
<p>
       // vindex is always equal to StartIndex here<br>
       voffset =3D StartOffset;<br>
<p>
       // if this value exceeds the suballoc record size,<br>
       // ReadSuballoc record will reduce this size to the<br>
       // current record allocation.<br>
       vsize =3D bytesLeft;<br>
<p>
       cbytes =3D ReadSuballocRecord(volume, voffset, cluster, buf, =<br>
vsize);<br>
       bytesRead +=3D cbytes;<br>
       bytesLeft -=3D cbytes;<br>
       buf +=3D cbytes;<br>
<p>
       // filesize may exceed allocation, which means the rest of<br>
       // the file is sparse.  fill zeros into the requested<br>
       // size.<br>
       if (bytesLeft &gt; 0)<br>
       {<br>
	  NWFSSetUserSpace(buf, 0, bytesLeft);<br>
	  bytesRead +=3D bytesLeft;<br>
       }<br>
       return bytesRead;<br>
    }<br>
<p>
    vindex =3D StartIndex;<br>
    FAT =3D GetFatEntry(volume, cluster);<br>
    if (FAT)<br>
       index =3D FAT-&gt;FATIndex;<br>
<p>
    while (FAT &amp;&amp; FAT-&gt;FATCluster &amp;&amp; (bytesLeft &gt; 0))<br>
    {<br>
       //  if we found a hole, then return zeros until we<br>
       //  either satisfy the requested read size or<br>
       //  we span to the next valid index entry<br>
<p>
       while ((bytesLeft &gt; 0) &amp;&amp; (vindex &lt; index))<br>
       {<br>
	  voffset =3D 0;<br>
	  if (vindex =3D=3D StartIndex)<br>
	     voffset =3D StartOffset;<br>
<p>
	  vsize =3D (bytesLeft &gt; (volume-&gt;ClusterSize - voffset))<br>
		  ? (volume-&gt;ClusterSize - voffset) : bytesLeft;<br>
<p>
	  NWFSSetUserSpace(buf, 0, vsize);<br>
	  bytesRead +=3D vsize;<br>
	  bytesLeft -=3D vsize;<br>
	  buf +=3D vsize;<br>
	  vindex++;<br>
       }<br>
<p>
       // found our index block, perform the copy operation<br>
<p>
       if ((bytesLeft &gt; 0) &amp;&amp; (vindex =3D=3D index))<br>
       {<br>
	  voffset =3D 0;<br>
	  if (vindex =3D=3D StartIndex)<br>
	     voffset =3D StartOffset;<br>
<p>
	  vsize =3D (bytesLeft &gt; (volume-&gt;ClusterSize - voffset))<br>
		  ? (volume-&gt;ClusterSize - voffset) : bytesLeft;<br>
<p>
	  cbytes =3D ReadClusterWithOffset(volume, cluster, voffset, buf, =<br>
vsize,<br>
					 USER_ADDRESS_SPACE);<br>
	  bytesRead +=3D cbytes;<br>
	  bytesLeft -=3D cbytes;<br>
	  buf +=3D cbytes;<br>
	  vindex++;<br>
       }<br>
<p>
       // bump to the next cluster<br>
       cluster =3D FAT-&gt;FATCluster;<br>
<p>
       // check if the next cluster is a suballoc element or EOF marker<br>
       if ((bytesLeft &gt; 0) &amp;&amp; (cluster &lt; 0))<br>
       {<br>
	  // end of file<br>
	  if (cluster =3D=3D (ULONG) -1)<br>
	  {<br>
	     // filesize may exceed allocation, which means the rest of<br>
	     // the file is sparse.  fill zeros into the requested<br>
	     // size.<br>
	     if (bytesLeft &gt; 0)<br>
	     {<br>
		NWFSSetUserSpace(buf, 0, bytesLeft);<br>
		bytesRead +=3D bytesLeft;<br>
	     }<br>
	     return bytesRead;<br>
	  }<br>
<p>
	  // check for valid index<br>
	  if ((index + 1) =3D=3D vindex)<br>
	  {<br>
	     voffset =3D 0;<br>
	     if (vindex =3D=3D StartIndex)<br>
		voffset =3D StartOffset;<br>
<p>
	     // if this value exceeds the suballoc record size,<br>
	     // ReadSuballoc record will reduce this size to the<br>
	     // current record allocation.<br>
	     vsize =3D bytesLeft;<br>
<p>
	     cbytes =3D ReadSuballocRecord(volume, voffset, cluster, buf, =<br>
vsize);<br>
	     bytesRead +=3D cbytes;<br>
	     bytesLeft -=3D cbytes;<br>
	     buf +=3D cbytes;<br>
	  }<br>
<p>
	  // filesize may exceed allocation, which means the rest of<br>
	  // the file is sparse.  fill zeros into the requested<br>
	  // size.<br>
	  if (bytesLeft &gt; 0)<br>
	  {<br>
	     NWFSSetUserSpace(buf, 0, bytesLeft);<br>
	     bytesRead +=3D bytesLeft;<br>
	  }<br>
	  return bytesRead;<br>
       }<br>
<p>
       // get next fat table entry and index<br>
       FAT =3D GetFatEntry(volume, cluster);<br>
       if (FAT)<br>
	  index =3D FAT-&gt;FATIndex;<br>
    }<br>
<p>
    // filesize may exceed allocation, which means the rest of<br>
    // the file is sparse.  fill zeros into the requested<br>
    // size.<br>
    if (bytesLeft &gt; 0)<br>
    {<br>
       NWFSSetUserSpace(buf, 0, bytesLeft);<br>
       bytesRead +=3D bytesLeft;<br>
    }<br>
    return bytesRead;<br>
<p>
}<br>
<p>
#define STAGE_WRITE 0<br>
<p>
ULONG NWWriteFile(VOLUME *volume, DOS *dos, ULONG offset, BYTE *buf, =<br>
long count)<br>
{<br>
    register long cluster, index;<br>
    register ULONG bytesWritten =3D 0, bytesLeft =3D 0, lcount =3D 0;<br>
    register ULONG StartIndex, StartOffset, SuballocSize;<br>
    register FAT_ENTRY *FAT;<br>
    register ULONG voffset, vsize, vindex, cbytes;<br>
    register long pcluster, ncluster;<br>
    register BYTE *WorkSpace;<br>
    MIRROR_LRU *lru =3D 0;<br>
<p>
    // if a subdirectory then return 0<br>
    if (dos-&gt;Flags &amp; SUBDIRECTORY_FILE)<br>
       return 0;<br>
<p>
    bytesLeft =3D count;<br>
    StartIndex =3D offset / volume-&gt;ClusterSize;<br>
    StartOffset =3D offset % volume-&gt;ClusterSize;<br>
<p>
    // we always start with an index of zero<br>
    index =3D 0;<br>
    pcluster =3D cluster =3D dos-&gt;FirstBlock;<br>
    vindex =3D StartIndex;<br>
<p>
    if ((bytesLeft &gt; 0) &amp;&amp; (cluster &lt; 0))<br>
    {<br>
       // check for EOF<br>
       if (cluster =3D=3D (ULONG) -1)<br>
       {<br>
#if (STAGE_WRITE)<br>
	  NWFSPrint("[1] ");<br>
#endif<br>
	  // vindex is always equal to StartIndex here<br>
	  voffset =3D StartOffset;<br>
<p>
	  vsize =3D (bytesLeft &gt; (volume-&gt;ClusterSize - voffset))<br>
		  ? (volume-&gt;ClusterSize - voffset) : bytesLeft;<br>
<p>
	  // allocate cluster and point forward link to EOF<br>
	  ncluster =3D AllocateClusterSetIndexSetChain(volume, vindex, (ULONG) =<br>
-1);<br>
	  if (ncluster =3D=3D -1)<br>
	  {<br>
	     // if we could not get a free cluster, then return<br>
	     // (out of drive space)<br>
	     return (bytesWritten ? bytesWritten : -1);<br>
	  }<br>
<p>
	  // zero fill the new cluster<br>
	  ZeroPhysicalVolumeCluster(volume, ncluster);<br>
<p>
	  // this case<br>
	  dos-&gt;FirstBlock =3D ncluster;<br>
	  pcluster =3D ncluster;<br>
<p>
	  cbytes =3D WriteClusterWithOffset(volume, ncluster, voffset, buf, =<br>
vsize,<br>
					  USER_ADDRESS_SPACE);<br>
	  bytesWritten +=3D cbytes;<br>
	  bytesLeft -=3D cbytes;<br>
	  buf +=3D cbytes;<br>
	  vindex++;<br>
<p>
	  while (bytesLeft &gt; 0)<br>
	  {<br>
	     voffset =3D 0;<br>
	     if (vindex =3D=3D StartIndex)<br>
		voffset =3D StartOffset;<br>
<p>
	     vsize =3D (bytesLeft &gt; (volume-&gt;ClusterSize - voffset))<br>
		     ? (volume-&gt;ClusterSize - voffset) : bytesLeft;<br>
<p>
	     // allocate cluster and point forward link to EOF<br>
	     ncluster =3D AllocateClusterSetIndexSetChain(volume, vindex, -1);<br>
	     if (ncluster =3D=3D -1)<br>
	     {<br>
		// if we could not get a free cluster, then return<br>
		// (out of drive space)<br>
		return (bytesWritten ? bytesWritten : -1);<br>
	     }<br>
<p>
	     // zero fill the new cluster<br>
	     ZeroPhysicalVolumeCluster(volume, ncluster);<br>
<p>
	     // set previous cluster chain to point to this entry<br>
	     SetClusterValue(volume, pcluster, ncluster);<br>
<p>
	     // update previous cluster to new cluster<br>
	     // this will force inserts after the end of this cluster<br>
	     pcluster =3D ncluster;<br>
<p>
	     cbytes =3D WriteClusterWithOffset(volume, ncluster, voffset, buf, =<br>
vsize,<br>
					     USER_ADDRESS_SPACE);<br>
	     bytesWritten +=3D cbytes;<br>
	     bytesLeft -=3D cbytes;<br>
	     buf +=3D cbytes;<br>
	     vindex++;<br>
<p>
	  }<br>
	  return (bytesWritten ? bytesWritten : -1);<br>
       }<br>
<p>
       // we have detected a suballoc element in the fat chain if we<br>
       // get to this point<br>
<p>
#if (STAGE_WRITE)<br>
       NWFSPrint("[2] ");<br>
#endif<br>
<p>
       SuballocSize =3D GetSuballocSize(volume, cluster);<br>
<p>
       voffset =3D 0;<br>
       if (vindex =3D=3D StartIndex)<br>
	  voffset =3D StartOffset;<br>
<p>
       // this case assumes we will free the current suballoc element<br>
<p>
       if ((bytesLeft + voffset) &gt; SuballocSize)<br>
       {<br>
	  WorkSpace =3D NWFSCacheAlloc(SuballocSize, SA_WORKSPACE_TAG);<br>
	  if (!WorkSpace)<br>
	  {<br>
	     // if we could not get memory to copy the suballoc record,<br>
	     // then return (out of drive space)<br>
	     return (bytesWritten ? bytesWritten : -1);<br>
	  }<br>
<p>
	  voffset =3D 0;<br>
	  if (vindex =3D=3D StartIndex)<br>
	     voffset =3D StartOffset;<br>
<p>
	  vsize =3D (bytesLeft &gt; (volume-&gt;ClusterSize - voffset))<br>
		  ? (volume-&gt;ClusterSize - voffset) : bytesLeft;<br>
<p>
	  // allocate cluster and point forward link to EOF<br>
	  ncluster =3D AllocateClusterSetIndexSetChain(volume, vindex, (ULONG) =<br>
-1);<br>
	  if (ncluster =3D=3D -1)<br>
	  {<br>
	     // if we could not get a free cluster, then return<br>
	     // (out of drive space)<br>
	     NWFSFree(WorkSpace);<br>
	     return (bytesWritten ? bytesWritten : -1);<br>
	  }<br>
<p>
	  // zero fill the new cluster<br>
	  ZeroPhysicalVolumeCluster(volume, ncluster);<br>
<p>
	  // here we read the previous data from the suballoc element<br>
	  cbytes =3D ReadSuballocData(volume, 0, cluster, WorkSpace, =<br>
SuballocSize);<br>
	  if (cbytes !=3D SuballocSize)<br>
	  {<br>
	     NWFSFree(WorkSpace);<br>
	     return (bytesWritten ? bytesWritten : -1);<br>
	  }<br>
<p>
	  // now write the previous data from the suballoc element<br>
	  // into the newly allocated cluster.<br>
	  cbytes =3D WriteClusterWithOffset(volume, ncluster, 0, WorkSpace, =<br>
SuballocSize,<br>
					  KERNEL_ADDRESS_SPACE);<br>
	  if (cbytes !=3D SuballocSize)<br>
	  {<br>
	     NWFSFree(WorkSpace);<br>
	     return (bytesWritten ? bytesWritten : -1);<br>
	  }<br>
<p>
	  // free the suballoc element in bit block list<br>
	  FreeSuballocRecord(volume, cluster);<br>
<p>
	  // this case<br>
	  dos-&gt;FirstBlock =3D ncluster;<br>
	  pcluster =3D ncluster;<br>
<p>
	  // now write the user data into the suballoc element<br>
	  cbytes =3D WriteClusterWithOffset(volume, ncluster, voffset, buf, =<br>
vsize,<br>
					  USER_ADDRESS_SPACE);<br>
	  bytesWritten +=3D cbytes;<br>
	  bytesLeft -=3D cbytes;<br>
	  buf +=3D cbytes;<br>
	  vindex++;<br>
<p>
	  NWFSFree(WorkSpace);<br>
<p>
	  while (bytesLeft &gt; 0)<br>
	  {<br>
	     voffset =3D 0;<br>
	     if (vindex =3D=3D StartIndex)<br>
		voffset =3D StartOffset;<br>
<p>
	     vsize =3D (bytesLeft &gt; (volume-&gt;ClusterSize - voffset))<br>
		     ? (volume-&gt;ClusterSize - voffset) : bytesLeft;<br>
<p>
	     // allocate cluster and point forward link to EOF<br>
	     ncluster =3D AllocateClusterSetIndexSetChain(volume, vindex, -1);<br>
	     if (ncluster =3D=3D -1)<br>
	     {<br>
		// if we could not get a free cluster, then return<br>
		// (out of drive space)<br>
		return (bytesWritten ? bytesWritten : -1);<br>
	     }<br>
<p>
	     // zero fill the new cluster<br>
	     ZeroPhysicalVolumeCluster(volume, ncluster);<br>
<p>
	     // set previous cluster chain to point to this entry<br>
	     SetClusterValue(volume, pcluster, ncluster);<br>
<p>
	     // update previous cluster to new cluster<br>
	     // this will force inserts after the end of this cluster<br>
	     pcluster =3D ncluster;<br>
<p>
	     cbytes =3D WriteClusterWithOffset(volume, ncluster, voffset, buf, =<br>
vsize,<br>
					     USER_ADDRESS_SPACE);<br>
	     bytesWritten +=3D cbytes;<br>
	     bytesLeft -=3D cbytes;<br>
	     buf +=3D cbytes;<br>
	     vindex++;<br>
<p>
	  }<br>
	  return (bytesWritten ? bytesWritten : -1);<br>
       }<br>
       else<br>
       {<br>
#if (STAGE_WRITE)<br>
	  NWFSPrint("[3] ");<br>
#endif<br>
	  // for this case, since our target write size fits within<br>
	  // the previously allocated suballoc element, then just<br>
	  // write the data.<br>
<p>
	  // vindex will always be equal to StartIndex here<br>
	  voffset =3D StartOffset;<br>
<p>
	  // at this point, bytesLeft is either equal to or<br>
	  // less than the size of the current suballocation<br>
	  // record.<br>
<p>
	  vsize =3D bytesLeft;<br>
	  cbytes =3D WriteSuballocRecord(volume, voffset, cluster, buf, vsize);<br>
<p>
	  bytesWritten +=3D cbytes;<br>
	  bytesLeft -=3D cbytes;<br>
<p>
	  return (bytesWritten ? bytesWritten : -1);<br>
       }<br>
    }<br>
<p>
    FAT =3D GetFatEntryAndLRU(volume, cluster, &amp;lru);<br>
    if (FAT)<br>
       index =3D FAT-&gt;FATIndex;<br>
<p>
    while (FAT &amp;&amp; FAT-&gt;FATCluster &amp;&amp; (bytesLeft &gt; 0))<br>
    {<br>
       //  if we found a hole, then allocate and add a new cluster<br>
       //  to the file and continue to add clusters and write until<br>
       //  bytesLeft is &lt; 0 or we find the next valid cluster in the<br>
       //  fat chain<br>
<p>
       while ((bytesLeft &gt; 0) &amp;&amp; (vindex &lt; index))<br>
       {<br>
#if (STAGE_WRITE)<br>
	  NWFSPrint("[4] ");<br>
#endif<br>
	  // we can only get here if we detected the next<br>
	  // fat element is greater than the target index<br>
	  // (the file has holes, and we hit an index<br>
	  // larger than we expected).<br>
<p>
	  // we simply extend the file by allocating clusters<br>
	  // until we complete the write or the target index<br>
	  // equals the current cluster.  obvioulsy, we must<br>
	  // insert nodes into the fat chain for each element we<br>
	  // allocate.<br>
<p>
	  voffset =3D 0;<br>
	  if (vindex =3D=3D StartIndex)<br>
	     voffset =3D StartOffset;<br>
<p>
	  vsize =3D (bytesLeft &gt; (volume-&gt;ClusterSize - voffset))<br>
		  ? (volume-&gt;ClusterSize - voffset) : bytesLeft;<br>
<p>
	  // allocate cluster and point forward link to next cluster<br>
	  ncluster =3D AllocateClusterSetIndexSetChain(volume, vindex, =<br>
cluster);<br>
	  if (ncluster =3D=3D -1)<br>
	  {<br>
	     // if we could not get a free cluster, then return<br>
	     // (out of drive space)<br>
	     return (bytesWritten ? bytesWritten : -1);<br>
	  }<br>
<p>
	  // zero fill the new cluster<br>
	  ZeroPhysicalVolumeCluster(volume, ncluster);<br>
<p>
	  // set previous cluster chain to point to this entry<br>
	  // if pcluster and cluster are equal, then we are<br>
	  // inserting at the front of the cluster chain<br>
	  // so adjust the directory block<br>
<p>
	  (pcluster !=3D cluster)<br>
	  ? SetClusterValue(volume, pcluster, ncluster)<br>
	  : (dos-&gt;FirstBlock =3D ncluster);<br>
<p>
	  // update previous cluster to new cluster<br>
	  pcluster =3D ncluster;<br>
<p>
	  cbytes =3D WriteClusterWithOffset(volume, ncluster, voffset, buf, =<br>
vsize,<br>
					  USER_ADDRESS_SPACE);<br>
	  bytesWritten +=3D cbytes;<br>
	  bytesLeft -=3D cbytes;<br>
	  buf +=3D cbytes;<br>
	  vindex++;<br>
<p>
       }<br>
<p>
       // found our index block, perform the copy operation<br>
<p>
       if ((bytesLeft &gt; 0) &amp;&amp; (vindex =3D=3D index))<br>
       {<br>
#if (STAGE_WRITE)<br>
	  NWFSPrint("[5] ");<br>
#endif<br>
<p>
	  voffset =3D 0;<br>
	  if (vindex =3D=3D StartIndex)<br>
	     voffset =3D StartOffset;<br>
<p>
	  vsize =3D (bytesLeft &gt; (volume-&gt;ClusterSize - voffset))<br>
		  ? (volume-&gt;ClusterSize - voffset) : bytesLeft;<br>
<p>
	  cbytes =3D WriteClusterWithOffset(volume, cluster, voffset, buf, =<br>
vsize,<br>
					  USER_ADDRESS_SPACE);<br>
	  bytesWritten +=3D cbytes;<br>
	  bytesLeft -=3D cbytes;<br>
	  buf +=3D cbytes;<br>
	  vindex++;<br>
<p>
       }<br>
<p>
       // save the previous cluster<br>
       pcluster =3D cluster;<br>
<p>
       // bump to the next cluster<br>
       cluster =3D FAT-&gt;FATCluster;<br>
<p>
       // check if the next cluster is a suballoc element or EOF<br>
       if ((bytesLeft &gt; 0) &amp;&amp; (cluster &lt; 0))<br>
       {<br>
	  // end of file<br>
	  if (cluster =3D=3D (ULONG) -1)<br>
	  {<br>
#if (STAGE_WRITE)<br>
	     NWFSPrint("[6] ");<br>
#endif<br>
	     while (bytesLeft &gt; 0)<br>
	     {<br>
		voffset =3D 0;<br>
		if (vindex =3D=3D StartIndex)<br>
		   voffset =3D StartOffset;<br>
<p>
		vsize =3D (bytesLeft &gt; (volume-&gt;ClusterSize - voffset))<br>
			? (volume-&gt;ClusterSize - voffset) : bytesLeft;<br>
<p>
		// allocate cluster and point forward link to EOF<br>
		ncluster =3D AllocateClusterSetIndexSetChain(volume, vindex, -1);<br>
		if (ncluster =3D=3D -1)<br>
		{<br>
		   // if we could not get a free cluster, then return<br>
		   // (out of drive space)<br>
		   return (bytesWritten ? bytesWritten : -1);<br>
		}<br>
<p>
		// zero fill the new cluster<br>
		ZeroPhysicalVolumeCluster(volume, ncluster);<br>
<p>
		// set previous cluster chain to point to this entry<br>
		SetClusterValue(volume, pcluster, ncluster);<br>
<p>
		// update previous cluster to new cluster<br>
		// this will force inserts after the end of this cluster<br>
		pcluster =3D ncluster;<br>
<p>
		cbytes =3D WriteClusterWithOffset(volume, ncluster, voffset, buf, =<br>
vsize,<br>
						USER_ADDRESS_SPACE);<br>
		bytesWritten +=3D cbytes;<br>
		bytesLeft -=3D cbytes;<br>
		buf +=3D cbytes;<br>
		vindex++;<br>
<p>
	     }<br>
	     return (bytesWritten ? bytesWritten : -1);<br>
	  }<br>
<p>
	  // we have detected a suballoc element in the fat chain if we<br>
	  // get to this point<br>
<p>
#if (STAGE_WRITE)<br>
	  NWFSPrint("[7] ");<br>
#endif<br>
	  SuballocSize =3D GetSuballocSize(volume, cluster);<br>
<p>
	  voffset =3D 0;<br>
	  if (vindex =3D=3D StartIndex)<br>
	     voffset =3D StartOffset;<br>
<p>
	  // this case assumes we will free the current suballoc element<br>
	  // and copy it to a cluster or another suballoc element<br>
<p>
	  if ((bytesLeft + voffset) &gt; SuballocSize)<br>
	  {<br>
	     WorkSpace =3D NWFSCacheAlloc(SuballocSize, SA_WORKSPACE_TAG);<br>
	     if (!WorkSpace)<br>
	     {<br>
		// if we could not get memory to copy the suballoc record,<br>
		// then return (out of drive space)<br>
		return (bytesWritten ? bytesWritten : -1);<br>
	     }<br>
<p>
	     voffset =3D 0;<br>
	     if (vindex =3D=3D StartIndex)<br>
		voffset =3D StartOffset;<br>
<p>
	     vsize =3D (bytesLeft &gt; (volume-&gt;ClusterSize - voffset))<br>
		     ? (volume-&gt;ClusterSize - voffset) : bytesLeft;<br>
<p>
	     // allocate cluster and point forward link to EOF<br>
	     ncluster =3D AllocateClusterSetIndexSetChain(volume, vindex, -1);<br>
	     if (ncluster =3D=3D -1)<br>
	     {<br>
		// if we could not get a free cluster, then return<br>
		// (out of drive space)<br>
		NWFSFree(WorkSpace);<br>
		return (bytesWritten ? bytesWritten : -1);<br>
	     }<br>
<p>
	     // zero fill the new cluster<br>
	     ZeroPhysicalVolumeCluster(volume, ncluster);<br>
<p>
	     // here we read the previous data from the suballoc element<br>
	     cbytes =3D ReadSuballocData(volume, 0, cluster, WorkSpace, =<br>
SuballocSize);<br>
	     if (cbytes !=3D SuballocSize)<br>
	     {<br>
		NWFSFree(WorkSpace);<br>
		return (bytesWritten ? bytesWritten : -1);<br>
	     }<br>
<p>
	     // now write the previous data from the suballoc element<br>
	     // into the newly allocated cluster.<br>
	     cbytes =3D WriteClusterWithOffset(volume, ncluster, 0, WorkSpace, =<br>
SuballocSize,<br>
					  KERNEL_ADDRESS_SPACE);<br>
	     if (cbytes !=3D SuballocSize)<br>
	     {<br>
		NWFSFree(WorkSpace);<br>
		return (bytesWritten ? bytesWritten : -1);<br>
	     }<br>
<p>
	     // free the suballoc element in bit block list<br>
	     FreeSuballocRecord(volume, cluster);<br>
<p>
	     // set previous cluster chain to point to this entry<br>
	     SetClusterValue(volume, pcluster, ncluster);<br>
<p>
	     // update previous cluster to new cluster<br>
	     // this will force inserts after the end of this cluster<br>
	     pcluster =3D ncluster;<br>
<p>
	     cbytes =3D WriteClusterWithOffset(volume, ncluster, voffset, buf, =<br>
vsize,<br>
					     USER_ADDRESS_SPACE);<br>
	     bytesWritten +=3D cbytes;<br>
	     bytesLeft -=3D cbytes;<br>
	     buf +=3D cbytes;<br>
	     vindex++;<br>
<p>
	     NWFSFree(WorkSpace);<br>
<p>
	     while (bytesLeft &gt; 0)<br>
	     {<br>
		voffset =3D 0;<br>
		if (vindex =3D=3D StartIndex)<br>
		   voffset =3D StartOffset;<br>
<p>
		vsize =3D (bytesLeft &gt; (volume-&gt;ClusterSize - voffset))<br>
			? (volume-&gt;ClusterSize - voffset) : bytesLeft;<br>
<p>
		// allocate cluster and point forward link to EOF<br>
		ncluster =3D AllocateClusterSetIndexSetChain(volume, vindex, -1);<br>
		if (ncluster =3D=3D -1)<br>
		{<br>
		   // if we could not get a free cluster, then return<br>
		   // (out of drive space)<br>
		   return (bytesWritten ? bytesWritten : -1);<br>
		}<br>
<p>
		// zero fill the new cluster<br>
		ZeroPhysicalVolumeCluster(volume, ncluster);<br>
<p>
		// set previous cluster chain to point to this entry<br>
		SetClusterValue(volume, pcluster, ncluster);<br>
<p>
		// update previous cluster to new cluster<br>
		// this will force inserts after the end of this cluster<br>
		pcluster =3D ncluster;<br>
<p>
		cbytes =3D WriteClusterWithOffset(volume, ncluster, voffset, buf, =<br>
vsize,<br>
						USER_ADDRESS_SPACE);<br>
		bytesWritten +=3D cbytes;<br>
		bytesLeft -=3D cbytes;<br>
		buf +=3D cbytes;<br>
		vindex++;<br>
<p>
	     }<br>
	     return (bytesWritten ? bytesWritten : -1);<br>
	  }<br>
	  else<br>
	  {<br>
#if (STAGE_WRITE)<br>
	     NWFSPrint("[8] ");<br>
#endif<br>
	     // for this case, since our target write size fits within<br>
	     // the previously allocated suballoc element, then just<br>
	     // write the data.<br>
<p>
	     // check for valid index<br>
	     if ((index + 1) =3D=3D vindex)<br>
	     {<br>
		voffset =3D 0;<br>
		if (vindex =3D=3D StartIndex)<br>
		   voffset =3D StartOffset;<br>
<p>
		// at this point, bytesLeft is either equal to or<br>
		// less than the size of the current suballocation<br>
		// record.<br>
<p>
		vsize =3D bytesLeft;<br>
		cbytes =3D WriteSuballocRecord(volume, voffset, cluster,<br>
					  buf, vsize);<br>
		bytesWritten +=3D cbytes;<br>
		bytesLeft -=3D cbytes;<br>
	     }<br>
	  }<br>
	  return (bytesWritten ? bytesWritten : -1);<br>
       }<br>
<p>
       // get next fat table entry and index<br>
       FAT =3D GetFatEntryAndLRU(volume, cluster, &amp;lru);<br>
<p>
       // if the fat chain terminates, then exit<br>
       if (!FAT)<br>
	  return (bytesWritten ? bytesWritten : -1);<br>
<p>
       index =3D FAT-&gt;FATIndex;<br>
       lcount++;<br>
    }<br>
    return (bytesWritten ? bytesWritten : -1);<br>
<p>
}<br>
<p>
ULONG NWExclusiveWriteFile(VOLUME *volume, DOS *dos, HASH *hash,<br>
			   ULONG offset, BYTE *buf, long count)<br>
{<br>
    register ULONG retCode;<br>
<p>
    NWLockDirectory(hash);<br>
    retCode =3D NWWriteFile(volume, dos, offset, buf, count);<br>
    NWUnlockDirectory(hash);<br>
<p>
    return retCode;<br>
}<br>
<p>
<p>
ULONG TrgDebugTrans =3D 0;<br>
<p>
NW_STATUS TrgGetPartitionInfoFromVolumeInfo(IN   ULONG VolumeNumber,<br>
					    IN   ULONG SectorOffsetInVolume,<br>
					    OUT  void **PartitionPointer,<br>
					    OUT  ULONG *SectorOffsetInPartition,<br>
					    OUT  ULONG *SectorsLeftInSegment)<br>
{<br>
    register VOLUME *volume =3D VolumeTable[VolumeNumber];<br>
    register ULONG i, ClusterOffset, SectorOffset, ClusterTotal =3D 0;<br>
    register ULONG VirtualSectorOffset, VirtualSegmentOffset;<br>
    register NWPART *NWPart;<br>
<p>
    ClusterOffset =3D (SectorOffsetInVolume / =<br>
volume-&gt;SectorsPerCluster);<br>
    SectorOffset =3D (SectorOffsetInVolume % volume-&gt;SectorsPerCluster);<br>
<p>
    for (i=3D0; i &lt; volume-&gt;NumberOfSegments; i++)<br>
    {<br>
<p>
#if VERBOSE<br>
       if (TrgDebugTrans)<br>
       {<br>
	  NWPart =3D volume-&gt;Partitions[i];<br>
	  NWFSPrint("[0x%08X]  start-%X  sba-%X\n",<br>
		    NWPart-&gt;PartitionPointer,<br>
		    volume-&gt;Segments[i]-&gt;SegmentClusterStart,<br>
		    volume-&gt;SegmentBlockAddress[i]);<br>
       }<br>
#endif<br>
<p>
       if (volume-&gt;Segments[i])<br>
       {<br>
	  if ((ClusterOffset &gt;=3D ClusterTotal) &amp;&amp;<br>
	      (ClusterOffset &lt; (volume-&gt;SegmentClusters[i] + ClusterTotal)))<br>
	  {<br>
<p>
<p>
	     NWPart =3D volume-&gt;Partitions[i];<br>
	     *PartitionPointer =3D NWPart-&gt;PartitionPointer;<br>
<p>
	     VirtualSegmentOffset =3D ((ClusterOffset -<br>
				    volume-&gt;Segments[i]-&gt;SegmentClusterStart) *<br>
				    volume-&gt;SectorsPerCluster) +<br>
				    SectorOffset;<br>
<p>
	     VirtualSectorOffset =3D VirtualSegmentOffset +<br>
				   (volume-&gt;SegmentBlockAddress[i] *<br>
				   volume-&gt;SectorsPerBlock);<br>
#if VERBOSE<br>
	     if (TrgDebugTrans)<br>
	     {<br>
		NWFSPrint("clstr-%X total-%X rclstr-%X start-%X [0x%08X]\n",<br>
		       (unsigned int)ClusterOffset,<br>
		       (unsigned int)volume-&gt;VolumeClusters,<br>
		       (unsigned int)(ClusterOffset - =<br>
volume-&gt;Segments[i]-&gt;SegmentClusterStart),<br>
		       (unsigned int)volume-&gt;Segments[i]-&gt;SegmentClusterStart,<br>
		       (unsigned int)NWPart-&gt;PartitionPointer);<br>
<p>
		NWFSPrint("vso-%X + [(sba-%X * spb-8) =3D -%X] vso-%X\n",<br>
		       (unsigned int)VirtualSegmentOffset,<br>
		       (unsigned int)volume-&gt;SegmentBlockAddress[i],<br>
		       (unsigned int)(volume-&gt;SegmentBlockAddress[i] * =<br>
volume-&gt;SectorsPerBlock),<br>
		       (unsigned int)VirtualSegmentOffset);<br>
	     }<br>
#endif<br>
<p>
	     *SectorOffsetInPartition =3D VirtualSectorOffset;<br>
	     *SectorsLeftInSegment =3D (volume-&gt;SegmentClusters[i] *<br>
				      volume-&gt;SectorsPerCluster) -<br>
				      VirtualSegmentOffset;<br>
<p>
	     return NwSuccess;<br>
	  }<br>
	  ClusterTotal +=3D volume-&gt;SegmentClusters[i];<br>
       }<br>
    }<br>
    return NwInvalidParameter;<br>
}<br>
<p>
NW_STATUS TrgLookupFileAllocation(IN   ULONG VolumeNumber,<br>
				  IN   HASH *hash,<br>
				  IN   ULONG *StartingSector,<br>
				  IN   ULONG *Context,<br>
				  OUT  ULONG *SectorOffsetInVolume,<br>
				  OUT  ULONG *SectorCount)<br>
{<br>
    register ULONG StreamSize, StreamOffset, SpanningClusters;<br>
    register VOLUME *volume =3D VolumeTable[VolumeNumber];<br>
    register long cluster, index;<br>
    register ULONG StartIndex, StartOffset, rc;<br>
    register FAT_ENTRY *FAT, *LFAT;<br>
    SUBALLOC_MAP map;<br>
<p>
    // if a subdirectory then return error<br>
    if (!hash || hash-&gt;Flags &amp; SUBDIRECTORY_FILE)<br>
       return NwInvalidParameter;<br>
<p>
    // get the proper namespace stream cluster and size<br>
    switch (hash-&gt;NameSpace)<br>
    {<br>
       case DOS_NAME_SPACE:<br>
       case MAC_NAME_SPACE:<br>
	  cluster =3D hash-&gt;FirstBlock;<br>
	  StreamSize =3D hash-&gt;FileSize;<br>
	  break;<br>
<p>
       default:<br>
	  return NwInvalidParameter;<br>
    }<br>
<p>
    // calculate a size offset and range check for EOF<br>
    StreamOffset =3D ((*StartingSector) * 512);<br>
<p>
    // make certain to round the file size up to the next sector boundry<br>
    if (StreamOffset &gt; ((StreamSize + 511) &amp; ~511))<br>
       return NwEndOfFile;<br>
<p>
    StartIndex =3D StreamOffset / volume-&gt;ClusterSize;<br>
    StartOffset =3D StreamOffset % volume-&gt;ClusterSize;<br>
<p>
    // we always start with an index of zero<br>
    index =3D 0;<br>
<p>
    if (cluster &lt; 0)<br>
    {<br>
       // check for EOF<br>
       if (cluster =3D=3D (ULONG) -1)<br>
       {<br>
	  *Context =3D 0;<br>
	  return NwEndOfFile;<br>
       }<br>
<p>
       // index must be null here<br>
       if (StartIndex)<br>
       {<br>
	  *Context =3D 0;<br>
	  return NwEndOfFile;<br>
       }<br>
<p>
       rc =3D MapSuballocNode(volume, &amp;map, cluster);<br>
       if (rc)<br>
       {<br>
	  *Context =3D 0;<br>
	  return NwFileCorrupt;<br>
       }<br>
<p>
       if (StartOffset &gt;=3D map.Size)<br>
       {<br>
	  *Context =3D 0;<br>
	  return NwEndOfFile;<br>
       }<br>
<p>
       if (StartOffset &gt;=3D map.clusterSize[0])<br>
       {<br>
	  if (map.Count =3D=3D 1)<br>
	  {<br>
	     *Context =3D 0;<br>
	     return NwEndOfFile;<br>
	  }<br>
	  *StartingSector =3D (StartIndex * volume-&gt;SectorsPerCluster) +<br>
			       (map.clusterSize[0] / 512);<br>
	  *SectorCount =3D (map.clusterSize[1] / 512);<br>
	  *SectorOffsetInVolume =3D (map.clusterNumber[1] * =<br>
volume-&gt;SectorsPerCluster) +<br>
				     (map.clusterOffset[1] / 512);<br>
	  *Context =3D 0;<br>
	  return NwSuccess;<br>
       }<br>
       else<br>
       {<br>
	  *StartingSector =3D (StartIndex * volume-&gt;SectorsPerCluster);<br>
	  *SectorCount =3D (map.clusterSize[0] / 512);<br>
	  *SectorOffsetInVolume =3D (map.clusterNumber[0] * =<br>
volume-&gt;SectorsPerCluster) +<br>
				 (map.clusterOffset[0] / 512);<br>
	  *Context =3D 0;<br>
	  return NwSuccess;<br>
       }<br>
    }<br>
<p>
    FAT =3D GetFatEntry(volume, cluster);<br>
    if (FAT)<br>
       index =3D FAT-&gt;FATIndex;<br>
<p>
    while (FAT &amp;&amp; FAT-&gt;FATCluster)<br>
    {<br>
       // we detected a hole in the file<br>
       if (StartIndex &lt; index)<br>
       {<br>
	  *StartingSector =3D (StartIndex * volume-&gt;SectorsPerCluster);<br>
	  *SectorOffsetInVolume =3D 0;<br>
<p>
	  // return the full size of the hole as a single run<br>
	  *SectorCount =3D volume-&gt;SectorsPerCluster +<br>
			((index - StartIndex) * volume-&gt;SectorsPerCluster);<br>
	  *Context =3D cluster;  // point to this cluster<br>
	  return NwSuccess;<br>
       }<br>
<p>
       // we found our cluster in the chain<br>
       if (StartIndex =3D=3D index)<br>
       {<br>
	  *StartingSector =3D (StartIndex * volume-&gt;SectorsPerCluster);<br>
	  *SectorOffsetInVolume =3D (cluster * volume-&gt;SectorsPerCluster);<br>
<p>
	  // see how far this span runs continguous by checking both<br>
	  // the index and the cluster number of this fat entry.<br>
<p>
	  NWFSPrint("clstr-%X index-%d nclstr-%X nindex-%d\n",<br>
		    (unsigned int) cluster,<br>
		    (int) index,<br>
		    (unsigned int) FAT-&gt;FATCluster,<br>
		    (int) FAT-&gt;FATIndex);<br>
<p>
	  for (SpanningClusters =3D 0;<br>
	       FAT &amp;&amp; FAT-&gt;FATCluster &amp;&amp;<br>
	       (FAT-&gt;FATCluster =3D=3D (cluster + 1)) &amp;&amp;<br>
	       (FAT-&gt;FATCluster &gt; 0) &amp;&amp; cluster &gt; 0; )<br>
	  {<br>
	     // check if next index number is also in sequence<br>
	     LFAT =3D GetFatEntry(volume, FAT-&gt;FATCluster);<br>
	     if (LFAT)<br>
	     {<br>
		if (LFAT-&gt;FATIndex !=3D (index + 1))<br>
		   break;<br>
	     }<br>
<p>
	     SpanningClusters++;<br>
	     cluster =3D FAT-&gt;FATCluster;<br>
<p>
	     if (cluster &lt; 0)<br>
		break;<br>
<p>
	     // get next fat table entry and index<br>
	     FAT =3D GetFatEntry(volume, cluster);<br>
	     if (FAT)<br>
		index =3D FAT-&gt;FATIndex;<br>
	  }<br>
<p>
	  //  return size of run plus any contiguous clusters we detected<br>
	  *SectorCount =3D volume-&gt;SectorsPerCluster +<br>
			 (SpanningClusters * volume-&gt;SectorsPerCluster);<br>
<p>
	  *Context =3D FAT-&gt;FATCluster;  // point to next cluster<br>
	  return NwSuccess;<br>
       }<br>
<p>
       // bump to the next cluster<br>
       cluster =3D FAT-&gt;FATCluster;<br>
<p>
       // check if the next cluster is a suballoc element or EOF marker<br>
       if (cluster &lt; 0)<br>
       {<br>
	  // end of file<br>
	  if (cluster =3D=3D (ULONG) -1)<br>
	  {<br>
	     *Context =3D 0;<br>
	     return NwEndOfFile;<br>
	  }<br>
<p>
	  // check for valid index<br>
	  if ((index + 1) =3D=3D StartIndex)<br>
	  {<br>
	     rc =3D MapSuballocNode(volume, &amp;map, cluster);<br>
	     if (rc)<br>
	     {<br>
		*Context =3D 0;<br>
		return NwFileCorrupt;<br>
	     }<br>
<p>
	     if (StartOffset &gt;=3D map.Size)<br>
	     {<br>
		*Context =3D 0;<br>
		return NwEndOfFile;<br>
	     }<br>
<p>
	     if (StartOffset &gt;=3D map.clusterSize[0])<br>
	     {<br>
		if (map.Count =3D=3D 1)<br>
		{<br>
		   *Context =3D 0;<br>
		   return NwEndOfFile;<br>
		}<br>
<p>
		*StartingSector =3D (StartIndex * volume-&gt;SectorsPerCluster) +<br>
				  (map.clusterSize[0] / 512);<br>
		*SectorCount =3D (map.clusterSize[1] / 512);<br>
		*SectorOffsetInVolume =3D (map.clusterNumber[1] * =<br>
volume-&gt;SectorsPerCluster) +<br>
				     (map.clusterOffset[1] / 512);<br>
		*Context =3D 0;<br>
		return NwSuccess;<br>
	     }<br>
	     else<br>
	     {<br>
		*StartingSector =3D (StartIndex * volume-&gt;SectorsPerCluster);<br>
		*SectorCount =3D (map.clusterSize[0] / 512);<br>
		*SectorOffsetInVolume =3D (map.clusterNumber[0] * =<br>
volume-&gt;SectorsPerCluster) +<br>
				     (map.clusterOffset[0] / 512);<br>
		*Context =3D 0;<br>
		return NwSuccess;<br>
	     }<br>
	  }<br>
	  return NwEndOfFile;<br>
       }<br>
<p>
       // get next fat table entry and index<br>
       FAT =3D GetFatEntry(volume, cluster);<br>
       if (FAT)<br>
	  index =3D FAT-&gt;FATIndex;<br>
    }<br>
    return NwEndOfFile;<br>
<p>
}<br>
<p>
<p>
<p>
------=_NextPart_000_0047_01BEAB79.25032C30--<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0487.html">Bryn Paul Arnold Jones: "Re: 2nd cpu"</a>
<li> <b>Previous message:</b> <a href="0485.html">Andi Kleen: "Re: Migrating to larger numbers"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
