<!-- received="Tue Jun  1 06:59:59 1999 EET DST" -->
<!-- sent="Mon, 31 May 1999 23:08:09 -0400 (EDT)" -->
<!-- name="Theodore Y. Ts'o" -->
<!-- email="tytso@mit.edu" -->
<!-- subject="Re: serial callout devices" -->
<!-- id="199906010308.XAA19627@dcl.MIT.EDU" -->
<!-- inreplyto="serial callout devices" -->
<title>Linux-kernel mailing list archive 1999-22,: Re: serial callout devices</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: serial callout devices</h1>
<b>Theodore Y. Ts'o</b> (<a href="mailto:tytso@mit.edu"><i>tytso@mit.edu</i></a>)<br>
<i>Mon, 31 May 1999 23:08:09 -0400 (EDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#526">[ date ]</a><a href="index.html#526">[ thread ]</a><a href="subject.html#526">[ subject ]</a><a href="author.html#526">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0527.html">Alan Cox: "Re: I2O status and Linux?"</a>
<li> <b>Previous message:</b> <a href="0525.html">Rodel T. Viado: "Re: 2.2.9 oops"</a>
<li> <b>Maybe in reply to:</b> <a href="0002.html">Florian Lohoff: "serial callout devices"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0545.html">Albert D. Cahalan: "Re: serial callout devices"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
   From: Keith Owens &lt;<a href="mailto:kaos@ocs.com.au">kaos@ocs.com.au</a>&gt;<br>
   Date: 	Tue, 01 Jun 1999 07:49:38 +1000<br>
<p>
   On 31 May 1999 10:49:45 +0200, <br>
   <a href="mailto:miquels@cistron.nl">miquels@cistron.nl</a> (Miquel van Smoorenburg) wrote:<br>
<i>   &gt;stty -F /dev/ttyS1 clocal</i><br>
<p>
   The -F flag is not supported by stty.  At least not in<br>
   sh-utils-1.16-23.i386.rpm, the latest Redhat version.  Users have to<br>
   build their own version to get the -F flag.<br>
<p>
That's because I submitted the patches to the FSF Shellutils maintainer<br>
over a year ago, and by the maintainer's own admission, he's been<br>
lame.....<br>
<p>
Here are the patches, for anyone who's interested.<br>
<p>
						- Ted<br>
<p>
Patch generated: on Wed Apr  1 13:34:53 EST 1998 by <a href="mailto:tytso@rsts-11.mit.edu">tytso@rsts-11.mit.edu</a><br>
against shellutils version 1.16<br>
 <br>
===================================================================<br>
RCS file: ChangeLog,v<br>
retrieving revision 1.1<br>
diff -u -r1.1 ChangeLog<br>
--- ChangeLog	1998/04/01 14:39:04	1.1<br>
+++ ChangeLog	1998/04/01 18:14:44<br>
@@ -1,3 +1,17 @@<br>
+1998-03-31  Theodore Ts'o  &lt;<a href="mailto:tytso@rsts-11.mit.edu">tytso@rsts-11.mit.edu</a>&gt;<br>
+<br>
+	* src/stty.c (main): Fix broken options parsing that worked only<br>
+	by serendipity (getopt_long_only already parsed short options; no<br>
+	need to parse them again manually!).  Add support for the --file<br>
+	option, which allows the user to specify the device whose line<br>
+	settings are to be set.  This is necessary because POSIX ttys will<br>
+	block waiting for carrier detect to go high if CLOCAL is not set,<br>
+	unless the device is opened with the O_NONBLOCK flag.<br>
+	Unfortunately, the shell doesn't use this flag, so users lose.<br>
+	Opening the device in stty is the easist way to fix this.  <br>
+	(speeds): Add support for 230400 and 460800 line speeds, which are<br>
+	supported by Linux.<br>
+<br>
 Sun Jan 26 12:51:05 1997  Jim Meyering  &lt;<a href="mailto:meyering@na-net.ornl.gov">meyering@na-net.ornl.gov</a>&gt;<br>
 <br>
 	* Version 1.16.<br>
===================================================================<br>
RCS file: src/RCS/stty.c,v<br>
retrieving revision 1.1<br>
diff -u -r1.1 src/stty.c<br>
--- src/stty.c	1998/04/01 07:01:02	1.1<br>
+++ src/stty.c	1998/04/01 18:34:51<br>
@@ -15,15 +15,16 @@<br>
    along with this program; if not, write to the Free Software Foundation,<br>
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */<br>
 <br>
-/* Usage: stty [-ag] [--all] [--save] [setting...]<br>
+/* Usage: stty [-ag] [--all] [--save] [-F device] [--file=device] [setting...]<br>
 <br>
    Options:<br>
    -a, --all    Write all current settings to stdout in human-readable form.<br>
    -g, --save   Write all current settings to stdout in stty-readable form.<br>
+   -F, --file   Open and use the specified device instead of stdin<br>
 <br>
    If no args are given, write to stdout the baud rate and settings that<br>
    have been changed from their defaults.  Mode reading and changes<br>
-   are done on stdin.<br>
+   are done on the specified device, or stdin if none was specified.<br>
 <br>
    David MacKenzie &lt;djm@gnu.ai.mit.edu&gt; */<br>
 <br>
@@ -401,19 +402,23 @@<br>
 static speed_t string_to_baud __P ((const char *arg));<br>
 static tcflag_t *mode_type_flag __P ((enum mode_type type,<br>
 				      struct termios *mode));<br>
-static void display_all __P ((struct termios *mode));<br>
+static void display_all __P ((struct termios *mode, int fd,<br>
+			      const char *device));<br>
 static void display_changed __P ((struct termios *mode));<br>
 static void display_recoverable __P ((struct termios *mode));<br>
 static void display_settings __P ((enum output_type output_type,<br>
-				   struct termios *mode));<br>
+				   struct termios *mode, int fd,<br>
+				   const char *device));<br>
 static void display_speed __P ((struct termios *mode, int fancy));<br>
-static void display_window_size __P ((int fancy));<br>
+static void display_window_size __P ((int fancy, int fd,<br>
+				      const char *device));<br>
 static void sane_mode __P ((struct termios *mode));<br>
 static void set_control_char __P ((struct control_info *info, const char *arg,<br>
 				   struct termios *mode));<br>
 static void set_speed __P ((enum speed_setting type, const char *arg,<br>
 			    struct termios *mode));<br>
-static void set_window_size __P ((int rows, int cols));<br>
+static void set_window_size __P ((int rows, int cols, int fd,<br>
+				  const char *device));<br>
 <br>
 /* The width of the screen, for output wrapping. */<br>
 static int max_col;<br>
@@ -425,6 +430,7 @@<br>
 {<br>
   {"all", no_argument, NULL, 'a'},<br>
   {"save", no_argument, NULL, 'g'},<br>
+  {"file", required_argument, NULL, 'F'},<br>
   {NULL, 0, NULL, 0}<br>
 };<br>
 <br>
@@ -476,15 +482,17 @@<br>
   else<br>
     {<br>
       printf (_("\<br>
-Usage: %s [SETTING]...\n\<br>
-  or:  %s OPTION\n\<br>
+Usage: %s [-F device] [--file=device] [SETTING]...\n\<br>
+  or:  %s [-F device] [--file=device] [-a|--all]\n\<br>
+  or:  %s [-F device] [--file=device] [-g|--save]\n\<br>
 "),<br>
-	      program_name, program_name);<br>
+	      program_name, program_name, program_name);<br>
       printf (_("\<br>
 Print or change terminal characteristics.\n\<br>
 \n\<br>
   -a, --all       print all current settings in human-readable form\n\<br>
   -g, --save      print all current settings in a stty-readable form\n\<br>
+  -F, --file      open and use the specified device instead of stdin\n\<br>
       --help      display this help and exit\n\<br>
       --version   output version information and exit\n\<br>
 \n\<br>
@@ -648,6 +656,29 @@<br>
   exit (status);<br>
 }<br>
 <br>
+/*<br>
+ * Return 1 if the string only contains valid options<br>
+ */<br>
+int valid_options(char *opt, const char *valid_opts,<br>
+		  const char *valid_arg_opts)<br>
+{<br>
+	char ch;<br>
+	<br>
+	if (*opt++ != '-')<br>
+		return 0;<br>
+<br>
+	while (ch = *opt) {<br>
+		opt++;<br>
+		if (strchr(valid_opts, ch))<br>
+			continue;<br>
+		if (strchr(valid_arg_opts, ch))<br>
+			return 1;<br>
+		return 0;<br>
+	}<br>
+	return 1;<br>
+}<br>
+<br>
+<br>
 int<br>
 main (int argc, char **argv)<br>
 {<br>
@@ -659,6 +690,11 @@<br>
   int verbose_output;<br>
   int recoverable_output;<br>
   int k;<br>
+  int noargs = 1;<br>
+  char *file_name = NULL, *cp;<br>
+  int fd, fdflags;<br>
+  const char *device_name;<br>
+  const char *posixly_correct = getenv("POSIXLY_CORRECT");<br>
 <br>
   program_name = argv[0];<br>
   setlocale (LC_ALL, "");<br>
@@ -673,7 +709,7 @@<br>
 <br>
   /* Recognize the long options only.  */<br>
   opterr = 0;<br>
-  while ((optc = getopt_long_only (argc, argv, "ag", longopts, (int *) 0))<br>
+  while ((optc = getopt_long_only (argc, argv, "agF:", longopts, (int *) 0))<br>
 	 != EOF)<br>
     {<br>
       switch (optc)<br>
@@ -688,44 +724,80 @@<br>
 	  output_type = recoverable;<br>
 	  break;<br>
 <br>
+	case 'f':<br>
+	  if (file_name)<br>
+	    error(2, 0, _("Only one device can be specified.\n"));<br>
+	  file_name = optarg;<br>
+	  break;<br>
+<br>
 	default:<br>
 	  break;<br>
 	}<br>
     }<br>
 <br>
-  /* Recognize short options and combinations: -a, -g, -ag, and -ga.<br>
-     They need not precede non-options.  We cannot use GNU getopt because<br>
-     it would treat -tabs and -ixany as uses of the -a option.  */<br>
-  for (k = optind; k &lt; argc; k++)<br>
+  /*<br>
+   * Clear out the options that have been parsed.  This is kind of<br>
+   * gross, but it's needed because stty SETTINGS look like options to<br>
+   * getopt(), so we need to work around things in a really horrible<br>
+   * way.  If any new options are ever added to stty, the short option<br>
+   * MUST NOT be a letter which is the first letter of one of the<br>
+   * possible stty settings.  (NOTE: I didn't add this brokeness, I<br>
+   * just fixed the existing code so that it worked correctly in all<br>
+   * cases of --, POSIXLY_CORRECT, etc.  [tytso:19980401.1316EST])<br>
+   */<br>
+  for (k = 1; k &lt; argc; k++) <br>
     {<br>
-      if (argv[k][0] == '-')<br>
+      if (!argv[k])<br>
+	continue;<br>
+      /* Handle --, and set noargs if there are arguments following it */<br>
+      if (!strcmp(argv[k], "--"))<br>
 	{<br>
-	  if (argv[k][1] == 'a'<br>
-	      &amp;&amp; argv[k][2] == '\0')<br>
-	    {<br>
-	      ++optind;<br>
-	      verbose_output = 1;<br>
-	    }<br>
-	  else if (argv[k][1] == 'g'<br>
-		   &amp;&amp; argv[k][2] == '\0')<br>
-	    {<br>
-	      ++optind;<br>
-	      recoverable_output = 1;<br>
-	    }<br>
-	  else if ((argv[k][1] == 'g'<br>
-		    &amp;&amp; argv[k][2] == 'a'<br>
-		    &amp;&amp; argv[k][3] == '\0')<br>
-		   || (argv[k][1] == 'a'<br>
-		       &amp;&amp; argv[k][2] == 'g'<br>
-		       &amp;&amp; argv[k][3] == '\0'))<br>
-	    {<br>
-	      ++optind;<br>
-	      verbose_output = 1;<br>
-	      recoverable_output = 1;<br>
-	    }<br>
-	}<br>
+	  argv[k] = 0;<br>
+	  if (k &lt; argc-1)<br>
+	    noargs = 0;<br>
+	  break;<br>
+    	}<br>
+      /* Handle "--file device" */<br>
+      if (!strcmp(argv[k], "--file"))<br>
+	{<br>
+	  argv[k+1] = 0;<br>
+	  argv[k] = 0;<br>
+    	}<br>
+      /* Handle "--all", "--save", and "--file=device" */<br>
+      else if (!strcmp(argv[k], "--all") ||<br>
+	       !strcmp(argv[k], "--save") ||<br>
+	       !strncmp(argv[k], "--file=", 7))<br>
+	argv[k] = 0;<br>
+      /* Handle "-a", "-ag", "-aF/dev/foo", "-aF /dev/foo", etc. */<br>
+      else if (valid_options(argv[k], "ag", "F"))<br>
+	{<br>
+	  if (!strcmp(argv[k], "-file") ||<br>
+	      argv[k][strlen(argv[k])-1] == 'F')<br>
+	    argv[k+1] = 0;<br>
+	  argv[k] = 0;<br>
+        }<br>
+      /* Everything else must be a normal, non-option argument. */<br>
+      else<br>
+	{<br>
+	noargs = 0;<br>
+	if (posixly_correct)<br>
+	  break;<br>
+        }<br>
     }<br>
 <br>
+#if 0<br>
+  /* For debugging purposes, print out the argument */<br>
+  for (k=1; k &lt; argc; k++) {<br>
+	if (argv[k])<br>
+		printf("arg: %s\n", argv[k]);<br>
+	else<br>
+		printf("arg: none\n");<br>
+  }<br>
+  printf("File_name = %s\n", file_name ? file_name : "NONE");<br>
+  printf("noargs = %d\n", noargs);<br>
+#endif<br>
+<br>
+<br>
   /* Specifying both -a and -g gets an error.  */<br>
   if (verbose_output &amp;&amp; recoverable_output)<br>
     error (2, 0,<br>
@@ -733,20 +805,35 @@<br>
 mutually exclusive"));<br>
 <br>
   /* Specifying any other arguments with -a or -g gets an error.  */<br>
-  if (argc - optind &gt; 0 &amp;&amp; (verbose_output || recoverable_output))<br>
+  if (!noargs &amp;&amp; (verbose_output || recoverable_output))<br>
     error (2, 0, _("when specifying an output style, modes may not be set"));<br>
 <br>
+  if (file_name)<br>
+    {<br>
+      device_name = file_name;<br>
+      fd = open(device_name, O_RDONLY|O_NONBLOCK);<br>
+      if (fd &lt; 0)<br>
+	error(1, errno, device_name);<br>
+      if ((fdflags = fcntl(fd, F_GETFL)) == -1<br>
+	  || fcntl(fd, F_SETFL, fdflags &amp; ~O_NONBLOCK) &lt; 0)<br>
+	error(1, errno, _("couldn't reset non-blocking mode"));<br>
+    } else<br>
+    {<br>
+      fd = 0;<br>
+      device_name = _("standard input");<br>
+    }<br>
+  <br>
   /* Initialize to all zeroes so there is no risk memcmp will report a<br>
      spurious difference in an uninitialized portion of the structure.  */<br>
   memset (&amp;mode, 0, sizeof (mode));<br>
-  if (tcgetattr (0, &amp;mode))<br>
-    error (1, errno, _("standard input"));<br>
+  if (tcgetattr (fd, &amp;mode))<br>
+    error (1, errno, device_name);<br>
 <br>
-  if (verbose_output || recoverable_output || argc == 1)<br>
+  if (verbose_output || recoverable_output || noargs)<br>
     {<br>
       max_col = screen_columns ();<br>
       current_col = 0;<br>
-      display_settings (output_type, &amp;mode);<br>
+      display_settings (output_type, &amp;mode, fd, device_name);<br>
       exit (0);<br>
     }<br>
 <br>
@@ -759,6 +846,11 @@<br>
       int reversed = 0;<br>
       int i;<br>
 <br>
+      if (argv[k] == 0) {<br>
+	 k++;<br>
+         continue;<br>
+      }<br>
+<br>
       if (argv[k][0] == '-')<br>
 	{<br>
 	  ++argv[k];<br>
@@ -832,7 +924,8 @@<br>
 		  usage (1);<br>
 		}<br>
 	      ++k;<br>
-	      set_window_size ((int) integer_arg (argv[k]), -1);<br>
+	      set_window_size ((int) integer_arg (argv[k]), -1,<br>
+			       fd, device_name);<br>
 	    }<br>
 	  else if (!strcmp (argv[k], "cols")<br>
<i> 		   || !strcmp (argv[k], "columns"))</i><br>
@@ -843,13 +936,14 @@<br>
 		  usage (1);<br>
 		}<br>
 	      ++k;<br>
-	      set_window_size (-1, (int) integer_arg (argv[k]));<br>
+	      set_window_size (-1, (int) integer_arg (argv[k]),<br>
+			       fd, device_name);<br>
 	    }<br>
 	  else if (!strcmp (argv[k], "size"))<br>
 	    {<br>
 	      max_col = screen_columns ();<br>
 	      current_col = 0;<br>
-	      display_window_size (0);<br>
+	      display_window_size (0, fd, device_name);<br>
 	    }<br>
 #endif<br>
 #ifdef HAVE_C_LINE<br>
@@ -893,8 +987,8 @@<br>
     {<br>
       struct termios new_mode;<br>
 <br>
-      if (tcsetattr (0, TCSADRAIN, &amp;mode))<br>
-	error (1, errno, _("standard input"));<br>
+      if (tcsetattr (fd, TCSADRAIN, &amp;mode))<br>
+	error (1, errno, device_name);<br>
 <br>
       /* POSIX (according to Zlotnick's book) tcsetattr returns zero if<br>
 	 it performs *any* of the requested operations.  This means it<br>
@@ -906,8 +1000,8 @@<br>
       /* Initialize to all zeroes so there is no risk memcmp will report a<br>
 	 spurious difference in an uninitialized portion of the structure.  */<br>
       memset (&amp;new_mode, 0, sizeof (new_mode));<br>
-      if (tcgetattr (0, &amp;new_mode))<br>
-	error (1, errno, _("standard input"));<br>
+      if (tcgetattr (fd, &amp;new_mode))<br>
+	error (1, errno, device_name);<br>
 <br>
       /* Normally, one shouldn't use memcmp to compare structures that<br>
 	 may have `holes' containing uninitialized data, but we have been<br>
@@ -934,7 +1028,8 @@<br>
 	    {<br>
 	      size_t i;<br>
 	      error (1, 0,<br>
-	      _("standard input: unable to perform all requested operations"));<br>
+		     _("%s: unable to perform all requested operations"),<br>
+		     device_name);<br>
 	      printf (_("new_mode: mode\n"));<br>
 	      for (i = 0; i &lt; sizeof (new_mode); i++)<br>
 		printf ("0x%02x: 0x%02x\n",<br>
@@ -1201,14 +1296,14 @@<br>
 }<br>
 <br>
 static void<br>
-set_window_size (int rows, int cols)<br>
+set_window_size (int rows, int cols, int fd, const char *device)<br>
 {<br>
   struct winsize win;<br>
 <br>
-  if (get_win_size (STDIN_FILENO, &amp;win))<br>
+  if (get_win_size (fd, &amp;win))<br>
     {<br>
       if (errno != EINVAL)<br>
-	error (1, errno, _("standard input"));<br>
+	error (1, errno, device);<br>
       memset (&amp;win, 0, sizeof (win));<br>
     }<br>
 <br>
@@ -1249,28 +1344,28 @@<br>
       win.ws_row = 1;<br>
       win.ws_col = 1;<br>
 <br>
-      if (ioctl (STDIN_FILENO, TIOCSWINSZ, (char *) &amp;win))<br>
-	error (1, errno, _("standard input"));<br>
+      if (ioctl (fd, TIOCSWINSZ, (char *) &amp;win))<br>
+	error (1, errno, device);<br>
 <br>
-      if (ioctl (STDIN_FILENO, TIOCSSIZE, (char *) &amp;ttysz))<br>
-	error (1, errno, _("standard input"));<br>
+      if (ioctl (fd, TIOCSSIZE, (char *) &amp;ttysz))<br>
+	error (1, errno, device);<br>
       return;<br>
     }<br>
 # endif<br>
 <br>
-  if (ioctl (STDIN_FILENO, TIOCSWINSZ, (char *) &amp;win))<br>
-    error (1, errno, _("standard input"));<br>
+  if (ioctl (fd, TIOCSWINSZ, (char *) &amp;win))<br>
+    error (1, errno, device);<br>
 }<br>
 <br>
 static void<br>
-display_window_size (int fancy)<br>
+display_window_size (int fancy, int fd, const char *device)<br>
 {<br>
   struct winsize win;<br>
 <br>
-  if (get_win_size (STDIN_FILENO, &amp;win))<br>
+  if (get_win_size (fd, &amp;win))<br>
     {<br>
       if (errno != EINVAL)<br>
-	error (1, errno, _("standard input"));<br>
+	error (1, errno, device);<br>
       if (!fancy)<br>
 	error (1, 0, _("no size information for this device"));<br>
     }<br>
@@ -1331,7 +1426,8 @@<br>
 }<br>
 <br>
 static void<br>
-display_settings (enum output_type output_type, struct termios *mode)<br>
+display_settings (enum output_type output_type, struct termios *mode,<br>
+		  int fd, const char *device)<br>
 {<br>
   switch (output_type)<br>
     {<br>
@@ -1340,7 +1436,7 @@<br>
       break;<br>
 <br>
     case all:<br>
-      display_all (mode);<br>
+      display_all (mode, fd, device);<br>
       break;<br>
 <br>
     case recoverable:<br>
@@ -1434,7 +1530,7 @@<br>
 }<br>
 <br>
 static void<br>
-display_all (struct termios *mode)<br>
+display_all (struct termios *mode, int fd, const char *device)<br>
 {<br>
   int i;<br>
   tcflag_t *bitsp;<br>
@@ -1443,7 +1539,7 @@<br>
 <br>
   display_speed (mode, 1);<br>
 #ifdef TIOCGWINSZ<br>
-  display_window_size (1);<br>
+  display_window_size (1, fd, device);<br>
 #endif<br>
 #ifdef HAVE_C_LINE<br>
   wrapf ("line = %d;", mode-&gt;c_line);<br>
@@ -1590,6 +1686,12 @@<br>
 #endif<br>
 #ifdef B115200<br>
   {"115200", B115200, 115200},<br>
+#endif<br>
+#ifdef B230400<br>
+  {"230400", B230400, 230400},<br>
+#endif<br>
+#ifdef B460800<br>
+  {"460800", B460800, 460800},<br>
 #endif<br>
   {NULL, 0, 0}<br>
 };<br>
===================================================================<br>
RCS file: man/RCS/stty.1,v<br>
retrieving revision 1.1<br>
diff -u -r1.1 man/stty.1<br>
--- man/stty.1	1998/04/01 09:26:14	1.1<br>
+++ man/stty.1	1998/04/01 18:14:16<br>
@@ -2,10 +2,12 @@<br>
 .SH NAME<br>
 stty \- change and print terminal line settings<br>
 .SH SYNOPSIS<br>
-.B stty<br>
+.B stty <br>
+[-F device] [--file=device]<br>
 [setting...]<br>
 .br<br>
 .B stty<br>
+[-F device] [--file=device]<br>
 {\-a,\-\-all,\-g,\-\-help,\-\-save,\-\-version}<br>
 .SH DESCRIPTION<br>
 This documentation is no longer being maintained and may be inaccurate<br>
@@ -271,14 +273,17 @@<br>
 .I "\-a, \-\-all"<br>
 Print all current settings in human-readable form.<br>
 .TP<br>
-.I "\-\-help"<br>
-Print a usage message on standard output and exit successfully.<br>
+.I "\-F, \-\-file device"<br>
+Open and use the specified device instead of stdin.<br>
 .TP<br>
 .I "\-g, \-\-save"<br>
 Print all current settings in a form that can be used as an argument<br>
 to another<br>
 .B stty<br>
 command to restore the current settings.<br>
+.I "\-\-help"<br>
+Print a usage message on standard output and exit successfully.<br>
+.TP<br>
 .TP<br>
 .I "\-\-version"<br>
 Print version information on standard output then exit successfully.<br>
===================================================================<br>
RCS file: doc/sh-utils.texi,v<br>
retrieving revision 1.1<br>
diff -u -r1.1 doc/sh-utils.texi<br>
--- doc/sh-utils.texi	1998/04/01 14:29:18	1.1<br>
+++ doc/sh-utils.texi	1998/04/01 18:14:36<br>
@@ -1109,15 +1109,16 @@<br>
 Synopses:<br>
 <br>
 @example<br>
-stty [@var{setting}]@dots{}<br>
+stty [@var{option}] [@var{setting}]@dots{}<br>
 stty [@var{option}]<br>
 @end example<br>
 <br>
-If given no arguments, @code{stty} prints the baud rate, line<br>
+If given no line settings, @code{stty} prints the baud rate, line<br>
 discipline number (on systems that support it), and line settings<br>
 that have been changed from the values set by @samp{stty sane}.<br>
-Mode reading and setting are performed on the tty line connected to<br>
-standard input.<br>
+By default, mode reading and setting are performed on the tty line <br>
+connected to standard input, although this can be modified by the <br>
+@samp{--file} option.<br>
 <br>
 @code{stty} accepts many non-option arguments that change aspects of<br>
 the terminal line operation, as described below.<br>
@@ -1129,7 +1130,19 @@<br>
 @itemx --all<br>
 @opindex -a<br>
 @opindex --all<br>
-Print all current settings in human-readable form.<br>
+Print all current settings in human-readable form.  This option may not<br>
+be used in combination with any line settings.<br>
+<br>
+@item -F @var{device}<br>
+@itemx --file @var{device}<br>
+@opindex -F<br>
+@opindex --file<br>
+Set the line opened by the filename specified in @var{device} instead of <br>
+the tty line connected to standard input.  This option is necessary <br>
+because opening a POSIX tty requires the @code{O_NONDELAY} flag to prevent<br>
+a POSIX tty from blocking until the carrier detect line is high if <br>
+the @code{clocal} flag is not set.  Hence, it is not possible to allow<br>
+the shell to open the device in the traditional manner.<br>
 <br>
 @item -g<br>
 @itemx --save<br>
@@ -1137,7 +1150,8 @@<br>
 @opindex --save<br>
 @cindex machine-readable @code{stty} output<br>
 Print all current settings in a form that can be used as an argument to<br>
-another @code{stty} command to restore the current settings.<br>
+another @code{stty} command to restore the current settings.  This option<br>
+may not be used in combination with any line settings.<br>
 <br>
 @end table<br>
 <br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0527.html">Alan Cox: "Re: I2O status and Linux?"</a>
<li> <b>Previous message:</b> <a href="0525.html">Rodel T. Viado: "Re: 2.2.9 oops"</a>
<li> <b>Maybe in reply to:</b> <a href="0002.html">Florian Lohoff: "serial callout devices"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0545.html">Albert D. Cahalan: "Re: serial callout devices"</a>
<!-- reply="end" -->
</ul>
</font></body>
