<!-- received="Tue Jun  1 19:34:48 1999 EET DST" -->
<!-- sent="Tue, 1 Jun 1999 18:04:48 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="Re: Allocation of too much memory hangs system, kernel 2.2.*" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.4.10.9906010942170.3302-100000@cola.svenskatest.se" -->
<title>Linux-kernel mailing list archive 1999-22,: Re: Allocation of too much memory hangs system, kernel 2.2.*</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Allocation of too much memory hangs system, kernel 2.2.*</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Tue, 1 Jun 1999 18:04:48 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#619">[ date ]</a><a href="index.html#619">[ thread ]</a><a href="subject.html#619">[ subject ]</a><a href="author.html#619">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0620.html">p3: "Slow network connection with 2.2.7 and 3c59x"</a>
<li> <b>Previous message:</b> <a href="0618.html">Malcolm Beattie: "Re: Q: Buffered vs Cached vs mmap()ed"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Tue, 1 Jun 1999, Urban Widmark wrote:<br>
<p>
<i>&gt;I don't remember if I reported it or not, since I thought the "OOM"</i><br>
<i>&gt;problem was well known and left for future Linux versions.</i><br>
<p>
I thought it was just fine with 2.2.x.<br>
<p>
Could you check if the lockup goes away with this patch below against<br>
clean 2.2.9? (... really I never tried it on a clean 2.2.9 but should work<br>
really fine there too :) The problem seems to be only a too high<br>
runtime-complexity of the page-freeing code. This patch will reduce the<br>
swapout complexity of a good bit.<br>
<p>
Index: linux//arch/i386/mm/fault.c<br>
===================================================================<br>
RCS file: /var/cvs/linux/arch/i386/mm/fault.c,v<br>
retrieving revision 1.1.1.1<br>
diff -u -r1.1.1.1 fault.c<br>
--- linux//arch/i386/mm/fault.c	1999/01/18 01:28:56	1.1.1.1<br>
+++ linux//arch/i386/mm/fault.c	1999/06/01 15:29:48<br>
@@ -265,7 +265,7 @@<br>
 	tsk-&gt;tss.cr2 = address;<br>
 	tsk-&gt;tss.error_code = error_code;<br>
 	tsk-&gt;tss.trap_no = 14;<br>
-	force_sig(SIGBUS, tsk);<br>
+	oom(tsk);<br>
 <br>
 	/* Kernel mode? Handle exceptions or die */<br>
 	if (!(error_code &amp; 4))<br>
Index: linux//mm/vmscan.c<br>
===================================================================<br>
RCS file: /var/cvs/linux/mm/vmscan.c,v<br>
retrieving revision 1.1.1.6<br>
diff -u -r1.1.1.6 vmscan.c<br>
--- linux//mm/vmscan.c	1999/04/28 20:46:48	1.1.1.6<br>
+++ linux//mm/vmscan.c	1999/06/01 15:31:12<br>
@@ -308,7 +308,8 @@<br>
 static int swap_out(unsigned int priority, int gfp_mask)<br>
 {<br>
 	struct task_struct * p, * pbest;<br>
-	int counter, assign, max_cnt;<br>
+	int assign = 0, counter;<br>
+	unsigned long max_cnt;<br>
 <br>
 	/* <br>
 	 * We make one or two passes through the task list, indexed by <br>
@@ -327,11 +328,8 @@<br>
 	counter = nr_tasks / (priority+1);<br>
 	if (counter &lt; 1)<br>
 		counter = 1;<br>
-	if (counter &gt; nr_tasks)<br>
-		counter = nr_tasks;<br>
 <br>
 	for (; counter &gt;= 0; counter--) {<br>
-		assign = 0;<br>
 		max_cnt = 0;<br>
 		pbest = NULL;<br>
 	select:<br>
@@ -343,7 +341,7 @@<br>
 	 		if (p-&gt;mm-&gt;rss &lt;= 0)<br>
 				continue;<br>
 			/* Refresh swap_cnt? */<br>
-			if (assign)<br>
+			if (assign == 1)<br>
 				p-&gt;mm-&gt;swap_cnt = p-&gt;mm-&gt;rss;<br>
 			if (p-&gt;mm-&gt;swap_cnt &gt; max_cnt) {<br>
 				max_cnt = p-&gt;mm-&gt;swap_cnt;<br>
@@ -361,6 +359,8 @@<br>
 <br>
 		if (swap_out_process(pbest, gfp_mask))<br>
 			return 1;<br>
+		if (assign == 1)<br>
+			assign = 2;<br>
 	}<br>
 out:<br>
 	return 0;<br>
<p>
<p>
<p>
If there's nothing to swapout in the VM there's no need to continue trying<br>
nr_tasks times on the whole VM. The first part of the patch is nicer<br>
(printk oom task) and will make sure that nobody will trap the sigbus (if<br>
an attacker will register a sigbus handler and then will go oom...).<br>
<p>
If the patch above is not enough, I would like to know if you can<br>
reproduce in:<br>
<p>
	<a href="ftp://e-mind.com/pub/andrea/kernel/pre-2.3.4-2_andrea2.bz2">ftp://e-mind.com/pub/andrea/kernel/pre-2.3.4-2_andrea2.bz2</a><br>
<p>
(against pre-2.3.4-2 of course :), since here the shrink_mmap<br>
runtime-complexity is reduced near zero using my pagemap-lru.<br>
<p>
BTW, pre-2.3.4-2_andrea2 also seems to fix completly the `cp /dev/zero<br>
/tmp` I/O overload this time without harming too much write performances<br>
and I am quite happy with it now.<br>
<p>
Andrea Arcangeli<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0620.html">p3: "Slow network connection with 2.2.7 and 3c59x"</a>
<li> <b>Previous message:</b> <a href="0618.html">Malcolm Beattie: "Re: Q: Buffered vs Cached vs mmap()ed"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
