<!-- received="Wed Jun  2 10:19:13 1999 EET DST" -->
<!-- sent="Wed, 02 Jun 1999 09:13:06 +0200" -->
<!-- name="Giacomo Amabile Catenazzi" -->
<!-- email="cate@student.ethz.ch" -->
<!-- subject="[PATCH] {asm-i386,linux}/string.h:Adjustments for **NOT** using gcc" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-22,: [PATCH] {asm-i386,linux}/string.h:Adjustments for **NOT** using gcc</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] {asm-i386,linux}/string.h:Adjustments for **NOT** using gcc</h1>
<b>Giacomo Amabile Catenazzi</b> (<a href="mailto:cate@student.ethz.ch"><i>cate@student.ethz.ch</i></a>)<br>
<i>Wed, 02 Jun 1999 09:13:06 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#735">[ date ]</a><a href="index.html#735">[ thread ]</a><a href="subject.html#735">[ subject ]</a><a href="author.html#735">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0736.html">Rolf Offermanns: "Kernel patch for terratec radio card"</a>
<li> <b>Previous message:</b> <a href="0734.html">Hoagie: "Possible S3 FrameBuffer Problem?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
<p>
--Boundary_(ID_+Z9CynwWkxKCyWEZ4mBLWg)<br>
Content-type: text/plain; charset=us-ascii<br>
Content-transfer-encoding: 7bit<br>
<p>
This patch (to linux-2.3.4) fixes:<br>
1- Force the compiler not to use the builtin (in compiler) str* and mem*<br>
   function, by rename it with preprocessor<br>
   NOTE: I have modified more function that actually need.<br>
2- __inline__ instead of inline (This is a header included in external<br>
   program [indirectly!])<br>
3- use __kernel_size_t instead of size_t as in linux/string.h<br>
<p>
Note:<br>
I change (actually) only asm-i386, because in some other arch.<br>
there are other change, so I want have some feedback. (e.g. in<br>
asm-m68k there are some function NEVER full defined has memcmp)<br>
<p>
I've changed linux/string.h in this manner, because I want to include<br>
in linux/string.h some inline C functions (as asm-m68k/string.h do),<br>
but before this change, we must be sure that the other change is OK.<br>
<p>
Maybe it is better instead of change -2-, to add at the top of<br>
linux/string.h:<br>
+#ifndef __KERNEL__<br>
+#include &lt;string.h&gt;<br>
+#else<br>
  ...all the file...<br>
+#endif<br>
This is cleaner, but I don't like it. Maybe it is better don't include<br>
&lt;string.h&gt; but there can be some inline that use/require it.<br>
<p>
This patch works on egcs and gcc-2.7.2.3.<br>
<p>
Test it!<br>
<p>
        Giacomo Catenazzi       &lt;cate@student.ethz.ch&gt;<br>
<p>
--Boundary_(ID_+Z9CynwWkxKCyWEZ4mBLWg)<br>
Content-type: text/plain; name=str.at.EML; charset=us-ascii<br>
Content-disposition: inline; filename=str.at.EML<br>
Content-transfer-encoding: 7bit<br>
<p>
diff -ur linux/include/asm-i386/string.h linux.mydevel/include/asm-i386/string.h<br>
--- linux/include/asm-i386/string.h	Wed May 19 19:22:17 1999<br>
+++ linux.mydevel/include/asm-i386/string.h	Tue Jun  1 22:58:14 1999<br>
@@ -28,7 +28,8 @@<br>
  */<br>
 <br>
 #define __HAVE_ARCH_STRCPY<br>
-extern inline char * strcpy(char * dest,const char *src)<br>
+#define strcpy __kernel_strcpy<br>
+extern __inline__ char * strcpy(char * dest,const char *src)<br>
 {<br>
 int d0, d1, d2;<br>
 __asm__ __volatile__(<br>
@@ -43,7 +44,8 @@<br>
 }<br>
 <br>
 #define __HAVE_ARCH_STRNCPY<br>
-extern inline char * strncpy(char * dest,const char *src,size_t count)<br>
+#define strncpy __kernel_strncpy<br>
+extern __inline__ char * strncpy(char * dest,const char *src,__kernel_size_t count)<br>
 {<br>
 int d0, d1, d2, d3;<br>
 __asm__ __volatile__(<br>
@@ -63,7 +65,7 @@<br>
 }<br>
 <br>
 #define __HAVE_ARCH_STRCAT<br>
-extern inline char * strcat(char * dest,const char * src)<br>
+extern __inline__ char * strcat(char * dest,const char * src)<br>
 {<br>
 int d0, d1, d2, d3;<br>
 __asm__ __volatile__(<br>
@@ -81,7 +83,7 @@<br>
 }<br>
 <br>
 #define __HAVE_ARCH_STRNCAT<br>
-extern inline char * strncat(char * dest,const char * src,size_t count)<br>
+extern __inline__ char * strncat(char * dest,const char * src,__kernel_size_t count)<br>
 {<br>
 int d0, d1, d2, d3;<br>
 __asm__ __volatile__(<br>
@@ -105,7 +107,8 @@<br>
 }<br>
 <br>
 #define __HAVE_ARCH_STRCMP<br>
-extern inline int strcmp(const char * cs,const char * ct)<br>
+#define strcmp __kernel_strcmp<br>
+extern __inline__ int strcmp(const char * cs,const char * ct)<br>
 {<br>
 int d0, d1;<br>
 register int __res;<br>
@@ -127,7 +130,8 @@<br>
 }<br>
 <br>
 #define __HAVE_ARCH_STRNCMP<br>
-extern inline int strncmp(const char * cs,const char * ct,size_t count)<br>
+#define strncmp __kernel_strncmp<br>
+extern __inline__ int strncmp(const char * cs,const char * ct,__kernel_size_t count)<br>
 {<br>
 register int __res;<br>
 int d0, d1, d2;<br>
@@ -151,7 +155,7 @@<br>
 }<br>
 <br>
 #define __HAVE_ARCH_STRCHR<br>
-extern inline char * strchr(const char * s, int c)<br>
+extern __inline__ char * strchr(const char * s, int c)<br>
 {<br>
 int d0;<br>
 register char * __res;<br>
@@ -171,7 +175,7 @@<br>
 }<br>
 <br>
 #define __HAVE_ARCH_STRRCHR<br>
-extern inline char * strrchr(const char * s, int c)<br>
+extern __inline__ char * strrchr(const char * s, int c)<br>
 {<br>
 int d0, d1;<br>
 register char * __res;<br>
@@ -189,7 +193,8 @@<br>
 }<br>
 <br>
 #define __HAVE_ARCH_STRLEN<br>
-extern inline size_t strlen(const char * s)<br>
+#define strlen __kernel_strlen<br>
+extern __inline__ __kernel_size_t strlen(const char * s)<br>
 {<br>
 int d0;<br>
 register int __res;<br>
@@ -203,7 +208,7 @@<br>
 return __res;<br>
 }<br>
 <br>
-extern inline void * __memcpy(void * to, const void * from, size_t n)<br>
+extern __inline__ void * __kernel_memcpy(void * to,const void * from,__kernel_size_t n)<br>
 {<br>
 int d0, d1, d2;<br>
 __asm__ __volatile__(<br>
@@ -226,7 +231,7 @@<br>
  * This looks horribly ugly, but the compiler can optimize it totally,<br>
  * as the count is constant.<br>
  */<br>
-extern inline void * __constant_memcpy(void * to, const void * from, size_t n)<br>
+extern inline void * __kernel_constant_memcpy(void * to,const void * from,__kernel_size_t n)<br>
 {<br>
 	switch (n) {<br>
 		case 0:<br>
@@ -295,11 +300,12 @@<br>
 #define __HAVE_ARCH_MEMCPY<br>
 #define memcpy(t, f, n) \<br>
 (__builtin_constant_p(n) ? \<br>
- __constant_memcpy((t),(f),(n)) : \<br>
- __memcpy((t),(f),(n)))<br>
+ __kernel_constant_memcpy((t),(f),(n)) : \<br>
+ __kernel_memcpy((t),(f),(n)))<br>
 <br>
 #define __HAVE_ARCH_MEMMOVE<br>
-extern inline void * memmove(void * dest,const void * src, size_t n)<br>
+#define memmove __kernel_memmove<br>
+extern __inline__ void * memmove(void * dest,const void * src,__kernel_size_t n)<br>
 {<br>
 int d0, d1, d2;<br>
 if (dest&lt;src)<br>
@@ -324,10 +330,11 @@<br>
 return dest;<br>
 }<br>
 <br>
+/* use builtin (in gcc compiler) memcmp */ <br>
 #define memcmp __builtin_memcmp<br>
 <br>
 #define __HAVE_ARCH_MEMCHR<br>
-extern inline void * memchr(const void * cs,int c,size_t count)<br>
+extern __inline__ void * memchr(const void * cs,int c,__kernel_size_t count)<br>
 {<br>
 int d0;<br>
 register void * __res;<br>
@@ -344,7 +351,7 @@<br>
 return __res;<br>
 }<br>
 <br>
-extern inline void * __memset_generic(void * s, char c,size_t count)<br>
+extern __inline__ void * __memset_generic(void * s,char c,__kernel_size_t count)<br>
 {<br>
 int d0, d1;<br>
 __asm__ __volatile__(<br>
@@ -365,7 +372,7 @@<br>
  * things 32 bits at a time even when we don't know the size of the<br>
  * area at compile-time..<br>
  */<br>
-extern inline void * __constant_c_memset(void * s, unsigned long c, size_t count)<br>
+extern __inline__ void * __constant_c_memset(void * s,unsigned long c,__kernel_size_t count)<br>
 {<br>
 int d0, d1;<br>
 __asm__ __volatile__(<br>
@@ -386,7 +393,8 @@<br>
 <br>
 /* Added by Gertjan van Wingerde to make minix and sysv module work */<br>
 #define __HAVE_ARCH_STRNLEN<br>
-extern inline size_t strnlen(const char * s, size_t count)<br>
+#define strnlen __kernel_strnlen<br>
+extern __inline__ __kernel_size_t strnlen(const char * s,__kernel_size_t count)<br>
 {<br>
 int d0;<br>
 register int __res;<br>
@@ -410,7 +418,7 @@<br>
  * This looks horribly ugly, but the compiler can optimize it totally,<br>
  * as we by now know that both pattern and count is constant..<br>
  */<br>
-extern inline void * __constant_c_and_count_memset(void * s, unsigned long pattern, size_t count)<br>
+extern __inline__ void * __constant_c_and_count_memset(void * s,unsigned long pattern,__kernel_size_t count)<br>
 {<br>
 	switch (count) {<br>
 		case 0:<br>
@@ -469,7 +477,7 @@<br>
  * find the first occurrence of byte 'c', or 1 past the area if none<br>
  */<br>
 #define __HAVE_ARCH_MEMSCAN<br>
-extern inline void * memscan(void * addr, int c, size_t size)<br>
+extern __inline__ void * memscan(void * addr,int c,__kernel_size_t size)<br>
 {<br>
 	if (!size)<br>
 		return addr;<br>
Only in linux.mydevel/include/asm-i386: string.h~<br>
diff -ur linux/include/linux/string.h linux.mydevel/include/linux/string.h<br>
--- linux/include/linux/string.h	Wed May 19 19:28:13 1999<br>
+++ linux.mydevel/include/linux/string.h	Tue Jun  1 22:59:00 1999<br>
@@ -7,40 +7,80 @@<br>
 #define NULL ((void *) 0)<br>
 #endif<br>
 <br>
-#ifdef __cplusplus<br>
-extern "C" {<br>
-#endif<br>
-<br>
-extern char * ___strtok;<br>
-extern char * strcpy(char *,const char *);<br>
-extern char * strncpy(char *,const char *, __kernel_size_t);<br>
-extern char * strcat(char *, const char *);<br>
-extern char * strncat(char *, const char *, __kernel_size_t);<br>
-extern char * strchr(const char *,int);<br>
-extern char * strrchr(const char *,int);<br>
-extern char * strpbrk(const char *,const char *);<br>
-extern char * strtok(char *,const char *);<br>
-extern char * strstr(const char *,const char *);<br>
-extern __kernel_size_t strlen(const char *);<br>
-extern __kernel_size_t strnlen(const char *,__kernel_size_t);<br>
-extern __kernel_size_t strspn(const char *,const char *);<br>
-extern int strcmp(const char *,const char *);<br>
-extern int strncmp(const char *,const char *,__kernel_size_t);<br>
-extern int strnicmp(const char *, const char *, __kernel_size_t);<br>
-<br>
-extern void * memset(void *,int,__kernel_size_t);<br>
-extern void * memcpy(void *,const void *,__kernel_size_t);<br>
-extern void * memmove(void *,const void *,__kernel_size_t);<br>
-extern void * memscan(void *,int,__kernel_size_t);<br>
-extern int memcmp(const void *,const void *,__kernel_size_t);<br>
-<br>
 /*<br>
  * Include machine specific inline routines<br>
  */<br>
 #include &lt;asm/string.h&gt;<br>
+ <br>
 <br>
 #ifdef __cplusplus<br>
-}<br>
+  #define externC  extern "C"<br>
+#else<br>
+  #define externC  extern<br>
+#endif<br>
+<br>
+extern char * ___strtok;<br>
+#ifndef __HAVE_ARCH_STRCPY<br>
+  externC char * strcpy(char *,const char *);<br>
+#endif<br>
+#ifndef __HAVE_ARCH_STRNCPY<br>
+  externC char * strncpy(char *,const char *, __kernel_size_t);<br>
+#endif<br>
+#ifndef __HAVE_ARCH_STRCAT<br>
+  externC char * strcat(char *, const char *);<br>
+#endif<br>
+#ifndef __HAVE_ARCH_STRNCAT<br>
+  externC char * strncat(char *, const char *, __kernel_size_t);<br>
+#endif<br>
+#ifndef __HAVE_ARCH_STRCHR<br>
+  externC char * strchr(const char *,int);<br>
+#endif<br>
+#ifndef __HAVE_ARCH_STRRCHR<br>
+  externC char * strrchr(const char *,int);<br>
+#endif<br>
+#ifndef __HAVE_ARCH_STRPBRK<br>
+  externC char * strpbrk(const char *,const char *);<br>
 #endif<br>
+#ifndef __HAVE_ARCH_STRTOK<br>
+  externC char * strtok(char *,const char *);<br>
+#endif<br>
+#ifndef __HAVE_ARCH_STRSTR<br>
+  externC char * strstr(const char *,const char *);<br>
+#endif<br>
+#ifndef __HAVE_ARCH_STRLEN<br>
+  externC __kernel_size_t strlen(const char *);<br>
+#endif<br>
+#ifndef __HAVE_ARCH_STRNLEN<br>
+  externC __kernel_size_t strnlen(const char *,__kernel_size_t);<br>
+#endif<br>
+#ifndef __HAVE_ARCH_STRSPN<br>
+  externC __kernel_size_t strspn(const char *,const char *);<br>
+#endif<br>
+#ifndef __HAVE_ARCH_STRCMP<br>
+  externC int strcmp(const char *,const char *);<br>
+#endif<br>
+#ifndef __HAVE_ARCH_STRNCMP<br>
+  externC int strncmp(const char *,const char *,__kernel_size_t);<br>
+#endif<br>
+#ifndef  __HAVE_ARCH_STRNICMP<br>
+  externC int strnicmp(const char *, const char *, __kernel_size_t);<br>
+#endif<br>
+#ifndef __HAVE_ARCH_MEMSET<br>
+  externC void * memset(void *,int,__kernel_size_t);<br>
+#endif<br>
+#ifndef __HAVE_ARCH_MEMCPY<br>
+  externC void * memcpy(void *,const void *,__kernel_size_t);<br>
+#endif<br>
+#ifndef __HAVE_ARCH_MEMMOVE<br>
+  externC void * memmove(void *,const void *,__kernel_size_t);<br>
+#endif<br>
+#ifndef __HAVE_ARCH_MEMSCAN<br>
+  externC void * memscan(void *,int,__kernel_size_t);<br>
+#endif<br>
+#ifndef __HAVE_ARCH_MEMCMP<br>
+  externC int memcmp(const void *,const void *,__kernel_size_t);<br>
+#endif<br>
+<br>
+#undef externC<br>
 <br>
 #endif /* _LINUX_STRING_H_ */<br>
<p>
--Boundary_(ID_+Z9CynwWkxKCyWEZ4mBLWg)--<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0736.html">Rolf Offermanns: "Kernel patch for terratec radio card"</a>
<li> <b>Previous message:</b> <a href="0734.html">Hoagie: "Possible S3 FrameBuffer Problem?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
