<!-- received="Wed Jun  2 15:43:52 1999 EET DST" -->
<!-- sent="Wed, 2 Jun 1999 14:13:19 +0200" -->
<!-- name="Pavel Machek" -->
<!-- email="pavel@bug.ucw.cz" -->
<!-- subject="Flip changes done right" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-22,: Flip changes done right</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Flip changes done right</h1>
<b>Pavel Machek</b> (<a href="mailto:pavel@bug.ucw.cz"><i>pavel@bug.ucw.cz</i></a>)<br>
<i>Wed, 2 Jun 1999 14:13:19 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#772">[ date ]</a><a href="index.html#772">[ thread ]</a><a href="subject.html#772">[ subject ]</a><a href="author.html#772">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0773.html">Pavel Machek: "Re: 2.3 wish: integrate pcmcia into mainstream kernel"</a>
<li> <b>Previous message:</b> <a href="0771.html">Denis Karpov: "Re: Removable media bug"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi!<br>
<p>
My previous patch was totally bogus. (I thought I tried it!!!) I spend<br>
two hours fixing it. Ok, here it is, this time it should work. Please<br>
apply, <br>
								Pavel<br>
<p>
--- clean/include/linux/tty.h	Fri May 14 20:42:58 1999<br>
+++ linux/include/linux/tty.h	Wed Jun  2 13:45:36 1999<br>
@@ -125,13 +125,14 @@<br>
  */<br>
 #define __DISABLED_CHAR '\0'<br>
 <br>
+/* HACK for old drivers, don't include this constant in new code */<br>
+#define TTY_FLIPBUF_SIZE 512<br>
+<br>
 /*<br>
  * This is the flip buffer used for the tty driver.  The buffer is<br>
- * located in the tty structure, and is used as a high speed interface<br>
- * between the tty driver and the tty line discipline.<br>
+ * kmalloced, and is used as a high speed interface between tty driver<br>
+ * and the line discipline.<br>
  */<br>
-#define TTY_FLIPBUF_SIZE 512<br>
-<br>
 struct tty_flip_buffer {<br>
 	struct tq_struct tqueue;<br>
 	struct semaphore pty_sem;<br>
@@ -139,9 +140,9 @@<br>
 	unsigned char	*flag_buf_ptr;<br>
 	int		count;<br>
 	int		buf_num;<br>
-	unsigned char	char_buf[2*TTY_FLIPBUF_SIZE];<br>
-	char		flag_buf[2*TTY_FLIPBUF_SIZE];<br>
-	unsigned char	slop[4]; /* N.B. bug overwrites buffer by 1 */<br>
+	int		flipbuf_size;<br>
+	unsigned char	*char_buf;<br>
+	char		*flag_buf;<br>
 };<br>
 /*<br>
  * The pty uses char_buf and flag_buf as a contiguous buffer<br>
--- clean/include/linux/tty_flip.h	Wed Sep 10 04:41:41 1997<br>
+++ linux/include/linux/tty_flip.h	Sun May 30 21:08:21 1999<br>
@@ -10,7 +10,7 @@<br>
 _INLINE_ void tty_insert_flip_char(struct tty_struct *tty,<br>
 				   unsigned char ch, char flag)<br>
 {<br>
-	if (tty-&gt;flip.count &lt; TTY_FLIPBUF_SIZE) {<br>
+	if (tty-&gt;flip.count &lt; tty-&gt;flip.flipbuf_size) {<br>
 		tty-&gt;flip.count++;<br>
 		*tty-&gt;flip.flag_buf_ptr++ = flag;<br>
 		*tty-&gt;flip.char_buf_ptr++ = ch;<br>
--- clean/include/linux/tty_driver.h	Sun Aug 16 22:34:51 1998<br>
+++ linux/include/linux/tty_driver.h	Wed Jun  2 13:24:01 1999<br>
@@ -132,6 +132,7 @@<br>
 	int	*refcount;	/* for loadable tty drivers */<br>
 	struct proc_dir_entry *proc_entry; /* /proc fs entry */<br>
 	struct tty_driver *other; /* only used for the PTY driver */<br>
+	int	flip_size;	/* requested size of flip buffer */<br>
 <br>
 	/*<br>
 	 * Pointer to the tty data structures<br>
@@ -197,10 +198,13 @@<br>
  *	optimize for this case if this flag is set.  (Note that there<br>
  * 	is also a promise, if the above case is true, not to signal<br>
  * 	overruns, either.)<br>
+ *<br>
+ * TTY_DRIVER_SPECIAL_FLIPSIZE --- we want non-512 bytes flip buffer<br>
  */<br>
 #define TTY_DRIVER_INSTALLED		0x0001<br>
 #define TTY_DRIVER_RESET_TERMIOS	0x0002<br>
 #define TTY_DRIVER_REAL_RAW		0x0004<br>
+#define TTY_DRIVER_SPECIAL_FLIPSIZE	0x0008<br>
 <br>
 /* tty driver types */<br>
 #define TTY_DRIVER_TYPE_SYSTEM		0x0001<br>
--- clean/drivers/char/tty_io.c	Fri May 14 20:42:29 1999<br>
+++ linux/drivers/char/tty_io.c	Wed Jun  2 14:11:00 1999<br>
@@ -54,6 +54,9 @@<br>
  *<br>
  * Added support for a Unix98-style ptmx device.<br>
  *      -- C. Scott Ananian &lt;<a href="mailto:cananian@alumni.princeton.edu">cananian@alumni.princeton.edu</a>&gt;, 14-Jan-1998<br>
+ *<br>
+ * Added support for bigger flipbuf sizes<br>
+ *	-- Pavel Machek &lt;<a href="mailto:pavel@ucw.cz">pavel@ucw.cz</a>&gt;, June 99<br>
  */<br>
 <br>
 #include &lt;linux/config.h&gt;<br>
@@ -115,7 +118,7 @@<br>
  */<br>
 struct tty_struct * redirect = NULL;<br>
 <br>
-static void initialize_tty_struct(struct tty_struct *tty);<br>
+static int initialize_tty_struct(struct tty_struct *tty, int);<br>
 <br>
 static ssize_t tty_read(struct file *, char *, size_t, loff_t *);<br>
 static ssize_t tty_write(struct file *, const char *, size_t, loff_t *);<br>
@@ -786,10 +789,14 @@<br>
 	tp = o_tp = NULL;<br>
 	ltp = o_ltp = NULL;<br>
 <br>
-	tty = (struct tty_struct*) get_free_page(GFP_KERNEL);<br>
+	tty = (struct tty_struct*) kmalloc(sizeof(struct tty_struct), GFP_KERNEL);<br>
 	if(!tty)<br>
 		goto fail_no_mem;<br>
-	initialize_tty_struct(tty);<br>
+<br>
+	if (initialize_tty_struct(tty, driver-&gt;flip_size)) {<br>
+		kfree(tty);<br>
+		goto fail_no_mem;<br>
+	}<br>
 	tty-&gt;device = device;<br>
 	tty-&gt;driver = *driver;<br>
 <br>
@@ -812,10 +819,14 @@<br>
 	}<br>
 <br>
 	if (driver-&gt;type == TTY_DRIVER_TYPE_PTY) {<br>
-		o_tty = (struct tty_struct *) get_free_page(GFP_KERNEL);<br>
+		o_tty = (struct tty_struct *) kmalloc(sizeof(struct tty_struct), GFP_KERNEL);<br>
 		if (!o_tty)<br>
 			goto free_mem_out;<br>
-		initialize_tty_struct(o_tty);<br>
+		if (initialize_tty_struct(o_tty, 512)) {<br>
+			kfree(o_tty);<br>
+			o_tty = NULL;<br>
+			goto free_mem_out;<br>
+		}<br>
 		o_tty-&gt;device = (kdev_t) MKDEV(driver-&gt;other-&gt;major,<br>
 					driver-&gt;other-&gt;minor_start + idx);<br>
 		o_tty-&gt;driver = *driver-&gt;other;<br>
@@ -931,13 +942,16 @@<br>
 free_mem_out:<br>
 	if (o_tp)<br>
 		kfree_s(o_tp, sizeof(struct termios));<br>
-	if (o_tty)<br>
-		free_page((unsigned long) o_tty);<br>
+	if (o_tty) {<br>
+		kfree(o_tty-&gt;flip.char_buf);<br>
+		kfree(o_tty);<br>
+	}<br>
 	if (ltp)<br>
 		kfree_s(ltp, sizeof(struct termios));<br>
 	if (tp)<br>
 		kfree_s(tp, sizeof(struct termios));<br>
-	free_page((unsigned long) tty);<br>
+	kfree(tty-&gt;flip.char_buf);<br>
+	kfree(tty);<br>
 <br>
 fail_no_mem:<br>
 	retval = -ENOMEM;<br>
@@ -968,7 +982,8 @@<br>
 		}<br>
 		o_tty-&gt;magic = 0;<br>
 		(*o_tty-&gt;driver.refcount)--;<br>
-		free_page((unsigned long) o_tty);<br>
+		kfree(o_tty-&gt;flip.char_buf);<br>
+		kfree(o_tty);<br>
 	}<br>
 <br>
 	tty-&gt;driver.table[idx] = NULL;<br>
@@ -979,7 +994,8 @@<br>
 	}<br>
 	tty-&gt;magic = 0;<br>
 	(*tty-&gt;driver.refcount)--;<br>
-	free_page((unsigned long) tty);<br>
+	kfree(tty-&gt;flip.char_buf);<br>
+	kfree(tty);<br>
 }<br>
 <br>
 /*<br>
@@ -1842,8 +1858,8 @@<br>
 		return;<br>
 	}<br>
 	if (tty-&gt;flip.buf_num) {<br>
-		cp = tty-&gt;flip.char_buf + TTY_FLIPBUF_SIZE;<br>
-		fp = tty-&gt;flip.flag_buf + TTY_FLIPBUF_SIZE;<br>
+		cp = tty-&gt;flip.char_buf + tty-&gt;flip.flipbuf_size;<br>
+		fp = tty-&gt;flip.flag_buf + tty-&gt;flip.flipbuf_size;<br>
 		tty-&gt;flip.buf_num = 0;<br>
 <br>
 		save_flags(flags); cli();<br>
@@ -1855,8 +1871,8 @@<br>
 		tty-&gt;flip.buf_num = 1;<br>
 <br>
 		save_flags(flags); cli();<br>
-		tty-&gt;flip.char_buf_ptr = tty-&gt;flip.char_buf + TTY_FLIPBUF_SIZE;<br>
-		tty-&gt;flip.flag_buf_ptr = tty-&gt;flip.flag_buf + TTY_FLIPBUF_SIZE;<br>
+		tty-&gt;flip.char_buf_ptr = tty-&gt;flip.char_buf + tty-&gt;flip.flipbuf_size;<br>
+		tty-&gt;flip.flag_buf_ptr = tty-&gt;flip.flag_buf + tty-&gt;flip.flipbuf_size;<br>
 	}<br>
 	count = tty-&gt;flip.count;<br>
 	tty-&gt;flip.count = 0;<br>
@@ -1920,9 +1936,17 @@<br>
 /*<br>
  * This subroutine initializes a tty structure.<br>
  */<br>
-static void initialize_tty_struct(struct tty_struct *tty)<br>
+static int initialize_tty_struct(struct tty_struct *tty, int flip_size)<br>
 {<br>
 	memset(tty, 0, sizeof(struct tty_struct));<br>
+<br>
+	/* there was notice about buffer overrun in original code -- that's why I do +4 */<br>
+	tty-&gt;flip.char_buf = kmalloc(flip_size*4 +4, GFP_KERNEL);<br>
+	if (!tty-&gt;flip.char_buf)<br>
+		return -ENOMEM;<br>
+<br>
+	tty-&gt;flip.flag_buf = tty-&gt;flip.char_buf + flip_size*2;<br>
+	tty-&gt;flip.flipbuf_size = flip_size;<br>
 	tty-&gt;magic = TTY_MAGIC;<br>
 	tty-&gt;ldisc = ldiscs[N_TTY];<br>
 	tty-&gt;pgrp = -1;<br>
@@ -1936,6 +1960,7 @@<br>
 	tty-&gt;tq_hangup.routine = do_tty_hangup;<br>
 	tty-&gt;tq_hangup.data = tty;<br>
 	sema_init(&amp;tty-&gt;atomic_read, 1);<br>
+	return 0;<br>
 }<br>
 <br>
 /*<br>
@@ -1956,14 +1981,19 @@<br>
 	if (driver-&gt;flags &amp; TTY_DRIVER_INSTALLED)<br>
 		return 0;<br>
 <br>
+	if (!(driver-&gt;flags &amp; TTY_DRIVER_SPECIAL_FLIPSIZE))<br>
+		driver-&gt;flip_size = 512;<br>
+<br>
 	error = register_chrdev(driver-&gt;major, driver-&gt;name, &amp;tty_fops);<br>
-	if (error &lt; 0)<br>
+	if (error &lt; 0) {<br>
 		return error;<br>
+	}<br>
 	else if(driver-&gt;major == 0)<br>
 		driver-&gt;major = error;<br>
 <br>
 	if (!driver-&gt;put_char)<br>
 		driver-&gt;put_char = tty_default_put_char;<br>
+<br>
 	<br>
 	driver-&gt;prev = 0;<br>
 	driver-&gt;next = tty_drivers;<br>
--- clean/drivers/char/pty.c	Fri May 14 20:42:27 1999<br>
+++ linux/drivers/char/pty.c	Wed Jun  2 12:08:15 1999<br>
@@ -150,7 +150,7 @@<br>
 			n = MIN(count, to-&gt;ldisc.receive_room(to));<br>
 			if (!n) break;<br>
 <br>
-			n  = MIN(n, PTY_BUF_SIZE);<br>
+			n  = MIN(n, tty-&gt;flip.flipbuf_size);<br>
 			n -= copy_from_user(temp_buffer, buf, n);<br>
 			if (!n) {<br>
 				if (!c)<br>
--- clean/drivers/char/serial.c	Fri May 14 20:42:29 1999<br>
+++ linux/drivers/char/serial.c	Wed Jun  2 12:09:51 1999<br>
@@ -385,7 +389,7 @@<br>
 	icount = &amp;info-&gt;state-&gt;icount;<br>
 	do {<br>
 		ch = serial_inp(info, UART_RX);<br>
-		if (tty-&gt;flip.count &gt;= TTY_FLIPBUF_SIZE)<br>
+		if (tty-&gt;flip.count &gt;= tty-&gt;flip.flipbuf_size)<br>
 			break;<br>
 		*tty-&gt;flip.char_buf_ptr = ch;<br>
 		icount-&gt;rx++;<br>
@@ -438,7 +442,7 @@<br>
 				 * reported immediately, and doesn't<br>
 				 * affect the current character<br>
 				 */<br>
-				if (tty-&gt;flip.count &lt; TTY_FLIPBUF_SIZE) {<br>
+				if (tty-&gt;flip.count &lt; tty-&gt;flip.flipbuf_size) {<br>
 					tty-&gt;flip.count++;<br>
 					tty-&gt;flip.flag_buf_ptr++;<br>
 					tty-&gt;flip.char_buf_ptr++;<br>
<pre>
-- 
I'm really <a href="mailto:pavel@ucw.cz">pavel@ucw.cz</a>. Look at <a href="http://195.113.31.123/~pavel">http://195.113.31.123/~pavel</a>.  Pavel
Hi! I'm a .signature virus! Copy me into your ~/.signature, please!
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0773.html">Pavel Machek: "Re: 2.3 wish: integrate pcmcia into mainstream kernel"</a>
<li> <b>Previous message:</b> <a href="0771.html">Denis Karpov: "Re: Removable media bug"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
