<!-- received="Wed Jun  2 16:06:12 1999 EET DST" -->
<!-- sent="Wed, 02 Jun 1999 14:48:06 +0200" -->
<!-- name="Manfred Spraul" -->
<!-- email="manfreds@colorfullife.com" -->
<!-- subject="[PATCH] move initialize_secondary() from start_kernel() into" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-22,: [PATCH] move initialize_secondary() from start_kernel() into</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] move initialize_secondary() from start_kernel() into</h1>
<b>Manfred Spraul</b> (<a href="mailto:manfreds@colorfullife.com"><i>manfreds@colorfullife.com</i></a>)<br>
<i>Wed, 02 Jun 1999 14:48:06 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#775">[ date ]</a><a href="index.html#775">[ thread ]</a><a href="subject.html#775">[ subject ]</a><a href="author.html#775">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0776.html">John Hayward-Warburton: "Re: Simultaneous network/IDE traffic = reboot"</a>
<li> <b>Previous message:</b> <a href="0774.html">Philip Blundell: "Re: [PATCH] New documentation"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0779.html">David S. Miller: "Re: [PATCH] move initialize_secondary() from start_kernel() into"</a>
<li> <b>Reply:</b> <a href="0779.html">David S. Miller: "Re: [PATCH] move initialize_secondary() from start_kernel() into"</a>
<li> <b>Reply:</b> <a href="0802.html">Manfred Spraul: "Re: [PATCH] move initialize_secondary() from start_kernel() into"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------5D4363467D4A94E075DD9D83<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
initialize_secondary() is only required by i386,<br>
the other architectures do not need this function.<br>
(actually, they complain about the function, see<br>
linux/arch/*/kernel/smp.c)<br>
<p>
This patch moves the call from linux/init/main.c:start_kernel()<br>
into arch/i386/kernel/head.S.<br>
<p>
* tested on dual-PII<br>
* I did not remove the initialize_secondary() functions<br>
from arch/{alpha, ppc, sparc, sparc64} because<br>
I've heard that the most up to date versions<br>
are maintained in individual CVS trees.<br>
<pre>
--
	Manfred
--------------5D4363467D4A94E075DD9D83
Content-Type: text/plain; charset=us-ascii;
 name="patch-SMPCLEANUP-2.3.4"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline;
 filename="patch-SMPCLEANUP-2.3.4"
<p>
// $Header: /pub/cvs/ms/patches/patch-SMPCLEANUP-2.3.4,v 1.1 1999/06/02 12:31:59 ms Exp $
// Kernel Version:
//  VERSION = 2
//  PATCHLEVEL = 3
//  SUBLEVEL = 4
//  EXTRAVERSION =
diff -r -u -P -x CVS -x *,v 2.3/arch/i386/kernel/head.S build-2.3/arch/i386/kernel/head.S
--- 2.3/arch/i386/kernel/head.S	Fri Jan 15 07:57:25 1999
+++ build-2.3/arch/i386/kernel/head.S	Wed Jun  2 14:24:36 1999
@@ -242,6 +242,14 @@
 	xorl %eax,%eax
 	lldt %ax
 	cld			# gcc2 wants the direction flag cleared at all times
+#ifdef __SMP__
+	movb ready, %cl
+	cmpb $1,%cl
+	je 1f
+	call SYMBOL_NAME(initialize_secondary)
+	jmp L6
+1:
+#endif
 	call SYMBOL_NAME(start_kernel)
 L6:
 	jmp L6			# main should never return here, but
diff -r -u -P -x CVS -x *,v 2.3/init/main.c build-2.3/init/main.c
--- 2.3/init/main.c	Wed May 19 14:20:14 1999
+++ build-2.3/init/main.c	Wed Jun  2 14:24:36 1999
@@ -1116,8 +1116,6 @@
 
 #endif
 
-extern void initialize_secondary(void);
-
 /*
  *	Activate the first processor.
  */
@@ -1125,14 +1123,6 @@
 asmlinkage void __init start_kernel(void)
 {
 	char * command_line;
-
-#ifdef __SMP__
-	static int boot_cpu = 1;
-	/* "current" has been set up, we need to load it now */
-	if (!boot_cpu)
-		initialize_secondary();
-	boot_cpu = 0;
-#endif
 
 /*
  * Interrupts are still disabled. Do necessary setups, then
<p>
<p>
<p>
<p>
--------------5D4363467D4A94E075DD9D83--
<p>
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0776.html">John Hayward-Warburton: "Re: Simultaneous network/IDE traffic = reboot"</a>
<li> <b>Previous message:</b> <a href="0774.html">Philip Blundell: "Re: [PATCH] New documentation"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0779.html">David S. Miller: "Re: [PATCH] move initialize_secondary() from start_kernel() into"</a>
<li> <b>Reply:</b> <a href="0779.html">David S. Miller: "Re: [PATCH] move initialize_secondary() from start_kernel() into"</a>
<li> <b>Reply:</b> <a href="0802.html">Manfred Spraul: "Re: [PATCH] move initialize_secondary() from start_kernel() into"</a>
<!-- reply="end" -->
</ul>
</font></body>
