<!-- received="Wed Jun  2 19:09:35 1999 EET DST" -->
<!-- sent="Wed, 02 Jun 1999 17:53:36 +0200" -->
<!-- name="Manfred Spraul" -->
<!-- email="manfreds@colorfullife.com" -->
<!-- subject="Re: [PATCH] move initialize_secondary() from start_kernel() into" -->
<!-- id="" -->
<!-- inreplyto="[PATCH] move initialize_secondary() from start_kernel() into" -->
<title>Linux-kernel mailing list archive 1999-22,: Re: [PATCH] move initialize_secondary() from start_kernel() into</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: [PATCH] move initialize_secondary() from start_kernel() into</h1>
<b>Manfred Spraul</b> (<a href="mailto:manfreds@colorfullife.com"><i>manfreds@colorfullife.com</i></a>)<br>
<i>Wed, 02 Jun 1999 17:53:36 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#802">[ date ]</a><a href="index.html#802">[ thread ]</a><a href="subject.html#802">[ subject ]</a><a href="author.html#802">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0803.html">Michael Dale Long: "Re: Multitech ISI4608 Card"</a>
<li> <b>Previous message:</b> <a href="0801.html">Rogier Wolff: "IBM token ring documentation?"</a>
<li> <b>Maybe in reply to:</b> <a href="0775.html">Manfred Spraul: "[PATCH] move initialize_secondary() from start_kernel() into"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------7E8F9775E5DCCB41E4CD38EC<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
"David S. Miller" wrote:<br>
<i>&gt;    From: Manfred Spraul &lt;<a href="mailto:manfreds@colorfullife.com">manfreds@colorfullife.com</a>&gt;</i><br>
<i>&gt;</i><br>
<i>&gt;    * I did not remove the initialize_secondary() functions</i><br>
<i>&gt;    from arch/{alpha, ppc, sparc, sparc64} because</i><br>
<i>&gt;    I've heard that the most up to date versions</i><br>
<i>&gt;    are maintained in individual CVS trees.</i><br>
<i>&gt; This is really not the case anymore, we're pretty synchronized at this</i><br>
<i>&gt; point.</i><br>
<p>
Here's the long version, I've removed initialize_secondary from all<br>
architectures except i386.<br>
--------------7E8F9775E5DCCB41E4CD38EC<br>
Content-Type: text/plain; charset=us-ascii;<br>
 name="patch-SMPCLEANUP-2.3.4"<br>
Content-Transfer-Encoding: 7bit<br>
Content-Disposition: inline;<br>
 filename="patch-SMPCLEANUP-2.3.4"<br>
<p>
// $Header: /pub/cvs/ms/patches/patch-SMPCLEANUP-2.3.4,v 1.2 1999/06/02 15:53:35 ms Exp $<br>
// Kernel Version:<br>
//  VERSION = 2<br>
//  PATCHLEVEL = 3<br>
//  SUBLEVEL = 4<br>
//  EXTRAVERSION =<br>
diff -r -u -P -x CVS -x *,v 2.3/arch/alpha/kernel/smp.c build-2.3/arch/alpha/kernel/smp.c<br>
--- 2.3/arch/alpha/kernel/smp.c	Wed May 19 14:20:13 1999<br>
+++ build-2.3/arch/alpha/kernel/smp.c	Wed Jun  2 17:32:59 1999<br>
@@ -565,17 +565,6 @@<br>
 	mb();<br>
 }<br>
 <br>
-/*<br>
- * Only broken Intel needs this, thus it should not even be<br>
- * referenced globally.<br>
- */<br>
-<br>
-void __init<br>
-initialize_secondary(void)<br>
-{<br>
-}<br>
-<br>
-<br>
 extern void update_one_process(struct task_struct *p, unsigned long ticks,<br>
 	                       unsigned long user, unsigned long system,<br>
 			       int cpu);<br>
diff -r -u -P -x CVS -x *,v 2.3/arch/i386/kernel/head.S build-2.3/arch/i386/kernel/head.S<br>
--- 2.3/arch/i386/kernel/head.S	Fri Jan 15 07:57:25 1999<br>
+++ build-2.3/arch/i386/kernel/head.S	Wed Jun  2 14:24:36 1999<br>
@@ -242,6 +242,14 @@<br>
 	xorl %eax,%eax<br>
 	lldt %ax<br>
 	cld			# gcc2 wants the direction flag cleared at all times<br>
+#ifdef __SMP__<br>
+	movb ready, %cl<br>
+	cmpb $1,%cl<br>
+	je 1f<br>
+	call SYMBOL_NAME(initialize_secondary)<br>
+	jmp L6<br>
+1:<br>
+#endif<br>
 	call SYMBOL_NAME(start_kernel)<br>
 L6:<br>
 	jmp L6			# main should never return here, but<br>
diff -r -u -P -x CVS -x *,v 2.3/arch/ppc/kernel/smp.c build-2.3/arch/ppc/kernel/smp.c<br>
--- 2.3/arch/ppc/kernel/smp.c	Wed May 19 14:16:08 1999<br>
+++ build-2.3/arch/ppc/kernel/smp.c	Wed Jun  2 17:33:15 1999<br>
@@ -373,11 +373,6 @@<br>
 	smp_commenced = 1;<br>
 }<br>
 <br>
-/* intel needs this */<br>
-void __init initialize_secondary(void)<br>
-{<br>
-}<br>
-<br>
 /* Activate a secondary processor. */<br>
 asmlinkage int __init start_secondary(void *unused)<br>
 {<br>
diff -r -u -P -x CVS -x *,v 2.3/arch/sparc/kernel/smp.c build-2.3/arch/sparc/kernel/smp.c<br>
--- 2.3/arch/sparc/kernel/smp.c	Wed May 19 14:15:46 1999<br>
+++ build-2.3/arch/sparc/kernel/smp.c	Wed Jun  2 17:33:23 1999<br>
@@ -100,13 +100,6 @@<br>
 	local_flush_tlb_all();<br>
 }<br>
 <br>
-/* Only broken Intel needs this, thus it should not even be referenced<br>
- * globally...<br>
- */<br>
-__initfunc(void initialize_secondary(void))<br>
-{<br>
-}<br>
-<br>
 extern int cpu_idle(void *unused);<br>
 <br>
 /* Activate a secondary processor. */<br>
diff -r -u -P -x CVS -x *,v 2.3/arch/sparc64/kernel/smp.c build-2.3/arch/sparc64/kernel/smp.c<br>
--- 2.3/arch/sparc64/kernel/smp.c	Wed Jun  2 14:00:10 1999<br>
+++ build-2.3/arch/sparc64/kernel/smp.c	Wed Jun  2 17:33:34 1999<br>
@@ -160,10 +160,6 @@<br>
 extern int cpu_idle(void *unused);<br>
 extern void init_IRQ(void);<br>
 <br>
-void initialize_secondary(void)<br>
-{<br>
-}<br>
-<br>
 int start_secondary(void *unused)<br>
 {<br>
 	trap_init();<br>
diff -r -u -P -x CVS -x *,v 2.3/init/main.c build-2.3/init/main.c<br>
--- 2.3/init/main.c	Wed May 19 14:20:14 1999<br>
+++ build-2.3/init/main.c	Wed Jun  2 14:24:36 1999<br>
@@ -1116,8 +1116,6 @@<br>
 <br>
 #endif<br>
 <br>
-extern void initialize_secondary(void);<br>
-<br>
 /*<br>
  *	Activate the first processor.<br>
  */<br>
@@ -1125,14 +1123,6 @@<br>
 asmlinkage void __init start_kernel(void)<br>
 {<br>
 	char * command_line;<br>
-<br>
-#ifdef __SMP__<br>
-	static int boot_cpu = 1;<br>
-	/* "current" has been set up, we need to load it now */<br>
-	if (!boot_cpu)<br>
-		initialize_secondary();<br>
-	boot_cpu = 0;<br>
-#endif<br>
 <br>
 /*<br>
  * Interrupts are still disabled. Do necessary setups, then<br>
<p>
--------------7E8F9775E5DCCB41E4CD38EC--<br>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0803.html">Michael Dale Long: "Re: Multitech ISI4608 Card"</a>
<li> <b>Previous message:</b> <a href="0801.html">Rogier Wolff: "IBM token ring documentation?"</a>
<li> <b>Maybe in reply to:</b> <a href="0775.html">Manfred Spraul: "[PATCH] move initialize_secondary() from start_kernel() into"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
