<!-- received="Thu Jun  3 02:03:18 1999 EET DST" -->
<!-- sent="Wed, 2 Jun 1999 20:22:29 +0200" -->
<!-- name="Petr Vandrovec" -->
<!-- email="vandrove@vc.cvut.cz" -->
<!-- subject="[PATCH] ncpfs read at the EOF" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-22,: [PATCH] ncpfs read at the EOF</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] ncpfs read at the EOF</h1>
<b>Petr Vandrovec</b> (<a href="mailto:vandrove@vc.cvut.cz"><i>vandrove@vc.cvut.cz</i></a>)<br>
<i>Wed, 2 Jun 1999 20:22:29 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#836">[ date ]</a><a href="index.html#836">[ thread ]</a><a href="subject.html#836">[ subject ]</a><a href="author.html#836">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0837.html">Stephen C. Tweedie: "Re: accessing raw disk."</a>
<li> <b>Previous message:</b> <a href="0835.html">Gerard Roudier: "Re: accessing raw disk."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--liOOAslEiF7prFVr<br>
Content-Type: text/plain; charset=us-ascii<br>
<p>
Hi Linus,<br>
  Michael Tross found that ncpfs does not correctly handle read above EOF<br>
under some conditions (it tries to read random number of bytes above end<br>
of file again and again because of it computes bytes to read as negative<br>
value). Attached fix fixes:<br>
  (1) 'count' is no longer set to illegal negative value such as '-384000' in<br>
      ncp_file_read. It is main problem.<br>
  (2) ncp_file_read and ncp_file_write used file-&gt;f_pos instead of passed<br>
      parameter ppos. Now pread and pwrite should work on ncpfs too.<br>
  (3) I changed type of some variables in ncp_file_{read,write} from<br>
      'int' to 'size_t'. Now 'read(fd, x, -1)' under some circumstances<br>
      behaves much better than before.<br>
  Could you apply attached fix, please? It fits into both 2.2.10-pre2 and<br>
2.3.4.<br>
                                   Thanks,<br>
                                      Petr Vandrovec<br>
                                      <a href="mailto:vandrove@vc.cvut.cz">vandrove@vc.cvut.cz</a><br>
<p>
P.S.: Patch included in this file is plain text. Attached is same file,<br>
but gzipped.<br>
<p>
diff -urdN linux/fs/ncpfs/file.c linux/fs/ncpfs/file.c<br>
--- linux/fs/ncpfs/file.c	Thu May 20 19:36:53 1999<br>
+++ linux/fs/ncpfs/file.c	Wed Jun  2 19:29:32 1999<br>
@@ -21,7 +21,7 @@<br>
 #include &lt;linux/ncp_fs.h&gt;<br>
 #include "ncplib_kernel.h"<br>
 <br>
-static inline int min(int a, int b)<br>
+static inline unsigned int min(unsigned int a, unsigned int b)<br>
 {<br>
 	return a &lt; b ? a : b;<br>
 }<br>
@@ -99,9 +99,10 @@<br>
 	struct inode *inode = dentry-&gt;d_inode;<br>
 	size_t already_read = 0;<br>
 	off_t pos;<br>
-	int bufsize, error;<br>
+	size_t bufsize;<br>
+	int error;<br>
 	void* freepage;<br>
-	int freelen;<br>
+	size_t freelen;<br>
 <br>
 	DPRINTK(KERN_DEBUG "ncp_file_read: enter %s/%s\n",<br>
 		dentry-&gt;d_parent-&gt;d_name.name, dentry-&gt;d_name.name);<br>
@@ -121,10 +122,12 @@<br>
 		goto out;<br>
 	}<br>
 <br>
-	pos = file-&gt;f_pos;<br>
+	pos = *ppos;<br>
+/* leave it out on server ...<br>
 	if (pos + count &gt; inode-&gt;i_size) {<br>
 		count = inode-&gt;i_size - pos;<br>
 	}<br>
+*/<br>
 	error = 0;<br>
 	if (!count)	/* size_t is never &lt; 0 */<br>
 		goto out;<br>
@@ -146,7 +149,7 @@<br>
 	/* First read in as much as possible for each bufsize. */<br>
 	while (already_read &lt; count) {<br>
 		int read_this_time;<br>
-		int to_read = min(bufsize - (pos % bufsize),<br>
+		size_t to_read = min(bufsize - (pos % bufsize),<br>
 				  count - already_read);<br>
 <br>
 		error = ncp_read_bounce(NCP_SERVER(inode),<br>
@@ -162,13 +165,13 @@<br>
 		buf += read_this_time;<br>
 		already_read += read_this_time;<br>
 <br>
-		if (read_this_time &lt; to_read) {<br>
+		if (read_this_time != to_read) {<br>
 			break;<br>
 		}<br>
 	}<br>
 	kfree(freepage);<br>
 <br>
-	file-&gt;f_pos = pos;<br>
+	*ppos = pos;<br>
 <br>
 	if (!IS_RDONLY(inode)) {<br>
 		inode-&gt;i_atime = CURRENT_TIME;<br>
@@ -187,7 +190,8 @@<br>
 	struct inode *inode = dentry-&gt;d_inode;<br>
 	size_t already_written = 0;<br>
 	off_t pos;<br>
-	int bufsize, errno;<br>
+	size_t bufsize;<br>
+	int errno;<br>
 	void* bouncebuffer;<br>
 <br>
 	DPRINTK(KERN_DEBUG "ncp_file_write: enter %s/%s\n",<br>
@@ -213,7 +217,7 @@<br>
 		printk(KERN_ERR "ncp_file_write: open failed, error=%d\n", errno);<br>
 		return errno;<br>
 	}<br>
-	pos = file-&gt;f_pos;<br>
+	pos = *ppos;<br>
 <br>
 	if (file-&gt;f_flags &amp; O_APPEND) {<br>
 		pos = inode-&gt;i_size;<br>
@@ -227,7 +231,7 @@<br>
 		return -EIO;	/* -ENOMEM */<br>
 	while (already_written &lt; count) {<br>
 		int written_this_time;<br>
-		int to_write = min(bufsize - (pos % bufsize),<br>
+		size_t to_write = min(bufsize - (pos % bufsize),<br>
 				   count - already_written);<br>
 <br>
 		if (copy_from_user(bouncebuffer, buf, to_write)) {<br>
@@ -244,14 +248,14 @@<br>
 		buf += written_this_time;<br>
 		already_written += written_this_time;<br>
 <br>
-		if (written_this_time &lt; to_write) {<br>
+		if (written_this_time != to_write) {<br>
 			break;<br>
 		}<br>
 	}<br>
 	kfree(bouncebuffer);<br>
 	inode-&gt;i_mtime = inode-&gt;i_atime = CURRENT_TIME;<br>
 	<br>
-	file-&gt;f_pos = pos;<br>
+	*ppos = pos;<br>
 <br>
 	if (pos &gt; inode-&gt;i_size) {<br>
 		inode-&gt;i_size = pos;<br>
<p>
--liOOAslEiF7prFVr<br>
Content-Type: application/octet-stream<br>
Content-Disposition: attachment; filename="ncpfs.gz"<br>
Content-Transfer-Encoding: base64<br>
<p>
H4sICBlzVTcAA25jcGZzAKVVbW/bNhD+LP2Ka4YMtiX5RXaTOI7dbI06ZF2cQE03DBggyBYV<br>
E5Elg5LSpUP+++5ISrVgt3OxL6R4b7x77vgo4nEMTimiOSQ8Lf/uxXkvXW5wjXnCusv9UtNx<br>
nP0a435Vwk34DG4fBuPz4cn56yF+jMemZVlfcfmDRfBrmQK45OKil6tcLi/BcQf2KVhyvbw0<br>
4QeeLpMyYnChYmGgIM67q9mW6giFCV8Ej0ykLOmujkwwnbwIC74EnqIfw62ANU9btIe2PC7a<br>
ptU0KtOcP6SYXGXdEKBb44z+8I8JhmBFKVII4QIW8Ab3c1hMTHiR1YzH9hgsXAd9WY6RF6Jc<br>
Fhggw8Q7aptCxNJCPDuzKJCSCRnyzyzAWxPBwug5oBUN+6TK4hg1myyfmI4hUyljMreBCZGJ<br>
iWlV3lpBErLTajCeMh51IBaMbcIHVoWhc8LSLf9aAuh0dedfz+/ft957/jy48n7++ItEPqCu<br>
yvzOActgAo7z3nH+V3pko5PxpbRNKPCbvtJwzbq02FuV18L2REI3wBlA1KyB69oDV6FnPGRF<br>
BllZUBEv1GYDYUBcKAdnFgcSFEsLOxt17HUgYeETTkFBvpClkDPxhJl2u10MxGNokYcFy6xE<br>
HGaqPc6MB4RDW7bZULppUweO6gNlY3V6uEuMq05R5FfSsW1gFhpVnkPK6PoL6IN02qpLlj46<br>
oUcwGI31KyDnd1zkBcg54DhuOazL5Yp2TCDni4RBjBezEIW67V0V/NMKwYFWY5IuVKm6NGo+<br>
iYNixfOg4Gs5ElJcZNXo0YPQgbFqCdhxdVPbRtCroTnYBW82DNCgO41Rb6uRq9GkOZMZLtB4<br>
yVrzt3fBB8//3fNbsh8YTQJ3grMyROROXtOuZgYvBGu6UyBqGpDsM5EoYA+bCkRP10j4WXtN<br>
Xk23bajSBR4e5bUvaniNR3pereoVttV9W5OMdet5lpNcHaEarOsPgX91O//tT41B3U09oKHM<br>
ZApvP/q+N78P7q9vPD1gZ6dywMZ9++z/8dInwYuCpQdRU5p9k5pIXVGTajPaxEwcwD6UBdul<br>
H/U/Gaofymn1loyNwBsfVSTP93fjZBusKA5REmlOnR5HFFGl2ZZd1LxfJ/5yEBlVzats4iR8<br>
yOFHuA1+urvz5le6h8qnQTWqc64rO+cOB3U5OhHHu76dEFE43vz2xrvZ+/irdu2+f63ZTwES<br>
l+/kgAN9NAnssIDOpyICwmyZbZ6DWGTroET+bm3PiE0R7fpa+RQkXKORPRghXqMz2huEsKfi<br>
LU6okPqKYcUMOzpFDiqLL+ywa6YIorb7FkNsFypnr56LtX7h//HkwfguYiHR/n9g89+n3f4F<br>
Il/+RVMKAAA=<br>
<p>
--liOOAslEiF7prFVr--<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0837.html">Stephen C. Tweedie: "Re: accessing raw disk."</a>
<li> <b>Previous message:</b> <a href="0835.html">Gerard Roudier: "Re: accessing raw disk."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
