<!-- received="Thu Jun  3 02:33:51 1999 EET DST" -->
<!-- sent="Wed, 2 Jun 1999 21:15:57 +0200 (MEST)" -->
<!-- name="Rogier Wolff" -->
<!-- email="R.E.Wolff@BitWizard.nl" -->
<!-- subject="IBMTR LAA support." -->
<!-- id="199906021915.VAA01872@cave.BitWizard.nl" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-22,: IBMTR LAA support.</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>IBMTR LAA support.</h1>
<b>Rogier Wolff</b> (<a href="mailto:R.E.Wolff@BitWizard.nl"><i>R.E.Wolff@BitWizard.nl</i></a>)<br>
<i>Wed, 2 Jun 1999 21:15:57 +0200 (MEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#844">[ date ]</a><a href="index.html#844">[ thread ]</a><a href="subject.html#844">[ subject ]</a><a href="author.html#844">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0845.html">David S. Miller: "Re: Linux 2.2.* remote exploit fix"</a>
<li> <b>Previous message:</b> <a href="0843.html">Chris Evans: "2.3: acl's?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0842.html">Paul Norton: "IBMTR LAA support."</a>
<li> <b>Reply:</b> <a href="0842.html">Paul Norton: "IBMTR LAA support."</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi everyone,<br>
<p>
Thanks to Paul Norton, I found the IBM shared RAM token ring card docs<br>
on the IBM website:<br>
<p>
  <a href="http://www.s390.ibm.com/bookmgr-cgi/bookmgr.cmd/BOOKS/BK8R1001/CCONTENTS">http://www.s390.ibm.com/bookmgr-cgi/bookmgr.cmd/BOOKS/BK8R1001/CCONTENTS</a><br>
<p>
Those do come in handy when things don't work at first :-)<br>
<p>
Thanks to Henrik Stoerner for the userinterface and the LAA parsing<br>
code.<br>
<p>
<p>
Locally Administrated Addresses are useful for some people because<br>
that can simplify routing tables in large networks enormously.<br>
<p>
At insmod time, you specify "laa=aa.bb.cc.dd.ee.ff" to set the LAA to<br>
the value specified. (LAA's start with 0x40-0x7f, so "aa" is invalid,<br>
and will be rejected). Of course everybody but me puts this in<br>
/etc/conf.modules .<br>
<p>
As I was interested in the code that read the hardware address from<br>
the Adapter Identification Prom (AIP), I studied that code. At first I<br>
misunderstood that code. I tried rewriting it in a way that it is no<br>
longer so hard-to-read. It is now also much shorter. <br>
<p>
Paul, you're mentioned as the Maintainer. Are you agreed with me with<br>
these changes? Will you submit them to Linus, or do you want me to do<br>
this? <br>
<p>
Uwe, do you need this backported to 2.0, or will this 2.2 patch<br>
suffice? (I promised you I'd do that, so you have every right to<br>
ask me to produce that patch too... :-)<br>
<p>
Regards,<br>
<p>
	Roger Wolff.<br>
<p>
------------------------------------------------------------------------<br>
<p>
diff -ur linux-2.2.9.clean/drivers/net/ibmtr.c linux/drivers/net/ibmtr.c<br>
--- linux-2.2.9.clean/drivers/net/ibmtr.c	Mon May 17 07:49:55 1999<br>
+++ linux/drivers/net/ibmtr.c	Wed Jun  2 20:57:24 1999<br>
@@ -79,6 +79,10 @@<br>
  *<br>
  *	Changes by Tim Hockin (<a href="mailto:thockin@isunix.it.ilstu.edu">thockin@isunix.it.ilstu.edu</a>) :<br>
  *	+ added spinlocks for SMP sanity (10 March 1999)<br>
+ *<br>
+ *	Changes by Roger E. Wolff (<a href="mailto:R.E.Wolff@BitWizard.nl">R.E.Wolff@BitWizard.nl</a>) :<br>
+ *	+ added support for Locally Administrated Adresses (May 30, 1999)<br>
+ *<br>
  */<br>
 <br>
 /* change the define of IBMTR_DEBUG_MESSAGES to a nonzero value <br>
@@ -187,6 +191,8 @@<br>
 #endif<br>
 <br>
 #if !TR_NEWFORMAT<br>
+/* Tip: Declare this variable as a module parameter, makes changing the <br>
+   debug options much easier. -- REW */<br>
 unsigned char ibmtr_debug_trace=1;  /*  Patch or otherwise alter to<br>
                                          control tokenring tracing.  */<br>
 #else<br>
@@ -216,6 +222,7 @@<br>
 void		ibmtr_readlog(struct device *dev);<br>
 void		ibmtr_reset_timer(struct timer_list *tmr, struct device *dev);<br>
 int             ibmtr_change_mtu(struct device *dev, int mtu);<br>
+static char *   get_laa (struct device *dev);<br>
 <br>
 static unsigned int ibmtr_portlist[] __initdata = {<br>
 	0xa20, 0xa24, 0<br>
@@ -297,12 +304,13 @@<br>
 <br>
 __initfunc(static int ibmtr_probe1(struct device *dev, int PIOaddr))<br>
 {<br>
-	unsigned char segment=0, intr=0, irq=0, i=0, j=0, cardpresent=NOTOK,temp=0;<br>
+	unsigned char segment=0, intr=0, irq=0, i=0, j=0, cardpresent=NOTOK;<br>
 	__u32 t_mmio=0;<br>
 	struct tok_info *ti=0;<br>
 	__u32 cd_chanid;<br>
 	unsigned char *tchanid, ctemp;<br>
 	unsigned long timeout;<br>
+	char *laa;<br>
 <br>
 #ifndef MODULE<br>
 #ifndef PCMCIA<br>
@@ -473,33 +481,60 @@<br>
 	if (ibmtr_debug_trace &amp; TRC_INIT) { /* just report int */<br>
 		DPRINTK("irq=%d",irq);<br>
 		if (ibmtr_debug_trace &amp; TRC_INITV) { /* full chat in verbose only */<br>
-			DPRINTK(", ti-&gt;mmio=%08X",ti-&gt;mmio);<br>
+			printk(", ti-&gt;mmio=%08X",ti-&gt;mmio);<br>
 			printk(", segment=%02X",segment);<br>
 		}<br>
 		printk(".\n");<br>
 	}<br>
 <br>
-	/* Get hw address of token ring card */<br>
+	dev-&gt;dev_addr[0] = 0;<br>
+	laa =  get_laa (dev);<br>
+	if (laa &amp;&amp; strlen (laa) &gt; 0) {<br>
+		char *p = laa;<br>
+		char *newp;<br>
+		int j;<br>
+		u8 laa_mac[6];<br>
+	  <br>
+		for (j=0; (*p &amp;&amp; (j&lt;6)); j++) {<br>
+			laa_mac[j] = simple_strtoul(p, &amp;newp, 16);<br>
+			if (*newp == '.') p=++newp; <br>
+			else {<br>
+				if (j &lt; 5) laa_mac[0] = 0; /* Not enough numbers */<br>
+				break;<br>
+			}<br>
+		}<br>
+	  <br>
+		if ((laa_mac[0] &gt;= 0x40) &amp;&amp; (laa_mac[0] &lt;= 0x7f)) {<br>
+			/* Valid LAA, use it */<br>
+			printk(KERN_DEBUG "%s: Using locally administered address %x.%x.%x.%x.%x.%x\n",<br>
+			       dev-&gt;name, laa_mac[0],laa_mac[1],laa_mac[2],<br>
+			       laa_mac[3], laa_mac[4],laa_mac[5]);<br>
+<br>
+			for (j=0; j &lt; 6;j++) <br>
+				dev-&gt;dev_addr[j] = laa_mac[j];<br>
+		} else <br>
+			printk(KERN_WARNING "%s: Invalid locally administered address %s\n", dev-&gt;name, laa);<br>
+	} <br>
+	if (!dev-&gt;dev_addr[0]) {<br>
+		/* Get hw address of token ring card */<br>
 #if !TR_NEWFORMAT<br>
-	DPRINTK("hw address: ");<br>
+		DPRINTK("hw address: ");<br>
 #endif<br>
-	j=0;<br>
-	for (i=0; i&lt;0x18; i=i+2) <br>
-	{<br>
-		/* technical reference states to do this */<br>
-		temp = readb(ti-&gt;mmio + AIP + i) &amp; 0x0f;<br>
-#if !TR_NEWFORMAT<br>
-		printk("%1X",ti-&gt;hw_address[j]=temp);<br>
-#else<br>
-		ti-&gt;hw_address[j]=temp;<br>
+		/* I misunderstood this piece of code first time I read it. <br>
+		   I hope it is clearer now. In any case it is shorter now. -- REW */<br>
+		for (j=0;j&lt;6;j++) {<br>
+			/* technical reference states that the upper 4 bits are <br>
+			   undefined. They are usually zero though. -- REW */<br>
+			dev-&gt;dev_addr[j] = ((readb(ti-&gt;mmio + AIP + j*4) &amp; 0x0f) &lt;&lt; 4) |<br>
+			                    (readb(ti-&gt;mmio + AIP + j*4 + 2) &amp; 0x0f);<br>
+#ifndef TR_NEWFORMAT<br>
+			printk("%02x", dev-&gt;dev_addr[j]);<br>
 #endif<br>
-		if(j&amp;1)<br>
-			dev-&gt;dev_addr[(j/2)]=ti-&gt;hw_address[j]+(ti-&gt;hw_address[j-1]&lt;&lt;4);<br>
-		++j;<br>
-	}<br>
+		}<br>
 #ifndef TR_NEWFORMAT<br>
-	printk("\n");<br>
+		printk("\n");<br>
 #endif<br>
+	}<br>
 <br>
 	/* get Adapter type:  'F' = Adapter/A, 'E' = 16/4 Adapter II,...*/<br>
 	ti-&gt;adapter_type = readb(ti-&gt;mmio + AIPADAPTYPE);<br>
@@ -1368,6 +1403,9 @@<br>
 	       ti-&gt;init_srb + offsetof(struct dir_open_adapter, command));<br>
 	writew(htons(OPEN_PASS_BCON_MAC),<br>
 	       ti-&gt;init_srb + offsetof(struct dir_open_adapter, open_options));<br>
+	for (i=0;i&lt;6;i++) <br>
+	  writeb (dev-&gt;dev_addr[i], <br>
+		  ti-&gt;init_srb + offsetof(struct dir_open_adapter, node_address) + i);<br>
 	if (ti-&gt;ring_speed == 16) {<br>
 		writew(htons(ti-&gt;dhb_size16mb),<br>
 		       ti-&gt;init_srb + offsetof(struct dir_open_adapter, dhb_length));<br>
@@ -1714,10 +1752,13 @@<br>
 static int io[IBMTR_MAX_ADAPTERS] = {0xa20,0xa24};<br>
 static int irq[IBMTR_MAX_ADAPTERS] = {0,0};<br>
 static int mem[IBMTR_MAX_ADAPTERS] = {0,0};<br>
+static char *laa[IBMTR_MAX_ADAPTERS] = {NULL, };   /* LAA parameter string */<br>
+<br>
 <br>
 MODULE_PARM(io, "1-" __MODULE_STRING(IBMTR_MAX_ADAPTERS) "i");<br>
 MODULE_PARM(irq, "1-" __MODULE_STRING(IBMTR_MAX_ADAPTERS) "i");<br>
 MODULE_PARM(mem, "1-" __MODULE_STRING(IBMTR_MAX_ADAPTERS) "i");<br>
+MODULE_PARM(laa, "1-" __MODULE_STRING(IBMTR_MAX_ADAPTERS) "s");<br>
 <br>
 int init_module(void)<br>
 {<br>
@@ -1763,4 +1804,26 @@<br>
 			 dev_ibmtr[i] = NULL;<br>
                 }<br>
 }<br>
+<br>
+<br>
+char *get_laa (struct device *dev)<br>
+{<br>
+  int i;<br>
+<br>
+  for (i=0;i&lt; IBMTR_MAX_ADAPTERS; i++)<br>
+    if (dev == dev_ibmtr[i]) {<br>
+      return laa[i];<br>
+    }<br>
+  printk (KERN_WARNING "ibmtr: Unexpected situation: Dev is not from dev_ibmtr.\n");<br>
+  return NULL;<br>
+}<br>
+<br>
+#else<br>
+<br>
+/* Not module: laa not supported. */<br>
+char *get_laa (struct device *dev)<br>
+{<br>
+  return NULL;<br>
+}<br>
+<br>
 #endif /* MODULE */<br>
<p>
<p>
<pre>
-- 
** <a href="mailto:R.E.Wolff@BitWizard.nl">R.E.Wolff@BitWizard.nl</a> ** <a href="http://www.BitWizard.nl/">http://www.BitWizard.nl/</a> ** +31-15-2137555 **
*-- BitWizard writes Linux device drivers for any device you may have! --*
------ Microsoft SELLS you Windows, Linux GIVES you the whole house ------
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0845.html">David S. Miller: "Re: Linux 2.2.* remote exploit fix"</a>
<li> <b>Previous message:</b> <a href="0843.html">Chris Evans: "2.3: acl's?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0842.html">Paul Norton: "IBMTR LAA support."</a>
<li> <b>Reply:</b> <a href="0842.html">Paul Norton: "IBMTR LAA support."</a>
<!-- reply="end" -->
</ul>
</font></body>
