<!-- received="Thu Jun  3 03:17:49 1999 EET DST" -->
<!-- sent="Wed, 2 Jun 1999 23:01:26 +0200" -->
<!-- name="Pavel Machek" -->
<!-- email="pavel@bug.ucw.cz" -->
<!-- subject="Capabilities for elf executables under Linux" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-22,: Capabilities for elf executables under Linux</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Capabilities for elf executables under Linux</h1>
<b>Pavel Machek</b> (<a href="mailto:pavel@bug.ucw.cz"><i>pavel@bug.ucw.cz</i></a>)<br>
<i>Wed, 2 Jun 1999 23:01:26 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#850">[ date ]</a><a href="index.html#850">[ thread ]</a><a href="subject.html#850">[ subject ]</a><a href="author.html#850">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0851.html">Stephen C. Tweedie: "Re: The pread/pwrite bug"</a>
<li> <b>Previous message:</b> <a href="0849.html">Alexander V. Lukyanov: "getting size of data in socket buffer"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi!<br>
<p>
This is next try with capabilities (improved docs, ported to<br>
2.3.4; should work ok with 2.2.9). Why do I think this is a good idea?<br>
<p>
* it immediately gives us better security: you can for example easily<br>
say "I want ping to run with CAP_NET_RAW raised, but nothing more",<br>
and it is possible even without ping being recompiled<br>
<p>
* it brings otherwise-unused capabilities mechanism into live, so that<br>
it can be tested and improved<br>
<p>
Yes, I know it is elf specific, but most setuid0 applications at your<br>
system are elf, anyways. I believe that even in future most<br>
priviledged applications will stay to be elf, and this will be<br>
preffered way for storing capabilities information on media like cdrom<br>
(where you want to keep iso9660 format).<br>
<p>
Also, I expect userland problems. [For example current dynamic linker<br>
will look if euid==ruid, and if they are equal, it will honour<br>
LD_PRELOAD. This would screw up capabilities system in big way.]<br>
Therefore it is probably good idea to start using capabilities _now_<br>
so that userland has more time (till end of 2.3 series) to find stupid<br>
problems.<br>
<p>
I believe this is very good now, and it will be usable even in future<br>
because iso9660-like formats are here to stay. Please apply,<br>
<p>
								Pavel<br>
<p>
--- /dev/null	Tue Jul 21 02:45:36 1998<br>
+++ linux/Documentation/capabilities.txt	Wed Jun  2 22:46:58 1999<br>
@@ -0,0 +1,52 @@<br>
+   <br>
+Elf capabilities hack<br>
+<br>
+   From now on, there's support for capabilities in elf executable. Elf<br>
+   executable now may contain "capabilities header", telling which<br>
+   capabilities should be dropped on exec. This can not hurt: lowering<br>
+   capabilities is not priviledged operation, and executable could do it<br>
+   itself at beggining of main.<br>
+   <br>
+   Doing it in exec() time has certain advantages, through: you can<br>
+   easily look and what capabilities are in use by what program and you<br>
+   can set capabilities for existing executables without need to<br>
+   recompile. (It is hard to create tool which insers elfcap header into<br>
+   elf file. But it has been done. Inserting code to drop capabilities on<br>
+   the beggining of main would be nightmare.)<br>
+   <br>
+   Notice that this system is very nice, but as described has limited<br>
+   use. It only lowers capabilities, and raising capabilities is what<br>
+   causes problems. (50% of security holes in unix are related to setuid0<br>
+   programs). But wait: elfcap can easily be used to limit damage done by<br>
+   setuid0 programs. It needs only little trick: ability to set euid back<br>
+   to ruid. By setuid0, process gets all capabilities, and elfcap is free<br>
+   to drop that capabilities it does not want.<br>
+   <br>
+   So, along with existing setuid mechanism, this hack can be used to<br>
+   grant subset of capabilities to executables. For example currently<br>
+   ping has to be setuid0. With elfcap, ping still will be setuid0, but<br>
+   most of its capabilities (and its euid) will be dropped at exec()<br>
+   time, so breaking into ping will allow attacker to generate arbitrary<br>
+   packets to network, but nothing more.<br>
+   <br>
+   Summary of what can elfcap do:<br>
+     * mask inheritable, permitted and effective sets by arbitrary mask<br>
+     * set euid back to ruid (effectivelly undoing result of setuid bit)<br>
+       Warning: using this feature with unpatched dynamic linker is<br>
+       security hole: current dynamic linker will test and if (euid==uid)<br>
+       will honour LD_PRELOAD, leaking capabilities to anyone.<br>
+     * set euid to arbitrary value if euid==0<br>
+       <br>
+   For more info &amp; utility programs, look at<br>
+   <a href="http://atrey.karlin.mff.cuni.cz/~pavel/elfcap.html">http://atrey.karlin.mff.cuni.cz/~pavel/elfcap.html</a>.<br>
+   <br>
+Bad idea<br>
+<br>
+   I should empatize that it is bad idea to give suid0 to any program<br>
+   just because you have capabilities. If program did not have suid0<br>
+   yesterday, it probably should not have suid0 today. (Think about<br>
+   booting old kernel, for example).<br>
+   <br>
+                                                        Pavel Machek<br>
+						       &lt;<a href="mailto:pavel@ucw.cz">pavel@ucw.cz</a>&gt;<br>
+				   <br>
\ No newline at end of file<br>
--- clean//fs/binfmt_elf.c	Wed Jun  2 14:10:26 1999<br>
+++ linux/fs/binfmt_elf.c	Wed Jun  2 11:36:41 1999<br>
@@ -7,6 +7,7 @@<br>
  * Tools".<br>
  *<br>
  * Copyright 1993, 1994: Eric Youngdale (<a href="mailto:ericy@cais.com">ericy@cais.com</a>).<br>
+ * Capabilities copyright 1999 Pavel Machek (<a href="mailto:pavel@ucw.cz">pavel@ucw.cz</a>).<br>
  */<br>
 <br>
 #include &lt;linux/module.h&gt;<br>
@@ -387,6 +388,26 @@<br>
 	return elf_entry;<br>
 }<br>
 <br>
+static void<br>
+restrict( struct linux_binprm * bprm, struct elf_capabilities *cap )<br>
+{<br>
+	if (cap-&gt;signature != 0xca5ab1e)<br>
+		return;<br>
+<br>
+	/* I do not check versions... That is because current version<br>
+           is 0 and I expect all changes to be backward - compabtible */<br>
+	if (cap-&gt;flags &amp; ECF_MAKE_EUID_UID) /* You may want to loose owner's uid */<br>
+		bprm-&gt;e_uid = current-&gt;uid;<br>
+	if ((!bprm-&gt;e_uid) &amp;&amp; (cap-&gt;flags &amp; ECF_MAKE_EUID_XUID))<br>
+		bprm-&gt;e_uid = cap-&gt;xuid; /* We only honour random uid changes for root */<br>
+	cap_mask( bprm-&gt;cap_effective, cap-&gt;effective );<br>
+	cap_mask( bprm-&gt;cap_permitted, cap-&gt;permitted );<br>
+	cap_mask( bprm-&gt;cap_inheritable, cap-&gt;inheritable );<br>
+<br>
+	printk( KERN_DEBUG "Now: uid = %d, effective = %x, permitted = %x, inheritable = %x\n", bprm-&gt;e_uid, bprm-&gt;cap_effective, bprm-&gt;cap_permitted, bprm-&gt;cap_inheritable );<br>
+}<br>
+<br>
+<br>
 /*<br>
  * These are the functions used to load ELF style executables and shared<br>
  * libraries.  There is no binary dependent code anywhere else.<br>
@@ -396,6 +417,7 @@<br>
 #define INTERPRETER_AOUT 1<br>
 #define INTERPRETER_ELF 2<br>
 <br>
+#define roundup(x, y)  ((((x)+((y)-1))/(y))*(y))<br>
 <br>
 static inline int<br>
 do_load_elf_binary(struct linux_binprm * bprm, struct pt_regs * regs)<br>
@@ -473,6 +498,22 @@<br>
 	end_data = 0;<br>
 <br>
 	for (i = 0; i &lt; elf_ex.e_phnum; i++) {<br>
+		if (elf_ppnt-&gt;p_type == PT_NOTE) {<br>
+			struct elf_capabilities_note note;<br>
+			int offset = elf_ppnt-&gt;p_offset;<br>
+			int maxoffset = offset + elf_ppnt-&gt;p_filesz;<br>
+<br>
+			while (offset &lt;= (maxoffset - sizeof(note))) {<br>
+				int retval;<br>
+				retval = read_exec(bprm-&gt;dentry, offset, (void *) &amp;note,<br>
+						   sizeof(note), 1);<br>
+				if (retval != sizeof(note))<br>
+					goto skip;<br>
+				if (note.note_signature == be32_to_cpu(0x43415053)) /* "CAPS" */<br>
+					restrict(bprm, &amp;note.cap);<br>
+				offset += sizeof(Elf32_Nhdr) + roundup(note.nhdr.n_namesz, 4) + roundup(note.nhdr.n_descsz, 4);<br>
+			}<br>
+		}<br>
 		if (elf_ppnt-&gt;p_type == PT_INTERP) {<br>
 			retval = -EINVAL;<br>
 		  	if (elf_interpreter)<br>
@@ -533,6 +574,7 @@<br>
 			interp_ex = *((struct exec *) bprm-&gt;buf);<br>
 			interp_elf_ex = *((struct elfhdr *) bprm-&gt;buf);<br>
 		}<br>
+	skip:<br>
 		elf_ppnt++;<br>
 	}<br>
 <br>
--- clean//include/linux/elf.h	Thu Jun 25 17:38:14 1998<br>
+++ linux/include/linux/elf.h	Tue May 18 22:34:21 1999<br>
@@ -496,6 +496,27 @@<br>
   Elf32_Word n_type;	/* Content type */<br>
 } Elf64_Nhdr;<br>
 <br>
+/* Capabilities support<br>
+ */<br>
+struct elf_capabilities {<br>
+  __u32 signature;<br>
+  __u32 version;	/* Currently 0; this is so that you can append on the end painlessly */<br>
+  __u32 flags;<br>
+#define ECF_MAKE_EUID_UID 1<br>
+#define ECF_MAKE_EUID_XUID 2<br>
+  __u32 xuid;	/* We want our set 128bit for future expansion */<br>
+  __u32 effective, effective1, effective2, effective3;<br>
+  __u32 permitted, permitted1, permitted2, permitted3;<br>
+  __u32 inheritable, inheritable1, inheritable2, inheritable3;<br>
+  __u32 known, known1, known2, known3;<br>
+};<br>
+<br>
+struct elf_capabilities_note {<br>
+  Elf32_Nhdr nhdr;<br>
+  __u32 note_signature;	/* == "CAPS" */ <br>
+  struct elf_capabilities cap;<br>
+};<br>
+<br>
 #if ELF_CLASS == ELFCLASS32<br>
 <br>
 extern Elf32_Dyn _DYNAMIC [];<br>
<p>
<pre>
-- 
I'm really <a href="mailto:pavel@ucw.cz">pavel@ucw.cz</a>. Look at <a href="http://195.113.31.123/~pavel">http://195.113.31.123/~pavel</a>.  Pavel
Hi! I'm a .signature virus! Copy me into your ~/.signature, please!
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0851.html">Stephen C. Tweedie: "Re: The pread/pwrite bug"</a>
<li> <b>Previous message:</b> <a href="0849.html">Alexander V. Lukyanov: "getting size of data in socket buffer"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
