<!-- received="Thu Jun  3 03:21:30 1999 EET DST" -->
<!-- sent="Wed, 2 Jun 1999 22:15:18 +0100 (BST)" -->
<!-- name="Stephen C. Tweedie" -->
<!-- email="sct@redhat.com" -->
<!-- subject="Re: The pread/pwrite bug" -->
<!-- id="" -->
<!-- inreplyto="199906021255.IAA28671@devserv.devel.redhat.com" -->
<title>Linux-kernel mailing list archive 1999-22,: Re: The pread/pwrite bug</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: The pread/pwrite bug</h1>
<b>Stephen C. Tweedie</b> (<a href="mailto:sct@redhat.com"><i>sct@redhat.com</i></a>)<br>
<i>Wed, 2 Jun 1999 22:15:18 +0100 (BST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#851">[ date ]</a><a href="index.html#851">[ thread ]</a><a href="subject.html#851">[ subject ]</a><a href="author.html#851">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0852.html">David Hinds: "Re: 2.3 wish: integrate pcmcia into mainstream kernel"</a>
<li> <b>Previous message:</b> <a href="0850.html">Pavel Machek: "Capabilities for elf executables under Linux"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi,<br>
<p>
On Wed, 2 Jun 1999 08:55:58 -0400 (EDT), Alan Cox &lt;<a href="mailto:alan@redhat.com">alan@redhat.com</a>&gt;<br>
said:<br>
<p>
<i>&gt;&gt; Well guys, looks like it still isn't working,  The server is much slower</i><br>
<i>&gt;&gt; with the patch and not only throws off Typhoon, but locks it up solid to</i><br>
<i>&gt;&gt; require a power cycle.  Any other Ideas as to where to go now?</i><br>
<p>
<i>&gt; Where does it lock up - what does right-alt-scroll-lock show as the EIP</i><br>
<i>&gt; if you hit it a few times when th ebox seems hung</i><br>
<p>
And which kernel are you using?  We have other problem reports with<br>
2.2.9, still unresolved.  If you could try the same patch against<br>
2.2.5 or 2.2.7, that would help to narrow things down.<br>
<p>
I have a parallel kernel build running in conjunction with the<br>
pread/pwrite stress running on a 32MB 4-waySMP setup right now with no<br>
apparent problems and no buffer leaks/lockups, using straight<br>
2.2.10-pre2.  [update: the runs have now completed twice without any<br>
sign of fault.]  The 2.2.9 corruption bug is definitely fixed, and<br>
performance appears unaffected.<br>
<p>
However, in case there is a problem with the patch, the diff below<br>
backs out the more complex part of the fix and replaces it with a cure<br>
just for the update_vm_cache() part of the fix.  It does not cure the<br>
bug concerning the race during copy_from_user, but it should fix the<br>
Typhoon bug in the simplest manner possible, just by moving the<br>
mark_buffer_uptodate() to before the update_vm_cache() in<br>
ext2_file_write.  I won't be able to test anything for the next week<br>
or so as I'll be away for Usenix, so feel free to try both variants of<br>
the fix.  I'll be online to respond to any experiences you have,<br>
though.<br>
<p>
--Stephen<br>
<p>
----------------------------------------------------------------<br>
--- fs/ext2/file.c.~1~	Wed Jun  2 18:49:50 1999<br>
+++ fs/ext2/file.c	Wed Jun  2 18:50:52 1999<br>
@@ -162,7 +162,7 @@<br>
 	struct buffer_head * bh, *bufferlist[NBUF];<br>
 	struct super_block * sb;<br>
 	int err;<br>
-	int i,buffercount,write_error, new_buffer;<br>
+	int i,buffercount,write_error;<br>
 <br>
 	/* POSIX: mtime/ctime may not change for 0 count */<br>
 	if (!count)<br>
@@ -247,53 +247,24 @@<br>
 		}<br>
 		if (c &gt; count)<br>
 			c = count;<br>
-<br>
-		/* Tricky: what happens if we are writing the complete<br>
-		 * contents of a block which is not currently<br>
-		 * initialised?  We have to obey the same<br>
-		 * synchronisation rules as the IO code, to prevent some<br>
-		 * other process from stomping on the buffer contents by<br>
-		 * refreshing them from disk while we are setting up the<br>
-		 * buffer.  The copy_from_user() can page fault, after<br>
-		 * all.  We also have to throw away partially successful<br>
-		 * copy_from_users to such buffers, since we can't trust<br>
-		 * the rest of the buffer_head in that case.  --sct */<br>
-<br>
-		new_buffer = (!buffer_uptodate(bh) &amp;&amp; !buffer_locked(bh) &amp;&amp;<br>
-			      c == sb-&gt;s_blocksize);<br>
-<br>
-		if (new_buffer) {<br>
-			set_bit(BH_Lock, &amp;bh-&gt;b_state);<br>
-			c -= copy_from_user (bh-&gt;b_data + offset, buf, c);<br>
-			if (c != sb-&gt;s_blocksize) {<br>
-				c = 0;<br>
-				unlock_buffer(bh);<br>
-				brelse(bh);<br>
+		if (c != sb-&gt;s_blocksize &amp;&amp; !buffer_uptodate(bh)) {<br>
+			ll_rw_block (READ, 1, &amp;bh);<br>
+			wait_on_buffer (bh);<br>
+			if (!buffer_uptodate(bh)) {<br>
+				brelse (bh);<br>
 				if (!written)<br>
-					written = -EFAULT;<br>
+					written = -EIO;<br>
 				break;<br>
 			}<br>
-			mark_buffer_uptodate(bh, 1);<br>
-			unlock_buffer(bh);<br>
-		} else {<br>
-			if (!buffer_uptodate(bh)) {<br>
-				ll_rw_block (READ, 1, &amp;bh);<br>
-				wait_on_buffer (bh);<br>
-				if (!buffer_uptodate(bh)) {<br>
-					brelse (bh);<br>
-					if (!written)<br>
-						written = -EIO;<br>
-					break;<br>
-				}<br>
-			}<br>
-			c -= copy_from_user (bh-&gt;b_data + offset, buf, c);<br>
 		}<br>
+		c -= copy_from_user (bh-&gt;b_data + offset, buf, c);<br>
 		if (!c) {<br>
 			brelse(bh);<br>
 			if (!written)<br>
 				written = -EFAULT;<br>
 			break;<br>
 		}<br>
+		mark_buffer_uptodate(bh, 1);<br>
 		mark_buffer_dirty(bh, 0);<br>
 		update_vm_cache(inode, pos, bh-&gt;b_data + offset, c);<br>
 		pos += c;<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0852.html">David Hinds: "Re: 2.3 wish: integrate pcmcia into mainstream kernel"</a>
<li> <b>Previous message:</b> <a href="0850.html">Pavel Machek: "Capabilities for elf executables under Linux"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
