<!-- received="Fri Jun  4 21:43:32 1999 EET DST" -->
<!-- sent="Fri, 4 Jun 1999 12:59:20 -0500" -->
<!-- name="Andy Sloane" -->
<!-- email="andy@guildsoftware.com" -->
<!-- subject="[patch] ESS 1869, 1879, 1887, 1888 sound fix" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-22,: [patch] ESS 1869, 1879, 1887, 1888 sound fix</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] ESS 1869, 1879, 1887, 1888 sound fix</h1>
<b>Andy Sloane</b> (<a href="mailto:andy@guildsoftware.com"><i>andy@guildsoftware.com</i></a>)<br>
<i>Fri, 4 Jun 1999 12:59:20 -0500</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1271">[ date ]</a><a href="index.html#1271">[ thread ]</a><a href="subject.html#1271">[ subject ]</a><a href="author.html#1271">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1272.html">Arjan van de Ven: "[patch] Exported some extra symbols for modules"</a>
<li> <b>Previous message:</b> <a href="1270.html">David Hinds: "Re: 2.3 wish: integrate pcmcia into mainstream kernel"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--1yeeQ81UyVL57Vl7<br>
Content-Type: text/plain; charset=us-ascii<br>
<p>
I looked at the ALSA code to figure out the problem with the linux 2.2 ESS<br>
driver, and this is what I came up with.  I also added support for the<br>
ESS1879 (which was previously unrecognized by the driver) which is present<br>
in VAIO notebooks.  Additionally I enabled autodetection by default since<br>
the failure of autodetection to work is less likely than the failure of the<br>
driver to set the correct rate without it.  At least, that's the way it<br>
seems to me.<br>
<p>
Those with ESS chips, please try this out.  I only tested it on my ESS1869<br>
(works for 11kHz as well as 22kHz as well as 44kHz) and a friend's ESS1879<br>
on his VAIO.<br>
<p>
-Andy.<br>
<p>
<p>
--1yeeQ81UyVL57Vl7<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Disposition: attachment; filename="ess-speed.aas.patch"<br>
<p>
--- drivers/sound/sb_ess.c.orig	Fri Jun  4 12:30:16 1999<br>
+++ drivers/sound/sb_ess.c	Fri Jun  4 12:57:52 1999<br>
@@ -40,6 +40,10 @@<br>
  *								recording problems for high samplerates. I<br>
  *								fixed this by removing ess_calc_best_speed ()<br>
  *								and just doing what the documentation says. <br>
+ * Andy Sloane  (June 4 1999):  Stole some code from ALSA to fix the playback<br>
+ * <a href="mailto:andy@guildsoftware.com">andy@guildsoftware.com</a>		speed on ES1869, ES1879, ES1887, and ES1888.<br>
+ * 								1879's were previously ignored by this driver;<br>
+ * 								added (untested) support for those.<br>
  *<br>
  * This files contains ESS chip specifics. It's based on the existing ESS<br>
  * handling as it resided in sb_common.c, sb_mixer.c and sb_audio.c. This<br>
@@ -190,15 +194,23 @@<br>
 #define ESSTYPE_LIKE20	-1		/* Mimic 2.0 behaviour					*/<br>
 #define ESSTYPE_DETECT	0		/* Mimic 2.0 behaviour					*/<br>
 <br>
-int esstype = ESSTYPE_LIKE20; /* module parameter in sb_card.c */<br>
+int esstype = ESSTYPE_DETECT; /* module parameter in sb_card.c */<br>
 <br>
 #define SUBMDL_ES1788	0x10	/* Subtype ES1788 for specific handling */<br>
 #define SUBMDL_ES1868	0x11	/* Subtype ES1868 for specific handling */<br>
 #define SUBMDL_ES1869	0x12	/* Subtype ES1869 for specific handling */<br>
 #define SUBMDL_ES1878	0x13	/* Subtype ES1878 for specific handling */<br>
+#define SUBMDL_ES1879	0x16    /* ES1879 was initially forgotten */<br>
 #define SUBMDL_ES1887	0x14	/* Subtype ES1887 for specific handling */<br>
 #define SUBMDL_ES1888	0x15	/* Subtype ES1888 for specific handling */<br>
 <br>
+#define SB_CAP_ES18XX_RATE 0x100<br>
+<br>
+#define ES1688_CLOCK1 795444 /* 128 - div */<br>
+#define ES1688_CLOCK2 397722 /* 256 - div */<br>
+#define ES18XX_CLOCK1 793800 /* 128 - div */<br>
+#define ES18XX_CLOCK2 768000 /* 256 - div */<br>
+<br>
 #ifdef FKS_LOGGING<br>
 static void ess_show_mixerregs (sb_devc *devc);<br>
 #endif<br>
@@ -323,7 +335,6 @@<br>
 	return retval;<br>
 }<br>
 <br>
-#ifdef OBSOLETE<br>
 static int ess_calc_best_speed<br>
 	(int clock1, int rev1, int clock2, int rev2, int *divp, int *speedp)<br>
 {<br>
@@ -347,7 +358,6 @@<br>
 <br>
 	return retval;<br>
 }<br>
-#endif<br>
 <br>
 /*<br>
  * Depending on the audiochannel ESS devices can<br>
@@ -366,11 +376,14 @@<br>
 		 * The 0x80 is important for the first audio channel<br>
 		 */<br>
 		div = 0x80 | ess_calc_div (795500, 128, speedp, &amp;diff);<br>
+	} else if(devc-&gt;caps &amp; SB_CAP_ES18XX_RATE) {<br>
+		ess_calc_best_speed(ES18XX_CLOCK1, 128, ES18XX_CLOCK2, 256, <br>
+						&amp;div, speedp);<br>
 	} else {<br>
 		if (*speedp &gt; 22000) {<br>
-			div = 0x80 | ess_calc_div (795500, 256, speedp, &amp;diff);<br>
+			div = 0x80 | ess_calc_div (ES1688_CLOCK1, 256, speedp, &amp;diff);<br>
 		} else {<br>
-			div = 0x00 | ess_calc_div (397700, 128, speedp, &amp;diff);<br>
+			div = 0x00 | ess_calc_div (ES1688_CLOCK2, 128, speedp, &amp;diff);<br>
 		}<br>
 	}<br>
 	*divp = div;<br>
@@ -1070,6 +1083,12 @@<br>
 		case 1788:<br>
 			submodel = SUBMDL_ES1788;<br>
 			break;<br>
+		case 1878:<br>
+			submodel = SUBMDL_ES1878;<br>
+			break;<br>
+		case 1879:<br>
+			submodel = SUBMDL_ES1879;<br>
+			break;<br>
 		case 1887:<br>
 			submodel = SUBMDL_ES1887;<br>
 			break;<br>
@@ -1117,6 +1136,10 @@<br>
 				chip = "ES1878";<br>
 				devc-&gt;submodel = SUBMDL_ES1878;<br>
 				break;<br>
+			case 0x1879:<br>
+				chip = "ES1879";<br>
+				devc-&gt;submodel = SUBMDL_ES1879;<br>
+				break;<br>
 			default:<br>
 				if ((type &amp; 0x00ff) != ((type &gt;&gt; 8) &amp; 0x00ff)) {<br>
 					printk ("ess_init: Unrecognized %04x\n", type);<br>
@@ -1173,6 +1196,15 @@<br>
 		sprintf(name,"ESS %s AudioDrive (rev %d)", chip, ess_minor &amp; 0x0f);<br>
 	} else {<br>
 		strcpy(name, "Jazz16");<br>
+	}<br>
+<br>
+	/* AAS: info stolen from ALSA: these boards have different clocks */<br>
+	switch(devc-&gt;submodel) {<br>
+		case SUBMDL_ES1869:<br>
+		case SUBMDL_ES1887:<br>
+		case SUBMDL_ES1888:<br>
+			devc-&gt;caps |= SB_CAP_ES18XX_RATE;<br>
+			break;<br>
 	}<br>
 <br>
 	hw_config-&gt;name = name;<br>
<p>
--1yeeQ81UyVL57Vl7--<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1272.html">Arjan van de Ven: "[patch] Exported some extra symbols for modules"</a>
<li> <b>Previous message:</b> <a href="1270.html">David Hinds: "Re: 2.3 wish: integrate pcmcia into mainstream kernel"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
