<!-- received="Fri Jun  4 21:46:11 1999 EET DST" -->
<!-- sent="Fri, 4 Jun 1999 20:29:25 +0200 (CEST)" -->
<!-- name="Arjan van de Ven" -->
<!-- email="arjan@fenrus.demon.nl" -->
<!-- subject="[patch] Exported some extra symbols for modules" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-22,: [patch] Exported some extra symbols for modules</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] Exported some extra symbols for modules</h1>
<b>Arjan van de Ven</b> (<a href="mailto:arjan@fenrus.demon.nl"><i>arjan@fenrus.demon.nl</i></a>)<br>
<i>Fri, 4 Jun 1999 20:29:25 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1272">[ date ]</a><a href="index.html#1272">[ thread ]</a><a href="subject.html#1272">[ subject ]</a><a href="author.html#1272">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1273.html">Artur Skawina: "Re: Linux/i386 fastcall support"</a>
<li> <b>Previous message:</b> <a href="1271.html">Andy Sloane: "[patch] ESS 1869, 1879, 1887, 1888 sound fix"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1290.html">David S. Miller: "Re: [patch] Exported some extra symbols for modules"</a>
<li> <b>Reply:</b> <a href="1290.html">David S. Miller: "Re: [patch] Exported some extra symbols for modules"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi,<br>
<p>
This patch exports the symbols (patch agains 2.2.9 at the end of the<br>
message)<br>
<p>
do_generic_file_read<br>
tcp_reset_xmit_timer<br>
tcp_write_xmit<br>
<p>
for modules. I need "do_generic_file_read" to build my own "sendfile from <br>
struct file to struct socket". The later two are for a module-version of<br>
"TCP_CORK". Using these symbols increases the number of<br>
http-requests/second by over 20% (to over 1400 for 1K files, 900 for 8K<br>
files; this is more than the C'T guy benchmarked for a quad Xeon<br>
machine using NT; I use only a K6-2 350Mhz).<br>
<p>
One more question:<br>
<p>
"sendfile" holds the global kernel-lock. Is it possible to remove this<br>
somehow? <br>
<p>
Greetings,<br>
  Arjan van de Ven<br>
<p>
<p>
diff -u -r linux/include/linux/fs.h /nfs/usr/src/linux/include/linux/fs.h<br>
--- linux/include/linux/fs.h	Sun Jun  6 00:42:16 1999<br>
+++ /nfs/usr/src/linux/include/linux/fs.h	Sun May 30 10:05:49 1999<br>
@@ -822,6 +824,17 @@<br>
 #define LOOKUP_SLASHOK		(4)<br>
 #define LOOKUP_CONTINUE		(8)<br>
 <br>
+<br>
+typedef struct {<br>
+	size_t written;<br>
+	size_t count;<br>
+	char * buf;<br>
+	int error;<br>
+} read_descriptor_t;<br>
+<br>
+typedef int (*read_actor_t)(read_descriptor_t *, const char *, unsigned long);<br>
+<br>
+<br>
 extern struct dentry * lookup_dentry(const char *, struct dentry *, unsigned int);<br>
 extern struct dentry * __namei(const char *, unsigned int);<br>
 <br>
@@ -865,6 +878,8 @@<br>
 extern int generic_file_mmap(struct file *, struct vm_area_struct *);<br>
 extern ssize_t generic_file_read(struct file *, char *, size_t, loff_t *);<br>
 extern ssize_t generic_file_write(struct file *, const char*, size_t, loff_t*);<br>
+extern void do_generic_file_read(struct file * filp, loff_t *ppos, read_descriptor_t * desc, read_actor_t actor);<br>
+<br>
 <br>
 extern struct super_block *get_super(kdev_t dev);<br>
 extern void put_super(kdev_t dev);<br>
diff -u -r linux/kernel/ksyms.c /nfs/usr/src/linux/kernel/ksyms.c<br>
--- linux/kernel/ksyms.c	Sun Jun  6 00:41:19 1999<br>
+++ /nfs/usr/src/linux/kernel/ksyms.c	Sun May 30 10:03:21 1999<br>
@@ -162,6 +162,7 @@<br>
 EXPORT_SYMBOL(mark_buffer_uptodate);<br>
 EXPORT_SYMBOL(add_blkdev_randomness);<br>
 EXPORT_SYMBOL(generic_file_read);<br>
+EXPORT_SYMBOL(do_generic_file_read);<br>
 EXPORT_SYMBOL(generic_file_write);<br>
 EXPORT_SYMBOL(generic_file_mmap);<br>
 EXPORT_SYMBOL(generic_readpage);<br>
diff -u -r linux/mm/filemap.c /nfs/usr/src/linux/mm/filemap.c<br>
--- linux/mm/filemap.c	Sun Jun  6 00:42:16 1999<br>
+++ /nfs/usr/src/linux/mm/filemap.c	Sun May 30 10:07:54 1999<br>
@@ -556,14 +556,6 @@<br>
  * The simplest case just copies the data to user<br>
  * mode.<br>
  */<br>
-typedef struct {<br>
-	size_t written;<br>
-	size_t count;<br>
-	char * buf;<br>
-	int error;<br>
-} read_descriptor_t;<br>
-<br>
-typedef int (*read_actor_t)(read_descriptor_t *, const char *, unsigned long);<br>
 <br>
 /*<br>
  * This is a generic file read routine, and uses the<br>
@@ -573,7 +565,7 @@<br>
  * This is really ugly. But the goto's actually try to clarify some<br>
  * of the logic when it comes to error handling etc.<br>
  */<br>
-static void do_generic_file_read(struct file * filp, loff_t *ppos, read_descriptor_t * desc, read_actor_t actor)<br>
+void do_generic_file_read(struct file * filp, loff_t *ppos, read_descriptor_t * desc, read_actor_t actor)<br>
 {<br>
 	struct dentry *dentry = filp-&gt;f_dentry;<br>
 	struct inode *inode = dentry-&gt;d_inode;<br>
@@ -1726,3 +1718,4 @@<br>
 		}<br>
 	}<br>
 }<br>
+<br>
diff -u -r linux/net/netsyms.c /nfs/usr/src/linux/net/netsyms.c<br>
--- linux/net/netsyms.c	Sun Jun  6 00:41:57 1999<br>
+++ /nfs/usr/src/linux/net/netsyms.c	Thu Jun  3 18:30:33 1999<br>
@@ -224,6 +224,8 @@<br>
 <br>
 #ifdef CONFIG_INET<br>
 /* Internet layer registration */<br>
+EXPORT_SYMBOL(tcp_reset_xmit_timer);<br>
+EXPORT_SYMBOL(tcp_write_xmit);<br>
 EXPORT_SYMBOL(inet_add_protocol);<br>
 EXPORT_SYMBOL(inet_del_protocol);<br>
 EXPORT_SYMBOL(rarp_ioctl_hook);<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1273.html">Artur Skawina: "Re: Linux/i386 fastcall support"</a>
<li> <b>Previous message:</b> <a href="1271.html">Andy Sloane: "[patch] ESS 1869, 1879, 1887, 1888 sound fix"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1290.html">David S. Miller: "Re: [patch] Exported some extra symbols for modules"</a>
<li> <b>Reply:</b> <a href="1290.html">David S. Miller: "Re: [patch] Exported some extra symbols for modules"</a>
<!-- reply="end" -->
</ul>
</font></body>
