<!-- received="Sat Jun  5 12:03:31 1999 EET DST" -->
<!-- sent="Sat, 5 Jun 1999 12:00:08 +0300" -->
<!-- name="Nimrod Zimerman" -->
<!-- email="zimerman@deskmail.com" -->
<!-- subject="[PATCH] Re: sound and control-c" -->
<!-- id="" -->
<!-- inreplyto="19990601170549.17804@cs.mcgill.ca" -->
<title>Linux-kernel mailing list archive 1999-22,: [PATCH] Re: sound and control-c</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] Re: sound and control-c</h1>
<b>Nimrod Zimerman</b> (<a href="mailto:zimerman@deskmail.com"><i>zimerman@deskmail.com</i></a>)<br>
<i>Sat, 5 Jun 1999 12:00:08 +0300</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1356">[ date ]</a><a href="index.html#1356">[ thread ]</a><a href="subject.html#1356">[ subject ]</a><a href="author.html#1356">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1357.html">Matthew Kirkwood: "Re: Xerox and Lexmark printers (was Re: linux 2.x kernel lp.c and parport.c bug)"</a>
<li> <b>Previous message:</b> <a href="1355.html">Albert D. Cahalan: "Re: 2.3 wish: integrate pcmcia into mainstream kernel"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Tue, Jun 01, 1999 at 05:05:49PM -0400, Navindra Umanee wrote:<br>
<p>
[I CC this to Alan because it is, in a way, sound related, and I couldn't<br>
find anyone maintaining signal handling...]<br>
<p>
<i>&gt; I've noticed that the problem also occurs with the wavplay and</i><br>
<i>&gt; playmidi programs (and probably others).  I just gave 'cat' as the</i><br>
<i>&gt; simplest example...</i><br>
<i>&gt; </i><br>
<i>&gt; &gt; Maybe this is a non-issue, hence. When I get some time, I'll take a look</i><br>
<i>&gt; &gt; again.</i><br>
<p>
Okay. I had some time (actually, that's a lie. I don't have any time. I just<br>
decided to postpone something else), so I decided to figure out what's wrong<br>
with ctrl-c and sound. Here are my results.<br>
<p>
Stopping pending sound with the same signal that caused the writing program<br>
to terminate - doesn't work. For example, when playing sound with<br>
'cat soundfile.wav &gt; /dev/dsp', and using SIGKILL to kill it, another<br>
SIGKILL wouldn't stop the pending sound. Some other signal would.<br>
<p>
This happens due to the following bit of code<br>
(linux/arch/i386/kernel/signal.c:do_signal() - and applies to other arches<br>
quite equally):<br>
<p>
         default:<br>
            lock_kernel();<br>
            sigaddset(&amp;current-&gt;signal, signr);<br>
            current-&gt;flags |= PF_SIGNALED;<br>
            do_exit(exit_code);<br>
            /* NOTREACHED */<br>
<p>
This is executed when a signal is sent to a process, such that the signal is<br>
supposed to kill the process (like, a signal that isn't captured).<br>
<p>
What happens is that the pending signal is added back to the signal set<br>
(it was previously removed, when the processing started). However, the<br>
sigpending bit of the task isn't updated. This simply means that this signal<br>
can have no effect from this point on, unless some other signal is sent.<br>
<p>
The patch below applies on 2.2.9 (and probably on mostly anything else). One<br>
line. Works fine here (I've been running with it for the past few hours).<br>
If this seems to be the correct thing to do, it should probably be added for<br>
the other arches too.<br>
<p>
<p>
--- linux/arch/i386/kernel/signal.c.ORIG	Tue Dec  1 21:28:24 1998<br>
+++ linux/arch/i386/kernel/signal.c	Sat Jun  5 11:44:02 1999<br>
@@ -698,6 +698,7 @@<br>
 			default:<br>
 				lock_kernel();<br>
 				sigaddset(&amp;current-&gt;signal, signr);<br>
+				recalc_sigpending(current);<br>
 				current-&gt;flags |= PF_SIGNALED;<br>
 				do_exit(exit_code);<br>
 				/* NOTREACHED */<br>
<p>
<p>
<p>
                                                   Nimrod<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1357.html">Matthew Kirkwood: "Re: Xerox and Lexmark printers (was Re: linux 2.x kernel lp.c and parport.c bug)"</a>
<li> <b>Previous message:</b> <a href="1355.html">Albert D. Cahalan: "Re: 2.3 wish: integrate pcmcia into mainstream kernel"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
