<!-- received="Sat Jun  5 17:07:15 1999 EET DST" -->
<!-- sent="Sat, 5 Jun 1999 16:03:57 +0200" -->
<!-- name="Jamie Lokier" -->
<!-- email="jamie.lokier@cern.ch" -->
<!-- subject="[PATCH] speedup for directory tree traversals" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-22,: [PATCH] speedup for directory tree traversals</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] speedup for directory tree traversals</h1>
<b>Jamie Lokier</b> (<a href="mailto:jamie.lokier@cern.ch"><i>jamie.lokier@cern.ch</i></a>)<br>
<i>Sat, 5 Jun 1999 16:03:57 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1370">[ date ]</a><a href="index.html#1370">[ thread ]</a><a href="subject.html#1370">[ subject ]</a><a href="author.html#1370">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1371.html">Alan Cox: "Re: [PATCH] 3DSE support for AWE sound cards"</a>
<li> <b>Previous message:</b> <a href="1369.html">Stanislav V. Voronyi: "[PATCH] 3DSE support for AWE sound cards"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Dear Linus,<br>
<p>
  Here's a patch that speeds up programs that recurse over directory<br>
  trees, by removing redundant I/O and reducing inode cache flushing.<br>
  Only subdirectory inodes get read, usually a very small subset of the<br>
  ones we read now.<br>
<p>
  The trick is to avoid reading inodes when opening a non-directory with<br>
  O_DIRECTORY set.  It's similar to the effect of the BSD's<br>
  `dirent-&gt;d_type' field.  Using that, you can see when you can skip<br>
  stat()ing an entry.<br>
<p>
  But this is better because it doesn't need a new API.  Simply try to<br>
  open each entry using opendir().  Glibc's opendir() always sets<br>
  O_DIRECTORY, and opendir() is specified to refuse to open<br>
  non-directories.<br>
<p>
  For this use it's also more effective than d_type.  Conceivably, some<br>
  filesystem would know if a directory entry is a subdirectory or not,<br>
  but that's all.  So it would set d_type to DT_UNKNOWN in the<br>
  non-directory case, which the application must assume _might_ be a<br>
  directory...<br>
<p>
  Implementation: When looking up the last component of a path with<br>
  O_DIRECTORY explicitly requested, set some flags in the dentry passed to<br>
  lookup.  This is safe and keeps the VFS interface the same.  On seeing<br>
  the flags, fs-specific lookup() may choose to return -ENOTDIR for<br>
  non-directory lookups.  +Quirks for symlinks.<br>
<p>
  I've implemented the fs-specifics for msdos and ext2.  vfat is hairier<br>
  and I thought it'd tread on Alex Viro's toes.  Unfortunately the<br>
  FILETYPE feature of ext2 is not widely deployed (I'm a bit<br>
  disappointed), but it does work and gives a significant speedup with<br>
  some directory structures.  I haven't measured traversing a large<br>
  filesystem because I don't have one handy.<br>
<p>
have a nice day,<br>
-- Jamie<br>
<p>
diff -u linux-2.2.9/fs/ext2/namei.c.diropt linux-2.2/fs/ext2/namei.c<br>
--- linux-2.2.9/fs/ext2/namei.c.diropt	Wed May 12 00:17:11 1999<br>
+++ linux-2.2.9/fs/ext2/namei.c	Sat Jun  5 15:13:34 1999<br>
@@ -168,6 +168,7 @@<br>
 <br>
 struct dentry *ext2_lookup(struct inode * dir, struct dentry *dentry)<br>
 {<br>
+	unsigned long ino;<br>
 	struct inode * inode;<br>
 	struct ext2_dir_entry_2 * de;<br>
 	struct buffer_head * bh;<br>
@@ -178,10 +179,19 @@<br>
 	bh = ext2_find_entry (dir, dentry-&gt;d_name.name, dentry-&gt;d_name.len, &amp;de);<br>
 	inode = NULL;<br>
 	if (bh) {<br>
-		unsigned long ino = le32_to_cpu(de-&gt;inode);<br>
+		/* Optimise away iget() when we want a directory. */<br>
+		if ((dentry-&gt;d_flags &amp; DCACHE_LOOKUP_DIR)<br>
+		    &amp;&amp; de-&gt;file_type != EXT2_FT_DIR<br>
+		    &amp;&amp; de-&gt;file_type != EXT2_FT_UNKNOWN<br>
+		    &amp;&amp; (de-&gt;file_type != EXT2_FT_SYMLINK<br>
+			|| !(dentry-&gt;d_flags &amp; DCACHE_LOOKUP_SYMLINK))) {<br>
+			brelse (bh);<br>
+			return ERR_PTR(-ENOTDIR);<br>
+		}<br>
+<br>
+		ino = le32_to_cpu(de-&gt;inode);<br>
 		brelse (bh);<br>
 		inode = iget(dir-&gt;i_sb, ino);<br>
-<br>
 		if (!inode)<br>
 			return ERR_PTR(-EACCES);<br>
 	}<br>
diff -u linux-2.2.9/fs/msdos/namei.c.diropt linux-2.2/fs/msdos/namei.c<br>
--- linux-2.2.9/fs/msdos/namei.c.diropt	Wed Apr 28 22:41:44 1999<br>
+++ linux-2.2.9/fs/msdos/namei.c	Sat Jun  5 15:08:45 1999<br>
@@ -269,8 +269,16 @@<br>
 		goto add;<br>
 	if (res &lt; 0)<br>
 		goto out;<br>
-	if (bh)<br>
+	if (bh) {<br>
+		/* Optimise away iget() when we want a directory. */<br>
+		if ((dentry-&gt;d_flags &amp; DCACHE_LOOKUP_DIR)<br>
+		    &amp;&amp; !((de-&gt;attr &amp; ATTR_DIR) &amp;&amp; !IS_FREE(de-&gt;name))) {<br>
+			fat_brelse(sb, bh);<br>
+			res = -ENOTDIR;<br>
+			goto out;		<br>
+		}<br>
 		fat_brelse(sb, bh);<br>
+	}<br>
 <br>
 	/* try to get the inode */<br>
 	res = -EACCES;<br>
diff -u linux-2.2.9/fs/namei.c.diropt linux-2.2/fs/namei.c<br>
--- linux-2.2.9/fs/namei.c.diropt	Wed May 12 00:17:11 1999<br>
+++ linux-2.2.9/fs/namei.c	Sat Jun  5 12:35:19 1999<br>
@@ -251,6 +251,20 @@<br>
 		struct dentry * dentry = d_alloc(parent, name);<br>
 		result = ERR_PTR(-ENOMEM);<br>
 		if (dentry) {<br>
+			/*<br>
+			 * Try not to read non-directory inodes for the final<br>
+			 * component of an explicit O_DIRECTORY lookup.  Don't<br>
+			 * do this optimisation for intermediate components --<br>
+			 * those lookups tend to repeat so it's faster to cache<br>
+			 * the result than repeatedly call lookup().<br>
+			 */<br>
+			if ((flags &amp; (LOOKUP_O_DIRECTORY | LOOKUP_CONTINUE))<br>
+			    == LOOKUP_O_DIRECTORY) {<br>
+				dentry-&gt;d_flags |= DCACHE_LOOKUP_DIR;<br>
+				if (flags &amp; LOOKUP_FOLLOW)<br>
+					dentry-&gt;d_flags |= DCACHE_LOOKUP_SYMLINK;<br>
+			}<br>
+<br>
 			result = dir-&gt;i_op-&gt;lookup(dir, dentry);<br>
 			if (result)<br>
 				dput(dentry);<br>
@@ -324,7 +338,8 @@<br>
 		goto return_base;<br>
 <br>
 	inode = base-&gt;d_inode;<br>
-	lookup_flags &amp;= LOOKUP_FOLLOW | LOOKUP_DIRECTORY | LOOKUP_SLASHOK;<br>
+	lookup_flags &amp;= (LOOKUP_FOLLOW | LOOKUP_DIRECTORY | LOOKUP_SLASHOK<br>
+			 | LOOKUP_O_DIRECTORY);<br>
 <br>
 	/* At this point we know we have a real path component. */<br>
 	for(;;) {<br>
@@ -628,7 +643,7 @@<br>
 		retval &amp;= ~LOOKUP_FOLLOW;<br>
 	<br>
 	if (f &amp; O_DIRECTORY)<br>
-		retval |= LOOKUP_DIRECTORY;<br>
+		retval |= LOOKUP_DIRECTORY | LOOKUP_O_DIRECTORY;<br>
 	<br>
 	return retval;<br>
 }<br>
diff -u linux-2.2.9/include/linux/dcache.h.diropt linux-2.2/include/linux/dcache.h<br>
--- linux-2.2.9/include/linux/dcache.h.diropt	Wed May 12 00:17:13 1999<br>
+++ linux-2.2.9/include/linux/dcache.h	Wed May 12 00:17:13 1999<br>
@@ -100,6 +100,15 @@<br>
 					 * renamed" and has to be<br>
 					 * deleted on the last dput()<br>
 					 */<br>
+#define DCACHE_LOOKUP_DIR     0x0004	/* during fs lookup(): "if you find a<br>
+					 * non-directory, you may return<br>
+					 * -ENOTDIR instead of reading the<br>
+					 * inode" (ignored at other times)<br>
+					 */<br>
+#define DCACHE_LOOKUP_SYMLINK 0x0008	/* modifies above: "if you find a<br>
+					 * non-directory that is also not a<br>
+					 * symbolic link..."<br>
+					 */<br>
 <br>
 /*<br>
  * d_drop() unhashes the entry from the parent<br>
diff -u linux-2.2.9/include/linux/fs.h.diropt linux-2.2/include/linux/fs.h<br>
--- linux-2.2.9/include/linux/fs.h.diropt	Tue May 18 11:11:33 1999<br>
+++ linux-2.2.9/include/linux/fs.h	Tue May 18 11:11:33 1999<br>
@@ -815,12 +815,14 @@<br>
  *  - follow links at the end<br>
  *  - require a directory<br>
  *  - ending slashes ok even for nonexistent files<br>
- *  - internal "there are more path compnents" flag<br>
+ *  - internal "there are more path components" flag<br>
+ *  - internal "use different cache strategy for explicit O_DIRECTORY" flag<br>
  */<br>
 #define LOOKUP_FOLLOW		(1)<br>
 #define LOOKUP_DIRECTORY	(2)<br>
 #define LOOKUP_SLASHOK		(4)<br>
 #define LOOKUP_CONTINUE		(8)<br>
+#define LOOKUP_O_DIRECTORY	(16)<br>
 <br>
 extern struct dentry * lookup_dentry(const char *, struct dentry *, unsigned int);<br>
 extern struct dentry * __namei(const char *, unsigned int);<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1371.html">Alan Cox: "Re: [PATCH] 3DSE support for AWE sound cards"</a>
<li> <b>Previous message:</b> <a href="1369.html">Stanislav V. Voronyi: "[PATCH] 3DSE support for AWE sound cards"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
