<!-- received="Mon Jun 21 14:11:30 1999 EET DST" -->
<!-- sent="Sun, 20 Jun 1999 17:55:55 +0200 (CEST)" -->
<!-- name="Stanislav Meduna" -->
<!-- email="stano@trillian.eunet.sk" -->
<!-- subject="Process memory vs. total vm, resource limiting?" -->
<!-- id="199906201555.RAA02311@trillian.eunet.sk" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-25,: Process memory vs. total vm, resource limiting?</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Process memory vs. total vm, resource limiting?</h1>
<b>Stanislav Meduna</b> (<a href="mailto:stano@trillian.eunet.sk"><i>stano@trillian.eunet.sk</i></a>)<br>
<i>Sun, 20 Jun 1999 17:55:55 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#236">[ date ]</a><a href="index.html#236">[ thread ]</a><a href="subject.html#236">[ subject ]</a><a href="author.html#236">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0237.html">Marcus Ruehmann: "Re: Why khttpd is a bad idea"</a>
<li> <b>Previous message:</b> <a href="0235.html">Brandon S. Allbery KF8NH: "Re: UUIDs (and devfs and major/minor numbers)"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0353.html">Pavel Machek: "Re: Process memory vs. total vm, resource limiting?"</a>
<li> <b>Reply:</b> <a href="0353.html">Pavel Machek: "Re: Process memory vs. total vm, resource limiting?"</a>
<li> <b>Reply:</b> <a href="0513.html">Benno Senoner: "Re: Process memory vs. total vm, resource limiting?"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hello,<br>
<p>
I have seen some posts in the local newsgroup regarding<br>
problems with static data and I started to experiment<br>
a bit. My setup is PPro, 96 MB RAM, 135 MB of swap<br>
in one 65 MB and one 70 MB partition (total 231 MB<br>
of vm), stock 2.2.10 kernel, egcs 1.1.2, glibc 2.1.1.<br>
<p>
The limit setting is <br>
cputime         unlimited<br>
filesize        unlimited<br>
datasize        unlimited<br>
stacksize       8192 kbytes<br>
coredumpsize    0 kbytes<br>
memoryuse       unlimited<br>
descriptors     1024 <br>
memorylocked    unlimited<br>
maxproc         256 <br>
openfiles       1024<br>
<p>
<p>
Program #1:<br>
<p>
=== snip ===<br>
#include &lt;stdio.h&gt;<br>
#include &lt;malloc.h&gt;<br>
<p>
/* define to represent appr. half of your mem+swap */<br>
#define N1 128<br>
<p>
static int x[N1*1024*1024/sizeof(int)];<br>
<p>
main()<br>
{<br>
  int i;<br>
<p>
  char *p;<br>
<p>
  if (! (p=(char *)malloc(N1*1024*1024)))<br>
    fprintf(stderr, "process %d: Not enough memory for malloc\n", getpid());<br>
<p>
  fprintf(stderr, "process %d setting dynamic area\n", getpid());<br>
<p>
  for (i=0; i &lt; N1*1024*1024; i+=4096)<br>
    p[i] = 1;<br>
<p>
  fprintf(stderr, "process %d set dynamic area\n", getpid());<br>
<p>
<p>
  fprintf(stderr, "process %d setting static area\n", getpid());<br>
<p>
  for (i=0; i &lt; sizeof(x)/sizeof(int); i+=4096/sizeof(int))<br>
    x[i] = 1;<br>
<p>
  fprintf(stderr, "process %d set static area\n", getpid());<br>
<p>
  sleep(10);<br>
<p>
  fprintf(stderr, "process %d ending\n", getpid());<br>
<p>
  exit(0);<br>
}<br>
=== snip ==<br>
<p>
The program defines a static area of 128 MB, then allocates<br>
128 MB dynamically, writes something there and proceeds<br>
to write to the static area.<br>
<p>
The surprise #1 is that the dynamic alloc succeeded,<br>
even if the memory requested by the process was<br>
more than total amount of vm in the machine. I find<br>
the assumption that the process won't be using all<br>
of the requested memory a bit too optimistic.<br>
Is there a possibility to change this behaviour?<br>
<p>
The process then proceeded to set the static area.<br>
When it consumed all of the available vm,<br>
it crashed with a bus error. This is _bad_ -<br>
a well written program checks for the mallocs() and<br>
such returning zero, but there is no easy way<br>
(if any) of detecting that the system cannot make<br>
a copy-on-write for a page in a static buffer.<br>
This can happen just anytime (the huge area<br>
makes it more probable) and the problem is<br>
that if I want to make a robust application,<br>
I cannot. Not good for critical applications.<br>
<p>
Of course, there were more applications that crashed<br>
because of memory shortage - X server being one of them<br>
(so I cannot copy&amp;paste the result of the program :-))<br>
and IDE subsystem was having problems too:<br>
<p>
% dmesg<br>
<p>
hdc: timeout waiting for DMA<br>
hdc: irq timeout: status=0x58 { DriveReady SeekComplete DataRequest }<br>
hdc: DMA disabled<br>
ide1: reset: success<br>
<p>
Out of memory for httpd.<br>
<p>
Out of memory for klogd.<br>
<p>
Out of memory for update.<br>
<p>
Out of memory for actived.<br>
<p>
Out of memory for rclock.<br>
<p>
Out of memory for syslogd.<br>
<p>
Out of memory for gpm.<br>
<p>
Out of memory for init.<br>
<p>
<p>
Well, let's check whether we can guard against<br>
such code deployed as DoS:<br>
<p>
=== snip ===<br>
#include &lt;sys/time.h&gt;<br>
#include &lt;sys/resource.h&gt;<br>
#include &lt;unistd.h&gt;<br>
#include &lt;stdio.h&gt;<br>
<p>
static char x[128*1024*1024];<br>
<p>
main()<br>
{<br>
  int i;<br>
  struct rlimit limit;<br>
<p>
  getrlimit(RLIMIT_RSS, &amp;limit);<br>
  printf("RSS limit curr, max: %d, %d\n", limit.rlim_cur, limit.rlim_max);<br>
<p>
  if (! malloc(20000000))<br>
    printf("malloc not successfull - good\n");<br>
<p>
  for (i=0; i &lt; sizeof(x); i+=4096)<br>
    x[i] = 1;<br>
<p>
  system("ps gauxww | grep a.out | grep -v grep");<br>
<p>
  exit(0);<br>
}<br>
=== snip ===<br>
<p>
% limit  memoryuse 10000<br>
% limit  datasize 10000<br>
% ./a.out<br>
RSS limit curr, max: 10240512, 2147483647<br>
stano     1929 27.4 81.9 151660 78760 pts/3  S    16:47   0:03 ./a.out<br>
<p>
so the process happily consumed 77 MB of real memory<br>
and allowed to allocate 20 MB dynamically instead<br>
of failing because of the limit.<br>
<p>
<p>
Now my question is: is there any way to guard<br>
against this?<br>
<p>
<p>
I don't know the vm subsystem and the interactions<br>
with glibc - the dynamic allocation obviously<br>
goes through mmap and is not checked against<br>
the limits. The static area is in the object<br>
header and probably gets around the check too ...<br>
Perhaps someone clarifies these issues.<br>
<p>
Regards<br>
<pre>
-- 
				Stano
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0237.html">Marcus Ruehmann: "Re: Why khttpd is a bad idea"</a>
<li> <b>Previous message:</b> <a href="0235.html">Brandon S. Allbery KF8NH: "Re: UUIDs (and devfs and major/minor numbers)"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0353.html">Pavel Machek: "Re: Process memory vs. total vm, resource limiting?"</a>
<li> <b>Reply:</b> <a href="0353.html">Pavel Machek: "Re: Process memory vs. total vm, resource limiting?"</a>
<li> <b>Reply:</b> <a href="0513.html">Benno Senoner: "Re: Process memory vs. total vm, resource limiting?"</a>
<!-- reply="end" -->
</ul>
</font></body>
