<!-- received="Mon Jun 21 14:37:50 1999 EET DST" -->
<!-- sent="Mon, 21 Jun 1999 13:16:36 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="Re: lantency scheduling benchmarks of audio playing tasks during" -->
<!-- id="" -->
<!-- inreplyto="99062114572700.00997@localhost.localdomain" -->
<title>Linux-kernel mailing list archive 1999-25,: Re: lantency scheduling benchmarks of audio playing tasks during</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: lantency scheduling benchmarks of audio playing tasks during</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Mon, 21 Jun 1999 13:16:36 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#253">[ date ]</a><a href="index.html#253">[ thread ]</a><a href="subject.html#253">[ subject ]</a><a href="author.html#253">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0254.html">roel@grobbebol.xs4all.nl: "Re: Massive e2fs corruption with 2.2.9/10?"</a>
<li> <b>Previous message:</b> <a href="0252.html">Gabor Lenart: "Re: egcs-1.1.2 ping bug also causes miscompilation of pcbit isdn drive"</a>
<li> <b>In reply to:</b> <a href="0242.html">Benno Senoner: "Re: lantency scheduling benchmarks of audio playing tasks during high disk I/O"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Mon, 21 Jun 1999, Benno Senoner wrote:<br>
<p>
<i>&gt;--------------+-------------+---------------+-------------+--------------+</i><br>
<i>&gt;buffer size   |proc (top)   | disk write    | disk copy   | disk read    |</i><br>
<i>&gt;--------------+-------------+---------------+-------------+--------------+</i><br>
<i>&gt;2x1024(11.6ms)| 15.1ms (307)| 9610.0ms (221)| 20.5ms (  2)| 867.3ms ( 10)|</i><br>
		 ^^^^^^ ^^^^^<br>
Could you explain the meaning of the two fields? Which bench are you using<br>
to generate the numbers?<br>
<p>
<i>&gt;the andrea patch behaves very well during disk copy (cp file1 file2) operations,</i><br>
<i>&gt;but on write only , or read only operations , it gives extremely high</i><br>
<i>&gt;latencies. </i><br>
<p>
This sounds to me as a bit weird. A copy always imply a read and a<br>
write... so it should be the slower one. This made me to think that the<br>
numbers got fooled by a far different working set across benchmarks run.<br>
Is this possible?<br>
<p>
If not I would like if you could try without the wait_for_IO hack.<br>
<p>
To do that apply this patch:<br>
<p>
	<a href="ftp://ftp.suse.com/pub/people/andrea/kernel-patches/2.2.10_andrea-VM8.gz">ftp://ftp.suse.com/pub/people/andrea/kernel-patches/2.2.10_andrea-VM8.gz</a><br>
<p>
And then apply the below diff against 2.2.10_andrea-VM8:<br>
<p>
Index: linux//fs/buffer.c<br>
===================================================================<br>
RCS file: /var/cvs/linux/fs/buffer.c,v<br>
retrieving revision 1.1.1.13.2.9<br>
diff -u -r1.1.1.13.2.9 buffer.c<br>
--- linux//fs/buffer.c	1999/06/19 13:42:05	1.1.1.13.2.9<br>
+++ linux//fs/buffer.c	1999/06/21 11:01:56<br>
@@ -126,8 +126,6 @@<br>
 	(size_buffers_type[BUF_DIRTY] &gt;&gt; PAGE_SHIFT &gt;	\<br>
 	 nr_free_pages+(buffermem&gt;&gt;(PAGE_SHIFT+1)))<br>
 <br>
-atomic_t wait_for_IO = ATOMIC_INIT(0);<br>
-<br>
 /*<br>
  * Rewrote the wait-routines to use the "new" wait-queue functionality,<br>
  * and getting rid of the cli-sti pairs. The wait-queue routines still<br>
@@ -144,7 +142,6 @@<br>
 <br>
 	bh-&gt;b_count++;<br>
 	wait.task = tsk;<br>
-	atomic_inc(&amp;wait_for_IO);<br>
 	add_wait_queue(&amp;bh-&gt;b_wait, &amp;wait);<br>
 	do {<br>
 		tsk-&gt;state = TASK_UNINTERRUPTIBLE;<br>
@@ -155,7 +152,6 @@<br>
 	} while (buffer_locked(bh));<br>
 	tsk-&gt;state = TASK_RUNNING;<br>
 	remove_wait_queue(&amp;bh-&gt;b_wait, &amp;wait);<br>
-	atomic_dec(&amp;wait_for_IO);<br>
 	bh-&gt;b_count--;<br>
 }<br>
 <br>
@@ -1701,8 +1697,6 @@<br>
 		bh-&gt;b_count++;<br>
 		ll_rw_block(WRITE, 1, &amp;bh);<br>
 		bh-&gt;b_count--;<br>
-		if (atomic_read(&amp;wait_for_IO))<br>
-			wait_on_buffer(bh);<br>
 		if (bdflush_tsk-&gt;need_resched)<br>
 			schedule();<br>
 		next-&gt;b_count--;<br>
Index: linux//include/linux/fs.h<br>
===================================================================<br>
RCS file: /var/cvs/linux/include/linux/fs.h,v<br>
retrieving revision 1.1.1.10.2.2<br>
diff -u -r1.1.1.10.2.2 fs.h<br>
--- linux//include/linux/fs.h	1999/06/09 19:36:59	1.1.1.10.2.2<br>
+++ linux//include/linux/fs.h	1999/06/21 11:02:04<br>
@@ -25,8 +25,6 @@<br>
 <br>
 struct poll_table_struct;<br>
 <br>
-extern atomic_t wait_for_IO;<br>
-<br>
 /*<br>
  * It's silly to have NR_OPEN bigger than NR_FILE, but I'll fix<br>
  * that later. Anyway, now the file code is no longer dependent<br>
Index: linux//mm/filemap.c<br>
===================================================================<br>
RCS file: /var/cvs/linux/mm/filemap.c,v<br>
retrieving revision 1.1.1.12.2.7<br>
diff -u -r1.1.1.12.2.7 filemap.c<br>
--- linux//mm/filemap.c	1999/06/20 14:19:14	1.1.1.12.2.7<br>
+++ linux//mm/filemap.c	1999/06/21 11:02:12<br>
@@ -362,7 +362,6 @@<br>
 	struct wait_queue wait;<br>
 <br>
 	wait.task = tsk;<br>
-	atomic_inc(&amp;wait_for_IO);<br>
 	add_wait_queue(&amp;page-&gt;wait, &amp;wait);<br>
 	do {<br>
 		tsk-&gt;state = TASK_UNINTERRUPTIBLE;<br>
@@ -373,7 +372,6 @@<br>
 	} while (PageLocked(page));<br>
 	tsk-&gt;state = TASK_RUNNING;<br>
 	remove_wait_queue(&amp;page-&gt;wait, &amp;wait);<br>
-	atomic_dec(&amp;wait_for_IO);<br>
 }<br>
 <br>
 #if 0<br>
<p>
<p>
The wait_for_IO hack currently is decreasing the write throughput but it's<br>
also avoiding you stalling for looong times waiting for I/O completation.<br>
It's an ugly band-aid of course but it's better than nothing right now.<br>
<p>
Andrea Arcangeli<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0254.html">roel@grobbebol.xs4all.nl: "Re: Massive e2fs corruption with 2.2.9/10?"</a>
<li> <b>Previous message:</b> <a href="0252.html">Gabor Lenart: "Re: egcs-1.1.2 ping bug also causes miscompilation of pcbit isdn drive"</a>
<li> <b>In reply to:</b> <a href="0242.html">Benno Senoner: "Re: lantency scheduling benchmarks of audio playing tasks during high disk I/O"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
