<!-- received="Mon Jun 21 15:05:44 1999 EET DST" -->
<!-- sent="Mon, 21 Jun 1999 07:44:29 -0400 (EDT)" -->
<!-- name="Alexander Viro" -->
<!-- email="viro@math.psu.edu" -->
<!-- subject="Re: I discussed reading directories as files with jra, Stallman," -->
<!-- id="" -->
<!-- inreplyto="E10w19Z-0005bu-00@the-village.bc.nu" -->
<title>Linux-kernel mailing list archive 1999-25,: Re: I discussed reading directories as files with jra, Stallman,</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: I discussed reading directories as files with jra, Stallman,</h1>
<b>Alexander Viro</b> (<a href="mailto:viro@math.psu.edu"><i>viro@math.psu.edu</i></a>)<br>
<i>Mon, 21 Jun 1999 07:44:29 -0400 (EDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#257">[ date ]</a><a href="index.html#257">[ thread ]</a><a href="subject.html#257">[ subject ]</a><a href="author.html#257">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0258.html">Rick Hohensee: "in re... I discussed directory bla bla"</a>
<li> <b>Previous message:</b> <a href="0256.html">Andrea Arcangeli: "Re: [patch] `cp /dev/zero /tmp' (patch against 2.2.9)"</a>
<li> <b>In reply to:</b> <a href="0207.html">Alan Cox: "Re: I discussed reading directories as files with jra, Stallman,"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Mon, 21 Jun 1999, Alan Cox wrote:<br>
<p>
<i>&gt; &gt; and that's what happens here. It's not the fact that we have a recursive</i><br>
<i>&gt; &gt; lookup_dentry(), it's bringing tons of cruft into stack between the nested</i><br>
<i>&gt; &gt; calls and severe code duplication. And multiple pathes of recursion (every</i><br>
<i>&gt; &gt; foo_follow_link contains one).</i><br>
<i>&gt; </i><br>
<i>&gt; The fact we have fs recursion is actually bad, but purely because we don't</i><br>
<i>&gt; have dynamic stack allocation. (Which we dont want either). With a non </i><br>
<i>&gt; recudsive follow link we could probably go back to 4K stacks. If thats the</i><br>
<i>&gt; case then on x86 recursive link following currently costs us 4K a process</i><br>
<i>&gt; idle, or otherwise. Ie about 350K of unswappable memory on my box currently.</i><br>
<p>
Alan, wait with it, OK? The real problem is not that much in recursion but<br>
in the way we (ab)use it. We can seriously cut it down just with some<br>
trivial rearrangements. I wouldn't go for 4K stacks, though - we got some<br>
pretty long code pathes outside of lookup_dentry(). Darn RPC engines in<br>
network file systems...<br>
<p>
<i>&gt; &gt; It's order of magnitude. I'm more than sure that with sufficiently long</i><br>
<i>&gt; &gt; and perverted code path (we have them) the current implementation can be</i><br>
<i>&gt; &gt; used to overflow the ring 0 stack.</i><br>
<i>&gt; </i><br>
<i>&gt; Try a self referencing symlink on smbfs - although that appears to be</i><br>
<i>&gt; not entirely the VFS fault.</i><br>
<p>
... and one of them in smbfs.<br>
<p>
<i>&gt; &gt; PS: ObCodeDuplication: sys_mmap() on PPC. down(&amp;current-&gt;mm-&gt;mmap_sem)</i><br>
<i>&gt; &gt; missing. fcheck() instead of fget(). The former is more or less fresh, but</i><br>
<i>&gt; &gt; the latter is about 1.5 years old. Exploitable race. Sigh... And there are</i><br>
<i>&gt; &gt; other similar buggers. grep(1) is our friend...</i><br>
<i>&gt; </i><br>
<i>&gt; patch ?</i><br>
<p>
[Sorry, just woke up. Hmm... Looks like $PERSONAL_TZ and $TZ got within a<br>
couple of hours from each other. Weird...]<br>
<p>
Here (with the SMP-safe f_count handling, but without symlink changes):<br>
<p>
diff -urN linux-2.3.7/arch/alpha/kernel/osf_sys.c linux-bird.f_count/arch/alpha/kernel/osf_sys.c<br>
--- linux-2.3.7/arch/alpha/kernel/osf_sys.c	Thu May 13 07:01:28 1999<br>
+++ linux-bird.f_count/arch/alpha/kernel/osf_sys.c	Mon Jun 21 07:31:19 1999<br>
@@ -255,6 +255,7 @@<br>
 	struct file *file = NULL;<br>
 	unsigned long ret = -EBADF;<br>
 <br>
+	down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	lock_kernel();<br>
 #if 0<br>
 	if (flags &amp; (_MAP_HASSEMAPHORE | _MAP_INHERIT | _MAP_UNALIGNED))<br>
@@ -272,6 +273,7 @@<br>
 		fput(file);<br>
 out:<br>
 	unlock_kernel();<br>
+	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	return ret;<br>
 }<br>
 <br>
diff -urN linux-2.3.7/arch/arm/kernel/sys_arm.c linux-bird.f_count/arch/arm/kernel/sys_arm.c<br>
--- linux-2.3.7/arch/arm/kernel/sys_arm.c	Mon Jun 21 07:29:18 1999<br>
+++ linux-bird.f_count/arch/arm/kernel/sys_arm.c	Mon Jun 21 07:31:19 1999<br>
@@ -72,6 +72,7 @@<br>
 	struct file * file = NULL;<br>
 	struct mmap_arg_struct a;<br>
 <br>
+	down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	lock_kernel();<br>
 	if (copy_from_user(&amp;a, arg, sizeof(a)))<br>
 		goto out;<br>
@@ -87,6 +88,7 @@<br>
 		fput(file);<br>
 out:<br>
 	unlock_kernel();<br>
+	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	return error;<br>
 }<br>
 <br>
diff -urN linux-2.3.7/arch/mips/kernel/irixelf.c linux-bird.f_count/arch/mips/kernel/irixelf.c<br>
--- linux-2.3.7/arch/mips/kernel/irixelf.c	Wed Jun  9 08:00:39 1999<br>
+++ linux-bird.f_count/arch/mips/kernel/irixelf.c	Mon Jun 21 07:31:19 1999<br>
@@ -850,13 +850,12 @@<br>
 <br>
 	len = 0;<br>
 	file = current-&gt;files-&gt;fd[fd];<br>
+	if (!file || !file-&gt;f_op)<br>
+		return -EACCES;<br>
 	dentry = file-&gt;f_dentry;<br>
 	inode = dentry-&gt;d_inode;<br>
 	elf_bss = 0;<br>
 	<br>
-	if (!file || !file-&gt;f_op)<br>
-		return -EACCES;<br>
-<br>
 	/* Seek to the beginning of the file. */<br>
 	if (file-&gt;f_op-&gt;llseek) {<br>
 		if ((error = file-&gt;f_op-&gt;llseek(file, 0, 0)) != 0)<br>
diff -urN linux-2.3.7/arch/mips/kernel/syscall.c linux-bird.f_count/arch/mips/kernel/syscall.c<br>
--- linux-2.3.7/arch/mips/kernel/syscall.c	Thu May 13 07:01:37 1999<br>
+++ linux-bird.f_count/arch/mips/kernel/syscall.c	Mon Jun 21 07:31:19 1999<br>
@@ -61,6 +61,7 @@<br>
 	struct file * file = NULL;<br>
 	unsigned long error = -EFAULT;<br>
 <br>
+	down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	lock_kernel();<br>
 	if (!(flags &amp; MAP_ANONYMOUS)) {<br>
 		error = -EBADF;<br>
@@ -74,6 +75,7 @@<br>
                 fput(file);<br>
 out:<br>
 	unlock_kernel();<br>
+	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	return error;<br>
 }<br>
 <br>
diff -urN linux-2.3.7/arch/mips/kernel/sysirix.c linux-bird.f_count/arch/mips/kernel/sysirix.c<br>
--- linux-2.3.7/arch/mips/kernel/sysirix.c	Wed Jun  9 08:00:40 1999<br>
+++ linux-bird.f_count/arch/mips/kernel/sysirix.c	Mon Jun 21 07:31:19 1999<br>
@@ -1103,6 +1103,7 @@<br>
 	struct file *file = NULL;<br>
 	unsigned long retval;<br>
 <br>
+	down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	lock_kernel();<br>
 	if(!(flags &amp; MAP_ANONYMOUS)) {<br>
 		if(!(file = fget(fd))) {<br>
@@ -1130,6 +1131,7 @@<br>
 <br>
 out:<br>
 	unlock_kernel();<br>
+	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	return retval;<br>
 }<br>
 <br>
diff -urN linux-2.3.7/arch/ppc/kernel/syscalls.c linux-bird.f_count/arch/ppc/kernel/syscalls.c<br>
--- linux-2.3.7/arch/ppc/kernel/syscalls.c	Wed Jun  9 08:00:50 1999<br>
+++ linux-bird.f_count/arch/ppc/kernel/syscalls.c	Mon Jun 21 07:31:19 1999<br>
@@ -201,12 +201,16 @@<br>
 <br>
 	lock_kernel();<br>
 	if (!(flags &amp; MAP_ANONYMOUS)) {<br>
-		if (fd &gt;= NR_OPEN || !(file = current-&gt;files-&gt;fd[fd]))<br>
+		if (!(file = fget(fd)))<br>
 			goto out;<br>
 	}<br>
 	<br>
 	flags &amp;= ~(MAP_EXECUTABLE | MAP_DENYWRITE);<br>
+	down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	ret = do_mmap(file, addr, len, prot, flags, offset);<br>
+	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
+	if (file)<br>
+		fput(file);<br>
 out:<br>
 	unlock_kernel();<br>
 	return ret;<br>
diff -urN linux-2.3.7/arch/sparc/kernel/sunos_ioctl.c linux-bird.f_count/arch/sparc/kernel/sunos_ioctl.c<br>
--- linux-2.3.7/arch/sparc/kernel/sunos_ioctl.c	Thu May 13 07:01:43 1999<br>
+++ linux-bird.f_count/arch/sparc/kernel/sunos_ioctl.c	Mon Jun 21 07:31:19 1999<br>
@@ -40,7 +40,7 @@<br>
 	int ret = -EBADF;<br>
 <br>
 	lock_kernel();<br>
-	if (fd &gt;= SUNOS_NR_OPEN || !(filp = current-&gt;files-&gt;fd [fd]))<br>
+	if (fd &gt;= SUNOS_NR_OPEN || !(filp = fcheck(fd)))<br>
 		goto out;<br>
 <br>
 	/* First handle an easy compat. case for tty ldisc. */<br>
diff -urN linux-2.3.7/arch/sparc/mm/srmmu.c linux-bird.f_count/arch/sparc/mm/srmmu.c<br>
--- linux-2.3.7/arch/sparc/mm/srmmu.c	Thu May 13 07:01:45 1999<br>
+++ linux-bird.f_count/arch/sparc/mm/srmmu.c	Mon Jun 21 07:31:20 1999<br>
@@ -2076,6 +2076,7 @@<br>
 			goto done;<br>
 		inode = file-&gt;f_dentry-&gt;d_inode;<br>
 		offset = (address &amp; PAGE_MASK) - vma-&gt;vm_start;<br>
+		spin_lock(&amp;inode-&gt;i_shared_lock);<br>
 		vmaring = inode-&gt;i_mmap; <br>
 		do {<br>
 			/* Do not mistake ourselves as another mapping. */<br>
@@ -2109,6 +2110,7 @@<br>
 				}<br>
 			}<br>
 		} while ((vmaring = vmaring-&gt;vm_next_share) != NULL);<br>
+		spin_unlock(&amp;inode-&gt;i_shared_lock);<br>
 <br>
 		if(alias_found &amp;&amp; ((pte_val(pte) &amp; SRMMU_CACHE) != 0)) {<br>
 			pgdp = srmmu_pgd_offset(vma-&gt;vm_mm, address);<br>
diff -urN linux-2.3.7/arch/sparc/mm/sun4c.c linux-bird.f_count/arch/sparc/mm/sun4c.c<br>
--- linux-2.3.7/arch/sparc/mm/sun4c.c	Thu May 13 07:01:45 1999<br>
+++ linux-bird.f_count/arch/sparc/mm/sun4c.c	Mon Jun 21 07:31:20 1999<br>
@@ -2682,8 +2682,10 @@<br>
 		inode = dentry-&gt;d_inode;<br>
 	if(inode) {<br>
 		unsigned long offset = (address &amp; PAGE_MASK) - vma-&gt;vm_start;<br>
-		struct vm_area_struct *vmaring = inode-&gt;i_mmap; <br>
+		struct vm_area_struct *vmaring;<br>
 		int alias_found = 0;<br>
+		spin_lock(&amp;inode-&gt;i_shared_lock);<br>
+		vmaring = inode-&gt;i_mmap; <br>
 		do {<br>
 			unsigned long vaddr = vmaring-&gt;vm_start + offset;<br>
 			unsigned long start;<br>
@@ -2712,6 +2714,7 @@<br>
 				}<br>
 			}<br>
 		} while ((vmaring = vmaring-&gt;vm_next_share) != NULL);<br>
+		spin_unlock(&amp;inode-&gt;i_shared_lock);<br>
 <br>
 		if(alias_found &amp;&amp; !(pte_val(pte) &amp; _SUN4C_PAGE_NOCACHE)) {<br>
 			pgdp = sun4c_pgd_offset(vma-&gt;vm_mm, address);<br>
diff -urN linux-2.3.7/arch/sparc64/kernel/sys_sparc32.c linux-bird.f_count/arch/sparc64/kernel/sys_sparc32.c<br>
--- linux-2.3.7/arch/sparc64/kernel/sys_sparc32.c	Thu Jun 10 07:24:03 1999<br>
+++ linux-bird.f_count/arch/sparc64/kernel/sys_sparc32.c	Mon Jun 21 07:31:20 1999<br>
@@ -2335,8 +2335,8 @@<br>
 			break;<br>
 		}<br>
 		/* Bump the usage count and install the file. */<br>
-		fp[i]-&gt;f_count++;<br>
-		current-&gt;files-&gt;fd[new_fd] = fp[i];<br>
+		atomic_inc(&amp;fp[i]-&gt;f_count);<br>
+		fd_install(new_fd, fp[i]);<br>
 	}<br>
 <br>
 	if (i &gt; 0) {<br>
diff -urN linux-2.3.7/arch/sparc64/kernel/sys_sunos32.c linux-bird.f_count/arch/sparc64/kernel/sys_sunos32.c<br>
--- linux-2.3.7/arch/sparc64/kernel/sys_sunos32.c	Mon Jun 21 07:29:20 1999<br>
+++ linux-bird.f_count/arch/sparc64/kernel/sys_sunos32.c	Mon Jun 21 07:31:20 1999<br>
@@ -712,7 +712,7 @@<br>
 	struct inode  *inode;<br>
 	struct file   *file;<br>
 <br>
-	file = current-&gt;files-&gt;fd [fd];<br>
+	file = fcheck(fd);<br>
 	if(!file)<br>
 		return 0;<br>
 <br>
diff -urN linux-2.3.7/arch/sparc64/solaris/misc.c linux-bird.f_count/arch/sparc64/solaris/misc.c<br>
--- linux-2.3.7/arch/sparc64/solaris/misc.c	Thu May 13 07:01:48 1999<br>
+++ linux-bird.f_count/arch/sparc64/solaris/misc.c	Mon Jun 21 07:31:20 1999<br>
@@ -83,6 +83,7 @@<br>
 		}<br>
 	}<br>
 <br>
+	down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	retval = -ENOMEM;<br>
 	if(!(flags &amp; MAP_FIXED) &amp;&amp; !addr) {<br>
 		unsigned long attempt = get_unmapped_area(addr, len);<br>
@@ -100,8 +101,9 @@<br>
 			 (unsigned long) addr, (unsigned long) len,<br>
 			 (unsigned long) prot, (unsigned long) flags, off);<br>
 	if(!ret_type)<br>
-		retval = ((retval &lt; 0xf0000000) ? 0 : retval);<br>
+		pretval = ((retval &lt; 0xf0000000) ? 0 : retval);<br>
 out_putf:<br>
+	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	if (file)<br>
 		fput(file);<br>
 out:<br>
diff -urN linux-2.3.7/drivers/char/sysrq.c linux-bird.f_count/drivers/char/sysrq.c<br>
--- linux-2.3.7/drivers/char/sysrq.c	Thu May 13 07:01:58 1999<br>
+++ linux-bird.f_count/drivers/char/sysrq.c	Mon Jun 21 07:31:20 1999<br>
@@ -155,7 +155,8 @@<br>
 	struct file *file;<br>
 <br>
 	for (file = inuse_filps; file; file = file-&gt;f_next)<br>
-		if (file-&gt;f_dentry &amp;&amp; file-&gt;f_count &amp;&amp; S_ISREG(file-&gt;f_dentry-&gt;d_inode-&gt;i_mode))<br>
+		if (file-&gt;f_dentry &amp;&amp; atomic_read(&amp;file-&gt;f_count)<br>
+				&amp;&amp; S_ISREG(file-&gt;f_dentry-&gt;d_inode-&gt;i_mode))<br>
 			file-&gt;f_mode &amp;= ~2;<br>
 }<br>
 <br>
diff -urN linux-2.3.7/drivers/char/tpqic02.c linux-bird.f_count/drivers/char/tpqic02.c<br>
--- linux-2.3.7/drivers/char/tpqic02.c	Thu May 13 07:49:32 1999<br>
+++ linux-bird.f_count/drivers/char/tpqic02.c	Mon Jun 21 07:31:20 1999<br>
@@ -2216,7 +2216,7 @@<br>
     }<br>
     <br>
 	/* Only one at a time from here on... */<br>
-    if (filp-&gt;f_count&gt;1) 	/* filp-&gt;f_count==1 for the first open() */<br>
+    if (atomic_read(&amp;filp-&gt;f_count)&gt;1) 	/* filp-&gt;f_count==1 for the first open() */<br>
     {<br>
 	return -EBUSY;<br>
     }<br>
diff -urN linux-2.3.7/drivers/scsi/st.c linux-bird.f_count/drivers/scsi/st.c<br>
--- linux-2.3.7/drivers/scsi/st.c	Sat May 29 18:04:08 1999<br>
+++ linux-bird.f_count/drivers/scsi/st.c	Mon Jun 21 07:31:21 1999<br>
@@ -890,7 +890,7 @@<br>
     kdev_t devt = inode-&gt;i_rdev;<br>
     int dev;<br>
 <br>
-    if (filp-&gt;f_count &gt; 1)<br>
+    if (atomic_read(&amp;filp-&gt;f_count) &gt; 1)<br>
 	return 0;<br>
 <br>
     dev = TAPE_NR(devt);<br>
diff -urN linux-2.3.7/drivers/sgi/char/usema.c linux-bird.f_count/drivers/sgi/char/usema.c<br>
--- linux-2.3.7/drivers/sgi/char/usema.c	Mon May 17 07:34:12 1999<br>
+++ linux-bird.f_count/drivers/sgi/char/usema.c	Mon Jun 21 07:31:21 1999<br>
@@ -50,8 +50,8 @@<br>
 	if (newfd &lt; 0)<br>
 		return newfd;<br>
 	<br>
-	current-&gt;files-&gt;fd [newfd] = usema-&gt;filp;<br>
-	usema-&gt;filp-&gt;f_count++;<br>
+	atomic_inc(&amp;usema-&gt;filp-&gt;f_count);<br>
+	fd_install(newfd, usema-&gt;filp);<br>
 	/* Is that it? */<br>
 	printk("UIOCATTACHSEMA: new usema fd is %d", newfd);<br>
 	return newfd;<br>
diff -urN linux-2.3.7/fs/exec.c linux-bird.f_count/fs/exec.c<br>
--- linux-2.3.7/fs/exec.c	Wed Jun  2 22:39:43 1999<br>
+++ linux-bird.f_count/fs/exec.c	Mon Jun 21 07:31:21 1999<br>
@@ -563,7 +563,8 @@<br>
 	if ((retval = permission(inode, MAY_EXEC)) != 0)<br>
 		return retval;<br>
 	/* better not execute files which are being written to */<br>
-	if (inode-&gt;i_writecount &gt; 0)<br>
+	/* WARNING. Read comments in fs/namei.c::get_write_access() */<br>
+	if (atomic_read(&amp;inode-&gt;i_writecount) &gt; 0)<br>
 		return -ETXTBSY;<br>
 <br>
 	bprm-&gt;e_uid = current-&gt;euid;<br>
diff -urN linux-2.3.7/fs/file_table.c linux-bird.f_count/fs/file_table.c<br>
--- linux-2.3.7/fs/file_table.c	Wed Jun  2 22:39:43 1999<br>
+++ linux-bird.f_count/fs/file_table.c	Mon Jun 21 07:31:21 1999<br>
@@ -80,7 +80,7 @@<br>
 		nr_free_files--;<br>
 	new_one:<br>
 		memset(f, 0, sizeof(*f));<br>
-		f-&gt;f_count = 1;<br>
+		atomic_set(&amp;f-&gt;f_count,1);<br>
 		f-&gt;f_version = ++event;<br>
 		f-&gt;f_uid = current-&gt;fsuid;<br>
 		f-&gt;f_gid = current-&gt;fsgid;<br>
@@ -120,7 +120,7 @@<br>
 {<br>
 	memset(filp, 0, sizeof(*filp));<br>
 	filp-&gt;f_mode   = mode;<br>
-	filp-&gt;f_count  = 1;<br>
+	atomic_set(&amp;filp-&gt;f_count, 1);<br>
 	filp-&gt;f_dentry = dentry;<br>
 	filp-&gt;f_uid    = current-&gt;fsuid;<br>
 	filp-&gt;f_gid    = current-&gt;fsgid;<br>
@@ -133,21 +133,21 @@<br>
 <br>
 void fput(struct file *file)<br>
 {<br>
-	int count = file-&gt;f_count-1;<br>
-<br>
-	if (!count) {<br>
+	/* We still need big lock here */<br>
+	if (atomic_dec_and_test(&amp;file-&gt;f_count)) {<br>
+		atomic_inc(&amp;file-&gt;f_count);<br>
 		locks_remove_flock(file);<br>
 		__fput(file);<br>
-		file-&gt;f_count = 0;<br>
+		atomic_set(&amp;file-&gt;f_count, 0);<br>
 		remove_filp(file);<br>
 		insert_file_free(file);<br>
-	} else<br>
-		file-&gt;f_count = count;<br>
+	}<br>
 }<br>
 <br>
 void put_filp(struct file *file)<br>
 {<br>
-	if(--file-&gt;f_count == 0) {<br>
+	if(atomic_dec_and_test(&amp;file-&gt;f_count)) {<br>
+		/* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */<br>
 		remove_filp(file);<br>
 		insert_file_free(file);<br>
 	}<br>
diff -urN linux-2.3.7/fs/hpfs/mmap.c linux-bird.f_count/fs/hpfs/mmap.c<br>
--- linux-2.3.7/fs/hpfs/mmap.c	Fri May 14 23:54:27 1999<br>
+++ linux-bird.f_count/fs/hpfs/mmap.c	Mon Jun 21 07:31:21 1999<br>
@@ -119,9 +119,9 @@<br>
 		mark_inode_dirty(inode);<br>
 	}*/<br>
 <br>
-	vma-&gt;vm_file = file;<br>
 	/*inode-&gt;i_count++;*/<br>
-	file-&gt;f_count++;<br>
+	atomic_inc(&amp;file-&gt;f_count);<br>
+	vma-&gt;vm_file = file;<br>
 	vma-&gt;vm_ops = &amp;hpfs_file_mmap;<br>
 	/*printk("end mmap\n");*/<br>
 	return 0;<br>
diff -urN linux-2.3.7/fs/inode.c linux-bird.f_count/fs/inode.c<br>
--- linux-2.3.7/fs/inode.c	Mon Jun 21 07:29:25 1999<br>
+++ linux-bird.f_count/fs/inode.c	Mon Jun 21 07:31:21 1999<br>
@@ -130,6 +130,7 @@<br>
 	INIT_LIST_HEAD(&amp;inode-&gt;i_hash);<br>
 	INIT_LIST_HEAD(&amp;inode-&gt;i_dentry);<br>
 	sema_init(&amp;inode-&gt;i_sem, 1);<br>
+	spin_lock_init(&amp;inode-&gt;i_shared_lock);<br>
 }<br>
 <br>
 static inline void write_inode(struct inode *inode)<br>
@@ -521,7 +522,7 @@<br>
 	inode-&gt;i_sock = 0;<br>
 	inode-&gt;i_op = NULL;<br>
 	inode-&gt;i_nlink = 1;<br>
-	inode-&gt;i_writecount = 0;<br>
+	atomic_set(&amp;inode-&gt;i_writecount, 0);<br>
 	inode-&gt;i_size = 0;<br>
 	inode-&gt;i_generation = 0;<br>
 	memset(&amp;inode-&gt;i_dquot, 0, sizeof(inode-&gt;i_dquot));<br>
diff -urN linux-2.3.7/fs/locks.c linux-bird.f_count/fs/locks.c<br>
--- linux-2.3.7/fs/locks.c	Thu May 13 07:51:11 1999<br>
+++ linux-bird.f_count/fs/locks.c	Mon Jun 21 07:31:21 1999<br>
@@ -400,16 +400,23 @@<br>
 <br>
 	/* Don't allow mandatory locks on files that may be memory mapped<br>
 	 * and shared.<br>
+	 *<br>
+	 * Since do_mmap() is protected by big lock we are safe here, but as<br>
+	 * soon as it will go we will have a bunch of interesting stuff to<br>
+	 * care of.<br>
 	 */<br>
 	if (IS_MANDLOCK(inode) &amp;&amp;<br>
 	    (inode-&gt;i_mode &amp; (S_ISGID | S_IXGRP)) == S_ISGID &amp;&amp;<br>
 	    inode-&gt;i_mmap) {<br>
-		struct vm_area_struct *vma = inode-&gt;i_mmap;<br>
+		struct vm_area_struct *vma;<br>
 		error = -EAGAIN;<br>
+		spin_lock(&amp;inode-&gt;i_shared_lock);<br>
+		vma = inode-&gt;i_mmap;<br>
 		do {<br>
 			if (vma-&gt;vm_flags &amp; VM_MAYSHARE)<br>
-				goto out_putf;<br>
+				goto out_putf_unlock;<br>
 		} while ((vma = vma-&gt;vm_next_share) != NULL);<br>
+		spin_unlock(&amp;inode-&gt;i_shared_lock);<br>
 	}<br>
 <br>
 	error = -EINVAL;<br>
@@ -461,6 +468,9 @@<br>
 	fput(filp);<br>
 out:<br>
 	return error;<br>
+out_putf_unlock:<br>
+	spin_unlock(&amp;inode-&gt;i_shared_lock);<br>
+	goto out_putf;<br>
 }<br>
 <br>
 /*<br>
diff -urN linux-2.3.7/fs/namei.c linux-bird.f_count/fs/namei.c<br>
--- linux-2.3.7/fs/namei.c	Mon May 17 07:34:31 1999<br>
+++ linux-bird.f_count/fs/namei.c	Mon Jun 21 07:31:21 1999<br>
@@ -171,18 +171,22 @@<br>
  * 0: no writers, no VM_DENYWRITE mappings<br>
  * &lt; 0: (-i_writecount) vm_area_structs with VM_DENYWRITE set exist<br>
  * &gt; 0: (i_writecount) users are writing to the file.<br>
+ *<br>
+ * WARNING: as soon as we will move get_write_access(), do_mmap() or<br>
+ * prepare_binfmt() out of the big lock we will need a spinlock protecting<br>
+ * the checks in all 3. For the time being it is not needed.<br>
  */<br>
 int get_write_access(struct inode * inode)<br>
 {<br>
-	if (inode-&gt;i_writecount &lt; 0)<br>
+	if (atomic_read(&amp;inode-&gt;i_writecount) &lt; 0)<br>
 		return -ETXTBSY;<br>
-	inode-&gt;i_writecount++;<br>
+	atomic_inc(&amp;inode-&gt;i_writecount);<br>
 	return 0;<br>
 }<br>
 <br>
 void put_write_access(struct inode * inode)<br>
 {<br>
-	inode-&gt;i_writecount--;<br>
+	atomic_dec(&amp;inode-&gt;i_writecount);<br>
 }<br>
 <br>
 /*<br>
diff -urN linux-2.3.7/fs/nfs/write.c linux-bird.f_count/fs/nfs/write.c<br>
--- linux-2.3.7/fs/nfs/write.c	Mon Jun 21 07:29:25 1999<br>
+++ linux-bird.f_count/fs/nfs/write.c	Mon Jun 21 07:31:21 1999<br>
@@ -305,6 +305,7 @@<br>
 		goto out_req;<br>
 <br>
 	/* Put the task on inode's writeback request list. */<br>
+	atomic_inc(&amp;file-&gt;f_count);<br>
 	wreq-&gt;wb_file = file;<br>
 	wreq-&gt;wb_pid    = current-&gt;pid;<br>
 	wreq-&gt;wb_page   = page;<br>
@@ -467,7 +468,6 @@<br>
 	 * The IO completion will then free the page and the dentry.<br>
 	 */<br>
 	get_page(page);<br>
-	file-&gt;f_count++;<br>
 <br>
 	/* Schedule request */<br>
 	synchronous = schedule_write_request(req, synchronous);<br>
diff -urN linux-2.3.7/fs/nfsd/vfs.c linux-bird.f_count/fs/nfsd/vfs.c<br>
--- linux-2.3.7/fs/nfsd/vfs.c	Mon May 17 07:34:43 1999<br>
+++ linux-bird.f_count/fs/nfsd/vfs.c	Mon Jun 21 07:31:21 1999<br>
@@ -342,7 +342,7 @@<br>
 <br>
 	memset(filp, 0, sizeof(*filp));<br>
 	filp-&gt;f_op    = inode-&gt;i_op-&gt;default_file_ops;<br>
-	filp-&gt;f_count = 1;<br>
+	atomic_set(&amp;filp-&gt;f_count, 1);<br>
 	filp-&gt;f_flags = wflag? O_WRONLY : O_RDONLY;<br>
 	filp-&gt;f_mode  = wflag? FMODE_WRITE : FMODE_READ;<br>
 	filp-&gt;f_dentry = dentry;<br>
@@ -360,7 +360,7 @@<br>
 			/* I nearly added put_filp() call here, but this filp<br>
 			 * is really on callers stack frame. -DaveM<br>
 			 */<br>
-			filp-&gt;f_count--;<br>
+			atomic_dec(&amp;filp-&gt;f_count);<br>
 		}<br>
 	}<br>
 out_nfserr:<br>
@@ -585,7 +585,7 @@<br>
 		 * nice and simple solution (IMHO), and it seems to<br>
 		 * work:-)<br>
 		 */<br>
-		if (EX_WGATHER(exp) &amp;&amp; (inode-&gt;i_writecount &gt; 1<br>
+		if (EX_WGATHER(exp) &amp;&amp; (atomic_read(&amp;inode-&gt;i_writecount) &gt; 1<br>
<i> 		 || (last_ino == inode-&gt;i_ino &amp;&amp; last_dev == inode-&gt;i_dev))) {</i><br>
 #if 0<br>
 			interruptible_sleep_on_timeout(&amp;inode-&gt;i_wait, 10 * HZ / 1000);<br>
diff -urN linux-2.3.7/fs/open.c linux-bird.f_count/fs/open.c<br>
--- linux-2.3.7/fs/open.c	Sat May 29 18:04:33 1999<br>
+++ linux-bird.f_count/fs/open.c	Mon Jun 21 07:31:21 1999<br>
@@ -790,7 +790,7 @@<br>
 	int retval;<br>
 	struct dentry *dentry = filp-&gt;f_dentry;<br>
 <br>
-	if (filp-&gt;f_count == 0) {<br>
+	if (atomic_read(&amp;filp-&gt;f_count) == 0) {<br>
 		printk("VFS: Close: file count is 0\n");<br>
 		return 0;<br>
 	}<br>
diff -urN linux-2.3.7/fs/select.c linux-bird.f_count/fs/select.c<br>
--- linux-2.3.7/fs/select.c	Sat May 29 18:04:33 1999<br>
+++ linux-bird.f_count/fs/select.c	Mon Jun 21 07:31:21 1999<br>
@@ -65,8 +65,8 @@<br>
 			struct poll_table_entry * entry;<br>
 ok_table:<br>
 		 	entry = p-&gt;entry + p-&gt;nr;<br>
+		 	atomic_inc(&amp;filp-&gt;f_count);<br>
 		 	entry-&gt;filp = filp;<br>
-		 	filp-&gt;f_count++;<br>
 			entry-&gt;wait_address = wait_address;<br>
 			init_waitqueue_entry(&amp;entry-&gt;wait, current);<br>
 			add_wait_queue(wait_address,&amp;entry-&gt;wait);<br>
diff -urN linux-2.3.7/include/linux/file.h linux-bird.f_count/include/linux/file.h<br>
--- linux-2.3.7/include/linux/file.h	Wed Jun  9 08:04:09 1999<br>
+++ linux-bird.f_count/include/linux/file.h	Mon Jun 21 07:31:21 1999<br>
@@ -32,12 +32,13 @@<br>
 	return file;<br>
 }<br>
 <br>
+/* Still needs a protection against modifications of current-&gt;files-&gt;fd[] */<br>
 extern inline struct file * fget(unsigned int fd)<br>
 {<br>
 	struct file * file = fcheck(fd);<br>
 <br>
 	if (file)<br>
-		file-&gt;f_count++;<br>
+		atomic_inc(&amp;file-&gt;f_count);<br>
 	return file;<br>
 }<br>
 <br>
diff -urN linux-2.3.7/include/linux/fs.h linux-bird.f_count/include/linux/fs.h<br>
--- linux-2.3.7/include/linux/fs.h	Mon Jun 21 07:29:27 1999<br>
+++ linux-bird.f_count/include/linux/fs.h	Mon Jun 21 07:31:21 1999<br>
@@ -234,13 +234,30 @@<br>
 typedef void (bh_end_io_t)(struct buffer_head *bh, int uptodate);<br>
 void init_buffer(struct buffer_head *, kdev_t, int, bh_end_io_t *, void *);<br>
 <br>
-#define __buffer_state(bh, state)	(((bh)-&gt;b_state &amp; (1UL &lt;&lt; BH_##state)) != 0)<br>
+static inline int buffer_uptodate(struct buffer_head * bh)<br>
+{<br>
+	return test_bit(BH_Uptodate, &amp;bh-&gt;b_state);<br>
+}	<br>
+<br>
+static inline int buffer_dirty(struct buffer_head * bh)<br>
+{<br>
+	return test_bit(BH_Dirty, &amp;bh-&gt;b_state);<br>
+}<br>
+<br>
+static inline int buffer_locked(struct buffer_head * bh)<br>
+{<br>
+	return test_bit(BH_Lock, &amp;bh-&gt;b_state);<br>
+}<br>
+<br>
+static inline int buffer_req(struct buffer_head * bh)<br>
+{<br>
+	return test_bit(BH_Req, &amp;bh-&gt;b_state);<br>
+}<br>
 <br>
-#define buffer_uptodate(bh)	__buffer_state(bh,Uptodate)<br>
-#define buffer_dirty(bh)	__buffer_state(bh,Dirty)<br>
-#define buffer_locked(bh)	__buffer_state(bh,Lock)<br>
-#define buffer_req(bh)		__buffer_state(bh,Req)<br>
-#define buffer_protected(bh)	__buffer_state(bh,Protected)<br>
+static inline int buffer_protected(struct buffer_head * bh)<br>
+{<br>
+	return test_bit(BH_Protected, &amp;bh-&gt;b_state);<br>
+}<br>
 <br>
 #define buffer_page(bh)		(mem_map + MAP_NR((bh)-&gt;b_data))<br>
 #define touch_buffer(bh)	set_bit(PG_referenced, &amp;buffer_page(bh)-&gt;flags)<br>
@@ -345,6 +362,7 @@<br>
 	struct file_lock	*i_flock;<br>
 	struct vm_area_struct	*i_mmap;<br>
 	struct page		*i_pages;<br>
+	spinlock_t		i_shared_lock;<br>
 	struct dquot		*i_dquot[MAXQUOTAS];<br>
 	struct pipe_inode_info	*i_pipe;<br>
 <br>
@@ -353,7 +371,7 @@<br>
 	unsigned int		i_flags;<br>
 	unsigned char		i_sock;<br>
 <br>
-	int			i_writecount;<br>
+	atomic_t		i_writecount;<br>
 	unsigned int		i_attr_flags;<br>
 	__u32			i_generation;<br>
 	union {<br>
@@ -404,7 +422,8 @@<br>
 	struct file_operations	*f_op;<br>
 	mode_t			f_mode;<br>
 	loff_t			f_pos;<br>
-	unsigned int 		f_count, f_flags;<br>
+	atomic_t 		f_count;<br>
+	unsigned int		f_flags;<br>
 	unsigned long 		f_reada, f_ramax, f_raend, f_ralen, f_rawin;<br>
 	struct fown_struct	f_owner;<br>
 	unsigned int		f_uid, f_gid;<br>
diff -urN linux-2.3.7/ipc/shm.c linux-bird.f_count/ipc/shm.c<br>
--- linux-2.3.7/ipc/shm.c	Mon Jun 21 07:29:28 1999<br>
+++ linux-bird.f_count/ipc/shm.c	Mon Jun 21 07:31:21 1999<br>
@@ -547,6 +547,7 @@<br>
 	unsigned int id;<br>
 	struct shmid_kernel *shp;<br>
 <br>
+	lock_kernel();<br>
 	id = SWP_OFFSET(shmd-&gt;vm_pte) &amp; SHM_ID_MASK;<br>
 	shp = shm_segs[id];<br>
 	if (shp == IPC_UNUSED) {<br>
@@ -557,6 +558,7 @@<br>
 	shp-&gt;u.shm_nattch++;<br>
 	shp-&gt;u.shm_atime = CURRENT_TIME;<br>
 	shp-&gt;u.shm_lpid = current-&gt;pid;<br>
+	unlock_kernel();<br>
 }<br>
 <br>
 /*<br>
@@ -570,6 +572,7 @@<br>
 	struct shmid_kernel *shp;<br>
 	int id;<br>
 <br>
+	lock_kernel();<br>
 	/* remove from the list of attaches of the shm segment */<br>
 	id = SWP_OFFSET(shmd-&gt;vm_pte) &amp; SHM_ID_MASK;<br>
 	shp = shm_segs[id];<br>
@@ -578,6 +581,7 @@<br>
 	shp-&gt;u.shm_dtime = CURRENT_TIME;<br>
 	if (--shp-&gt;u.shm_nattch &lt;= 0 &amp;&amp; shp-&gt;u.shm_perm.mode &amp; SHM_DEST)<br>
 		killseg (id);<br>
+	unlock_kernel();<br>
 }<br>
 <br>
 /*<br>
diff -urN linux-2.3.7/kernel/acct.c linux-bird.f_count/kernel/acct.c<br>
--- linux-2.3.7/kernel/acct.c	Mon Jun 21 07:29:28 1999<br>
+++ linux-bird.f_count/kernel/acct.c	Mon Jun 21 07:31:21 1999<br>
@@ -276,7 +276,7 @@<br>
 	 */<br>
 	if (!file)<br>
 		return 0;<br>
-	file-&gt;f_count++;<br>
+	atomic_inc(&amp;file-&gt;f_count);<br>
 	if (!check_free_space(file)) {<br>
 		fput(file);<br>
 		return 0;<br>
diff -urN linux-2.3.7/kernel/exit.c linux-bird.f_count/kernel/exit.c<br>
--- linux-2.3.7/kernel/exit.c	Thu May 13 07:52:17 1999<br>
+++ linux-bird.f_count/kernel/exit.c	Mon Jun 21 07:31:21 1999<br>
@@ -166,11 +166,9 @@<br>
 			break;<br>
 		while (set) {<br>
 			if (set &amp; 1) {<br>
-				struct file * file = files-&gt;fd[i];<br>
-				if (file) {<br>
-					files-&gt;fd[i] = NULL;<br>
+				struct file * file = xchg(&amp;files-&gt;fd[i], NULL);<br>
+				if (file)<br>
 					filp_close(file, files);<br>
-				}<br>
 			}<br>
 			i++;<br>
 			set &gt;&gt;= 1;<br>
diff -urN linux-2.3.7/kernel/fork.c linux-bird.f_count/kernel/fork.c<br>
--- linux-2.3.7/kernel/fork.c	Sat May 29 18:05:43 1999<br>
+++ linux-bird.f_count/kernel/fork.c	Mon Jun 21 07:31:21 1999<br>
@@ -243,22 +243,28 @@<br>
 		if (!tmp)<br>
 			goto fail_nomem;<br>
 		*tmp = *mpnt;<br>
+		/*<br>
+		 * Accurate here. We need to be sure that nothing will<br>
+		 * alter mpnt-&gt;vm_file before we increment f_count.<br>
+		 */<br>
 		tmp-&gt;vm_flags &amp;= ~VM_LOCKED;<br>
 		tmp-&gt;vm_mm = mm;<br>
 		mm-&gt;map_count++;<br>
 		tmp-&gt;vm_next = NULL;<br>
 		file = tmp-&gt;vm_file;<br>
 		if (file) {<br>
-			file-&gt;f_count++;<br>
+			atomic_inc(&amp;file-&gt;f_count);<br>
 			if (tmp-&gt;vm_flags &amp; VM_DENYWRITE)<br>
-				file-&gt;f_dentry-&gt;d_inode-&gt;i_writecount--;<br>
+				atomic_dec(&amp;file-&gt;f_dentry-&gt;d_inode-&gt;i_writecount);<br>
       <br>
+			spin_lock(&amp;file-&gt;f_dentry-&gt;d_inode-&gt;i_shared_lock);<br>
 			/* insert tmp into the share list, just after mpnt */<br>
 			if((tmp-&gt;vm_next_share = mpnt-&gt;vm_next_share) != NULL)<br>
 				mpnt-&gt;vm_next_share-&gt;vm_pprev_share =<br>
 					&amp;tmp-&gt;vm_next_share;<br>
 			mpnt-&gt;vm_next_share = tmp;<br>
 			tmp-&gt;vm_pprev_share = &amp;mpnt-&gt;vm_next_share;<br>
+			spin_unlock(&amp;file-&gt;f_dentry-&gt;d_inode-&gt;i_shared_lock);<br>
 		}<br>
 <br>
 		/* Copy the pages, but defer checking for errors */<br>
@@ -483,9 +489,9 @@<br>
 	old_fds = oldf-&gt;fd;<br>
 	for (; i != 0; i--) {<br>
 		struct file *f = *old_fds++;<br>
-		*new_fds = f;<br>
 		if (f)<br>
-			f-&gt;f_count++;<br>
+			atomic_inc(&amp;f-&gt;f_count);<br>
+		*new_fds = f;<br>
 		new_fds++;<br>
 	}<br>
 	/* This is long word aligned thus could use a optimized version */ <br>
diff -urN linux-2.3.7/mm/filemap.c linux-bird.f_count/mm/filemap.c<br>
--- linux-2.3.7/mm/filemap.c	Mon Jun 21 07:29:29 1999<br>
+++ linux-bird.f_count/mm/filemap.c	Mon Jun 21 07:31:21 1999<br>
@@ -1512,7 +1512,7 @@<br>
 	 * If a task terminates while we're swapping the page, the vma and<br>
 	 * and file could be released ... increment the count to be safe.<br>
 	 */<br>
-	file-&gt;f_count++;<br>
+	atomic_inc(&amp;file-&gt;f_count);<br>
 <br>
 	/* <br>
 	 * If this is a swapping operation rather than msync(), then<br>
diff -urN linux-2.3.7/mm/memory.c linux-bird.f_count/mm/memory.c<br>
--- linux-2.3.7/mm/memory.c	Mon Jun 21 07:29:29 1999<br>
+++ linux-bird.f_count/mm/memory.c	Mon Jun 21 07:31:21 1999<br>
@@ -723,8 +723,9 @@<br>
 	struct vm_area_struct * mpnt;<br>
 <br>
 	truncate_inode_pages(inode, offset);<br>
+	spin_lock(&amp;inode-&gt;i_shared_lock);<br>
 	if (!inode-&gt;i_mmap)<br>
-		return;<br>
+		goto out_unlock;<br>
 	mpnt = inode-&gt;i_mmap;<br>
 	do {<br>
 		struct mm_struct *mm = mpnt-&gt;vm_mm;<br>
@@ -755,6 +756,8 @@<br>
 		zap_page_range(mm, start, len);<br>
 		flush_tlb_range(mm, start, end);<br>
 	} while ((mpnt = mpnt-&gt;vm_next_share) != NULL);<br>
+out_unlock:<br>
+	spin_unlock(&amp;inode-&gt;i_shared_lock);<br>
 }<br>
 <br>
 <br>
diff -urN linux-2.3.7/mm/mlock.c linux-bird.f_count/mm/mlock.c<br>
--- linux-2.3.7/mm/mlock.c	Mon May 17 07:35:39 1999<br>
+++ linux-bird.f_count/mm/mlock.c	Mon Jun 21 07:31:21 1999<br>
@@ -31,7 +31,7 @@<br>
 	vma-&gt;vm_offset += vma-&gt;vm_start - n-&gt;vm_start;<br>
 	n-&gt;vm_flags = newflags;<br>
 	if (n-&gt;vm_file)<br>
-		n-&gt;vm_file-&gt;f_count++;<br>
+		atomic_inc(&amp;n-&gt;vm_file-&gt;f_count);<br>
 	if (n-&gt;vm_ops &amp;&amp; n-&gt;vm_ops-&gt;open)<br>
 		n-&gt;vm_ops-&gt;open(n);<br>
 	insert_vm_struct(current-&gt;mm, n);<br>
@@ -52,7 +52,7 @@<br>
 	n-&gt;vm_offset += n-&gt;vm_start - vma-&gt;vm_start;<br>
 	n-&gt;vm_flags = newflags;<br>
 	if (n-&gt;vm_file)<br>
-		n-&gt;vm_file-&gt;f_count++;<br>
+		atomic_inc(&amp;n-&gt;vm_file-&gt;f_count);<br>
 	if (n-&gt;vm_ops &amp;&amp; n-&gt;vm_ops-&gt;open)<br>
 		n-&gt;vm_ops-&gt;open(n);<br>
 	insert_vm_struct(current-&gt;mm, n);<br>
@@ -82,7 +82,7 @@<br>
 	right-&gt;vm_offset += right-&gt;vm_start - left-&gt;vm_start;<br>
 	vma-&gt;vm_flags = newflags;<br>
 	if (vma-&gt;vm_file)<br>
-		vma-&gt;vm_file-&gt;f_count += 2;<br>
+		atomic_add(2, &amp;vma-&gt;vm_file-&gt;f_count);<br>
 <br>
 	if (vma-&gt;vm_ops &amp;&amp; vma-&gt;vm_ops-&gt;open) {<br>
 		vma-&gt;vm_ops-&gt;open(left);<br>
@@ -179,7 +179,6 @@<br>
 	int error = -ENOMEM;<br>
 <br>
 	down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
-	lock_kernel();<br>
 	len = (len + (start &amp; ~PAGE_MASK) + ~PAGE_MASK) &amp; PAGE_MASK;<br>
 	start &amp;= PAGE_MASK;<br>
 <br>
@@ -200,7 +199,6 @@<br>
 <br>
 	error = do_mlock(start, len, 1);<br>
 out:<br>
-	unlock_kernel();<br>
 	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	return error;<br>
 }<br>
@@ -210,11 +208,9 @@<br>
 	int ret;<br>
 <br>
 	down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
-	lock_kernel();<br>
 	len = (len + (start &amp; ~PAGE_MASK) + ~PAGE_MASK) &amp; PAGE_MASK;<br>
 	start &amp;= PAGE_MASK;<br>
 	ret = do_mlock(start, len, 0);<br>
-	unlock_kernel();<br>
 	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	return ret;<br>
 }<br>
@@ -254,7 +250,6 @@<br>
 	int ret = -EINVAL;<br>
 <br>
 	down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
-	lock_kernel();<br>
 	if (!flags || (flags &amp; ~(MCL_CURRENT | MCL_FUTURE)))<br>
 		goto out;<br>
 <br>
@@ -272,7 +267,6 @@<br>
 <br>
 	ret = do_mlockall(flags);<br>
 out:<br>
-	unlock_kernel();<br>
 	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	return ret;<br>
 }<br>
@@ -282,9 +276,7 @@<br>
 	int ret;<br>
 <br>
 	down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
-	lock_kernel();<br>
 	ret = do_mlockall(0);<br>
-	unlock_kernel();<br>
 	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	return ret;<br>
 }<br>
diff -urN linux-2.3.7/mm/mmap.c linux-bird.f_count/mm/mmap.c<br>
--- linux-2.3.7/mm/mmap.c	Mon Jun 21 07:29:29 1999<br>
+++ linux-bird.f_count/mm/mmap.c	Mon Jun 21 07:31:21 1999<br>
@@ -77,10 +77,12 @@<br>
 <br>
 	if (file) {<br>
 		if (vma-&gt;vm_flags &amp; VM_DENYWRITE)<br>
-			file-&gt;f_dentry-&gt;d_inode-&gt;i_writecount++;<br>
+			atomic_inc(&amp;file-&gt;f_dentry-&gt;d_inode-&gt;i_writecount);<br>
+		spin_lock(&amp;file-&gt;f_dentry-&gt;d_inode-&gt;i_shared_lock);<br>
 		if(vma-&gt;vm_next_share)<br>
 			vma-&gt;vm_next_share-&gt;vm_pprev_share = vma-&gt;vm_pprev_share;<br>
 		*vma-&gt;vm_pprev_share = vma-&gt;vm_next_share;<br>
+		spin_unlock(&amp;file-&gt;f_dentry-&gt;d_inode-&gt;i_shared_lock);<br>
 	}<br>
 }<br>
 <br>
@@ -294,7 +296,12 @@<br>
 	if (file) {<br>
 		int correct_wcount = 0;<br>
 		if (vma-&gt;vm_flags &amp; VM_DENYWRITE) {<br>
-			if (file-&gt;f_dentry-&gt;d_inode-&gt;i_writecount &gt; 0) {<br>
+			/*<br>
+			 * WARNING: when we will take it out of the big lock<br>
+			 * we will need a spinlock here. See comments in<br>
+			 * fs/namei.c::get_write_access()<br>
+			 */<br>
+			if (atomic_read(&amp;file-&gt;f_dentry-&gt;d_inode-&gt;i_writecount) &gt; 0) {<br>
 				error = -ETXTBSY;<br>
 				goto free_vma;<br>
 			}<br>
@@ -303,17 +310,17 @@<br>
 			 * might). In any case, this takes care of any<br>
 			 * race that this might cause.<br>
 			 */<br>
-			file-&gt;f_dentry-&gt;d_inode-&gt;i_writecount--;<br>
+			atomic_dec(&amp;file-&gt;f_dentry-&gt;d_inode-&gt;i_writecount);<br>
 			correct_wcount = 1;<br>
 		}<br>
 		error = file-&gt;f_op-&gt;mmap(file, vma);<br>
 		/* Fix up the count if necessary, then check for an error */<br>
 		if (correct_wcount)<br>
-			file-&gt;f_dentry-&gt;d_inode-&gt;i_writecount++;<br>
+			atomic_inc(&amp;file-&gt;f_dentry-&gt;d_inode-&gt;i_writecount);<br>
 		if (error)<br>
 			goto unmap_and_free_vma;<br>
+		atomic_inc(&amp;file-&gt;f_count);<br>
 		vma-&gt;vm_file = file;<br>
-		file-&gt;f_count++;<br>
 	}<br>
 <br>
 	/*<br>
@@ -547,7 +554,7 @@<br>
 		mpnt-&gt;vm_file = area-&gt;vm_file;<br>
 		mpnt-&gt;vm_pte = area-&gt;vm_pte;<br>
 		if (mpnt-&gt;vm_file)<br>
-			mpnt-&gt;vm_file-&gt;f_count++;<br>
+			atomic_inc(&amp;mpnt-&gt;vm_file-&gt;f_count);<br>
 		if (mpnt-&gt;vm_ops &amp;&amp; mpnt-&gt;vm_ops-&gt;open)<br>
 			mpnt-&gt;vm_ops-&gt;open(mpnt);<br>
 		area-&gt;vm_end = addr;	/* Truncate area */<br>
@@ -875,13 +882,14 @@<br>
 	if (file) {<br>
 		struct inode * inode = file-&gt;f_dentry-&gt;d_inode;<br>
 		if (vmp-&gt;vm_flags &amp; VM_DENYWRITE)<br>
-			inode-&gt;i_writecount--;<br>
-      <br>
+			atomic_dec(&amp;inode-&gt;i_writecount);<br>
+      		spin_lock(&amp;inode-&gt;i_shared_lock);<br>
 		/* insert vmp into inode's share list */<br>
 		if((vmp-&gt;vm_next_share = inode-&gt;i_mmap) != NULL)<br>
 			inode-&gt;i_mmap-&gt;vm_pprev_share = &amp;vmp-&gt;vm_next_share;<br>
 		inode-&gt;i_mmap = vmp;<br>
 		vmp-&gt;vm_pprev_share = &amp;inode-&gt;i_mmap;<br>
+      		spin_unlock(&amp;inode-&gt;i_shared_lock);<br>
 	}<br>
 }<br>
 <br>
@@ -948,7 +956,7 @@<br>
 		mm-&gt;map_count--;<br>
 		remove_shared_vm_struct(mpnt);<br>
 		if (mpnt-&gt;vm_file)<br>
-			fput(mpnt-&gt;vm_file);<br>
+			fput(mpnt-&gt;vm_file);	/* This one is safe */<br>
 		kmem_cache_free(vm_area_cachep, mpnt);<br>
 		mpnt = prev;<br>
 	}<br>
diff -urN linux-2.3.7/mm/mprotect.c linux-bird.f_count/mm/mprotect.c<br>
--- linux-2.3.7/mm/mprotect.c	Thu May 13 07:03:30 1999<br>
+++ linux-bird.f_count/mm/mprotect.c	Mon Jun 21 07:31:22 1999<br>
@@ -103,7 +103,7 @@<br>
 	n-&gt;vm_flags = newflags;<br>
 	n-&gt;vm_page_prot = prot;<br>
 	if (n-&gt;vm_file)<br>
-		n-&gt;vm_file-&gt;f_count++;<br>
+		atomic_inc(&amp;n-&gt;vm_file-&gt;f_count);<br>
 	if (n-&gt;vm_ops &amp;&amp; n-&gt;vm_ops-&gt;open)<br>
 		n-&gt;vm_ops-&gt;open(n);<br>
 	insert_vm_struct(current-&gt;mm, n);<br>
@@ -126,7 +126,7 @@<br>
 	n-&gt;vm_flags = newflags;<br>
 	n-&gt;vm_page_prot = prot;<br>
 	if (n-&gt;vm_file)<br>
-		n-&gt;vm_file-&gt;f_count++;<br>
+		atomic_inc(&amp;n-&gt;vm_file-&gt;f_count);<br>
 	if (n-&gt;vm_ops &amp;&amp; n-&gt;vm_ops-&gt;open)<br>
 		n-&gt;vm_ops-&gt;open(n);<br>
 	insert_vm_struct(current-&gt;mm, n);<br>
@@ -158,7 +158,7 @@<br>
 	vma-&gt;vm_flags = newflags;<br>
 	vma-&gt;vm_page_prot = prot;<br>
 	if (vma-&gt;vm_file)<br>
-		vma-&gt;vm_file-&gt;f_count += 2;<br>
+		atomic_add(2,&amp;vma-&gt;vm_file-&gt;f_count);<br>
 	if (vma-&gt;vm_ops &amp;&amp; vma-&gt;vm_ops-&gt;open) {<br>
 		vma-&gt;vm_ops-&gt;open(left);<br>
 		vma-&gt;vm_ops-&gt;open(right);<br>
@@ -212,7 +212,6 @@<br>
 		return 0;<br>
 <br>
 	down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
-	lock_kernel();<br>
 <br>
 	vma = find_vma(current-&gt;mm, start);<br>
 	error = -EFAULT;<br>
@@ -249,7 +248,6 @@<br>
 	}<br>
 	merge_segments(current-&gt;mm, start, end);<br>
 out:<br>
-	unlock_kernel();<br>
 	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	return error;<br>
 }<br>
diff -urN linux-2.3.7/mm/mremap.c linux-bird.f_count/mm/mremap.c<br>
--- linux-2.3.7/mm/mremap.c	Wed Jun  9 08:04:28 1999<br>
+++ linux-bird.f_count/mm/mremap.c	Mon Jun 21 07:31:22 1999<br>
@@ -134,14 +134,12 @@<br>
 			new_vma-&gt;vm_start = new_addr;<br>
 			new_vma-&gt;vm_end = new_addr+new_len;<br>
 			new_vma-&gt;vm_offset = vma-&gt;vm_offset + (addr - vma-&gt;vm_start);<br>
-			lock_kernel();<br>
 			if (new_vma-&gt;vm_file)<br>
-				new_vma-&gt;vm_file-&gt;f_count++;<br>
+				atomic_inc(&amp;new_vma-&gt;vm_file-&gt;f_count);<br>
 			if (new_vma-&gt;vm_ops &amp;&amp; new_vma-&gt;vm_ops-&gt;open)<br>
 				new_vma-&gt;vm_ops-&gt;open(new_vma);<br>
 			insert_vm_struct(current-&gt;mm, new_vma);<br>
 			merge_segments(current-&gt;mm, new_vma-&gt;vm_start, new_vma-&gt;vm_end);<br>
-			unlock_kernel();<br>
 			do_munmap(addr, old_len);<br>
 			current-&gt;mm-&gt;total_vm += new_len &gt;&gt; PAGE_SHIFT;<br>
 			if (new_vma-&gt;vm_flags &amp; VM_LOCKED) {<br>
diff -urN linux-2.3.7/net/core/scm.c linux-bird.f_count/net/core/scm.c<br>
--- linux-2.3.7/net/core/scm.c	Thu May 13 07:03:32 1999<br>
+++ linux-bird.f_count/net/core/scm.c	Mon Jun 21 07:31:22 1999<br>
@@ -232,8 +232,8 @@<br>
 			break;<br>
 		}<br>
 		/* Bump the usage count and install the file. */<br>
-		fp[i]-&gt;f_count++;<br>
-		current-&gt;files-&gt;fd[new_fd] = fp[i];<br>
+		atomic_inc(&amp;fp[i]-&gt;f_count);<br>
+		fd_install(new_fd, fp[i]);<br>
 	}<br>
 <br>
 	if (i &gt; 0)<br>
@@ -271,10 +271,9 @@<br>
 <br>
 	new_fpl = kmalloc(sizeof(*fpl), GFP_KERNEL);<br>
 	if (new_fpl) {<br>
-		memcpy(new_fpl, fpl, sizeof(*fpl));<br>
-<br>
 		for (i=fpl-&gt;count-1; i&gt;=0; i--)<br>
-			fpl-&gt;fp[i]-&gt;f_count++;<br>
+			atomic_inc(&amp;fpl-&gt;fp[i]-&gt;f_count);<br>
+		memcpy(new_fpl, fpl, sizeof(*fpl));<br>
 	}<br>
 	return new_fpl;<br>
 }<br>
diff -urN linux-2.3.7/net/sunrpc/xprt.c linux-bird.f_count/net/sunrpc/xprt.c<br>
--- linux-2.3.7/net/sunrpc/xprt.c	Wed Jun  9 08:04:49 1999<br>
+++ linux-bird.f_count/net/sunrpc/xprt.c	Mon Jun 21 07:31:22 1999<br>
@@ -1455,8 +1455,8 @@<br>
 <br>
 	proto = (sock-&gt;type == SOCK_DGRAM)? IPPROTO_UDP : IPPROTO_TCP;<br>
 	if ((xprt = xprt_setup(sock, proto, ap, to)) != NULL) {<br>
+		atomic_inc(&amp;file-&gt;f_count);<br>
 		xprt-&gt;file = file;<br>
-		file-&gt;f_count++;<br>
 	}<br>
 <br>
 	return xprt;<br>
diff -urN linux-2.3.7/net/unix/garbage.c linux-bird.f_count/net/unix/garbage.c<br>
--- linux-2.3.7/net/unix/garbage.c	Thu May 13 07:03:39 1999<br>
+++ linux-bird.f_count/net/unix/garbage.c	Mon Jun 21 07:31:22 1999<br>
@@ -199,7 +199,8 @@<br>
 		 *	in flight we are in use.<br>
 		 */<br>
 		if(s-&gt;socket &amp;&amp; s-&gt;socket-&gt;file &amp;&amp;<br>
-		   s-&gt;socket-&gt;file-&gt;f_count &gt; s-&gt;protinfo.af_unix.inflight)<br>
+		   atomic_read(&amp;s-&gt;socket-&gt;file-&gt;f_count) &gt;<br>
+				   s-&gt;protinfo.af_unix.inflight)<br>
 			maybe_unmark_and_push(s);<br>
 	}<br>
 <br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0258.html">Rick Hohensee: "in re... I discussed directory bla bla"</a>
<li> <b>Previous message:</b> <a href="0256.html">Andrea Arcangeli: "Re: [patch] `cp /dev/zero /tmp' (patch against 2.2.9)"</a>
<li> <b>In reply to:</b> <a href="0207.html">Alan Cox: "Re: I discussed reading directories as files with jra, Stallman,"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
