<!-- received="Tue Jun 22 01:22:34 1999 EET DST" -->
<!-- sent="Mon, 21 Jun 1999 18:27:59 +0200" -->
<!-- name="Pavel Machek" -->
<!-- email="pavel@bug.ucw.cz" -->
<!-- subject="Make USB printer work" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-25,: Make USB printer work</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Make USB printer work</h1>
<b>Pavel Machek</b> (<a href="mailto:pavel@bug.ucw.cz"><i>pavel@bug.ucw.cz</i></a>)<br>
<i>Mon, 21 Jun 1999 18:27:59 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#349">[ date ]</a><a href="index.html#349">[ thread ]</a><a href="subject.html#349">[ subject ]</a><a href="author.html#349">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0350.html">Pavel Machek: "2.3.6: panic: VFS: LRU block list corrupted"</a>
<li> <b>Previous message:</b> <a href="0348.html">Richard Stallman: "Re: I discussed reading directories as files with jra, Stallman, and loic"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi!<br>
<p>
Please apply this trivial patch -- it makes printer actually work. No<br>
more repeating of first characters of text all over and over and over<br>
and ov...<br>
<p>
							Pavel<br>
<p>
--- clean/drivers/usb/printer.c	Tue Jun 15 11:25:37 1999<br>
+++ linux/drivers/usb/printer.c	Tue Jun 15 11:19:33 1999<br>
@@ -2,6 +2,7 @@<br>
 /* Driver for USB Printers<br>
  * <br>
  * (C) Michael Gee (<a href="mailto:michael@linuxspecific.com">michael@linuxspecific.com</a>) 1999<br>
+ * Copyright 1999 Pavel Machek &lt;<a href="mailto:pavel@ucw.cz">pavel@ucw.cz</a>&gt;, sponsored by SuSE<br>
  * <br>
  */<br>
 <br>
@@ -25,7 +26,7 @@<br>
 #define MAX_RETRY_COUNT ((60*60*HZ)/NAK_TIMEOUT)	/* should not take 1 minute a page! */<br>
 <br>
 #ifndef USB_PRINTER_MAJOR<br>
-#define USB_PRINTER_MAJOR 0<br>
+#define USB_PRINTER_MAJOR 63<br>
 #endif<br>
 <br>
 static int mymajor = USB_PRINTER_MAJOR;<br>
@@ -179,16 +180,19 @@<br>
 			}<br>
 			result = p-&gt;pusb_dev-&gt;bus-&gt;op-&gt;bulk_msg(p-&gt;pusb_dev,<br>
 					 usb_sndbulkpipe(p-&gt;pusb_dev, 1), obuf, thistime, &amp;partial);<br>
+			if (partial) {<br>
+				obuf += partial;<br>
+				thistime -= partial;<br>
+				maxretry = MAX_RETRY_COUNT;<br>
+			}<br>
 			if (result == USB_ST_TIMEOUT) {	/* NAK - so hold for a while */<br>
 				if(!maxretry--)<br>
 					return -ETIME;<br>
                                 interruptible_sleep_on_timeout(&amp;p-&gt;wait_q, NAK_TIMEOUT);<br>
 				continue;<br>
-			} else if (!result &amp; partial) {<br>
-				obuf += partial;<br>
-				thistime -= partial;<br>
-			} else<br>
+			} else if (!result &amp;&amp; !partial) {<br>
 				break;<br>
+			}<br>
 		};<br>
 		if (result) {<br>
 			/* whoops - let's reset and fail the request */<br>
@@ -255,9 +259,10 @@<br>
 	/*<br>
 	 * FIXME - this will not cope with combined printer/scanners<br>
 	 */<br>
-	if (dev-&gt;descriptor.bDeviceClass != 7 ||<br>
+	if ((dev-&gt;descriptor.bDeviceClass != 7 &amp;&amp;<br>
+	     dev-&gt;descriptor.bDeviceClass != 0) ||<br>
 	    dev-&gt;descriptor.bNumConfigurations != 1 ||<br>
 	    dev-&gt;config[0].bNumInterfaces != 1) {<br>
 		return -1;<br>
 	}<br>
 <br>
<p>
<pre>
-- 
I'm really <a href="mailto:pavel@ucw.cz">pavel@ucw.cz</a>. Look at <a href="http://195.113.31.123/~pavel">http://195.113.31.123/~pavel</a>.  Pavel
Hi! I'm a .signature virus! Copy me into your ~/.signature, please!
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0350.html">Pavel Machek: "2.3.6: panic: VFS: LRU block list corrupted"</a>
<li> <b>Previous message:</b> <a href="0348.html">Richard Stallman: "Re: I discussed reading directories as files with jra, Stallman, and loic"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
