<!-- received="Tue Jun 22 12:04:03 1999 EET DST" -->
<!-- sent="Tue, 22 Jun 1999 00:01:35 +0930" -->
<!-- name="Paul Rusty Russell" -->
<!-- email="Paul.Russell@rustcorp.com.au" -->
<!-- subject="[PATCH] egcs "unused variable" warning fixup." -->
<!-- id="m10w56s-000mTzC@ketchup192.rustcorp.com.au" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-25,: [PATCH] egcs "unused variable" warning fixup.</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] egcs "unused variable" warning fixup.</h1>
<b>Paul Rusty Russell</b> (<a href="mailto:Paul.Russell@rustcorp.com.au"><i>Paul.Russell@rustcorp.com.au</i></a>)<br>
<i>Tue, 22 Jun 1999 00:01:35 +0930</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#438">[ date ]</a><a href="index.html#438">[ thread ]</a><a href="subject.html#438">[ subject ]</a><a href="author.html#438">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0439.html">Jeff Garzik: "Re: cachefs: need help to finish code..."</a>
<li> <b>Previous message:</b> <a href="0437.html">Jay Thorne: "Util-linux 2.9o lpstat does not compile against 2.2.10 or 2.3.4"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Doesn't seem to alter codegen, and gets rid of complaints about<br>
"unused" spinlocks for non-SMP.  Surrounding spinlock decls by #ifdef<br>
CONFIG_SMP is gross, and breaks spinlock debugging.<br>
<p>
Rusty.<br>
--- linux/include/asm/spinlock.h.~3~	Tue Jun  8 17:40:27 1999<br>
+++ linux/include/asm/spinlock.h	Mon Jun 21 23:57:12 1999<br>
@@ -50,7 +50,7 @@<br>
 #endif<br>
 <br>
 #define spin_lock_init(lock)	do { } while(0)<br>
-#define spin_lock(lock)		do { } while(0)<br>
+#define spin_lock(lock)		(void)(lock) /* Not "unused variable". */<br>
 #define spin_trylock(lock)	(1)<br>
 #define spin_unlock_wait(lock)	do { } while(0)<br>
 #define spin_unlock(lock)	do { } while(0)<br>
@@ -109,9 +109,9 @@<br>
   #define RW_LOCK_UNLOCKED (rwlock_t) { 0 }<br>
 #endif<br>
 <br>
-#define read_lock(lock)		do { } while(0)<br>
+#define read_lock(lock)		(void)(lock) /* Not "unused variable". */<br>
 #define read_unlock(lock)	do { } while(0)<br>
-#define write_lock(lock)	do { } while(0)<br>
+#define write_lock(lock)	(void)(lock) /* Not "unused variable". */<br>
 #define write_unlock(lock)	do { } while(0)<br>
 <br>
 #else	/* __SMP__ */<br>
<pre>
--
Tridge, Raster, DaveM, Cort, maddog... Where will you be 9-11 July 1999?
                <a href="http://www.linux.org.au/projects/calu">http://www.linux.org.au/projects/calu</a>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0439.html">Jeff Garzik: "Re: cachefs: need help to finish code..."</a>
<li> <b>Previous message:</b> <a href="0437.html">Jay Thorne: "Util-linux 2.9o lpstat does not compile against 2.2.10 or 2.3.4"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
