<!-- received="Wed Jun 23 16:40:29 1999 EET DST" -->
<!-- sent="23 Jun 1999 14:57:04 +0300" -->
<!-- name="Alexander L. Belikoff" -->
<!-- email="abel@bfr.co.il" -->
<!-- subject="[PATCH] UTS version naming a-la BSD" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-25,: [PATCH] UTS version naming a-la BSD</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] UTS version naming a-la BSD</h1>
<b>Alexander L. Belikoff</b> (<a href="mailto:abel@bfr.co.il"><i>abel@bfr.co.il</i></a>)<br>
<i>23 Jun 1999 14:57:04 +0300</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#712">[ date ]</a><a href="index.html#712">[ thread ]</a><a href="subject.html#712">[ subject ]</a><a href="author.html#712">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0713.html">Pavel Machek: "Web direction for filesystem [was Re: Some very thought-provoking ideas about OS architecture.]"</a>
<li> <b>Previous message:</b> <a href="0711.html">Michael Harnois: "Re: Kernel modules compiling error on 2.3.8 ?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi everybody,<br>
<p>
I've been always missing the ability to have some kind of unique<br>
kernel identifier in the UTS version string. So far, Linux just has a<br>
version number (the one printed after the '#' sign). Basically,<br>
whenever you rebuild a kernel, that number gets incremented.<br>
<p>
Here is a trivial patch, that allows you to put pretty much anything<br>
past the # sign - just put it in the .version file. If you don't tweak <br>
it, the default functionality is employed.<br>
<p>
<p>
<p>
--- Makefile    Wed Jun 23 08:38:45 1999<br>
+++ Makefile.new        Wed Jun 23 08:41:41 1999<br>
@@ -250,7 +250,7 @@<br>
 newversion:<br>
        @if [ ! -f .version ]; then \<br>
                echo 1 &gt; .version; \<br>
-       else \<br>
+       elif egrep -q '^[0-9]+$$' .version; then \<br>
                expr 0`cat .version` + 1 &gt; .version; \<br>
        fi<br>
<p>
<p>
<p>
Regards,<br>
<p>
<pre>
-- 
Alexander L. Belikoff
Bloomberg L.P. / BFM Financial Research Ltd.
<a href="mailto:abel@vallinor4.com">abel@vallinor4.com</a>, abel@bfr.co.il
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0713.html">Pavel Machek: "Web direction for filesystem [was Re: Some very thought-provoking ideas about OS architecture.]"</a>
<li> <b>Previous message:</b> <a href="0711.html">Michael Harnois: "Re: Kernel modules compiling error on 2.3.8 ?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
