<!-- received="Wed Jun 23 17:00:15 1999 EET DST" -->
<!-- sent="Wed, 23 Jun 1999 09:35:43 -0400" -->
<!-- name="Jeff Garzik" -->
<!-- email="jgarzik@pobox.com" -->
<!-- subject="Re: bug in fbmem.c," -->
<!-- id="" -->
<!-- inreplyto="bug in fbmem.c," -->
<title>Linux-kernel mailing list archive 1999-25,: Re: bug in fbmem.c,</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: bug in fbmem.c,</h1>
<b>Jeff Garzik</b> (<a href="mailto:jgarzik@pobox.com"><i>jgarzik@pobox.com</i></a>)<br>
<i>Wed, 23 Jun 1999 09:35:43 -0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#726">[ date ]</a><a href="index.html#726">[ thread ]</a><a href="subject.html#726">[ subject ]</a><a href="author.html#726">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0727.html">Riley Williams: "[PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Previous message:</b> <a href="0725.html">Alan Cox: "Re: [off-topic] Microsoft IP Stack"</a>
<li> <b>Maybe in reply to:</b> <a href="0449.html">Vignaud Jean-Baptiste: "bug in fbmem.c,"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------DDC0733EF0F328321B2B9EC7<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Let me know if this fixes it.<br>
<p>
	Jeff<br>
--------------DDC0733EF0F328321B2B9EC7<br>
Content-Type: text/plain; charset=us-ascii;<br>
 name="patch"<br>
Content-Transfer-Encoding: 7bit<br>
Content-Disposition: inline;<br>
 filename="patch"<br>
<p>
Index: fbmem.c<br>
===================================================================<br>
RCS file: /usr/local/cvsroot/linux_2_3/drivers/video/fbmem.c,v<br>
retrieving revision 1.1.1.1.24.2<br>
diff -u -r1.1.1.1.24.2 fbmem.c<br>
--- fbmem.c	1999/06/06 20:31:09	1.1.1.1.24.2<br>
+++ fbmem.c	1999/06/23 13:37:02<br>
@@ -30,9 +30,7 @@<br>
 #if defined(__mc68000__) || defined(CONFIG_APUS)<br>
 #include &lt;asm/setup.h&gt;<br>
 #endif<br>
-#ifdef __powerpc__<br>
 #include &lt;asm/io.h&gt;<br>
-#endif<br>
 #include &lt;asm/uaccess.h&gt;<br>
 #include &lt;asm/page.h&gt;<br>
 #include &lt;asm/pgtable.h&gt;<br>
@@ -278,9 +276,14 @@<br>
 	fb-&gt;fb_get_fix(&amp;fix,PROC_CONSOLE(info), info);<br>
 	base_addr=info-&gt;disp-&gt;screen_base;<br>
 	copy_size=(count + p &lt;= fix.smem_len ? count : fix.smem_len - p);<br>
-	if (copy_to_user(buf, base_addr+p, copy_size))<br>
-	    return -EFAULT;<br>
-	*ppos += copy_size;<br>
+	if (copy_size &gt; 0) {<br>
+		char tmpbuf [copy_size];<br>
+<br>
+		memcpy_fromio ((void *)&amp;tmpbuf, base_addr+p, copy_size);<br>
+		if (copy_to_user(buf, (void *)&amp;tmpbuf, copy_size))<br>
+	    		return -EFAULT;<br>
+		*ppos += copy_size;<br>
+	}<br>
 	return copy_size;<br>
 }<br>
 <br>
@@ -302,9 +305,14 @@<br>
 	fb-&gt;fb_get_fix(&amp;fix, PROC_CONSOLE(info), info);<br>
 	base_addr=info-&gt;disp-&gt;screen_base;<br>
 	copy_size=(count + p &lt;= fix.smem_len ? count : fix.smem_len - p);<br>
-	if (copy_from_user(base_addr+p, buf, copy_size))<br>
-	    return -EFAULT;<br>
-	file-&gt;f_pos += copy_size;<br>
+	if (copy_size &gt; 0) {<br>
+		char tmpbuf [copy_size];<br>
+<br>
+		if (copy_from_user((void *)&amp;tmpbuf, buf, copy_size))<br>
+	    		return -EFAULT;<br>
+		memcpy_toio (base_addr+p, (void *)&amp;tmpbuf, copy_size);<br>
+		file-&gt;f_pos += copy_size;<br>
+	}<br>
 	return copy_size;<br>
 }<br>
 <br>
<p>
--------------DDC0733EF0F328321B2B9EC7--<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0727.html">Riley Williams: "[PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Previous message:</b> <a href="0725.html">Alan Cox: "Re: [off-topic] Microsoft IP Stack"</a>
<li> <b>Maybe in reply to:</b> <a href="0449.html">Vignaud Jean-Baptiste: "bug in fbmem.c,"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
