<!-- received="Wed Jun 23 17:02:20 1999 EET DST" -->
<!-- sent="Wed, 23 Jun 1999 14:49:14 +0100 (GMT)" -->
<!-- name="Riley Williams" -->
<!-- email="rhw@MemAlpha.CX" -->
<!-- subject="[PATCH] *(int*)0 = 0 &amp; variations" -->
<!-- id="" -->
<!-- inreplyto="Pine.GSO.3.96.990622181052.8838K-100000@ext1" -->
<title>Linux-kernel mailing list archive 1999-25,: [PATCH] *(int*)0 = 0 &amp; variations</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] *(int*)0 = 0 &amp; variations</h1>
<b>Riley Williams</b> (<a href="mailto:rhw@MemAlpha.CX"><i>rhw@MemAlpha.CX</i></a>)<br>
<i>Wed, 23 Jun 1999 14:49:14 +0100 (GMT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#727">[ date ]</a><a href="index.html#727">[ thread ]</a><a href="subject.html#727">[ subject ]</a><a href="author.html#727">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0728.html">Riley Williams: "Re: why is the size of a directory always 1024b ?"</a>
<li> <b>Previous message:</b> <a href="0726.html">Jeff Garzik: "Re: bug in fbmem.c,"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0730.html">Jeff Garzik: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0730.html">Jeff Garzik: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0737.html">Andrew Morton: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0740.html">Manfred Spraul: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0777.html">Horst von Brand: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0794.html">Manfred Spraul: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0808.html">Manfred Spraul: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0833.html">Manfred Spraul: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0854.html">Jeff Garzik: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0876.html">Jeff Garzik: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0916.html">Jeff Garzik: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0986.html">Manfred Spraul: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="1020.html">Stefan Monnier: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="1090.html">Horst von Brand: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="1170.html">Manfred Spraul: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi there.<br>
<p>
<i> &gt;&gt; * assert()</i><br>
<p>
<i> &gt; Very, very much needed.  IMHO this should be enabled by default</i><br>
<i> &gt; in experimental versions and disabled in stable versions.</i><br>
<p>
Perhaps the following patch will help. It defines a kassert() macro<br>
that reports the location where an assertion fails via printk with the<br>
KERN_DEBUG reporting level, and should apply cleanly against ANY Linux<br>
kernel release.<br>
<p>
To enable it, define DEBUG before including it; to disable it, don't.<br>
<p>
All that's required is for the relevant unit authors to add the<br>
relevant calls to their units.<br>
<p>
===8&lt;=== CUT ===&gt;8===<br>
--- linux/include/linux/kassert.h~	Thu Jan  1 01:00:00 1970<br>
+++ linux/include/linux/kassert.h	Wed Jun 23 14:37:54 1999<br>
@@ -0,0 +1,16 @@<br>
+/*<br>
+ * Include definitions for kernel assertion checking<br>
+ */<br>
+<br>
+#ifndef __KASSERT_H__<br>
+#define __KASSERT_H__<br>
+<br>
+#ifdef DEBUG<br>
+#define kassert(cond) if (!(cond)) \<br>
+	printk(KERN_DEBUG "ASSERTION FAILURE: %s line %u: %s\n", \<br>
+		__FILE__, __LINE__, "cond")<br>
+#else<br>
+#define kassert(cond)<br>
+#endif<br>
+<br>
+#endif<br>
===8&lt;=== CUT ===&gt;8===<br>
<p>
Best wishes from Riley.<br>
<p>
+----------------------------------------------------------------------+<br>
<i>| There is something frustrating about the quality and speed of Linux  |</i><br>
<i>| development, ie., the quality is too high and the speed is too high, |</i><br>
<i>| in other words, I can implement this XXXX feature, but I bet someone |</i><br>
<i>| else has already done so and is just about to release their patch.   |</i><br>
+----------------------------------------------------------------------+<br>
 * <a href="ftp://ftp.MemAlpha.cx/pub/rhw/Linux">ftp://ftp.MemAlpha.cx/pub/rhw/Linux</a><br>
 * <a href="http://www.MemAlpha.cx/kernel.versions.html">http://www.MemAlpha.cx/kernel.versions.html</a><br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0728.html">Riley Williams: "Re: why is the size of a directory always 1024b ?"</a>
<li> <b>Previous message:</b> <a href="0726.html">Jeff Garzik: "Re: bug in fbmem.c,"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0730.html">Jeff Garzik: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0730.html">Jeff Garzik: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0737.html">Andrew Morton: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0740.html">Manfred Spraul: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0777.html">Horst von Brand: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0794.html">Manfred Spraul: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0808.html">Manfred Spraul: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0833.html">Manfred Spraul: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0854.html">Jeff Garzik: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0876.html">Jeff Garzik: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0916.html">Jeff Garzik: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="0986.html">Manfred Spraul: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="1020.html">Stefan Monnier: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="1090.html">Horst von Brand: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<li> <b>Reply:</b> <a href="1170.html">Manfred Spraul: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<!-- reply="end" -->
</ul>
</font></body>
