<!-- received="Wed Jun 23 17:29:15 1999 EET DST" -->
<!-- sent="Wed, 23 Jun 1999 15:21:44 +0100 (BST)" -->
<!-- name="Alan Cox" -->
<!-- email="alan@lxorguk.ukuu.org.uk" -->
<!-- subject="File Corruption Bug.. continued" -->
<!-- id="E10wnuM-00000M-00@the-village.bc.nu" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-25,: File Corruption Bug.. continued</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>File Corruption Bug.. continued</h1>
<b>Alan Cox</b> (<a href="mailto:alan@lxorguk.ukuu.org.uk"><i>alan@lxorguk.ukuu.org.uk</i></a>)<br>
<i>Wed, 23 Jun 1999 15:21:44 +0100 (BST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#734">[ date ]</a><a href="index.html#734">[ thread ]</a><a href="subject.html#734">[ subject ]</a><a href="author.html#734">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0735.html">Stephen C. Tweedie: "Re: Windows NT File Systems and Linux File Systems"</a>
<li> <b>Previous message:</b> <a href="0733.html">leitner@convergence.de: "Why Linux is doomed (was: Re: FENRIS (nwfs) 1.4.2 Source Code Available)"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0760.html">Andrea Arcangeli: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0760.html">Andrea Arcangeli: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0785.html">Chris Adams: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0802.html">Khimenko Victor: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0807.html">Thomas Davis: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0810.html">James David Rich: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0820.html">Rik van Riel: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0825.html">Thomas Davis: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0829.html">David J. Fred: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0855.html">Guest section DW: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0900.html">Anthony Barbachan: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0908.html">Khimenko Victor: "Re: File Corruption Bug.. continued"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
I've now been through most of the 2.2.7-&gt;2.2.9 diff set discarding stuff<br>
that seems not to be a viable candiate.<br>
<p>
The remaining suspects are:<br>
	o	Quota - which has big 2.2.7-&gt;2.2.9 changes.<br>
	o	The small scsi changes (dubious)<br>
	o	A small mm change<br>
<p>
There are other candiates - notably<br>
	TCP changes<br>
	interrupt changes<br>
	IRDA<br>
	NFS<br>
<p>
The tcp changes ought to have shown up more than this does. The interrupt<br>
changes dont really seem to explain cross platform stuff. And I doubt most<br>
people running these tests were running irda. NFS is a possibility.<br>
<p>
So - are most people seeing the problems running quotas ? And would someone<br>
with their brain firmly wrapped around the page cache/vfs verify this change<br>
that was made is absolutely safe<br>
<p>
diff -u --new-file --recursive --exclude-from ../../exclude linux.2.2.7/mm/page_alloc.c linux.2.2.9/mm/page_alloc.c<br>
--- linux.2.2.7/mm/page_alloc.c	Wed Jun 23 17:48:03 1999<br>
+++ linux.2.2.9/mm/page_alloc.c	Wed Jun 23 17:43:53 1999<br>
@@ -419,12 +419,12 @@<br>
 		return;<br>
 	}<br>
 <br>
-	/* The page is unshared, and we want write access.  In this<br>
-	   case, it is safe to tear down the swap cache and give the<br>
-	   page over entirely to this process. */<br>
-<br>
-	if (PageSwapCache(page_map))<br>
-		delete_from_swap_cache(page_map);<br>
+	/*<br>
+	 * The page is unshared and we're going to dirty it - so tear<br>
+	 * down the swap cache and give exclusive access to the page to<br>
+	 * this process.<br>
+	 */<br>
+	delete_from_swap_cache(page_map);<br>
 	set_pte(page_table, pte_mkwrite(pte_mkdirty(mk_pte(page, vma-&gt;vm_page_prot))));<br>
   	return;<br>
 }<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0735.html">Stephen C. Tweedie: "Re: Windows NT File Systems and Linux File Systems"</a>
<li> <b>Previous message:</b> <a href="0733.html">leitner@convergence.de: "Why Linux is doomed (was: Re: FENRIS (nwfs) 1.4.2 Source Code Available)"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0760.html">Andrea Arcangeli: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0760.html">Andrea Arcangeli: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0785.html">Chris Adams: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0802.html">Khimenko Victor: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0807.html">Thomas Davis: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0810.html">James David Rich: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0820.html">Rik van Riel: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0825.html">Thomas Davis: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0829.html">David J. Fred: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0855.html">Guest section DW: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0900.html">Anthony Barbachan: "Re: File Corruption Bug.. continued"</a>
<li> <b>Reply:</b> <a href="0908.html">Khimenko Victor: "Re: File Corruption Bug.. continued"</a>
<!-- reply="end" -->
</ul>
</font></body>
