<!-- received="Wed Jun 23 20:39:27 1999 EET DST" -->
<!-- sent="Wed, 23 Jun 1999 18:44:09 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="ll_rw_block mark_buffer_clean without the big kernel lock" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-25,: ll_rw_block mark_buffer_clean without the big kernel lock</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>ll_rw_block mark_buffer_clean without the big kernel lock</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Wed, 23 Jun 1999 18:44:09 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#770">[ date ]</a><a href="index.html#770">[ thread ]</a><a href="subject.html#770">[ subject ]</a><a href="author.html#770">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0771.html">DAVID BALAZIC: "Re: Some very thought-provoking ideas about OS architecture."</a>
<li> <b>Previous message:</b> <a href="0769.html">Simon Kenyon: "Re: [off-topic] Microsoft IP Stack"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
ll_rw_block will refile the buffer, and currently it can do that without<br>
the big kernel lock held (at least in write-partial). I think we can't put<br>
the lock_kernel just around mark_buffer_clean (in a<br>
async_mark_buffer_clean style) because we would end waiting for the big<br>
kernel lock but with the io_request_lock just acquired while other part of<br>
the kernel gets the io_request_lock with the lock_kernel acquired.<br>
<p>
I am not sure if we can make the buffer clean outside the io_request_lock<br>
(looks not to be sure that the req-&gt;bh won't change under us). Anyway the<br>
below patch will fix the race. It also fixes a wrong param to<br>
async_mark_buffer_dirty.<br>
<p>
Index: linux/fs/buffer.c<br>
===================================================================<br>
RCS file: /var/cvs/linux/fs/buffer.c,v<br>
retrieving revision 1.1.1.23<br>
diff -u -r1.1.1.23 buffer.c<br>
--- linux/fs/buffer.c	1999/06/22 22:33:23	1.1.1.23<br>
+++ linux/fs/buffer.c	1999/06/23 16:35:44<br>
@@ -1539,7 +1539,7 @@<br>
 		 * lots of dirty pages.<br>
 		 */<br>
 		if (!test_and_set_bit(BH_Dirty, &amp;bh-&gt;b_state)) {<br>
-			__atomic_mark_buffer_dirty(bh, bdf_prm.b_un.age_buffer);<br>
+			__atomic_mark_buffer_dirty(bh, 0);<br>
 			if (too_many_dirty_buffers)<br>
 				balance_dirty(bh-&gt;b_dev);<br>
 		}<br>
Index: linux/drivers/block/ll_rw_blk.c<br>
===================================================================<br>
RCS file: /var/cvs/linux/drivers/block/ll_rw_blk.c,v<br>
retrieving revision 1.1.1.9<br>
diff -u -r1.1.1.9 ll_rw_blk.c<br>
--- linux/drivers/block/ll_rw_blk.c	1999/06/14 17:12:07	1.1.1.9<br>
+++ linux/drivers/block/ll_rw_blk.c	1999/06/23 16:36:26<br>
@@ -634,13 +634,15 @@<br>
 	for (i = 0; i &lt; nr; i++) {<br>
 		if (bh[i]) {<br>
 			set_bit(BH_Req, &amp;bh[i]-&gt;b_state);<br>
+			lock_kernel();<br>
 #ifdef CONFIG_BLK_DEV_MD<br>
 			if (MAJOR(bh[i]-&gt;b_dev) == MD_MAJOR) {<br>
 				md_make_request(MINOR (bh[i]-&gt;b_dev), rw, bh[i]);<br>
-				continue;<br>
-			}<br>
+			} else<br>
 #endif<br>
-			make_request(MAJOR(bh[i]-&gt;b_rdev), rw, bh[i]);<br>
+				make_request(MAJOR(bh[i]-&gt;b_rdev), rw, bh[i]);<br>
+			unlock_kernel();<br>
+			<br>
 		}<br>
 	}<br>
 	return;<br>
<p>
Andrea Arcangeli<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0771.html">DAVID BALAZIC: "Re: Some very thought-provoking ideas about OS architecture."</a>
<li> <b>Previous message:</b> <a href="0769.html">Simon Kenyon: "Re: [off-topic] Microsoft IP Stack"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
