<!-- received="Wed Jun 23 22:06:14 1999 EET DST" -->
<!-- sent="23 Jun 1999 19:44:06 +0200" -->
<!-- name="Andi Kleen" -->
<!-- email="ak@muc.de" -->
<!-- subject="Re: [PATCH] *(int*)0 = 0 &amp; variations" -->
<!-- id="" -->
<!-- inreplyto="23 Jun 1999 17:02:07 +0200"" -->
<title>Linux-kernel mailing list archive 1999-25,: Re: [PATCH] *(int*)0 = 0 &amp; variations</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: [PATCH] *(int*)0 = 0 &amp; variations</h1>
<b>Andi Kleen</b> (<a href="mailto:ak@muc.de"><i>ak@muc.de</i></a>)<br>
<i>23 Jun 1999 19:44:06 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#795">[ date ]</a><a href="index.html#795">[ thread ]</a><a href="subject.html#795">[ subject ]</a><a href="author.html#795">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0796.html">Khimenko Victor: "Re: Why Linux is doomed (was: Re: FENRIS (nwfs) 1.4.2 Source Code"</a>
<li> <b>Previous message:</b> <a href="0794.html">Manfred Spraul: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
<a href="mailto:masp0008@stud.uni-sb.de">masp0008@stud.uni-sb.de</a> (Manfred Spraul) writes:<br>
<p>
<i>&gt; &gt; The following functions more like the userland version:</i><br>
<i>&gt; &gt;</i><br>
<i>&gt; &gt;#ifndef NDEBUG</i><br>
<i>&gt; &gt;#  define kassert(cond) \</i><br>
<i>&gt; &gt;      if (!(cond)) { \</i><br>
<i>&gt; &gt;      printk (KERN_ERR "kassert failed in function %s, file %s, line %d:</i><br>
<i>&gt; &gt;%s\n", \</i><br>
<i>&gt; &gt; __FUNCTION__, \</i><br>
<i>&gt; &gt; __FILE__, \</i><br>
<i>&gt; &gt; __LINE__, \</i><br>
<i>&gt; &gt; __STRING(cond)); \</i><br>
<i>&gt; &gt;      *(int*)0 = 0; \ &lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;</i><br>
<i>&gt; &gt;      }</i><br>
<i>&gt; </i><br>
<i>&gt; </i><br>
<i>&gt; we should split show_registers() into show_callchain() and</i><br>
<i>&gt; the rest. Don't force an oops.</i><br>
<p>
I did this some time ago, even loadable as a module (with some<br>
minor changes the ksyms.c to export the necessary symbols). It also<br>
does a better job with modules than the standard backtracer.<br>
<p>
An even better job does kdb.<br>
<p>
-Andi<br>
<p>
/* For i386. Based on the code in i386/kernel/traps.c, but with accurate<br>
   module checking and does not require an exception frame. <br>
   Hacked by Andi Kleen and subject to the GPL.  <br>
 */<br>
#include &lt;linux/types.h&gt;<br>
#include &lt;linux/mm.h&gt;<br>
#include &lt;linux/sched.h&gt;<br>
#include &lt;asm/pgtable.h&gt;<br>
#include &lt;linux/kernel.h&gt;<br>
#include &lt;linux/module.h&gt;<br>
<p>
// these two are not exported in a standard kernel<br>
extern unsigned long _etext, _stext;<br>
extern struct module *module_list;<br>
<p>
#define MODULE_RANGE (8*1024*1024)<br>
<p>
int backtrace_stack_depth = 24;<br>
<p>
static inline void print_trace(unsigned long *stack)<br>
{<br>
    int i;<br>
    unsigned long module_start,module_end,addr;<br>
    const char *mname = NULL;<br>
<p>
    static inline char * module_end_addr(struct module *mp) {<br>
	return ((char *)mp)  + mp-&gt;size; <br>
    }<br>
<p>
    static inline int valid_addr(unsigned long addr) {<br>
	return (((addr &gt;= (unsigned long) &amp;_stext) &amp;&amp; <br>
		 (addr &lt;= (unsigned long) &amp;_etext)) ||<br>
		((addr &gt;= module_start) &amp;&amp; (addr &lt;= module_end)));<br>
    }<br>
    <br>
    static inline const char * in_module(unsigned long addr) {<br>
	struct module *mp;<br>
	for (mp = module_list; mp; mp = mp-&gt;next) {<br>
	    static int warned;<br>
	    // be paranoid<br>
	    if (!valid_addr((unsigned long) mp) || <br>
		!valid_addr((unsigned long) module_end_addr(mp))) { <br>
		if (!warned++) <br>
		    printk("corrupted module pointer %p\n", mp); <br>
		break;<br>
	    }<br>
	    if (addr &gt;= (unsigned long) (mp+1) &amp;&amp; <br>
		addr &lt;= (unsigned long) module_end_addr(mp)) <br>
		return mp-&gt;name; <br>
	}<br>
	return 0; <br>
    }<br>
<p>
    printk(KERN_DEBUG "Call Trace: ");<br>
<p>
    module_start = PAGE_OFFSET + (max_mapnr &lt;&lt; PAGE_SHIFT);<br>
    module_start = ((module_start + VMALLOC_OFFSET) &amp; ~(VMALLOC_OFFSET-1));<br>
    module_end = module_start + MODULE_RANGE;<br>
<p>
    i = 1;<br>
    while (((long) stack &amp; 4095) != 0) {<br>
	const char *omname = mname; <br>
	addr = *stack++;<br>
	if (valid_addr(addr) &amp;&amp; <br>
	    (mname = in_module(addr))) {<br>
	    if (i &amp;&amp; ((i % 8) == 0))<br>
		printk("\n       ");<br>
	    printk("[&lt;%08lx&gt;] ", addr);<br>
	    if (mname &amp;&amp; mname != omname) <br>
		printk(" (%s) ", mname);<br>
	    i++;<br>
	}<br>
	if (i &gt; 30) { <br>
	    printk("..."); <br>
	    break;  <br>
	} <br>
    }<br>
    printk("\n"); <br>
}<br>
<p>
static inline void print_stack(unsigned long *stack) <br>
{<br>
    int i;<br>
    printk(KERN_DEBUG "Stack: ");<br>
    for(i=0; i &lt; backtrace_stack_depth; i++) {<br>
	if (((long) stack &amp; 4095) == 0)<br>
	    break;<br>
	if (i &amp;&amp; ((i % 8) == 0))<br>
	    printk("\n       ");<br>
	printk("%08lx ", *stack++);<br>
    }<br>
    printk("\n"); <br>
}<br>
<p>
static inline void print_code(unsigned char *eip)<br>
{<br>
    int i; <br>
    printk(KERN_DEBUG "Code: ");<br>
    for(i = 0; i &lt; 20; i++)<br>
	printk("%02x ", *eip++);<br>
    printk("\n"); <br>
}<br>
<p>
<p>
void backtrace(void)<br>
{<br>
    unsigned char *esp; <br>
<p>
    asm("movl %%esp,%0\n" : "=r" (esp)); <br>
<p>
    print_stack((unsigned long *) esp); <br>
    print_trace((unsigned long *) esp); <br>
    print_code((unsigned char *) __builtin_return_address(0));<br>
}  <br>
<p>
EXPORT_SYMBOL(backtrace);<br>
<p>
#ifdef MODULE<br>
int init_module(void) <br>
{ <br>
#ifdef TEST<br>
	printk(KERN_DEBUG "test\n"); <br>
	backtrace(); <br>
#endif<br>
	return 0; <br>
}<br>
void cleanup_module() { } <br>
#endif <br>
<p>
 <br>
<p>
<pre>
-- 
This is like TV. I don't like TV.
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0796.html">Khimenko Victor: "Re: Why Linux is doomed (was: Re: FENRIS (nwfs) 1.4.2 Source Code"</a>
<li> <b>Previous message:</b> <a href="0794.html">Manfred Spraul: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
