<!-- received="Thu Jun 24 02:35:29 1999 EET DST" -->
<!-- sent="Wed, 23 Jun 1999 15:58:09 -0700 (PDT)" -->
<!-- name="B. James Phillippe" -->
<!-- email="bryan@terran.org" -->
<!-- subject="Re: waitpid advice ? (killing off a kernel thread)" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.4.10.9906191125080.688-100000@localhost.localdomain" -->
<title>Linux-kernel mailing list archive 1999-25,: Re: waitpid advice ? (killing off a kernel thread)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: waitpid advice ? (killing off a kernel thread)</h1>
<b>B. James Phillippe</b> (<a href="mailto:bryan@terran.org"><i>bryan@terran.org</i></a>)<br>
<i>Wed, 23 Jun 1999 15:58:09 -0700 (PDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#850">[ date ]</a><a href="index.html#850">[ thread ]</a><a href="subject.html#850">[ subject ]</a><a href="author.html#850">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0851.html">Matti Aarnio: "Re: RFC: BSD system call revoke?"</a>
<li> <b>Previous message:</b> <a href="0849.html">Don Fisher: "compile error on pre 2.3.9"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Sat, 19 Jun 1999, David Waite wrote:<br>
<p>
<i>&gt; On Sat, 19 Jun 1999, B. James Phillippe wrote:</i><br>
<i>&gt; &gt; On Sat, 19 Jun 1999, David Waite wrote:</i><br>
<i>&gt; &gt; </i><br>
<i>&gt; &gt; &gt; The problem is that the drivers have threads running that are not dying</i><br>
<i>&gt; &gt; &gt; before I start deallocating resources.</i><br>
<i>&gt; &gt; ...</i><br>
<i>&gt; &gt; &gt; Anyways, my question is.. obviously my method of killing and then waiting</i><br>
<i>&gt; &gt; &gt; for the process to die is not working right. What can I do instead? Wait</i><br>
<p>
Hello,<br>
<p>
Let me summarize the problem: we would like a way to reliably write a<br>
module that starts a kernel_thread() in init_module() and kills the thread<br>
in cleanup_module().  The problem arises when cleanup_module() races the<br>
exiting kernel_thread().  If the thread wins, everything is okay.  If the<br>
cleanup_module() wins, the resources allocated by the module are removed<br>
before the thread is gone and therefore results in a kernel Oops.<br>
<p>
Here is a patch that seems to solve the problem by allowing cleanup_module<br>
to sleep until the process is released.  The existing wait_chldexit wait<br>
queue in task_struct is not sufficient because it wakes only waiting<br>
parents, and even then wakes them as soon as the child becomes a zombie<br>
(and is therefore still around).<br>
<p>
To use the patch, do a *sleep_on(&amp;task-&gt;wait_exit) in the cleanup_module.<br>
<p>
There is a potential problem with my patch, and that is if there is a race<br>
between wake_up and release.  What do you think?<br>
<p>
Index: include/linux/sched.h<br>
===================================================================<br>
RCS file: /v/CVS-kernel/linux-2.2/include/linux/sched.h,v<br>
retrieving revision 1.1.1.1<br>
diff -u -r1.1.1.1 sched.h<br>
--- include/linux/sched.h	1999/06/15 22:48:58	1.1.1.1<br>
+++ include/linux/sched.h	1999/06/23 04:49:56<br>
@@ -268,6 +268,7 @@<br>
 	struct task_struct **tarray_ptr;<br>
 <br>
 	struct wait_queue *wait_chldexit;	/* for wait4() */<br>
+	struct wait_queue *wait_exit;<br>
 	struct semaphore *vfork_sem;		/* for vfork() */<br>
 	unsigned long policy, rt_priority;<br>
 	unsigned long it_real_value, it_prof_value, it_virt_value;<br>
@@ -356,7 +357,7 @@<br>
 /* proc links*/ &amp;init_task,&amp;init_task,NULL,NULL,NULL, \<br>
 /* pidhash */	NULL, NULL, \<br>
 /* tarray */	&amp;task[0], \<br>
-/* chld wait */	NULL, NULL, \<br>
+/* chld wait */	NULL, NULL, NULL, \<br>
 /* timeout */	SCHED_OTHER,0,0,0,0,0,0,0, \<br>
 /* timer */	{ NULL, NULL, 0, 0, it_real_fn }, \<br>
 /* utime */	{0,0,0,0},0, \<br>
Index: kernel/exit.c<br>
===================================================================<br>
RCS file: /v/CVS-kernel/linux-2.2/kernel/exit.c,v<br>
retrieving revision 1.1.1.1<br>
diff -u -r1.1.1.1 exit.c<br>
--- kernel/exit.c	1999/06/15 22:48:56	1.1.1.1<br>
+++ kernel/exit.c	1999/06/23 22:01:06<br>
@@ -463,8 +463,11 @@<br>
 					SET_LINKS(p);<br>
 					write_unlock_irq(&amp;tasklist_lock);<br>
 					notify_parent(p, SIGCHLD);<br>
-				} else<br>
+				} else {<br>
+					if (waitqueue_active(&amp;p-&gt;wait_exit))<br>
+						wake_up(&amp;p-&gt;wait_exit);<br>
 					release(p);<br>
+				}<br>
 #ifdef DEBUG_PROC_TREE<br>
 				audit_ptree();<br>
 #endif<br>
Index: kernel/fork.c<br>
===================================================================<br>
RCS file: /v/CVS-kernel/linux-2.2/kernel/fork.c,v<br>
retrieving revision 1.1.1.1<br>
diff -u -r1.1.1.1 fork.c<br>
--- kernel/fork.c	1999/06/15 22:48:56	1.1.1.1<br>
+++ kernel/fork.c	1999/06/23 21:12:11<br>
@@ -590,6 +590,7 @@<br>
 	p-&gt;p_pptr = p-&gt;p_opptr = current;<br>
 	p-&gt;p_cptr = NULL;<br>
 	init_waitqueue(&amp;p-&gt;wait_chldexit);<br>
+	init_waitqueue(&amp;p-&gt;wait_exit);<br>
 	p-&gt;vfork_sem = NULL;<br>
 <br>
 	p-&gt;sigpending = 0;<br>
<p>
-bp<br>
<pre>
--
# bryan at terran dot org
# <a href="http://www.terran.org/~bryan">http://www.terran.org/~bryan</a>
<p>
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0851.html">Matti Aarnio: "Re: RFC: BSD system call revoke?"</a>
<li> <b>Previous message:</b> <a href="0849.html">Don Fisher: "compile error on pre 2.3.9"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
