<!-- received="Thu Jun 24 04:38:37 1999 EET DST" -->
<!-- sent="Wed, 23 Jun 1999 21:32:39 -0400 (EDT)" -->
<!-- name="Nate Riffe" -->
<!-- email="inkblot@geocities.com" -->
<!-- subject="Re: Why Linux is doomed (was: Re: FENRIS (nwfs) 1.4.2 Source Code" -->
<!-- id="" -->
<!-- inreplyto="19990623141635.12078.qmail@convergence.de" -->
<title>Linux-kernel mailing list archive 1999-25,: Re: Why Linux is doomed (was: Re: FENRIS (nwfs) 1.4.2 Source Code</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Why Linux is doomed (was: Re: FENRIS (nwfs) 1.4.2 Source Code</h1>
<b>Nate Riffe</b> (<a href="mailto:inkblot@geocities.com"><i>inkblot@geocities.com</i></a>)<br>
<i>Wed, 23 Jun 1999 21:32:39 -0400 (EDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#873">[ date ]</a><a href="index.html#873">[ thread ]</a><a href="subject.html#873">[ subject ]</a><a href="author.html#873">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0874.html">Albert D. Cahalan: "Re: (reiserfs) Re: I discussed reading directories as files with jra, Stallman,"</a>
<li> <b>Previous message:</b> <a href="0872.html">Riley Williams: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On 23 Jun 1999 <a href="mailto:leitner@convergence.de">leitner@convergence.de</a> wrote:<br>
<p>
<i>&gt; </i><br>
<i>&gt; Let me reiterate some things that happened to me recently:</i><br>
<i>&gt; </i><br>
<i>&gt; Management summary: stuff like this sucks.  I am but a programmer with a</i><br>
<i>&gt; SMP box that likes to run the latest kernel.  And yes, I expect all the</i><br>
<i>&gt; kernels to compile out of the box.  I don't think that this is too much</i><br>
<i>&gt; to ask.</i><br>
<p>
So you have simple compilation problems with the kernel and you're a<br>
programmer?  Let it be known that the people who have problems are<br>
generally the ones who fix problems.  You are capable of fixing, so do so<br>
and send patches.  Here's one I did recently to make nfs work as a module<br>
in 2.3.6:<br>
<p>
==========================CUT====================<br>
diff -urN linux/arch/i386/kernel/i386_ksyms.c linux-2.3.6/arch/i386/kernel/i386_ksyms.c<br>
--- linux/arch/i386/kernel/i386_ksyms.c	Mon May 10 13:32:45 1999<br>
+++ linux-2.3.6/arch/i386/kernel/i386_ksyms.c	Mon Jun 21 23:30:47 1999<br>
@@ -48,6 +48,7 @@<br>
 EXPORT_SYMBOL_NOVERS(__up_wakeup);<br>
 /* Networking helper routines. */<br>
 EXPORT_SYMBOL(csum_partial_copy);<br>
+EXPORT_SYMBOL(csum_partial_copy_generic);<br>
 /* Delay loops */<br>
 EXPORT_SYMBOL(__udelay);<br>
 EXPORT_SYMBOL(__delay);<br>
diff -urN linux/kernel/ksyms.c linux-2.3.6/kernel/ksyms.c<br>
--- linux/kernel/ksyms.c	Sun Jun 20 22:47:31 1999<br>
+++ linux-2.3.6/kernel/ksyms.c	Tue Jun 22 00:12:05 1999<br>
@@ -102,6 +102,9 @@<br>
 EXPORT_SYMBOL(kfree_s);<br>
 EXPORT_SYMBOL(vmalloc);<br>
 EXPORT_SYMBOL(vfree);<br>
+EXPORT_SYMBOL(page_hash_table);<br>
+EXPORT_SYMBOL(page_cache_size);<br>
+EXPORT_SYMBOL(__wait_on_page);<br>
 EXPORT_SYMBOL(mem_map);<br>
 EXPORT_SYMBOL(remap_page_range);<br>
 EXPORT_SYMBOL(max_mapnr);<br>
===========================CUT=====================<br>
<p>
Now was that so hard?  No, of course not.  You can do it too.  And if<br>
_you_ do to, then someone else doesn't have to.<br>
<p>
<i>&gt; Nowadays, people do not compile their kernels anymore.</i><br>
<p>
Everyone except you and me I guess.<br>
<p>
<i>&gt; I can practically see before my mental eyes a Microsoft sales weasel</i><br>
<i>&gt; showing people "make config" and then compiling a kernel where FAT</i><br>
<i>&gt; does not compile!  I mean, just the normal compilation messages look</i><br>
<i>&gt; like martian cryptography to normal people, but if you tell them "see,</i><br>
<i>&gt; now it broke", _nobody_ in the audience will actually tell you "but</i><br>
<i>&gt; you have the source, you can fix it if you are smart enough".</i><br>
<p>
I suppose LKML qualifies as an audience and surely there are Microsoft<br>
"sales weasels" listening, so I take it unto myself as a member of this<br>
audience to speak up and say to you:<br>
<p>
You have the source, you can fix it if you are smart enough.<br>
<p>
<i>&gt; Thus, I propose these changes:</i><br>
<i>&gt;</i><br>
<i>&gt;   1. No More Function Renaming.</i><br>
<p>
No.  Read on, the rationale is about 20 lines ahead.<br>
<p>
<i>&gt;      People are actually using your test kernels.</i><br>
<i>&gt;      Yes, you warned them, but what does that help the user?</i><br>
<p>
Nothing more can be done without compromising the bazaar style of<br>
developement[1].  Withholding test kernels and only releasing production<br>
code would neglect one of open source's biggest advantages.<br>
<p>
[1] Raymod, Eric S. "The Cathedral and the Bazaar"<br>
<p>
<i>&gt;      I, for example, have to use a 2.3 kernel, because the 2.2 kernel</i><br>
<i>&gt;      just freezes when I NFS-mount my laptop.</i><br>
<p>
There are many 2.2 kernels and will be many more.  Try a different one.<br>
<p>
<i>&gt;   2. No more incompatible changes.</i><br>
<p>
No.  Incompatible changes are a part of developement.  Sometimes it's<br>
about fixing old design mistakes, sometimes it's about creating a new more<br>
useful abstraction (which you've asked for in your next bullet point),<br>
sometimes it's some other issue.  Incompatible changes are a reality that<br>
will not go away.<br>
<p>
<i>&gt;      time.  But if you rename(!) a function in the kernel, is it too</i><br>
<i>&gt;      much to ask to do a global search-and-replace in the rest of the</i><br>
<i>&gt;      kernel?</i><br>
<p>
Perhaps it is.  Such an operation is certainly suseptible to error.<br>
Suppose someone renames foo to bar and does a search and replace on the<br>
whole source.  Now every occurrence of foo_baz has been renamed to<br>
bar_baz, which was completely unintended.<br>
<p>
<i>&gt;   3. Create some decent abstractions.</i><br>
<p>
You claim to be a programmer.  Patch and ye shall receive.<br>
<p>
<i>&gt;   4. When you do a change in the kernel, DOCUMENT IT.</i><br>
<p>
I superficially agree, but when it comes to documentation, do you have the<br>
patience?  If you did I suspect you'd have been patching the Documentation<br>
tree all along.  Do not expect of others what you do not expect of<br>
yourself.<br>
<p>
<i>&gt;      Let's create a new directory, Documentation/incompatible-changes.</i><br>
<p>
Sounds nice.  Send a patch (with a README in it, of course).<br>
<p>
Nate<br>
<p>
<i>&gt; </i><br>
<i>&gt; Felix</i><br>
<i>&gt; </i><br>
<i>&gt; -</i><br>
<i>&gt; To unsubscribe from this list: send the line "unsubscribe linux-kernel" in</i><br>
<i>&gt; the body of a message to majordomo@vger.rutgers.edu</i><br>
<i>&gt; Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a></i><br>
<i>&gt; </i><br>
<p>
<p>
------------------------------------------------((\))&lt;----------------------<br>
Nate Riffe			Duct tape by any other name is just as<br>
<a href="mailto:inkblot@geocities.com">inkblot@geocities.com</a>		sticky.<br>
<p>
-----BEGIN GEEK CODE BLOCK-----<br>
Version: 3.12<br>
GCS/IT/M/S/O d-@ s-:- a---&gt;- C++ UL++++BS++&gt;$ P+&gt;+++ L+++&gt;+++++$ W+ N !o<br>
K- w(---)$&gt;-- M-(--) V(--) PS+ PE Y+ PGP&gt;++ t(+)@ 5 X@ R tv&gt;! b+&gt;+++ DI++<br>
D e&gt;++(+++) h r++ y?<br>
------END GEEK CODE BLOCK------<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0874.html">Albert D. Cahalan: "Re: (reiserfs) Re: I discussed reading directories as files with jra, Stallman,"</a>
<li> <b>Previous message:</b> <a href="0872.html">Riley Williams: "Re: [PATCH] *(int*)0 = 0 &amp; variations"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
