<!-- received="Thu Jun 24 14:53:49 1999 EET DST" -->
<!-- sent="Thu, 24 Jun 1999 13:16:30 +0100 (GMT)" -->
<!-- name="Dr Mark Hagger" -->
<!-- email="mhagger@dera.gov.uk" -->
<!-- subject="Large file i/o in 2.2.10 and 2.3.8 (which locks up!)" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-25,: Large file i/o in 2.2.10 and 2.3.8 (which locks up!)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Large file i/o in 2.2.10 and 2.3.8 (which locks up!)</h1>
<b>Dr Mark Hagger</b> (<a href="mailto:mhagger@dera.gov.uk"><i>mhagger@dera.gov.uk</i></a>)<br>
<i>Thu, 24 Jun 1999 13:16:30 +0100 (GMT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#951">[ date ]</a><a href="index.html#951">[ thread ]</a><a href="subject.html#951">[ subject ]</a><a href="author.html#951">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0952.html">Matthew Kirkwood: "Re: RFC: BSD system call revoke?"</a>
<li> <b>Previous message:</b> <a href="0950.html">Uwe Schmeling: "dst cache overflow"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi,<br>
<p>
I've been experimenting with writing large amounts of data (in moderate<br>
size blocks) to disk followed by repeatedly reading it back in (again in<br>
blocks).  (For those interested its because I'm contemplating doing a<br>
matrix-vector multiply in an out-of-core fashion).<br>
<p>
However, I've run into strange problems while benchmarking my approach.  <br>
I've included the source code of this program for your perusal. I've run<br>
it on both 2.2.10 and 2.3.8 on my PII 400MHz (Redhat 5.2) machine, which<br>
has 256Mbytes RAM, an Ultra-wide SCSI bus and a 7000rpm SCSI drive.<br>
<p>
Basically the program generates a block of random data (16Mbytes) and<br>
writes this to a file on the disk 20 times.  It then lseeks back to the<br>
beginning of the file and tries to read it back in, again in blocks of<br>
16Mbytes.<br>
<p>
So, for 2.2.10:<br>
<p>
The writing proceeds quite well, getting bursts of 50Mbytes/s for most of<br>
the writes with periodic very slow writes (~1Mbytes/s) whilst<br>
(presumambly) quantities of data are fed to the disk.  The readbacks are<br>
quite slow, a fairly consistant 13Mbytes/s.  Although over time (ie<br>
multiple number of entire file reads) this seems to degrade somewhat,<br>
which in itself is odd.<br>
<p>
Now, for 2.3.8:<br>
<p>
I was a little surprised at how slow the writing to the disk goes, and<br>
indeed how much variation there was with write speeds of each block<br>
(between 3Mbytes/s and 9Mbytes/s).  I guess the main reason for this is to<br>
do with changes to the memory buffering of disk writes, and the general<br>
"bursty" nature of this process.<br>
<p>
Now, when the program gets to the read stage the disk goes mad and hammers<br>
away like crazy, reading apparently varies between 1 and 13Mbytes/s.  <br>
When I ran this for a while (ie looped over the entire file read a number<br>
of times) the program eventually Seg faulted and crashed, and actually<br>
took the machine down with it, locking it up solid.  I had to poweroff and<br>
reboot.<br>
<p>
On examining the messages file I saw a vast number of messages which read:<br>
<p>
  kernel: attempt to access beyond end of device<br>
  kernel: 08:09: rw=0, want=1072687759, limit=6827593<br>
<p>
(we're talking 100's of these for anyone interested).  Examining this<br>
again I saw that these messages poured out during the first (block) read<br>
and then continued to pour out during subsequent reads, up until the time<br>
the machine locks up.<br>
<p>
This all seems a little odd to me, (as ever I can't ignore the fact that<br>
I've done something silly!  But the read/write/lseek don't generate any<br>
error messages whilst this is happening).<br>
<p>
In general though, changes to the block size seems to make quite<br>
considerable differences to the performance, larger than 16Mbytes block<br>
size causes things to slow down considerably, although smaller block sizes<br>
seem to have effects as well. Possibly someone out there can tell me the<br>
reason for this!  (or indeed any thoughts on how to make this type of<br>
process run fast would be useful).<br>
<p>
Mark<br>
<p>
<p>
Here's the program:<br>
<p>
<p>
/* test a large (blocked) file write followed by a series of<br>
   repeated readbacks */<br>
<p>
#include &lt;stdio.h&gt;<br>
#include &lt;math.h&gt;<br>
#include &lt;stdlib.h&gt;<br>
<p>
#include &lt;sys/types.h&gt;<br>
#include &lt;sys/stat.h&gt;<br>
#include &lt;fcntl.h&gt;      <br>
#include &lt;unistd.h&gt;<br>
#include &lt;sys/time.h&gt;<br>
#include &lt;errno.h&gt; <br>
#include &lt;string.h&gt;<br>
<p>
int main() {<br>
  double wtime;<br>
  <br>
  int nblocks=16;<br>
  int bsize=1000;<br>
  int nsize=2000;<br>
  double *matrix;<br>
  struct timeval tim;<br>
  struct timezone tz;<br>
  int i,j,fid;<br>
  ssize_t nread;<br>
<p>
<p>
  matrix=malloc(bsize*nsize*sizeof(double));<br>
<p>
  fid=open("/local/block_file",O_CREAT | O_RDWR,S_IRWXU );<br>
  for(i=0;i&lt;nblocks;i++) {<br>
    /*create random numbers */<br>
    for(j=1;j&lt;bsize*nsize;j++)<br>
      matrix[j]=drand48();<br>
    /* and write the matrix to the file */<br>
    printf("Writing block %d to file\n",i);<br>
    fflush(stdout);<br>
<p>
<p>
    gettimeofday(&amp;tim,&amp;tz);<br>
    wtime=-tim.tv_sec-tim.tv_usec/1.0e+6;<br>
<p>
    if(write(fid,matrix,sizeof(double)*nsize*bsize)&lt;0) {<br>
       printf("write error: %s\n",strerror(errno));<br>
    }<br>
<p>
    gettimeofday(&amp;tim,&amp;tz);<br>
    wtime+=tim.tv_sec+tim.tv_usec/1.0e+6;<br>
<p>
    printf("Time to write = %le (%7.3lf Mbytes/s)\n",wtime,sizeof(double)*bsize*nsize/(wtime*1.0e+6));<br>
    fflush(stdout);<br>
  }  <br>
<p>
<p>
  /*now try reading it back a number of times */<br>
<p>
  for(j=0;j&lt;5;j++) {<br>
    off_t offset;<br>
    offset=0;<br>
    if(lseek(fid,offset,SEEK_SET)&lt;0) {<br>
       printf("lseek error: %s\n",strerror(errno));<br>
    }<br>
    for(i=0;i&lt;nblocks;i++) {<br>
      printf("Reading block %d from file\n",i);<br>
      fflush(stdout);<br>
      <br>
      gettimeofday(&amp;tim,&amp;tz);<br>
      wtime=-tim.tv_sec-tim.tv_usec/1.0e+6;<br>
      <br>
      nread=read(fid,matrix,sizeof(double)*nsize*bsize);<br>
      if(nread&lt;0) {<br>
       printf("read error: %s\n",strerror(errno));<br>
      }<br>
      if(nread&lt;sizeof(double)*nsize*bsize) {<br>
       printf("read wierdness %d read\n",nread);<br>
      }<br>
      <br>
      gettimeofday(&amp;tim,&amp;tz);<br>
      wtime+=tim.tv_sec+tim.tv_usec/1.0e+6;<br>
      <br>
      printf("Time to read = %le (%7.3lf Mbytes/s)\n",wtime,sizeof(double)*bsize*nsize/(wtime*1.0e+6));<br>
      fflush(stdout);<br>
    }<br>
  }<br>
<p>
<p>
<p>
  free(matrix);<br>
  close(fid);<br>
  return 0;<br>
}<br>
<p>
<p>
-- END PROGRAM --<br>
<p>
<pre>
--
<p>
Mark Hagger                                Tel: 01305 212803
DERA Winfrith, Winfrith Technology Centre  Fax: 01305 212103
Winfrith, Dorset, DT2 8XJ, UK              Email: <a href="mailto:mhagger@dera.gov.uk">mhagger@dera.gov.uk</a>
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0952.html">Matthew Kirkwood: "Re: RFC: BSD system call revoke?"</a>
<li> <b>Previous message:</b> <a href="0950.html">Uwe Schmeling: "dst cache overflow"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
