<!-- received="Thu Jun 24 17:05:45 1999 EET DST" -->
<!-- sent="Thu, 24 Jun 1999 14:35:30 +0100 (GMT)" -->
<!-- name="Riley Williams" -->
<!-- email="rhw@MemAlpha.CX" -->
<!-- subject="Re: [PATCH] *(int*)0 = 0 &amp; variations" -->
<!-- id="" -->
<!-- inreplyto="37718E78.65333EAA@pobox.com" -->
<title>Linux-kernel mailing list archive 1999-25,: Re: [PATCH] *(int*)0 = 0 &amp; variations</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: [PATCH] *(int*)0 = 0 &amp; variations</h1>
<b>Riley Williams</b> (<a href="mailto:rhw@MemAlpha.CX"><i>rhw@MemAlpha.CX</i></a>)<br>
<i>Thu, 24 Jun 1999 14:35:30 +0100 (GMT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#968">[ date ]</a><a href="index.html#968">[ thread ]</a><a href="subject.html#968">[ subject ]</a><a href="author.html#968">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0969.html">Matthew Wilcox: "Re: direct (unbufferd) disk access"</a>
<li> <b>Previous message:</b> <a href="0967.html">Matthew Jacob: "Re: System unique identifier....."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi Jeff.<br>
<p>
<i> &gt;&gt; There is also the fact that by its nature, assertion checking</i><br>
<i> &gt;&gt; makes most of the standard oops report redundant as, if</i><br>
<i> &gt;&gt; kassertoops was to be used, the exact circumstances would be</i><br>
<i> &gt;&gt; known in advance. It would therefore make more sense to have two</i><br>
<i> &gt;&gt; separate oops functions, one to deal with the current oops</i><br>
<i> &gt;&gt; events, and a second to deal with an oops caused by a</i><br>
<i> &gt;&gt; kassertoops() call.</i><br>
<p>
<i> &gt; Maybe call panic() or similar, instead of oops-ing?</i><br>
<p>
True - I've used panic() in the latest version.<br>
<p>
<i> &gt;&gt; Here's the corrected version:</i><br>
<p>
<i> &gt;&gt; +#ifdef DEBUG</i><br>
<p>
<i> &gt; 'DEBUG' is far too general.  __USING_KASSERT?</i><br>
<p>
How about a kernel configuration option - or, rather, two such<br>
options. The enclosed patch (relative to the 2.2.10 kernel) adds<br>
CONFIG_KERNEL_ASSERT and CONFIG_KERNEL_ASSERT_OOPS to the alpha,<br>
arm and i386 ports in the "Kernel hacking" section, together with<br>
the latest version of the kassert() and kassertoops() macros and<br>
the relevant COnfigure.help documentation.<br>
<p>
<i> &gt;&gt; +#else</i><br>
<i> &gt;&gt; +#define kassert(cond)          (void) abs(cond)</i><br>
<i> &gt;&gt; +#define kassertoops(cond)      (void) abs(cond)</i><br>
<i> &gt;&gt; +#endif</i><br>
<p>
<i> &gt; Any code depending on assert evaluating the condition is broken</i><br>
<i> &gt; IMHO.</i><br>
<p>
IMHO also, but the general concensus appears to be in favour of it.<br>
I've put an '#if 1'-#else-#endif block in the code, defaulting to<br>
not evaluating, but changing the '#if 1' line to '#if 0' inverts that.<br>
<p>
<i> &gt; Doing so breaks an important feature of assert: it evaluates to</i><br>
<i> &gt; nothing when disabled. Your above example violates the principle</i><br>
<i> &gt; of least surprise; instead, it should be ((void)0)</i><br>
<p>
Instead, it should be...<br>
<p>
 Q&gt; #define kassert(cond)<br>
<p>
...which just chops the whole line out.<br>
<p>
<i> &gt; Once it does that, please do submit it to the Upper Penguins.  </i><br>
<p>
One last round of checking before I do so...<br>
<p>
<p>
<p>
--- linux-2.2.10/include/linux/kassert.h~	Thu Jan  1 01:00:00 1970<br>
+++ linux-2.2.10/include/linux/kassert.h	Thu Jun 24 14:32:43 1999<br>
@@ -0,0 +1,63 @@<br>
+/*<br>
+ * Include definitions for kernel assertion checking<br>
+ */<br>
+<br>
+#ifndef __KASSERT_H__<br>
+#define __KASSERT_H__<br>
+<br>
+#ifdef CONFIG_KERNEL_ASSERT<br>
+<br>
+/*<br>
+ * Choose the reporting level to use<br>
+ */<br>
+<br>
+#  define REPORT_LEVEL	KERN_DEBUG<br>
+<br>
+/*<br>
+ * Define the kassert() macro<br>
+ */<br>
+<br>
+#  define kassert(cond) \<br>
+	if (cond) { \<br>
+		/* Do nothing */; \<br>
+	} else { \<br>
+		printk(	REPORT_LEVEL "ASSERTION FAILURE: %s line %u: %s\n" \<br>
+			"Assertion = (%s)\n", \<br>
+			__FILE__, __LINE__, __FUNCTION__, #cond ); \<br>
+	}<br>
+<br>
+/*<br>
+ * Define the kassertoops() macro appropriately<br>
+ */<br>
+<br>
+#  ifdef CONFIG_KERNEL_ASSERT_OOPS<br>
+<br>
+#    define kassertoops(cond) \<br>
+	if (cond) { \<br>
+		/* Do nothing */; \<br>
+	} else { \<br>
+		printk(	REPORT_LEVEL "ASSERTION FAILURE: %s line %u: %s\n" \<br>
+			"Assertion = (%s)\n", \<br>
+			__FILE__, __LINE__, __FUNCTION__, #cond ); \<br>
+		panic("Kernel assertion failure"); \<br>
+	}<br>
+<br>
+#  else<br>
+<br>
+#    define kassertoops(cond)	kassert(cond)<br>
+<br>
+#  endif<br>
+<br>
+#else<br>
+<br>
+#  if 1<br>
+#    define kassert(cond)<br>
+#  else<br>
+#    define kassert(cond)	(void) abs(cond)<br>
+#  endif<br>
+<br>
+#  define kassertoops(cond)	kassert(cond)<br>
+<br>
+#endif<br>
+<br>
+#endif<br>
--- linux-2.2.10/arch/i386/config.in~	Mon Apr 26 21:49:17 1999<br>
+++ linux-2.2.10/arch/i386/config.in	Thu Jun 24 14:06:00 1999<br>
@@ -199,5 +199,11 @@<br>
 <br>
 #bool 'Debug kmalloc/kfree' CONFIG_DEBUG_MALLOC<br>
 bool 'Magic SysRq key' CONFIG_MAGIC_SYSRQ<br>
+<br>
+bool 'Kernel assertion checking' CONFIG_KERNEL_ASSERT<br>
+if [ "$CONFIG_KERNEL_ASSERT" = "y" ]; then<br>
+  bool '  Allow OOPS on assertion failure' CONFIG_KERNEL_ASSERT_OOPS<br>
+fi<br>
+<br>
 endmenu<br>
 <br>
--- linux-2.2.10/arch/i386/defconfig~	Mon Apr 12 21:12:57 1999<br>
+++ linux-2.2.10/arch/i386/defconfig	Thu Jun 24 13:45:26 1999<br>
@@ -349,3 +349,4 @@<br>
 # Kernel hacking<br>
 #<br>
 # CONFIG_MAGIC_SYSRQ is not set<br>
+# CONFIG_KERNEL_ASSERT is not set<br>
--- linux-2.2.10/arch/alpha/config.in~	Sat May 22 21:41:37 1999<br>
+++ linux-2.2.10/arch/alpha/config.in	Thu Jun 24 14:05:43 1999<br>
@@ -285,4 +285,11 @@<br>
 fi<br>
 <br>
 bool 'Magic SysRq key' CONFIG_MAGIC_SYSRQ<br>
+<br>
+bool 'Kernel assertion checking' CONFIG_KERNEL_ASSERT<br>
+if [ "$CONFIG_KERNEL_ASSERT" = "y" ]; then<br>
+  bool '  Allow OOPS on assertion failure' CONFIG_KERNEL_ASSERT_OOPS<br>
+fi<br>
+<br>
 endmenu<br>
+<br>
--- linux-2.2.10/arch/alpha/defconfig~	Sat Jun 12 19:52:51 1999<br>
+++ linux-2.2.10/arch/alpha/defconfig	Thu Jun 24 13:50:00 1999<br>
@@ -331,3 +331,4 @@<br>
 #<br>
 CONFIG_MATHEMU=y<br>
 # CONFIG_MAGIC_SYSRQ is not set<br>
+# CONFIG_KERNEL_ASSERT is not set<br>
--- linux-2.2.10/arch/arm/config.in~	Thu Jan 14 18:29:28 1999<br>
+++ linux-2.2.10/arch/arm/config.in	Thu Jun 24 14:06:35 1999<br>
@@ -217,4 +217,11 @@<br>
 bool 'Debug kernel errors' CONFIG_DEBUG_ERRORS<br>
 #bool 'Debug kmalloc/kfree' CONFIG_DEBUG_MALLOC<br>
 bool 'Magic SysRq key' CONFIG_MAGIC_SYSRQ<br>
+<br>
+bool 'Kernel assertion checking' CONFIG_KERNEL_ASSERT<br>
+if [ "$CONFIG_KERNEL_ASSERT" = "y" ]; then<br>
+  bool '  Allow OOPS on assertion failure' CONFIG_KERNEL_ASSERT_OOPS<br>
+fi<br>
+<br>
 endmenu<br>
+<br>
--- linux-2.2.10/arch/arm/defconfig~	Thu Feb 25 18:46:46 1999<br>
+++ linux-2.2.10/arch/arm/defconfig	Thu Jun 24 13:51:03 1999<br>
@@ -263,3 +263,4 @@<br>
 # Kernel hacking<br>
 #<br>
 CONFIG_MAGIC_SYSRQ=y<br>
+# CONFIG_KERNEL_ASSERT is not set<br>
--- linux-2.2.10/Documentation/Configure.help~	Mon Jun 14 03:54:06 1999<br>
+++ linux-2.2.10/Documentation/Configure.help	Thu Jun 24 14:04:30 1999<br>
@@ -9762,6 +9762,23 @@<br>
   keys are documented in Documentation/sysrq.txt. Don't say Y unless<br>
   you really know what this hack does.<br>
 <br>
+Kernel assertion checking<br>
+CONFIG_KERNEL_ASSERT<br>
+  If you say Y here, then any assertions made in the kernel with the<br>
+  kassert() or kassertoops() macros will be checked at runtime. This<br>
+  can help in locating kernel bugs, since any messages resulting from<br>
+  this will indicate assumptions made by the programmers that are not<br>
+  in fact true.<br>
+<br>
+Allow OOPS on assertion failure<br>
+CONFIG_KERNEL_ASSERT_OOPS<br>
+  If you say Y here, then any assertions made in the kernel with the<br>
+  kassertoops() macro that fail will result in an OOPS occurring once<br>
+  the assertion failure has been reported.<br>
+<br>
+  If you say N here, then the kassertoops() macro will behave the same<br>
+  as the kassert() macro, and no OOPS will occur in this event.<br>
+<br>
 ISDN subsystem<br>
 CONFIG_ISDN<br>
   ISDN ("Integrated Services Digital Networks", called RNIS in France)<br>
<p>
<p>
<p>
Best wishes from Riley.<br>
<p>
+----------------------------------------------------------------------+<br>
<i>| There is something frustrating about the quality and speed of Linux  |</i><br>
<i>| development, ie., the quality is too high and the speed is too high, |</i><br>
<i>| in other words, I can implement this XXXX feature, but I bet someone |</i><br>
<i>| else has already done so and is just about to release their patch.   |</i><br>
+----------------------------------------------------------------------+<br>
 * <a href="ftp://ftp.MemAlpha.cx/pub/rhw/Linux">ftp://ftp.MemAlpha.cx/pub/rhw/Linux</a><br>
 * <a href="http://www.MemAlpha.cx/kernel.versions.html">http://www.MemAlpha.cx/kernel.versions.html</a><br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0969.html">Matthew Wilcox: "Re: direct (unbufferd) disk access"</a>
<li> <b>Previous message:</b> <a href="0967.html">Matthew Jacob: "Re: System unique identifier....."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
